/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.entity.waddler;

import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.weather_classic.WeatherClassic;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;

public class WaddlerEntity
extends class_1314 {
    private final class_1937 world;
    private boolean observed = false;
    private int stuckTicks = 0;
    private boolean exploded = false;
    public static final class_2940<Integer> RAGE = class_2945.method_12791(WaddlerEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> TPS = class_2945.method_12791(WaddlerEntity.class, (class_2941)class_2943.field_13327);

    public WaddlerEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_14, 0.0f);
        this.method_5941(class_7.field_8, 0.0f);
        this.world = world;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(RAGE, (Object)0);
        builder.method_56912(TPS, (Object)0);
        super.method_5693(builder);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.4, false));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public void method_5773() {
        super.method_5773();
        if (this.getRage() >= 4 && this.getSafety() <= 0 && !this.exploded) {
            this.explode();
            this.exploded = true;
        }
        if (!this.world.method_8608()) {
            class_1657 player;
            if (this.getSafety() > 0) {
                this.setSafety(this.getSafety() - 1);
            }
            if (this.method_5968() != null) {
                int time;
                if (Utils.inInvalidMode((class_1297)this.method_5968())) {
                    this.method_5980(null);
                    this.setRage(0);
                    return;
                }
                int n = time = this.world.method_18456().size() > 10 ? 10 : 5;
                if (this.observed) {
                    this.method_5988().method_35111((class_1297)this.method_5968());
                }
                if (this.field_6012 % time == 0) {
                    boolean prevObserved = this.observed;
                    this.observed = this.isObserved(this.method_33571());
                    if (prevObserved != this.observed) {
                        this.setWaddleSpeed(this.observed ? 0.0f : (this.getRage() >= 3 ? 0.3f : 0.25f));
                        if (this.observed) {
                            this.method_5942().method_6340();
                        }
                    }
                    if (!this.observed && this.field_6012 % 50 == 0) {
                        if (!this.hasValidPath() || Utils.isRawXZVelocityZero((class_1297)this) || this.method_5799() || this.method_5771() || this.world.method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10164)) {
                            if (this.stuckTicks++ > 3) {
                                this.attemptWaddlerTeleport(15, false);
                                this.stuckTicks = 0;
                            }
                        } else {
                            this.stuckTicks = 0;
                        }
                    }
                }
            } else if (this.field_6012 % 20 == 0 && (player = this.world.method_8604(this.method_23317(), this.method_23318(), this.method_23321(), 33.0, p -> !Utils.inInvalidMode(p))) != null) {
                this.method_5980((class_1309)player);
            }
        } else if (this.getRage() == 3) {
            this.world.method_8406((class_2394)class_2398.field_11240, this.method_23317() + (double)(this.field_5974.method_43057() * 0.3f * (float)(this.field_5974.method_43056() ? -1 : 1)), this.method_23318() + 0.2, this.method_23321() + (double)(this.field_5974.method_43057() * 0.3f * (float)(this.field_5974.method_43056() ? -1 : 1)), 0.0, 0.0, 0.0);
        }
    }

    private class_2338 getHiddenPos(int range) {
        class_2338 pos;
        if (this.method_5968() == null) {
            return null;
        }
        if (this.world.method_8409().method_43048(20) == 0 && !Utils.canPassThrough((class_1936)this.world, (pos = this.method_5968().method_24515().method_10079(this.method_5968().method_5755().method_10153(), 2)).method_10074()) && Utils.canPassThrough((class_1936)this.world, pos)) {
            return pos;
        }
        for (class_2338 next : class_2338.method_34848((class_5819)this.field_5974, (int)50, (class_2338)this.method_5968().method_24515(), (int)range)) {
            if (this.isObserved(Utils.convertBlockPosToVec(next)) || this.fallTooFar(next, 3) || next.method_10264() <= this.world.method_22350(next).method_31607() || next.method_10264() >= this.world.method_22350(next).method_31600() || !this.world.method_8621().method_11952(next) || !this.world.method_8320(next).method_26227().method_15769() || Utils.distanceXYZ(next, this.method_5968().method_24515()) < 10.0) continue;
            return next;
        }
        return null;
    }

    private boolean fallTooFar(class_2338 pos, int dist) {
        if (!Utils.canPassThrough((class_1936)this.world, pos) || !Utils.canPassThrough((class_1936)this.world, pos.method_10084())) {
            return true;
        }
        for (int i = 1; i < dist; ++i) {
            if (Utils.canPassThrough((class_1936)this.world, pos.method_10087(i))) continue;
            return false;
        }
        return true;
    }

    private boolean hasValidPath() {
        class_11 path;
        class_2338 pos = this.method_5968().method_24515();
        int dist1 = (int)Utils.distanceXYZ(this.method_24515(), pos);
        class_11 class_112 = path = this.method_5942().method_6345() == null ? this.method_5942().method_6348(pos, 0) : this.method_5942().method_6345();
        if (path == null) {
            return false;
        }
        int dist2 = (int)Utils.distanceXYZ(path.method_45().method_22879(), pos);
        return dist2 < dist1 - 1;
    }

    private boolean isObserved(class_243 vec) {
        boolean observed = false;
        for (class_1657 player : this.world.method_18456()) {
            class_243 look;
            int dist2;
            if (Utils.distanceXZ(player.method_73189(), vec) > 64.0 || !this.method_6057((class_1297)player)) continue;
            if (Utils.distanceXYZ(vec, player.method_33571()) < 2.5) {
                if (this.getRage() >= 3) {
                    this.setRage(4);
                } else if (this.field_5974.method_43048(40) == 0 && this.getSafety() == 0) {
                    this.increaseRage();
                }
                return true;
            }
            int dist1 = (int)Utils.distanceXYZ(player.method_33571(), vec);
            if (this.getRage() >= 3) {
                return false;
            }
            if (Utils.distanceXZ(vec, player.method_33571()) < 5.0) {
                if (player.method_36455() > 15.0f) {
                    return true;
                }
                if (player.method_36455() < -15.0f) {
                    return true;
                }
            }
            if ((dist2 = (int)Utils.distanceXYZ(look = Utils.getOffsetVecForRotation((class_1297)player, 2.0f, 1.7f, 0.0f, true), vec)) >= dist1) continue;
            observed = true;
            break;
        }
        return observed;
    }

    private void explode() {
        class_2338 pos = this.method_24515();
        this.world.method_8537(null, this.method_23317(), this.method_23318(), this.method_23321(), 4.0f, true, class_1937.class_7867.field_40890);
        for (class_2338 next : class_2338.method_25996((class_2338)pos, (int)10, (int)10, (int)10)) {
            if (!Materials.isGeneralStone(this.world.method_8320(next)) && !Materials.isAggregate(this.world.method_8320(next)) || this.field_5974.method_43048(3) == 0 || Utils.distanceXYZ(next, pos) > 8.0) continue;
            boolean valid = false;
            for (class_2350 dir : class_2350.values()) {
                if (!Utils.canPassThrough((class_1936)this.world, next.method_10093(dir))) continue;
                valid = true;
                break;
            }
            if (!valid) continue;
            this.world.method_8501(next, class_2246.field_10092.method_9564());
        }
        Utils.playSound(null, this.world, this.method_24515(), class_3417.field_14958, this.method_5634(), 5.0f, 1.6f);
        Utils.playSound(null, this.world, this.method_24515(), (class_3414)class_3417.field_14896.comp_349(), this.method_5634(), 5.0f, 1.0f);
        if (!this.world.method_8608()) {
            this.method_5768((class_3218)this.world);
        }
        if (this.world.method_8608()) {
            return;
        }
        this.createMonument();
        class_1639 diablo = new class_1639(class_1299.field_6076, this.world);
        diablo.method_5725(this.method_24515().method_10084().method_10078(), 0.0f, 0.0f);
        int infinite = -1;
        diablo.method_6092(new class_1293(class_1294.field_50121, infinite, 0, false, true));
        diablo.method_6092(new class_1293(class_1294.field_5923, infinite, 3, false, true));
        diablo.method_6092(new class_1293(class_1294.field_5906, infinite, 3, false, true));
        diablo.method_5971();
        diablo.method_5665((class_2561)class_2561.method_43470((String)"\u00a74Shrine Guardian"));
        diablo.method_5880(true);
        diablo.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8845));
        diablo.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8862));
        this.world.method_8649((class_1297)diablo);
    }

    private void createMonument() {
        class_2338 pos = this.method_24515();
        for (class_2338 next : class_2338.method_10097((class_2338)pos.method_10086(12).method_10076(4).method_10089(3), (class_2338)pos.method_10077(4).method_10088(3))) {
            if (!this.world.method_8320(next).method_26164(class_3481.field_37399)) continue;
            this.world.method_8501(next, class_2246.field_10124.method_9564());
        }
        this.setInfestedStoneBrick(pos);
        this.world.method_8501(pos, class_2246.field_33510.method_9564());
        this.setInfestedStoneBrick(pos.method_10078().method_10095());
        this.setInfestedStoneBrick(pos.method_10078().method_10072());
        this.setInfestedStoneBrick(pos.method_10078().method_10076(2));
        this.setInfestedStoneBrick(pos.method_10078().method_10077(2));
        this.setInfestedStoneBrick(pos.method_10095());
        this.setInfestedStoneBrick(pos.method_10072());
        this.world.method_8501(pos.method_10078(), class_2246.field_10492.method_9564());
        this.world.method_8501(pos.method_10067(), class_2246.field_10492.method_9564());
        this.setInfestedStoneBrick(pos.method_10076(2));
        this.setInfestedStoneBrick(pos.method_10077(2));
        this.setInfestedStoneBrick(pos.method_10067().method_10095());
        this.setInfestedStoneBrick(pos.method_10067().method_10072());
        this.setInfestedStoneBrick(pos.method_10067().method_10076(2));
        this.setInfestedStoneBrick(pos.method_10067().method_10077(2));
        for (int i = 1; i < 7; ++i) {
            this.setInfestedStoneBrick(pos.method_10095().method_10086(i));
            this.setInfestedStoneBrick(pos.method_10072().method_10086(i));
        }
        this.setInfestedStoneBrick(pos.method_10086(3));
        this.world.method_8501(pos.method_10086(4), class_2246.field_10515.method_9564());
        this.world.method_8501(pos.method_10086(5), class_2246.field_10036.method_9564());
        this.setInfestedStoneBrick(pos.method_10086(6));
        this.setInfestedStoneBrick(pos.method_10086(7));
        this.setInfestedStoneBrick(pos.method_10086(8));
        this.setInfestedStoneBrick(pos.method_10086(7).method_10078());
        this.setInfestedStoneBrick(pos.method_10086(7).method_10089(2));
        this.setInfestedChiseledBrick(pos.method_10086(9).method_10072());
        this.setInfestedChiseledBrick(pos.method_10086(10).method_10072());
        this.setInfestedChiseledBrick(pos.method_10086(9).method_10077(2));
        this.setInfestedChiseledBrick(pos.method_10086(10).method_10077(2));
        this.setInfestedChiseledBrick(pos.method_10086(9).method_10095());
        this.setInfestedChiseledBrick(pos.method_10086(10).method_10095());
        this.setInfestedChiseledBrick(pos.method_10086(9).method_10076(2));
        this.setInfestedChiseledBrick(pos.method_10086(10).method_10076(2));
        this.setInfestedStoneBrick(pos.method_10076(2).method_10086(3));
        this.setInfestedStoneBrick(pos.method_10077(2).method_10086(3));
    }

    private void setInfestedStoneBrick(class_2338 pos) {
        this.world.method_8501(pos, (double)this.field_5974.method_43057() < 0.2 ? class_2246.field_10100.method_9564() : class_2246.field_10387.method_9564());
    }

    private void setInfestedChiseledBrick(class_2338 pos) {
        this.world.method_8501(pos, class_2246.field_10176.method_9564());
    }

    private void setWaddleSpeed(float speed) {
        this.method_5996(class_5134.field_23719).method_6192((double)speed);
    }

    public void attemptWaddlerTeleport(int range, boolean hit) {
        class_2338 teleport = this.getHiddenPos(range);
        if (teleport != null) {
            class_243 v;
            int i;
            this.method_5942().method_6340();
            if (hit) {
                this.increaseRage();
            }
            if (this.getRage() == 3) {
                Utils.playSound(null, this.world, this.method_24515(), (class_3414)class_3417.field_14564.comp_349(), this.method_5634(), 4.0f, 0.8f + this.field_5974.method_43057() / 3.0f);
            } else {
                Utils.playSound(null, this.world, this.method_24515(), WeatherClassic.WADDLER_GIGGLE, this.method_5634(), 0.8f, 1.2f + this.field_5974.method_43057() / 3.0f);
                for (i = 0; i < 10; ++i) {
                    v = this.method_33571().method_1031((double)(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1)), -0.2 + (double)(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1)), (double)(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1)));
                    ((class_3218)this.world).method_65096((class_2394)class_2398.field_11203, v.field_1352, v.field_1351, v.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            this.setSafety(10);
            this.method_5808((double)teleport.method_10263() + 0.5, (double)teleport.method_10264() + 0.2, (double)teleport.method_10260() + 0.5, this.method_36454(), this.method_36455());
            for (i = 0; i < 10; ++i) {
                v = this.method_33571().method_1031((double)(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1)), -0.2 + (double)(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1)), (double)(this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1)));
                ((class_3218)this.world).method_65096((class_2394)class_2398.field_11203, v.field_1352, v.field_1351, v.field_1350, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        boolean playerSource;
        boolean bl = playerSource = source.method_5529() != null && source.method_5529().method_31747();
        if (source.method_5526() instanceof class_1685 || source == world.method_48963().method_51847() || source == world.method_48963().method_48829() || source.method_5529() != null && source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_68878()) {
            return super.method_64397(world, source, amount);
        }
        if (!world.method_8608() && playerSource) {
            this.attemptWaddlerTeleport(20, true);
            if (playerSource) {
                this.method_5980((class_1309)source.method_5529());
            }
        }
        return false;
    }

    public boolean method_5809() {
        return false;
    }

    protected class_3414 method_5994() {
        return WeatherClassic.WADDLER_LIVE;
    }

    protected class_3414 method_6011(class_1282 source) {
        return WeatherClassic.WADDLER_HURT;
    }

    protected class_3414 method_6002() {
        return WeatherClassic.WADDLER_DIE;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getRage() >= 3 ? class_3417.field_21074 : class_3417.field_14694, this.getRage() >= 3 ? 5.0f : 0.2f, 0.8f + this.field_5974.method_43057() * 0.2f);
    }

    protected class_1408 method_5965(class_1937 world) {
        return new WaddlerNavigation(this, world);
    }

    public void increaseRage() {
        this.setRage(this.getRage() + 1);
    }

    public void setRage(int i) {
        this.field_6011.method_12778(RAGE, (Object)class_3532.method_15340((int)i, (int)0, (int)4));
    }

    public int getRage() {
        return (Integer)this.field_6011.method_12789(RAGE);
    }

    public void setSafety(int i) {
        this.field_6011.method_12778(TPS, (Object)i);
    }

    public int getSafety() {
        return (Integer)this.field_6011.method_12789(TPS);
    }

    public boolean method_17326() {
        return false;
    }

    public boolean method_5974(double distanceSquared) {
        return distanceSquared > 7396.0;
    }

    public boolean method_5640(double distance) {
        return true;
    }

    static class WaddlerNavigation
    extends class_1409 {
        WaddlerNavigation(WaddlerEntity entity, class_1937 world) {
            super((class_1308)entity, world);
        }

        protected class_13 method_6336(int range) {
            this.field_6678 = new class_14();
            this.field_6678.method_15(true);
            this.field_6678.method_20(true);
            return new class_13(this.field_6678, range);
        }

        protected boolean method_26338(class_7 pathType) {
            if (pathType == class_7.field_8) {
                return true;
            }
            return super.method_26338(pathType);
        }

        public boolean method_6333(class_2338 pos) {
            return super.method_6333(pos);
        }
    }
}

