/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10588;
import net.minecraft.class_10730;
import net.minecraft.class_10733;
import net.minecraft.class_10758;
import net.minecraft.class_1297;
import net.minecraft.class_1428;
import net.minecraft.class_1452;
import net.minecraft.class_1463;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1590;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3854;
import net.minecraft.class_4836;
import net.minecraft.class_4985;
import net.minecraft.class_5137;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9347;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.IGlobal;
import net.weather_classic.global.tools.WeatherEventProbabilityCalculator;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.player.PlayerInputAccount;
import net.weather_classic.storm.sound.StormSound;
import net.weather_classic.storm.sound.StormSoundInfo;
import net.weather_classic.storm.sound.StormSoundManager;

public class Wind
implements IGlobal {
    private final class_3218 world;
    private int prevWindAngle = 0;
    private int windAngle = 0;
    private int goalAngle = 0;
    private float prevWindStrength = 0.0f;
    private float windStrength = 0.0f;
    private final float diminishThreshold = 0.025f;
    private final float gustyThreshold = 0.01f;
    private boolean prevWindy = false;
    private boolean windy = false;
    private boolean diminishing = false;
    private int daysSinceWind = 0;
    private boolean prevGusty = false;
    private int endWindTimer = 0;
    private int daysSinceGale = 0;
    private boolean isGale = false;
    private short galeTransitionTicks = 0;
    private short prevGaleTransitionTicks = 0;
    private boolean ghastly = false;
    private boolean prevGhastly = false;
    private int galeStartTimer = 0;
    private int windGustTime = 0;
    private boolean singleUpdate = false;
    private boolean fluctuatingWind = false;
    private short clusterCountdown = (short)-1;
    private int daysSinceCluster = 0;
    private Map<UUID, PlayerInputAccount> playerInputs = new HashMap<UUID, PlayerInputAccount>();

    public Wind(class_3218 world) {
        this.world = world;
    }

    public void tick() {
        TornadoEntity tornado;
        StormSoundManager manager;
        this.tickPlayerInputsForStorms();
        this.updateWindStatusByDay(Global.playersSkippingNight(this.world));
        if (this.windAngle != this.goalAngle) {
            this.incrementWindAngle(this.windAngle > this.goalAngle);
        }
        if (this.world.method_75260() % (long)(this.gusty() ? (this.isGale() ? 100 : 250) : 700) == 0L && this.world.method_8409().method_43048(3) == 0) {
            this.randomizeWindAngle();
            if (!this.windy) {
                float small;
                this.windStrength = small = this.world.field_9229.method_43048(5) == 0 ? 0.0f : Utils.getVerySmallFloat(this.world.field_9229, 0.006f);
                if (this.world.method_8409().method_43057() < 0.12f) {
                    this.windGustTime = 300 + this.world.method_8409().method_43048(3300);
                    this.singleUpdate = true;
                    this.setWindyDay(true, 0.2f + this.world.method_8409().method_43057() * 0.7f, true);
                }
            }
        }
        if (this.windGustTime > 0) {
            --this.windGustTime;
            if (this.windGustTime <= 0) {
                this.windGustTime = 1;
                this.setWindyDay(false, Utils.getVerySmallFloat(this.world.field_9229, 0.006f), false);
                this.windGustTime = 0;
            }
        }
        if (!(this.world.method_75260() % 120L != 0L || this.windy && this.gusty() || !Global.tornadoActive() && !this.isGale() && !Global.weather.isSevereStorm() || this.isWindyDay())) {
            this.windGustTime = 0;
            this.setWindyDay(true, 1.0f, true);
        }
        if (this.clusterCountdown > -1 && !this.world.method_18456().isEmpty()) {
            this.clusterCountdown = (short)(this.clusterCountdown - 1);
            if (this.clusterCountdown == -1) {
                Global.weather.trySpawnCluster(Global.weather.getRandomPlayers(4), Global.weather.maxSpawnDistance(), 4, false);
                this.singleUpdate = true;
                if ((double)this.world.field_9229.method_43057() < 0.15) {
                    this.scheduleCluster(true);
                }
            } else if (this.clusterCountdown % 40 == 0) {
                this.singleUpdate = true;
            }
        }
        if (Global.tornadoActive() && this.world.method_75260() % 20L == 0L) {
            for (class_1657 player : this.world.method_18456()) {
                StormSoundInfo info;
                StormSound sound;
                manager = Global.serverSoundManager.get(player);
                if (manager == null || (tornado = Global.getClosestTornado(player.method_33571())) == null || !tornado.isDestructiveStorm() || !Utils.withinTornadoSoundRange(player.method_33571(), tornado.method_73189(), tornado.getTornadoType(), tornado.variant) || !manager.isSoundPlayable(sound = WeatherClassic.TORNADO_TEAR, false) || (info = manager.begin(sound, 600L + (long)this.world.field_9229.method_43048(200), false)) == null) continue;
                float vol = (Utils.distanceXYZ(player.method_24515(), tornado.method_24515()) < 28.0 ? 0.27f : 0.2f) + this.world.method_8409().method_43057() * 0.2f;
                float pitch = 0.8f + this.world.method_8409().method_43057() * 0.25f;
                WCNetworkServer.sendWindSoundPacket(this.world, player, vol, pitch, info, 0);
            }
        }
        if (this.isGale) {
            if (this.galeTransitionTicks < 50) {
                this.galeTransitionTicks = (short)(this.galeTransitionTicks + 1);
            }
        } else if (this.galeTransitionTicks > 0) {
            this.galeTransitionTicks = (short)(this.galeTransitionTicks - 1);
        }
        if (!this.windy) {
            return;
        }
        if (this.world.method_75260() % 180L == 0L && this.world.method_8409().method_43048(2) == 0) {
            this.updateWindStrength();
            if (!this.diminishing && this.windStrength > 0.025f && (double)this.world.method_8409().method_43057() < 0.22 && !Global.weather.isSevereStorm() && !Global.tornadoActive() && !this.isGale) {
                this.diminishing = true;
            }
        }
        if (this.diminishing && this.windStrength <= 0.0f) {
            this.diminishing = false;
        }
        if (!this.gusty() || this.world.method_18456().isEmpty()) {
            return;
        }
        if (this.world.method_75260() % 20L == 0L) {
            for (class_1657 player : this.world.method_18456()) {
                StormSoundInfo info;
                boolean galeSound;
                if (this.world.method_75260() % 100L == 0L) {
                    WeatherClassic.WEATHER_ENCOUNTERED.triggerForWind((class_3222)player);
                }
                if ((manager = Global.serverSoundManager.get(player)) == null) continue;
                tornado = Global.getClosestTornado(player.method_33571());
                boolean bl = galeSound = this.isGale && (double)this.world.method_8409().method_43057() < 0.7;
                StormSound sound = Global.weather.isSevereStorm() && (double)this.world.method_8409().method_43057() < 0.3 ? WeatherClassic.DARK_WIND : (galeSound ? WeatherClassic.GALE_WIND : WeatherClassic.WIND_BLOWING);
                float prob = 0.4f;
                boolean ambient = true;
                boolean spout = false;
                if (tornado != null) {
                    if (Utils.withinTornadoSoundRange(player.method_33571(), tornado.method_73189(), tornado.getTornadoType(), tornado.variant)) {
                        sound = WeatherClassic.TORNADO_WIND;
                        spout = tornado.method_5864() == WCEntities.SPOUT;
                        prob = spout ? 1.0f : 0.6f;
                        ambient = false;
                    } else if (tornado.isDemon()) {
                        sound = WeatherClassic.DARK_WIND;
                    }
                }
                if (!manager.isSoundPlayable(sound, spout) || !(this.world.method_8409().method_43057() < prob) || ambient && !Wind.isOutsideInWindArea((class_1297)player, (class_1937)this.world) || (info = manager.begin(sound, this.world.method_8409().method_43048(100), spout)) == null) continue;
                WCNetworkServer.sendWindSoundPacket(this.world, player, tornado != null ? 0.27f : this.getWindVolume(galeSound), this.getWindPitch(galeSound), info, 0);
            }
        }
    }

    public static boolean windInteractableWeak(class_2680 state) {
        return state.method_26164(class_3481.field_15494) || state.method_26164(class_3481.field_25147) || state.method_26164(class_3481.field_15491) || state.method_26164(class_3481.field_15477) || state.method_26164(class_3481.field_15499) || state.method_26164(class_3481.field_26983) || state.method_26164(class_3481.field_26984);
    }

    public static boolean windInteractableStrong(class_2680 state) {
        return Wind.windInteractableWeak(state) || state.method_26164(class_3481.field_24076) || state.method_27852(class_2246.field_10363) || state.method_26164(class_3481.field_15493) || state.method_27852(class_2246.field_16332) || state.method_27852(class_2246.field_10528) || state.method_27852(class_2246.field_28048) || state.method_27852(class_2246.field_42752);
    }

    private void handleWindTimers() {
        if (this.endWindTimer > 0) {
            --this.endWindTimer;
            if (this.endWindTimer <= 0) {
                this.windGustTime = 0;
                this.setWindyDay(false, 0.0f, true);
            }
        }
        if (this.galeStartTimer > 0) {
            --this.galeStartTimer;
            if (this.galeStartTimer <= 0) {
                this.setGale(true);
            }
        }
    }

    private void updateWindStatusByDay(boolean force) {
        this.ghastly = false;
        if (this.world.method_75260() % 12000L == 0L || force) {
            class_5819 r = this.world.method_8409();
            this.ghastly = this.world.method_8409().method_43057() < 0.07f;
            ++this.daysSinceCluster;
            boolean cluster = WeatherEventProbabilityCalculator.shouldCluster(r, this.daysSinceCluster);
            if (cluster) {
                this.scheduleCluster(false);
                this.daysSinceCluster = 0;
            }
            if (this.windy && this.windGustTime <= 0) {
                if (this.endWindTimer <= 0) {
                    this.endWindTimer = this.world.method_8409().method_43048(force ? 1200 : 6000);
                }
            } else {
                boolean startWind;
                ++this.daysSinceWind;
                if (!this.windy && (startWind = WeatherEventProbabilityCalculator.shouldWind(r, this.daysSinceWind))) {
                    this.fluctuatingWind = r.method_43057() < 0.15f;
                    this.windGustTime = 0;
                    this.windy = true;
                    this.daysSinceWind = 0;
                    this.diminishing = false;
                    ++this.daysSinceGale;
                    if (WeatherEventProbabilityCalculator.shouldGale(r, this.daysSinceGale) && this.galeStartTimer <= 0 && !this.isGale()) {
                        if (!ModConfig.getEnableGale()) {
                            this.daysSinceGale = 0;
                        } else {
                            this.galeStartTimer = this.world.method_8409().method_43048(12000);
                        }
                    }
                }
            }
        }
        this.handleWindTimers();
    }

    public void setWindyDay(boolean b, float str, boolean asPercent) {
        if (!b) {
            this.ghastly = this.world.method_8409().method_43057() < 0.1f;
            this.fluctuatingWind = false;
            this.windStrength = Utils.getVerySmallFloat(this.world.field_9229, 0.006f);
            if (this.isGale) {
                this.setGale(false);
            }
        } else if (asPercent) {
            if (str >= 0.0f && str <= 1.0f) {
                this.windStrength = this.getMaxWindStrength() * str;
            }
        } else {
            this.setWindStrength(str);
        }
        this.windy = b;
        if (this.windGustTime <= 0) {
            this.daysSinceWind = 0;
        }
        this.diminishing = false;
        if (this.windGustTime <= 0) {
            this.endWindTimer = 0;
        }
        WCNetworkServer.sendWindStatusPacket(this.world);
    }

    public void updateWindData(boolean windy, float str, boolean dec, int angle, int days, int windEndTime, boolean gale, int daysSinceGale, boolean ghastly, int galeStartTimer, int windGustTime, short countdown, int daysSinceCluster) {
        this.setWindyDay(windy, str, false);
        this.diminishing = dec;
        this.windAngle = angle;
        this.goalAngle = angle;
        this.daysSinceWind = days;
        this.endWindTimer = windEndTime;
        this.isGale = gale;
        this.daysSinceGale = daysSinceGale;
        this.ghastly = ghastly;
        this.galeStartTimer = galeStartTimer;
        this.windGustTime = windGustTime;
        this.clusterCountdown = countdown;
        this.daysSinceCluster = daysSinceCluster;
    }

    public int getDaysSinceCluster() {
        return this.daysSinceCluster;
    }

    public short getClusterCountdown() {
        return this.clusterCountdown;
    }

    public int getGaleStartTimer() {
        return this.galeStartTimer;
    }

    public int getWindEndingTimer() {
        return this.endWindTimer;
    }

    public boolean ghastly() {
        return this.ghastly;
    }

    public boolean isGale() {
        return this.galeTransitionTicks > 0;
    }

    public short getGaleTransitionTicks() {
        return this.galeTransitionTicks;
    }

    public boolean isGaleTransitioning() {
        return this.prevGaleTransitionTicks != this.galeTransitionTicks;
    }

    public int getDaysSinceGale() {
        return this.daysSinceGale;
    }

    public float getWindVolume(boolean galeSound) {
        if (galeSound) {
            return 0.15732f;
        }
        if (Global.weather.isGreaterStormStage()) {
            return 0.3f;
        }
        return this.windStrength > this.diminishThreshold ? 0.25f : 0.1f;
    }

    public float getWindPitch(boolean galeSound) {
        if (galeSound) {
            return 0.6f + this.world.method_8409().method_43057() * 0.1f;
        }
        return 1.0f + this.world.method_8409().method_43057() * 0.2f;
    }

    public boolean gusty() {
        return this.windStrength >= 0.01f && this.windy;
    }

    public int getWindAngle() {
        return this.windAngle;
    }

    public float getWindStrength() {
        return this.windStrength;
    }

    public int getDaysSinceWindy() {
        return this.daysSinceWind;
    }

    public boolean isStrengthDecreasing() {
        return this.diminishing;
    }

    public boolean isWindyDay() {
        return this.windy;
    }

    public void setGale(boolean b) {
        this.windGustTime = 0;
        if (this.isGale != b) {
            this.isGale = b;
        }
        this.daysSinceGale = 0;
        this.diminishing = false;
        this.endWindTimer = 0;
        if (b) {
            this.galeStartTimer = 0;
        }
    }

    private void randomizeWindAngle() {
        int newAngle = this.world.method_8409().method_43048(361);
        this.setWindAngle(newAngle);
    }

    private void incrementWindAngle(boolean neg) {
        this.windAngle += neg ? -1 : 1;
        this.windAngle = class_3532.method_15340((int)this.windAngle, (int)0, (int)360);
    }

    private void setWindAngle(int angle) {
        this.goalAngle = class_3532.method_15340((int)angle, (int)0, (int)360);
    }

    private void setWindStrength(float str) {
        this.windStrength = class_3532.method_15363((float)str, (float)0.0f, (float)this.getMaxWindStrength());
    }

    private float getMaxWindStrength() {
        return this.isGale ? 0.04f : 0.035f;
    }

    public void setWindGustTime(int t) {
        this.windGustTime = t;
    }

    public int getWindGustTime() {
        return this.windGustTime;
    }

    private void updateWindStrength() {
        if (Global.tornadoActive() || Global.weather.isSevereStorm() || this.isGale()) {
            float minValue = this.isGale() ? 0.7f : 0.8f;
            this.setWindStrength(this.getMaxWindStrength() * (minValue + this.world.method_8409().method_43057() * 0.3f));
            this.windStrength = class_3532.method_15363((float)this.windStrength, (float)0.01f, (float)this.getMaxWindStrength());
            return;
        }
        float small = Utils.getVerySmallFloat(this.world.field_9229, this.world.method_8419() || this.fluctuatingWind ? 0.01f : 0.003f);
        this.setWindStrength(this.windStrength += (small *= (float)(this.diminishing || this.world.method_8409().method_43048(6) == 0 ? -1 : 1)));
    }

    public boolean changedState() {
        boolean changed = this.prevGusty != this.gusty() || this.prevWindAngle != this.windAngle || this.windStrength != this.prevWindStrength || this.prevWindy != this.windy || this.isGaleTransitioning() || this.ghastly != this.prevGhastly || this.singleUpdate;
        this.singleUpdate = false;
        if (this.prevGusty != this.gusty()) {
            this.prevGusty = this.gusty();
        }
        if (this.prevWindy != this.windy) {
            this.prevWindy = this.windy;
        }
        if (this.prevWindAngle != this.windAngle) {
            this.prevWindAngle = this.windAngle;
        }
        if (this.prevWindStrength != this.windStrength) {
            this.prevWindStrength = this.windStrength;
        }
        if (this.isGaleTransitioning()) {
            this.prevGaleTransitionTicks = this.galeTransitionTicks;
            if (this.galeTransitionTicks == 50 || this.galeTransitionTicks == 0) {
                WCNetworkServer.forceBigUpdate();
            }
        }
        if (this.prevGhastly != this.ghastly) {
            this.prevGhastly = this.ghastly;
        }
        return changed;
    }

    public static boolean isOutsideInWindArea(class_1297 ent, class_1937 world) {
        if (Wind.isSkyVisibleThroughLeaves(world, ent.method_24515())) {
            return true;
        }
        int size = 3;
        int yy = (int)ent.method_23320();
        int total = 0;
        float open = 0.0f;
        int expected = 49;
        int needed = 14;
        class_2338.class_2339 mpos = new class_2338.class_2339();
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                mpos.method_10102(ent.method_23317() + (double)xx, (double)yy, ent.method_23321() + (double)zz);
                int remaining = expected - ++total;
                if (open + (float)remaining < (float)needed) {
                    return false;
                }
                if (!Wind.isSkyVisibleThroughLeaves(world, (class_2338)mpos) || !Utils.canSeePosDirect(ent, (class_2338)mpos) || !((double)((open += 1.0f) / (float)total) > 0.3)) continue;
                return true;
            }
        }
        return (double)(open / (float)total) > 0.3;
    }

    public static boolean isOutsideInWindArea(class_243 vec, class_1937 world) {
        if (Wind.isSkyVisibleThroughLeaves(world, vec)) {
            return true;
        }
        int size = 3;
        int yy = (int)vec.field_1351;
        int total = 0;
        float open = 0.0f;
        int expected = 49;
        int needed = 14;
        class_2338.class_2339 mpos = new class_2338.class_2339();
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                mpos.method_10102(vec.field_1352 + (double)xx, (double)yy, vec.field_1350 + (double)zz);
                int remaining = expected - ++total;
                if (open + (float)remaining < (float)needed) {
                    return false;
                }
                if (!Wind.isSkyVisibleThroughLeaves(world, (class_2338)mpos) || !Utils.canSeePos(world, vec, (class_2338)mpos) || !((double)((open += 1.0f) / (float)total) > 0.3)) continue;
                return true;
            }
        }
        return (double)(open / (float)total) > 0.3;
    }

    public static boolean isOutsideInWindAreaClient(class_243 vec, class_1937 world) {
        if (Wind.isSkyVisibleThroughLeaves(world, vec)) {
            return true;
        }
        int size = 3;
        int yy = (int)vec.field_1351;
        int total = 0;
        float open = 0.0f;
        int expected = 49;
        int needed = 14;
        class_2338.class_2339 mpos = new class_2338.class_2339();
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                mpos.method_10102(vec.field_1352 + (double)xx, (double)yy, vec.field_1350 + (double)zz);
                int remaining = expected - ++total;
                if (open + (float)remaining < (float)needed) {
                    return false;
                }
                if (!Wind.isSkyVisible(world, (class_2338)mpos) || !Utils.canSeePos(world, vec, (class_2338)mpos) || !((double)((open += 1.0f) / (float)total) > 0.3)) continue;
                return true;
            }
        }
        return (double)(open / (float)total) > 0.3;
    }

    public static boolean isSkyVisible(class_1937 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
    }

    public static boolean isSkyVisibleThroughLeaves(class_1937 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
    }

    public static boolean isSkyVisibleThroughLeavesAndSea(class_1937 world, class_2338 pos, boolean underwater) {
        if (underwater) {
            return world.method_8624(class_2902.class_2903.field_13200, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
        }
        return world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
    }

    public static boolean isSkyVisibleThroughLeaves(class_1937 world, class_243 vec) {
        return world.method_8624(class_2902.class_2903.field_13203, class_3532.method_15357((double)vec.method_10216()), class_3532.method_15357((double)vec.method_10215())) <= class_3532.method_15357((double)vec.method_10214());
    }

    public static boolean hasNearbyHeatSource(class_243 vec, class_1937 world) {
        int size = 4;
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    class_2338 pos = BP.of(vec.field_1352 + (double)xx, vec.field_1351 + (double)yy, vec.field_1350 + (double)zz);
                    class_2680 state = world.method_8320(pos);
                    if (!Materials.isHeat(state)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public int getTimeForBlizzardFreeze() {
        float strPerc = this.windStrength / 0.035f;
        int t = strPerc > 1.0f ? 100 : (strPerc > 0.7f ? 250 : (strPerc > 0.4f ? 400 : 600));
        return this.world.method_23886() ? t - 50 : t;
    }

    public static boolean isBlizzardImmune(class_1297 entity) {
        class_1646 e;
        if (entity instanceof class_1657) {
            return false;
        }
        if (entity instanceof class_1493) {
            class_1493 e2 = (class_1493)entity;
            return !((class_6880)e2.method_58694(class_9334.field_56146)).method_40225(class_9347.field_49733) && !((class_6880)e2.method_58694(class_9334.field_56146)).method_40225(class_9347.field_49726) && !((class_6880)e2.method_58694(class_9334.field_56146)).method_40225(class_9347.field_49730);
        }
        if (entity instanceof class_1452) {
            class_1452 e3 = (class_1452)entity;
            return e3.method_66299() != class_10588.field_55697;
        }
        if (entity instanceof class_10730) {
            class_10730 e4 = (class_10730)entity;
            return e4.method_67349() != class_10733.field_56436;
        }
        if (entity instanceof class_1428) {
            class_1428 e5 = (class_1428)entity;
            return e5.method_67522() != class_10758.field_56548;
        }
        if (entity instanceof class_1463) {
            class_1463 e6 = (class_1463)entity;
            return e6.method_47855() != class_1463.class_7990.field_41565;
        }
        if (entity instanceof class_1646 && (e = (class_1646)entity).method_7231() != null) {
            return !e.method_7231().comp_3520().method_40225(class_3854.field_17071) && !e.method_7231().comp_3520().method_40225(class_3854.field_17074) && !e.method_7231().comp_3520().method_40225(class_3854.field_17076) && !e.method_7231().comp_3520().method_40225(class_3854.field_17072);
        }
        return !(entity instanceof class_4836) && !(entity instanceof class_1590) && !(entity instanceof class_5137) && !(entity instanceof class_4985);
    }

    @Override
    public class_1937 getWorld() {
        return this.world;
    }

    public void tickPlayerInputsForStorms() {
        ArrayList<UUID> blackList = new ArrayList<UUID>();
        for (UUID id : this.playerInputs.keySet()) {
            PlayerInputAccount account = this.playerInputs.get(id);
            account.tick();
            if (!account.discard()) continue;
            blackList.add(id);
        }
        blackList.forEach(this.playerInputs::remove);
    }

    public boolean playerHasInputAccount(UUID id) {
        return this.playerInputs.containsKey(id);
    }

    public void createOrUpdatePlayerInput(UUID id, float sideways, float forward, UUID stormId) {
        if (this.playerInputs.containsKey(id)) {
            this.playerInputs.get(id).updateInput(sideways, forward);
        } else {
            this.playerInputs.put(id, new PlayerInputAccount(id, stormId).updateInput(sideways, forward));
        }
    }

    public PlayerInputAccount getInputAccount(UUID playerID, UUID tornadoID) {
        PlayerInputAccount account = this.playerInputs.get(playerID);
        if (account != null && account.getStorm().equals(tornadoID)) {
            return account;
        }
        return null;
    }

    public void increaseWindFromDebug() {
        this.windGustTime = 0;
        if (!this.isWindyDay()) {
            this.setWindyDay(true, 0.0f, false);
        }
        if (this.windStrength >= this.getMaxWindStrength()) {
            if (!this.isGale) {
                this.setGale(true);
                this.setWindStrength(1.0f);
            } else {
                this.setWindStrength(0.0f);
                this.setWindyDay(false, 0.0f, false);
            }
            return;
        }
        this.setWindStrength(this.windStrength + Utils.getVerySmallFloat(this.world.field_9229, 0.005f));
    }

    public static class_243 pushItemFromWind(class_1297 ent, TornadoEntity tornado) {
        if (ent instanceof class_1542 && ent.method_5799()) {
            return class_243.field_1353;
        }
        if (tornado != null) {
            class_243 v = ent.method_73189().method_1020(tornado.method_73189()).method_1029().method_1021(-0.08);
            ent.method_5762(v.field_1352, 0.0, v.field_1350);
            return v;
        }
        class_243 v = Global.getGlobalWindVectorForPosition(ent.method_73189());
        float mult = (float)(Global.wind.ghastly() ? 1.5 : 1.0);
        ent.method_5762(v.field_1352 * (double)mult, 0.0, v.field_1350 * (double)mult);
        return v;
    }

    public static class_243 pushFromWind(class_1297 ent, float mult) {
        class_243 v = Global.getGlobalWindVectorForPosition(ent.method_73189());
        mult = (float)((double)mult * (Global.wind.ghastly() ? 1.5 : 1.0));
        ent.method_5762(v.field_1352 * (double)mult, 0.0, v.field_1350 * (double)mult);
        return v;
    }

    public void scheduleCluster(boolean fast) {
        if (this.clusterCountdown > -1 || !ModConfig.enableClusters() || Global.maxClustersReached()) {
            return;
        }
        this.clusterCountdown = this.getClusterCooldown(fast);
    }

    private short getClusterCooldown(boolean underDay) {
        if (underDay) {
            return (short)(2400 + this.world.field_9229.method_43048(12000));
        }
        return (short)this.world.field_9229.method_43048(23000);
    }
}

