/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global.client.config;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.weather_classic.WeatherClassic;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientCustomTornadoConfig {
    public static boolean USING_ALT = false;
    public static short speed = 0;
    public static byte ripType = 1;
    public static short time = (short)1200;
    public static byte pullType = 1;
    public static byte destructionLvlOverride = (byte)-1;
    public static boolean chasePlayers = false;
    public static float dispellerResistance = 0.0f;
    public static short extraParticleInterval = (short)2;
    public static byte extraParticleDistance = (byte)8;
    public static boolean createClouds = true;
    public static boolean colorOverride = false;
    public static boolean cloudColorOverride = false;
    public static float red = 0.1f;
    public static float green = 0.1f;
    public static float blue = 0.1f;
    public static boolean takeSurroundingColor = true;
    public static int soundDist = 50;
    public static byte passiveSoundType = 1;
    public static byte particleRadiusLvl = 1;
    public static short funnelWidth = (short)14;
    public static byte funnelPointedness = (byte)2;
    public static float funnelTightening = 0.0f;
    public static float scaling = 1.2f;
    public static byte particleCount = (byte)8;
    public static float baseParticleSizeIncrease = 0.15f;
    public static float bottomParticleSizeIncrease = 0.0f;
    public static float midParticleSizeIncrease = 0.0f;
    public static float topParticleSizeIncrease = 0.0f;
    public static byte biomeLockType = 0;
    public static float spawnPercent = 0.0f;
    public static byte weatherEventType = 0;

    public static float getDispellerResistance() {
        return dispellerResistance;
    }

    public static float getSpawnPercent() {
        return spawnPercent;
    }

    public static byte getWeatherEventType() {
        return weatherEventType;
    }

    public static byte getBiomeLockType() {
        return biomeLockType;
    }

    public static byte getPassiveSoundType() {
        return passiveSoundType;
    }

    public static int getSoundDist() {
        return soundDist;
    }

    public static boolean getTakeSurroundingColor() {
        return takeSurroundingColor;
    }

    public static boolean getChasePlayers() {
        return chasePlayers;
    }

    public static short getFunnelWidth() {
        return funnelWidth;
    }

    public static byte getFunnelPointedness() {
        return funnelPointedness;
    }

    public static float getFunnelTightening() {
        return funnelTightening;
    }

    public static short getSpeed() {
        return speed;
    }

    public static byte getParticleRadiusLvl() {
        return particleRadiusLvl;
    }

    public static byte getRipType(boolean includeBonus) {
        return (byte)(includeBonus ? ripType : (ripType > 4 ? (ripType == 7 ? 1 : 4) : ripType));
    }

    public static short getTime() {
        return time;
    }

    public static float getScaling() {
        return scaling;
    }

    public static byte getPullType(boolean includeBonus) {
        return includeBonus ? pullType : (pullType > 4 ? (byte)0 : pullType);
    }

    public static short getExtraParticleInterval() {
        return extraParticleInterval;
    }

    public static byte getExtraParticleDistance() {
        return extraParticleDistance;
    }

    public static boolean getCreateClouds() {
        return createClouds;
    }

    public static boolean getColorOverride() {
        return colorOverride;
    }

    public static boolean getCloudColorOverride() {
        return cloudColorOverride;
    }

    public static byte getDestructionLvlOverride() {
        return destructionLvlOverride;
    }

    public static Vector3f getColors() {
        return new Vector3f(red, green, blue);
    }

    public static byte getParticleCount() {
        return particleCount;
    }

    public static float getBaseParticleSizeIncrease() {
        return baseParticleSizeIncrease;
    }

    public static float getBottomParticleSizeIncrease() {
        return bottomParticleSizeIncrease;
    }

    public static float getMidParticleSizeIncrease() {
        return midParticleSizeIncrease;
    }

    public static float getTopParticleSizeIncrease() {
        return topParticleSizeIncrease;
    }

    public static void setDispellerResistance(float res) {
        dispellerResistance = res;
    }

    public static void setSpawnPercent(float spawn) {
        spawnPercent = spawn;
    }

    public static void setBiomeLockType(byte b) {
        biomeLockType = b;
    }

    public static void setWeatherEventType(byte b) {
        weatherEventType = b;
    }

    public static void setPassiveeSoundType(byte b) {
        passiveSoundType = b;
    }

    public static void setSoundDist(int d) {
        soundDist = d;
    }

    public static void setTakeSurroundingColor(boolean surroundingColor) {
        takeSurroundingColor = surroundingColor;
    }

    public static void setChasePlayers(boolean chase) {
        chasePlayers = chase;
    }

    public static void setDestructionLvlOverride(byte lvl) {
        destructionLvlOverride = lvl;
    }

    public static void setSpeed(short speed) {
        ClientCustomTornadoConfig.speed = speed;
    }

    public static void setRipType(byte ripType) {
        ClientCustomTornadoConfig.ripType = ripType;
    }

    public static void setTime(short time) {
        ClientCustomTornadoConfig.time = time;
    }

    public static void setPullType(byte pullType) {
        ClientCustomTornadoConfig.pullType = pullType;
    }

    public static void setScaling(float scaling) {
        ClientCustomTornadoConfig.scaling = scaling;
    }

    public static void setExtraParticleInterval(short extraParticleInterval) {
        ClientCustomTornadoConfig.extraParticleInterval = extraParticleInterval;
    }

    public static void setExtraParticleDistance(byte extraParticleDistance) {
        ClientCustomTornadoConfig.extraParticleDistance = extraParticleDistance;
    }

    public static void setCreateClouds(boolean createClouds) {
        ClientCustomTornadoConfig.createClouds = createClouds;
    }

    public static void setColorOverride(boolean colorOverride) {
        ClientCustomTornadoConfig.colorOverride = colorOverride;
    }

    public static void setCloudColorOverride(boolean cloudColorOverride) {
        ClientCustomTornadoConfig.cloudColorOverride = cloudColorOverride;
    }

    public static void setRed(float red) {
        ClientCustomTornadoConfig.red = red;
    }

    public static void setGreen(float green) {
        ClientCustomTornadoConfig.green = green;
    }

    public static void setBlue(float blue) {
        ClientCustomTornadoConfig.blue = blue;
    }

    public static void setParticleRadiusLvl(byte particleRadiusLvl) {
        ClientCustomTornadoConfig.particleRadiusLvl = particleRadiusLvl;
    }

    public static void setFunnelWidth(short funnelWidth) {
        ClientCustomTornadoConfig.funnelWidth = funnelWidth;
    }

    public static void setFunnelPointedness(byte funnelPointedness) {
        ClientCustomTornadoConfig.funnelPointedness = funnelPointedness;
    }

    public static void setFunnelTightening(float funnelTightening) {
        ClientCustomTornadoConfig.funnelTightening = funnelTightening;
    }

    public static void setParticleCount(byte particleCount) {
        ClientCustomTornadoConfig.particleCount = particleCount;
    }

    public static void setBaseParticleSizeIncrease(float baseParticleSizeIncrease) {
        ClientCustomTornadoConfig.baseParticleSizeIncrease = baseParticleSizeIncrease;
    }

    public static void setBottomParticleSizeIncrease(float bottomParticleSizeIncrease) {
        ClientCustomTornadoConfig.bottomParticleSizeIncrease = bottomParticleSizeIncrease;
    }

    public static void setMidParticleSizeIncrease(float midParticleSizeIncrease) {
        ClientCustomTornadoConfig.midParticleSizeIncrease = midParticleSizeIncrease;
    }

    public static void setTopParticleSizeIncrease(float topParticleSizeIncrease) {
        ClientCustomTornadoConfig.topParticleSizeIncrease = topParticleSizeIncrease;
    }

    public static float getTornadoParticleRadiusFromLvl() {
        switch (ClientCustomTornadoConfig.getParticleRadiusLvl()) {
            case 0: {
                return 1.5f;
            }
            case 2: {
                return 3.0f;
            }
            case 3: {
                return 5.0f;
            }
            case 4: {
                return 8.0f;
            }
            case 5: {
                return 10.0f;
            }
            case 6: {
                return 16.0f;
            }
            case 7: {
                return 24.0f;
            }
            case 8: {
                return 40.0f;
            }
            case 9: {
                return 60.0f;
            }
        }
        return 2.0f;
    }

    public static short getTornadoParticleFindRangeFromLvl() {
        float range = ClientCustomTornadoConfig.getTornadoParticleRadiusFromLvl();
        switch (ClientCustomTornadoConfig.getParticleRadiusLvl()) {
            case 0: {
                return (short)(range + 16.0f);
            }
            case 2: {
                return (short)(range + 16.0f);
            }
            case 3: {
                return (short)(range + 16.0f);
            }
            case 4: {
                return (short)(range + 16.0f);
            }
            case 5: {
                return (short)(range + 16.0f);
            }
            case 6: {
                return (short)(range + 16.0f);
            }
            case 7: {
                return (short)(range * 2.0f);
            }
            case 8: {
                return (short)(range * 2.0f);
            }
            case 9: {
                return (short)(range * 2.0f);
            }
        }
        return (short)(range + 12.0f);
    }

    public static float getGrabSpeed() {
        return switch (ClientCustomTornadoConfig.getPullType(true)) {
            case 0 -> WeatherClassic.SPOUT_CONFIG.grabSpeed + 0.05f;
            case 2 -> WeatherClassic.STAGE3_CONFIG.grabSpeed;
            case 3 -> WeatherClassic.STAGE4_CONFIG.grabSpeed;
            case 4 -> WeatherClassic.STAGE5_CONFIG.grabSpeed;
            case 5 -> WeatherClassic.SPOUT_CONFIG.grabSpeed + 0.01f;
            default -> WeatherClassic.STAGE2_CONFIG.grabSpeed;
        };
    }
}

