/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global.tools;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_7923;
import net.weather_classic.block.PuddleBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.help.Materials;
import net.weather_classic.help.MutableQuad;
import net.weather_classic.help.OneOrBoth;
import net.weather_classic.item.WindCore;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoStats;

public class TornadoDestructionInfo {
    public static final Map<class_2248, class_2248> ERODE_BLOCK_MAP = new HashMap<class_2248, class_2248>();
    public static final Map<class_2248, class_2248> CONCRETE_TO_POWDER_MAP = new HashMap<class_2248, class_2248>();
    public static final byte NO_PROTECTION = 0;
    public static final byte LOW_PROTECTION = -1;
    public static final byte HIGH_PROTECTION = -2;

    public static MutableQuad<BlockDestroyType, class_2680, OneOrBoth<class_2680, BlockDestroyType>, Boolean> getInteractType(class_2680 state, TornadoStats.Type stage, boolean aboveGround, boolean strong) {
        return TornadoDestructionInfo.getInteractType(state, stage, ModConfig.getTornadoDestructionLvl(), aboveGround, strong);
    }

    public static MutableQuad<BlockDestroyType, class_2680, OneOrBoth<class_2680, BlockDestroyType>, Boolean> getInteractType(class_2680 state, TornadoStats.Type stage, byte universalDL, boolean aboveGround, boolean strong) {
        if (!ModConfig.getCityDestructionMode()) {
            aboveGround = false;
        }
        if (ModConfig.CUSTOM_BLOCK_LIST.containsKey(class_7923.field_41175.method_10221((Object)state.method_26204()).toString())) {
            BlockDestroyType type;
            return MutableQuad.of(type, state, null, (type = ModConfig.CUSTOM_BLOCK_LIST.get(class_7923.field_41175.method_10221((Object)state.method_26204()).toString())) == BlockDestroyType.PROTECT);
        }
        BlockDestroyType rip = TornadoDestructionInfo.isRippableBlock(state, stage, universalDL, aboveGround, strong);
        if (rip != null) {
            boolean protecion = false;
            if (rip == BlockDestroyType.RARE_RIP && TornadoDestructionInfo.isProtectiveBlock(state, stage.getByte())) {
                protecion = true;
            }
            return MutableQuad.of(rip, state, null, protecion);
        }
        BlockDestroyType destroy = TornadoDestructionInfo.isBreakableBlock(state, stage, universalDL);
        if (destroy != null) {
            return MutableQuad.of(destroy, state, null, false);
        }
        OneOrBoth<class_2680, BlockDestroyType> replacementData = TornadoDestructionInfo.getReplaceableState(state, stage, universalDL, strong);
        if (replacementData != null) {
            boolean protecion = false;
            if (TornadoDestructionInfo.isProtectiveBlock(state, stage.getByte())) {
                protecion = true;
            }
            return MutableQuad.of(replacementData.getAdditional(), state, replacementData, protecion);
        }
        if (TornadoDestructionInfo.isProtectiveBlock(state, stage.getByte())) {
            return MutableQuad.of(BlockDestroyType.PROTECT, state, null, true);
        }
        return null;
    }

    public static BlockDestroyType isRippableBlock(class_2680 state, TornadoStats.Type stage, byte universalDL, boolean aboveGround, boolean strong) {
        byte lvl;
        byte by = lvl = stage.getByte() >= 5 && CustomTornadoConfig.getDestructionLvlOverride() > -1 ? CustomTornadoConfig.getDestructionLvlOverride() : universalDL;
        if (stage.getByte() >= 5) {
            stage = TornadoEntity.getTornadoTypeFrom(CustomTornadoConfig.getRipType(false));
        }
        switch (lvl) {
            case 0: {
                switch (stage) {
                    case STAGE2: {
                        if (state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicFood(state) || Materials.isStraw(state)) {
                            return BlockDestroyType.RIP;
                        }
                        if (Materials.isWool(state) || Materials.isSponge(state)) {
                            return BlockDestroyType.RARE_RIP;
                        }
                        return null;
                    }
                    case STAGE3: {
                        if (state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicFood(state) || Materials.isStraw(state) || Materials.isSponge(state)) {
                            return BlockDestroyType.RIP;
                        }
                        if (Materials.isWool(state)) {
                            return BlockDestroyType.RARE_RIP;
                        }
                        return null;
                    }
                    case STAGE4: {
                        if (state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicFood(state) || Materials.isWool(state) || Materials.isSponge(state) || Materials.isStraw(state)) {
                            return BlockDestroyType.RIP;
                        }
                        if (Materials.isLeaves(state) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state)) {
                            return BlockDestroyType.RARE_RIP;
                        }
                        return null;
                    }
                    case STAGE5: {
                        if (state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicFood(state) || Materials.isWool(state) || Materials.isSponge(state) || Materials.isStraw(state)) {
                            return BlockDestroyType.RIP;
                        }
                        if (Materials.isLeaves(state) || Materials.isPlanks(state) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state)) {
                            return BlockDestroyType.RARE_RIP;
                        }
                        return null;
                    }
                }
                return null;
            }
            case 1: {
                if (!Materials.isAggregate(state) || aboveGround && strong) break;
                return null;
            }
        }
        switch (stage) {
            case STAGE2: {
                if (Materials.isAggregate(state) || Materials.isLeaves(state) || state.method_26164(class_3481.field_29823) || Materials.isPathOrFarm(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isSponge(state) || Materials.isStraw(state)) {
                    return BlockDestroyType.RIP;
                }
                if (strong && (Materials.isCobblestone(state) || Materials.isSandstone(state))) {
                    return BlockDestroyType.RARE_RIP;
                }
                if (Materials.isWorkbench(state)) {
                    return BlockDestroyType.MUST_RIP;
                }
                return null;
            }
            case STAGE3: {
                if (Materials.isAggregate(state) || Materials.isLeaves(state) || state.method_26164(class_3481.field_29823) || Materials.isPathOrFarm(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isSponge(state) || Materials.isStraw(state) || Materials.isTerracotta(state)) {
                    return BlockDestroyType.RIP;
                }
                if (Materials.isCobblestone(state) || Materials.isSandstone(state)) {
                    return strong ? BlockDestroyType.RIP : BlockDestroyType.RARE_RIP;
                }
                if (Materials.isWorkbench(state)) {
                    return BlockDestroyType.MUST_RIP;
                }
                return null;
            }
            case STAGE4: {
                if (Materials.isAggregate(state) || Materials.isLeaves(state) || state.method_26164(class_3481.field_29823) || Materials.isPathOrFarm(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isSponge(state) || Materials.isStraw(state) || Materials.isTerracotta(state) || Materials.isCobblestone(state) || Materials.isSandstone(state) || Materials.isDefaultStone(state) && aboveGround) {
                    return BlockDestroyType.RIP;
                }
                if (Materials.isLog(state) || Materials.isBricks(state)) {
                    return strong ? BlockDestroyType.RIP : BlockDestroyType.RARE_RIP;
                }
                if (Materials.isWorkbench(state)) {
                    return BlockDestroyType.MUST_RIP;
                }
                return null;
            }
            case STAGE5: {
                if (Materials.isAggregate(state) || Materials.isLeaves(state) || state.method_26164(class_3481.field_29823) || Materials.isPathOrFarm(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isSponge(state) || Materials.isStraw(state) || Materials.isTerracotta(state) || Materials.isCobblestone(state) || Materials.isLog(state) || Materials.isBricks(state) || Materials.isSandstone(state) || Materials.isDefaultStone(state) && aboveGround) {
                    return BlockDestroyType.RIP;
                }
                if (Materials.isConcrete(state) || Materials.isMetal(state)) {
                    return strong ? BlockDestroyType.RIP : BlockDestroyType.RARE_RIP;
                }
                if (Materials.isWorkbench(state)) {
                    return BlockDestroyType.MUST_RIP;
                }
                return null;
            }
        }
        return null;
    }

    public static BlockDestroyType isBreakableBlock(class_2680 state, TornadoStats.Type stage, byte universalDL) {
        byte lvl;
        byte by = lvl = stage.getByte() >= 5 && CustomTornadoConfig.getDestructionLvlOverride() > -1 ? CustomTornadoConfig.getDestructionLvlOverride() : universalDL;
        if (stage.getByte() >= 5) {
            stage = TornadoEntity.getTornadoTypeFrom(CustomTornadoConfig.getRipType(false));
        }
        switch (lvl) {
            case 0: {
                switch (stage) {
                    case STAGE2: {
                        if (Materials.isPlant(state) || Materials.isWeb(state)) {
                            return BlockDestroyType.BREAK;
                        }
                        return null;
                    }
                    case STAGE3: {
                        if (Materials.isPlant(state) || Materials.isWeb(state)) {
                            return BlockDestroyType.BREAK;
                        }
                        if (Materials.isRails(state)) {
                            return BlockDestroyType.RARE_BREAK;
                        }
                        return null;
                    }
                    case STAGE4: {
                        if (Materials.isPlant(state) || Materials.isWeb(state)) {
                            return BlockDestroyType.BREAK;
                        }
                        if (Materials.isRails(state) || Materials.isGlass(state) || PuddleBlock.replaceableBlocks.contains(state.method_26204())) {
                            return BlockDestroyType.RARE_BREAK;
                        }
                        return null;
                    }
                    case STAGE5: {
                        if (Materials.isPlant(state) || Materials.isWeb(state) || Materials.isRails(state) || PuddleBlock.replaceableBlocks.contains(state.method_26204())) {
                            return BlockDestroyType.BREAK;
                        }
                        if (Materials.isGlass(state) || Materials.isLamp(state) || Materials.isDecoration(state)) {
                            return BlockDestroyType.RARE_BREAK;
                        }
                        return null;
                    }
                }
                return null;
            }
        }
        switch (stage) {
            case STAGE2: {
                if (Materials.isGlass(state) || Materials.isDecoration(state) || Materials.isRails(state) || PuddleBlock.replaceableBlocks.contains(state.method_26204()) || Materials.isPlant(state) || Materials.isLamp(state) || Materials.isBamboo(state) || Materials.isWeb(state) || Materials.isGravel(state)) {
                    return BlockDestroyType.BREAK;
                }
                return null;
            }
            case STAGE3: {
                if (Materials.isGlass(state) || Materials.isDecoration(state) || Materials.isRails(state) || PuddleBlock.replaceableBlocks.contains(state.method_26204()) || Materials.isPlant(state) || Materials.isLamp(state) || Materials.isBamboo(state) || Materials.isWeb(state)) {
                    return BlockDestroyType.BREAK;
                }
                if (Materials.isCrackedBricks(state) || Materials.isGravel(state)) {
                    return BlockDestroyType.RARE_BREAK;
                }
                return null;
            }
            case STAGE4: {
                if (Materials.isGlass(state) || Materials.isDecoration(state) || Materials.isRails(state) || PuddleBlock.replaceableBlocks.contains(state.method_26204()) || Materials.isPlant(state) || Materials.isLamp(state) || Materials.isBamboo(state) || Materials.isWeb(state) || Materials.isGravel(state)) {
                    return BlockDestroyType.BREAK;
                }
                if (Materials.isCrackedBricks(state)) {
                    return BlockDestroyType.RARE_BREAK;
                }
                return null;
            }
            case STAGE5: {
                if (Materials.isGlass(state) || Materials.isDecoration(state) || Materials.isRails(state) || PuddleBlock.replaceableBlocks.contains(state.method_26204()) || Materials.isPlant(state) || Materials.isLamp(state) || Materials.isBamboo(state) || Materials.isWeb(state) || Materials.isGravel(state) || Materials.isCrackedBricks(state)) {
                    return BlockDestroyType.BREAK;
                }
                return null;
            }
        }
        return null;
    }

    public static OneOrBoth<class_2680, BlockDestroyType> getReplaceableState(class_2680 state, TornadoStats.Type stage, byte universalDL, boolean strong) {
        byte lvl;
        byte by = lvl = stage.getByte() >= 5 && CustomTornadoConfig.getDestructionLvlOverride() > -1 ? CustomTornadoConfig.getDestructionLvlOverride() : universalDL;
        if (stage.getByte() >= 5) {
            stage = TornadoEntity.getTornadoTypeFrom(CustomTornadoConfig.getRipType(false));
        }
        switch (lvl) {
            case 0: {
                switch (stage) {
                    case STAGE2: {
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        return null;
                    }
                    case STAGE3: {
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        return null;
                    }
                    case STAGE4: {
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.1f, BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        return null;
                    }
                    case STAGE5: {
                        class_2248 block;
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.3f, BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (ERODE_BLOCK_MAP.containsKey(state.method_26204()) && (block = ERODE_BLOCK_MAP.get(state.method_26204())) instanceof class_2465) {
                            return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.RARE_REPLACE);
                        }
                        return null;
                    }
                }
                return null;
            }
            case 1: {
                switch (stage) {
                    case STAGE2: {
                        class_2248 block;
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.6f, BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (strong && ERODE_BLOCK_MAP.containsKey(state.method_26204()) && (block = ERODE_BLOCK_MAP.get(state.method_26204())) instanceof class_2465) {
                            return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.RARE_REPLACE);
                        }
                        return null;
                    }
                    case STAGE3: {
                        class_2248 block;
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.7f, BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (ERODE_BLOCK_MAP.containsKey(state.method_26204()) && (block = ERODE_BLOCK_MAP.get(state.method_26204())) instanceof class_2465) {
                            return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.RARE_REPLACE);
                        }
                        return null;
                    }
                    case STAGE4: {
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.8f, BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (Materials.isDefaultStone(state)) {
                            return OneOrBoth.of(class_2246.field_10255.method_9564(), class_2246.field_43227.method_9564(), 0.02f, BlockDestroyType.RARE_REPLACE);
                        }
                        if (Materials.isSandstone(state)) {
                            if (state.method_26204().method_9518().toString().contains("red")) {
                                return OneOrBoth.of(class_2246.field_10534.method_9564(), BlockDestroyType.RARE_REPLACE);
                            }
                            return OneOrBoth.of(class_2246.field_10102.method_9564(), class_2246.field_42728.method_9564(), 0.02f, BlockDestroyType.RARE_REPLACE);
                        }
                        if (ERODE_BLOCK_MAP.containsKey(state.method_26204())) {
                            class_2248 block = ERODE_BLOCK_MAP.get(state.method_26204());
                            if (block instanceof class_2465) {
                                return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.REPLACE);
                            }
                            return OneOrBoth.of(block.method_9564(), BlockDestroyType.RARE_REPLACE);
                        }
                        return null;
                    }
                    case STAGE5: {
                        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                            return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.9f, BlockDestroyType.REPLACE);
                        }
                        if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                            return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                        }
                        if (Materials.isDefaultStone(state)) {
                            return OneOrBoth.of(class_2246.field_10255.method_9564(), class_2246.field_43227.method_9564(), 0.02f, BlockDestroyType.RARE_REPLACE);
                        }
                        if (Materials.isSandstone(state)) {
                            if (state.method_26204().method_9518().toString().contains("red")) {
                                return OneOrBoth.of(class_2246.field_10534.method_9564(), BlockDestroyType.RARE_REPLACE);
                            }
                            return OneOrBoth.of(class_2246.field_10102.method_9564(), class_2246.field_42728.method_9564(), 0.02f, BlockDestroyType.RARE_REPLACE);
                        }
                        if (Materials.isConcrete(state)) {
                            if (CONCRETE_TO_POWDER_MAP.containsKey(state.method_26204())) {
                                return OneOrBoth.of(CONCRETE_TO_POWDER_MAP.get(state.method_26204()).method_9564(), BlockDestroyType.RARE_REPLACE);
                            }
                            return null;
                        }
                        if (ERODE_BLOCK_MAP.containsKey(state.method_26204())) {
                            class_2248 block = ERODE_BLOCK_MAP.get(state.method_26204());
                            if (block instanceof class_2465) {
                                return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.REPLACE);
                            }
                            return OneOrBoth.of(block.method_9564(), BlockDestroyType.REPLACE);
                        }
                        return null;
                    }
                }
                return null;
            }
        }
        switch (stage) {
            case STAGE2: {
                class_2248 block;
                if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                    return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.6f, BlockDestroyType.REPLACE);
                }
                if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                    return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                }
                if (strong && ERODE_BLOCK_MAP.containsKey(state.method_26204()) && (block = ERODE_BLOCK_MAP.get(state.method_26204())) instanceof class_2465) {
                    return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.RARE_REPLACE);
                }
                return null;
            }
            case STAGE3: {
                if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                    return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.7f, BlockDestroyType.REPLACE);
                }
                if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                    return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                }
                if (ERODE_BLOCK_MAP.containsKey(state.method_26204())) {
                    class_2248 block = ERODE_BLOCK_MAP.get(state.method_26204());
                    if (block instanceof class_2465) {
                        return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.RARE_REPLACE);
                    }
                    return OneOrBoth.of(block.method_9564(), BlockDestroyType.RARE_REPLACE);
                }
                return null;
            }
            case STAGE4: {
                if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                    return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.8f, BlockDestroyType.REPLACE);
                }
                if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                    return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                }
                if (Materials.isDefaultStone(state)) {
                    return OneOrBoth.of(class_2246.field_10255.method_9564(), class_2246.field_43227.method_9564(), 0.02f, BlockDestroyType.RARE_REPLACE);
                }
                if (ERODE_BLOCK_MAP.containsKey(state.method_26204())) {
                    class_2248 block = ERODE_BLOCK_MAP.get(state.method_26204());
                    if (block instanceof class_2465) {
                        return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.REPLACE);
                    }
                    return OneOrBoth.of(block.method_9564(), BlockDestroyType.REPLACE);
                }
                return null;
            }
            case STAGE5: {
                if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10194) || state.method_27852(class_2246.field_10362) || state.method_27852(class_2246.field_10520)) {
                    return OneOrBoth.of(class_2246.field_10566.method_9564(), class_2246.field_10253.method_9564(), 0.9f, BlockDestroyType.REPLACE);
                }
                if (state.method_27852(class_2246.field_22120) || state.method_27852(class_2246.field_22113)) {
                    return OneOrBoth.of(class_2246.field_10515.method_9564(), BlockDestroyType.REPLACE);
                }
                if (Materials.isDefaultStone(state)) {
                    return OneOrBoth.of(class_2246.field_10255.method_9564(), class_2246.field_43227.method_9564(), 0.02f, BlockDestroyType.RARE_REPLACE);
                }
                if (Materials.isConcrete(state)) {
                    if (CONCRETE_TO_POWDER_MAP.containsKey(state.method_26204())) {
                        return OneOrBoth.of(CONCRETE_TO_POWDER_MAP.get(state.method_26204()).method_9564(), BlockDestroyType.RARE_REPLACE);
                    }
                    return null;
                }
                if (ERODE_BLOCK_MAP.containsKey(state.method_26204())) {
                    class_2248 block = ERODE_BLOCK_MAP.get(state.method_26204());
                    if (block instanceof class_2465) {
                        return OneOrBoth.of((class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), BlockDestroyType.REPLACE);
                    }
                    return OneOrBoth.of(block.method_9564(), BlockDestroyType.REPLACE);
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isProtectiveBlock(class_2680 state, byte stage) {
        if (stage >= 5) {
            stage = TornadoEntity.getTornadoTypeFrom(CustomTornadoConfig.getRipType(false)).getByte();
        }
        if (Materials.isBricks(state) && stage < 3 || Materials.isConcrete(state) && stage < 4) {
            return true;
        }
        if (Materials.isMetal(state)) {
            return true;
        }
        return state.method_26204().method_36555() > 25.0f && state.method_26227().method_15769();
    }

    public static boolean shouldStateDrop(class_2680 state) {
        return Materials.isDecoration(state);
    }

    public static boolean canWindCoreGrab(class_2680 state, WindCore.WindCoreLevel lvl) {
        if (state.method_28501().stream().anyMatch(p -> p.method_11902() == class_2756.class)) {
            return false;
        }
        switch (lvl) {
            case STAGE2: {
                return Materials.isOrganicFood(state) || Materials.isStraw(state) || Materials.isSponge(state) || Materials.isWool(state) || Materials.isGlass(state) || Materials.isSnow(state) || Materials.isBamboo(state) || Materials.isLeaves(state);
            }
            case STAGE3: {
                return Materials.isLeaves(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isStraw(state) || Materials.isSponge(state) || Materials.isWorkbench(state) || Materials.isAggregate(state) || Materials.isSnow(state) || Materials.isGravel(state) || Materials.isBamboo(state) || Materials.isGlass(state);
            }
            case STAGE4: {
                return Materials.isLeaves(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isStraw(state) || Materials.isSponge(state) || Materials.isWorkbench(state) || Materials.isAggregate(state) || Materials.isSnow(state) || Materials.isGravel(state) || Materials.isTerracotta(state) || Materials.isBamboo(state) || Materials.isGlass(state) || Materials.isCobblestone(state) || Materials.isLog(state);
            }
            case STAGE5: {
                return Materials.isLeaves(state) || Materials.isWool(state) || Materials.isTnt(state) || Materials.isGlass(state) || Materials.isPlanks(state) || state.method_27852(WCBlocks.TORNADO_DISPELLER) || Materials.isOrganicLight(state) || Materials.isCoralBlocks(state) || Materials.isOrganicFood(state) || Materials.isStraw(state) || Materials.isSponge(state) || Materials.isWorkbench(state) || Materials.isAggregate(state) || Materials.isSnow(state) || Materials.isGravel(state) || Materials.isTerracotta(state) || Materials.isBricks(state) || Materials.isCobblestone(state) || Materials.isBamboo(state) || Materials.isLog(state) || Materials.isGeneralStone(state) || Materials.isConcrete(state) || Materials.isMetal(state);
            }
        }
        return false;
    }

    static {
        ERODE_BLOCK_MAP.put(class_2246.field_10126, class_2246.field_10250);
        ERODE_BLOCK_MAP.put(class_2246.field_10431, class_2246.field_10519);
        ERODE_BLOCK_MAP.put(class_2246.field_10178, class_2246.field_10374);
        ERODE_BLOCK_MAP.put(class_2246.field_10010, class_2246.field_10244);
        ERODE_BLOCK_MAP.put(class_2246.field_9999, class_2246.field_10103);
        ERODE_BLOCK_MAP.put(class_2246.field_10533, class_2246.field_10622);
        ERODE_BLOCK_MAP.put(class_2246.field_42733, class_2246.field_42730);
        ERODE_BLOCK_MAP.put(class_2246.field_42729, class_2246.field_42732);
        ERODE_BLOCK_MAP.put(class_2246.field_10307, class_2246.field_10204);
        ERODE_BLOCK_MAP.put(class_2246.field_10511, class_2246.field_10366);
        ERODE_BLOCK_MAP.put(class_2246.field_10303, class_2246.field_10084);
        ERODE_BLOCK_MAP.put(class_2246.field_10306, class_2246.field_10254);
        ERODE_BLOCK_MAP.put(class_2246.field_10155, class_2246.field_10558);
        ERODE_BLOCK_MAP.put(class_2246.field_10037, class_2246.field_10436);
        ERODE_BLOCK_MAP.put(class_2246.field_22111, class_2246.field_22112);
        ERODE_BLOCK_MAP.put(class_2246.field_22503, class_2246.field_22504);
        ERODE_BLOCK_MAP.put(class_2246.field_22118, class_2246.field_22119);
        ERODE_BLOCK_MAP.put(class_2246.field_22505, class_2246.field_22506);
        ERODE_BLOCK_MAP.put(class_2246.field_37549, class_2246.field_37550);
        ERODE_BLOCK_MAP.put(class_2246.field_37545, class_2246.field_37548);
        ERODE_BLOCK_MAP.put(class_2246.field_41072, class_2246.field_41073);
        ERODE_BLOCK_MAP.put(class_2246.field_10056, class_2246.field_10416);
        ERODE_BLOCK_MAP.put(class_2246.field_10387, class_2246.field_10100);
        ERODE_BLOCK_MAP.put(class_2246.field_23874, class_2246.field_23875);
        ERODE_BLOCK_MAP.put(class_2246.field_10266, class_2246.field_23867);
        ERODE_BLOCK_MAP.put(class_2246.field_28896, class_2246.field_29223);
        ERODE_BLOCK_MAP.put(class_2246.field_28900, class_2246.field_29222);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10458, class_2246.field_10506);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10011, class_2246.field_10456);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10439, class_2246.field_10023);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10308, class_2246.field_10233);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10038, class_2246.field_10353);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10367, class_2246.field_10529);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10242, class_2246.field_10321);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10172, class_2246.field_10628);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10421, class_2246.field_10133);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10585, class_2246.field_10300);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10210, class_2246.field_10022);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10434, class_2246.field_10522);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10206, class_2246.field_10404);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10058, class_2246.field_10287);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10107, class_2246.field_10197);
        CONCRETE_TO_POWDER_MAP.put(class_2246.field_10542, class_2246.field_10145);
    }

    public static enum BlockDestroyType {
        BREAK,
        RIP,
        REPLACE,
        RARE_BREAK,
        RARE_REPLACE,
        RARE_RIP,
        MUST_RIP,
        PROTECT;


        public boolean isRip() {
            return this == RIP || this == RARE_RIP || this == MUST_RIP;
        }

        public boolean isBreak() {
            return this == BREAK || this == RARE_BREAK;
        }

        public boolean isReplace() {
            return this == REPLACE || this == RARE_REPLACE;
        }
    }
}

