/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global.tools;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.storm.TornadoEntity;

public class TornadoReviver {
    private final class_2338 pos;
    private boolean finished = false;
    private final class_3218 world;
    private int startTime;
    private class_2338 target = null;
    private int id;
    private boolean on;
    private boolean dying;
    private final boolean demon;
    private final byte type;
    private boolean altBinded = false;
    private boolean variant = false;
    private float scaleBonus = 0.0f;

    public TornadoReviver(class_3218 world, class_2338 pos, byte type, boolean demon, boolean variant, float scaleBonus) {
        this.pos = pos;
        this.world = world;
        this.startTime = -1;
        this.type = type;
        this.on = true;
        this.id = 0;
        this.dying = false;
        this.demon = demon;
        this.variant = variant;
        this.scaleBonus = scaleBonus;
    }

    public boolean boundToAlt() {
        return this.altBinded;
    }

    public TornadoReviver binded(boolean b) {
        this.altBinded = b;
        return this;
    }

    public TornadoReviver with(class_2338 target) {
        this.target = target;
        return this;
    }

    public TornadoReviver off(int id, boolean dying) {
        this.id = id;
        this.on = false;
        this.dying = dying;
        return this;
    }

    public void update() {
        if (!this.on || this.finished) {
            return;
        }
        if (this.startTime < 0) {
            this.startTime = this.world.method_8503().method_3780();
            return;
        }
        if (this.world.method_27983() != class_1937.field_25179 || Global.maxTornadoesReached()) {
            this.finish();
            return;
        }
        if (this.world.method_8503().method_3780() > this.startTime + 2000) {
            this.finish();
            return;
        }
        if (!this.world.method_18456().isEmpty()) {
            for (class_1657 player : this.world.method_18456()) {
                if (!(Utils.distanceXYZ(this.pos, player.method_24515()) < (double)ModConfig.getMaxTornadoLoadDist())) continue;
                TornadoEntity storm = new TornadoEntity(TornadoEntity.getEntityTypeFrom(this.type), (class_1937)this.world).getWithShorterLifespan().enable();
                storm.method_5725(this.pos, 0.0f, 0.0f);
                if (this.target != null) {
                    storm.setCurrentTarget(this.target);
                }
                Global.forceChunksForTornadoSpawn(this.world, storm, storm.method_31476());
                if (this.type == 5) {
                    if (this.altBinded) {
                        storm.bindToAlt();
                    }
                    if (CustomTornadoConfig.USING_ALT != this.altBinded) {
                        WCNetworkServer.forceBigUpdateWithCustomTornado(this.altBinded);
                    }
                }
                if (this.variant) {
                    storm = storm.asVariant();
                }
                storm.scaleBonus = this.scaleBonus;
                this.world.method_8649((class_1297)storm);
                if (this.demon) {
                    storm.asDemon();
                }
                this.finished = true;
                return;
            }
        }
    }

    private void finish() {
        this.world.method_17988(new class_1923((class_2338)this.pos).field_9181, new class_1923((class_2338)this.pos).field_9180, false);
        this.finished = true;
    }

    public boolean isDone() {
        return this.finished;
    }

    public class_2338 getEntityPos() {
        return this.pos;
    }

    public byte getType() {
        return this.type;
    }

    public int getID() {
        return this.id;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isDying() {
        return this.dying;
    }

    public boolean isDemon() {
        return this.demon;
    }

    public boolean isVariant() {
        return this.variant;
    }

    public float getScaleBonus() {
        return this.scaleBonus;
    }
}

