/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.weather_classic.WeatherClassicClient;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.gui.ButtonWidgetBuilder;
import net.weather_classic.mixin.client.ClickableWidgetAccessor;
import net.weather_classic.networking.client.WCNetworkClient;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TornadoCreationScreen
extends class_437 {
    public static final class_2960 MENU_TEXTURE = class_2960.method_60655((String)"weather_classic", (String)"textures/gui/tornado_creation_menu.png");
    private int ySize;
    private int xSize;
    private int xAnimate;
    private int yAnimate;
    private boolean doneAnimating;
    private boolean closing;
    private byte page;
    private byte prevPage;
    private boolean refreshChildren = false;
    private byte tornadoSwitchingRef;
    public class_327 txt = null;

    public TornadoCreationScreen() {
        super(class_333.field_18967);
    }

    protected void method_25426() {
        this.xSize = 236;
        this.ySize = 219;
        if (WeatherClassicClient.defaultDebugPage >= 0) {
            this.xAnimate = -50;
            this.yAnimate = (this.field_22790 - this.ySize) / 2 + 10;
            this.doneAnimating = false;
        } else {
            this.xAnimate = -98;
            this.yAnimate = this.field_22790 - 30;
            this.doneAnimating = false;
        }
        this.closing = false;
        this.page = (byte)class_3532.method_15340((int)WeatherClassicClient.defaultDebugPage, (int)0, (int)5);
        this.prevPage = (byte)-2;
        this.tornadoSwitchingRef = ClientGlobal.customTornadoSwitchType;
        if (this.tornadoSwitchingRef == 2) {
            this.page = (byte)5;
        }
    }

    public void method_49589() {
        this.method_37067();
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        String COLOR;
        if (this.field_22787.field_1687 == null) {
            this.method_25419();
            return;
        }
        if (this.txt == null) {
            this.txt = this.field_22787.field_1772;
            return;
        }
        int imageSize = 256;
        int y = this.yAnimate;
        context.method_25290(class_10799.field_56883, MENU_TEXTURE, this.xAnimate, y, 0.0f, 0.0f, this.xSize, this.ySize, imageSize, imageSize);
        if (!this.doneAnimating || this.closing) {
            return;
        }
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_25300(this.txt, "Custom Tornado Settings", 72, y - 10, -1);
        if (!WeatherClassicClient.customTornadoInfoClicked) {
            double speed;
            long currentTimeMillis = System.currentTimeMillis();
            double offset = Math.sin((double)currentTimeMillis * (speed = 0.005)) * 2.0;
            context.method_25300(this.txt, (offset > 1.2 ? "\u00a7b" : "\u00a73") + "->", (int)(120.0 + offset), y + 9, -1);
        }
        String string = this.tornadoSwitchingRef == 2 ? "\u00a7d" : (COLOR = this.tornadoSwitchingRef == 1 ? "\u00a7e" : "\u00a74");
        if (this.tornadoSwitchingRef != 0) {
            long currentTimeMillis = System.currentTimeMillis();
            double speed = 0.005;
            double offset = Math.sin((double)currentTimeMillis * speed) * 2.0;
            context.method_25300(this.txt, COLOR + "^", 9, y + (int)(22.0 + offset), -1);
        }
        this.renderPage(context, y, COLOR);
    }

    public void renderPage(class_332 context, int y, String COLOR) {
        String displayAlt = "";
        switch (this.page) {
            case 0: {
                context.method_25300(this.txt, COLOR + "\u00a7l\u00a7nBehavior", 72, y + 12, -1);
                context.method_25303(this.txt, "Speed: " + ClientCustomTornadoConfig.getSpeed(), 4, y + 30, -1);
                displayAlt = ClientCustomTornadoConfig.getChasePlayers() ? "on" : "off";
                context.method_25303(this.txt, "Chase Players: " + displayAlt, 4, y + 50, -1);
                context.method_25303(this.txt, "Base Duration: " + ClientCustomTornadoConfig.getTime(), 4, y + 70, -1);
                switch (this.bypassRipType()) {
                    case 1: {
                        displayAlt = "STAGE 2";
                        break;
                    }
                    case 2: {
                        displayAlt = "STAGE 3";
                        break;
                    }
                    case 3: {
                        displayAlt = "STAGE 4";
                        break;
                    }
                    case 4: {
                        displayAlt = "STAGE 5";
                        break;
                    }
                    case 5: {
                        displayAlt = "WIDE";
                        break;
                    }
                    case 6: {
                        displayAlt = "FIRE";
                        break;
                    }
                    case 7: {
                        displayAlt = "THIN";
                        break;
                    }
                    default: {
                        displayAlt = "NONE";
                    }
                }
                context.method_25300(this.txt, "Destruction Type: " + displayAlt, 72, y + 92, -1);
                switch (this.bypassPullType()) {
                    case 1: {
                        displayAlt = "STAGE 2";
                        break;
                    }
                    case 2: {
                        displayAlt = "STAGE 3";
                        break;
                    }
                    case 3: {
                        displayAlt = "STAGE 4";
                        break;
                    }
                    case 4: {
                        displayAlt = "STAGE 5";
                        break;
                    }
                    case 5: {
                        displayAlt = "WEAK";
                        break;
                    }
                    default: {
                        displayAlt = "STAGE 1";
                    }
                }
                context.method_25300(this.txt, "Pulling Type: " + displayAlt, 72, y + 120, -1);
                switch (ClientCustomTornadoConfig.getDestructionLvlOverride()) {
                    case 0: {
                        displayAlt = "LOW";
                        break;
                    }
                    case 1: {
                        displayAlt = "MED";
                        break;
                    }
                    case 2: {
                        displayAlt = "HIGH";
                        break;
                    }
                    default: {
                        displayAlt = "\u00a72FILE";
                    }
                }
                context.method_25300(this.txt, "Destruction Lvl: " + displayAlt, 72, y + 148, -1);
                context.method_25303(this.txt, "Dispeller Resistance: " + WeatherClassicClient.SHORT_FORMAT.format(ClientCustomTornadoConfig.getDispellerResistance()), 4, y + 172, -1);
                break;
            }
            case 1: {
                context.method_25300(this.txt, COLOR + "\u00a7l\u00a7nShape", 72, y + 12, -1);
                context.method_25303(this.txt, "Radius: " + ClientCustomTornadoConfig.getParticleRadiusLvl(), 4, y + 40, -1);
                context.method_25303(this.txt, "Funnel Width: " + ClientCustomTornadoConfig.getFunnelWidth(), 4, y + 70, -1);
                context.method_25303(this.txt, "Smoothing: " + ClientCustomTornadoConfig.getFunnelPointedness(), 4, y + 100, -1);
                context.method_25303(this.txt, "Tightening: " + WeatherClassicClient.SHORT_FORMAT.format(ClientCustomTornadoConfig.getFunnelTightening()), 4, y + 130, -1);
                float scaling = ClientCustomTornadoConfig.getScaling();
                context.method_25303(this.txt, (scaling < 0.65f ? "\u00a77" : "") + "Tornado Height: " + WeatherClassicClient.SHORT_FORMAT.format(scaling), 4, y + 160, -1);
                break;
            }
            case 2: {
                context.method_25300(this.txt, COLOR + "\u00a7l\u00a7nParticles", 72, y + 12, -1);
                context.method_25303(this.txt, "Particle Amount: " + ClientCustomTornadoConfig.getParticleCount(), 4, y + 40, -1);
                context.method_25303(this.txt, "Base Scale Inc: " + WeatherClassicClient.MED_FORMAT.format(ClientCustomTornadoConfig.getBaseParticleSizeIncrease()), 4, y + 70, -1);
                context.method_25303(this.txt, "Low Scale Inc: " + WeatherClassicClient.MED_FORMAT.format(ClientCustomTornadoConfig.getBottomParticleSizeIncrease()), 4, y + 100, -1);
                context.method_25303(this.txt, "Mid Scale Inc: " + WeatherClassicClient.MED_FORMAT.format(ClientCustomTornadoConfig.getMidParticleSizeIncrease()), 4, y + 130, -1);
                context.method_25303(this.txt, "High Scale Inc: " + WeatherClassicClient.MED_FORMAT.format(ClientCustomTornadoConfig.getTopParticleSizeIncrease()), 4, y + 160, -1);
                break;
            }
            case 3: {
                context.method_25300(this.txt, COLOR + "\u00a7l\u00a7nExtras", 72, y + 12, -1);
                context.method_25303(this.txt, "Far Particle Freq: " + ClientCustomTornadoConfig.getExtraParticleInterval(), 4, y + 35, -1);
                context.method_25303(this.txt, "Far Particle Dist: " + ClientCustomTornadoConfig.getExtraParticleDistance(), 4, y + 55, -1);
                displayAlt = ClientCustomTornadoConfig.getCreateClouds() ? "on" : "off";
                context.method_25303(this.txt, "Create Clouds: " + displayAlt, 4, y + 75, -1);
                displayAlt = ClientCustomTornadoConfig.getColorOverride() ? "on" : "off";
                context.method_25303(this.txt, "Color Override: " + displayAlt, 4, y + 95, -1);
                Vector3f colors = ClientCustomTornadoConfig.getColors();
                boolean colorAccess = ClientCustomTornadoConfig.getColorOverride();
                context.method_25303(this.txt, (colorAccess ? "\u00a7c" : "\u00a70") + "R: " + WeatherClassicClient.SHORT_FORMAT.format(colors.x), 4, y + 115, -1);
                context.method_25303(this.txt, (colorAccess ? "\u00a7a" : "\u00a70") + "G: " + WeatherClassicClient.SHORT_FORMAT.format(colors.y), 46, y + 115, -1);
                context.method_25303(this.txt, (colorAccess ? "\u00a79" : "\u00a70") + "B: " + WeatherClassicClient.SHORT_FORMAT.format(colors.z), 88, y + 115, -1);
                displayAlt = ClientCustomTornadoConfig.getCloudColorOverride() ? "on" : "off";
                context.method_25303(this.txt, (colorAccess ? "" : "\u00a70") + "Color Clouds: " + displayAlt, 4, y + 137, -1);
                displayAlt = ClientCustomTornadoConfig.getTakeSurroundingColor() ? "on" : "off";
                context.method_25303(this.txt, "Enviornment Coloring: " + displayAlt, 4, y + 157, -1);
                displayAlt = ClientCustomTornadoConfig.getSoundDist() > 90 ? "" : " ";
                context.method_25303(this.txt, "Sound Dist:" + displayAlt + ClientCustomTornadoConfig.getSoundDist(), 4, y + 177, -1);
                context.method_25303(this.txt, "PSL: " + ClientCustomTornadoConfig.getPassiveSoundType(), 105, y + 177, -1);
                break;
            }
            case 4: {
                context.method_25300(this.txt, COLOR + "\u00a7l\u00a7nSpawning", 72, y + 12, -1);
                switch (ClientCustomTornadoConfig.getWeatherEventType()) {
                    case 1: {
                        displayAlt = "RAIN";
                        break;
                    }
                    case 2: {
                        displayAlt = "DOWNPOUR";
                        break;
                    }
                    case 3: {
                        displayAlt = "STAGE 1";
                        break;
                    }
                    case 4: {
                        displayAlt = "STAGE 2";
                        break;
                    }
                    case 5: {
                        displayAlt = "STAGE 3";
                        break;
                    }
                    case 6: {
                        displayAlt = "STAGE 4";
                        break;
                    }
                    case 7: {
                        displayAlt = "STAGE 5";
                        break;
                    }
                    case 8: {
                        displayAlt = "STAGE 6";
                        break;
                    }
                    default: {
                        displayAlt = "GALE";
                    }
                }
                context.method_25300(this.txt, "Weather Event: " + displayAlt, 72, y + 44, -1);
                displayAlt = ClientCustomTornadoConfig.getWeatherEventType() > 3 && ClientCustomTornadoConfig.getWeatherEventType() != 8 ? "\u00a7cReplace Existing" : "\u00a76Passive Spawn";
                context.method_25300(this.txt, "Type: " + displayAlt, 72, y + 75, -1);
                context.method_25300(this.txt, (ClientCustomTornadoConfig.getSpawnPercent() > 0.0f ? "" : "\u00a78\u00a7m") + "Chance: " + WeatherClassicClient.SHORT_FORMAT.format(class_3532.method_15363((float)(ClientCustomTornadoConfig.getSpawnPercent() * 100.0f), (float)0.0f, (float)100.0f)), 72, y + 95, -1);
                switch (ClientCustomTornadoConfig.getBiomeLockType()) {
                    case 1: {
                        displayAlt = "FORESTS";
                        break;
                    }
                    case 2: {
                        displayAlt = "PLAINS";
                        break;
                    }
                    case 3: {
                        displayAlt = "DESERTS";
                        break;
                    }
                    case 4: {
                        displayAlt = "MOUNTAINS";
                        break;
                    }
                    case 5: {
                        displayAlt = "WATER BODIES";
                        break;
                    }
                    default: {
                        displayAlt = "ANY";
                    }
                }
                context.method_25300(this.txt, "Biome Lock: " + displayAlt, 72, y + 126, -1);
                context.method_25303(this.txt, "\u00a70-----------------------", 3, y + 155, -1);
                break;
            }
            case 5: {
                context.method_25300(this.txt, COLOR + "\u00a7l\u00a7nTornado Switch", 72, y + 12, -1);
                context.method_25303(this.txt, "This page is for switching", 4, y + 35, -1);
                context.method_25303(this.txt, "between your tornadoes.", 4, y + 50, -1);
                context.method_25303(this.txt, "The option below dictates", 4, y + 75, -1);
                context.method_25303(this.txt, "which tornado can spawn.", 4, y + 90, -1);
                context.method_25303(this.txt, "\u00a7dAuto\u00a7f will dynamically switch", 4, y + 115, -1);
                context.method_25303(this.txt, "between both tornadoes", 4, y + 130, -1);
                context.method_25303(this.txt, "depending on the weather.", 4, y + 145, -1);
                displayAlt = ClientGlobal.customTornadoSwitchType == 2 ? "\u00a7dAuto" : (ClientGlobal.customTornadoSwitchType == 1 ? "\u00a7e2nd" : "\u00a741st");
                context.method_25300(this.txt, "\u00a7aCurrent Tornado: " + displayAlt, 72, y + 172, -1);
            }
        }
    }

    public void initPageWidgets(int startY, byte offsetY) {
        switch (this.page) {
            case 0: {
                this.createBehaviorScreen(startY, offsetY);
                break;
            }
            case 1: {
                this.createShapeScreen(startY, offsetY);
                break;
            }
            case 2: {
                this.createParticlesScreen(startY, offsetY);
                break;
            }
            case 3: {
                this.createExtrasScreen(startY, offsetY);
                break;
            }
            case 4: {
                this.createSpawningScreen(startY, offsetY);
                break;
            }
            case 5: {
                this.createSwitchScreen(startY, offsetY);
                break;
            }
        }
        WeatherClassicClient.defaultDebugPage = this.page;
    }

    private void createInfoButton(String name, int x, int y, String tooltip, boolean mainInfo) {
        class_4185 w = ButtonWidgetBuilder.makeWidget(x, y, 12, 12, (class_2561)class_2561.method_43470((String)name), button -> {
            if (((ClickableWidgetAccessor)button).getTooltipState().method_56137() == null) {
                button.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)tooltip)));
            } else {
                button.method_47400(null);
            }
            if (mainInfo) {
                WeatherClassicClient.customTornadoInfoClicked = true;
            }
        });
        this.method_37063((class_364)w);
    }

    private void createAdditionSubtractionWidget(int x, int y, class_4185.class_4241 subtractAction, class_4185.class_4241 addAction) {
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(x, y, 10, 10, (class_2561)class_2561.method_43470((String)"+"), addAction));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(x - 15, y, 10, 10, (class_2561)class_2561.method_43470((String)"-"), subtractAction));
    }

    private void createAdditionSubtractionWidgetVertical(int x, int y, class_4185.class_4241 subtractAction, class_4185.class_4241 addAction) {
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(x, y, 10, 10, (class_2561)class_2561.method_43470((String)"+"), addAction));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(x, y + 10, 10, 10, (class_2561)class_2561.method_43470((String)"-"), subtractAction));
    }

    public void method_25393() {
        super.method_25393();
        if (this.field_22787.field_1687 == null || this.field_22787.field_1687.method_27983() != class_1937.field_25179 || !ModConfig.getEnableCustomTornadoes()) {
            this.method_25419();
            return;
        }
        byte offsetY = 16;
        int startY = (this.field_22790 - this.ySize) / 2;
        if (this.closing) {
            this.method_37067();
            if (this.xAnimate > -98) {
                this.xAnimate -= 20;
                this.xAnimate = class_3532.method_15340((int)this.xAnimate, (int)-98, (int)-50);
            } else if (this.yAnimate < this.field_22790 - 30) {
                this.yAnimate += 50;
                startY = 10;
                this.yAnimate = class_3532.method_15340((int)this.yAnimate, (int)10, (int)(this.field_22790 - 30));
            } else {
                this.field_22787.method_1507(WeatherClassicClient.DEBUG_MENU_SCREEN);
                WeatherClassicClient.defaultDebugPage = (byte)-1;
            }
        } else {
            if (this.yAnimate > startY + 10) {
                this.yAnimate -= 50;
                this.yAnimate = class_3532.method_15340((int)this.yAnimate, (int)(startY + 10), (int)(this.field_22790 - 30));
            } else if (this.xAnimate < -50) {
                this.xAnimate += 20;
                this.xAnimate = class_3532.method_15340((int)this.xAnimate, (int)-98, (int)-50);
            } else if (!this.doneAnimating || this.refreshChildren) {
                this.doneAnimating = true;
                this.refreshChildren = false;
                this.initPageWidgets(startY, offsetY);
                this.createInfoButton("\u00a73i", 128, startY + 17, "\u00a73Custom Tornado Creation Info:\u00a7f\n\n- Custom tornado settings are saved \u00a73by world\u00a7f. Only 2 custom tornadoes per world.\n\n- Custom tornado settings are saved in your world folder under \u00a73wm_data\u00a7f.\n\n- You must manually backup your \u00a73wm_data\u00a7f files to save previous settings! Changes made here will update \u00a73immediately\u00a7f in the files!\n\n- For more info, please visit the \u00a76CurseForge\u00a7f page!", true);
                String COLOR = this.tornadoSwitchingRef == 2 ? "\u00a7d" : (this.tornadoSwitchingRef == 1 ? "\u00a7e" : "\u00a74");
                this.createInfoButton(COLOR + "i", 3, startY + 17, switch (this.tornadoSwitchingRef) {
                    case 1 -> "\u00a7eYou are Currently Editing Your 2nd Tornado:\u00a7f\n\n- Notice the titles are \u00a7eyellow\u00a7f.\n\n- Your 2nd tornado can only persist in Stage 4 storms or lower.\n\n- Only one of your custom tornadoes can be active at a time.\n\n- Currently, only your 2nd tornado will spawn naturally. (See \u00a7lTornado Switch\u00a7f page)";
                    case 2 -> "\u00a7dAutomatic Tornado Switching is Enabled:\u00a7f\n\n- Notice the titles are \u00a7dmagenta\u00a7f.\n\n- You cannot edit your settings while the \u00a7aCurrent Tornado\u00a7f is set to \u00a7dAuto\u00a7f.\n\n- Automatic mode allows both of your tornadoes to spawn naturally.\n\n- If the conditions for your \u00a7e2nd\u00a7f tornado are met, it will take priority.";
                    default -> "\u00a74You are Currently Editing Your 1st Tornado:\u00a7f\n\n- Notice the titles are \u00a74red\u00a7f.\n\n- Your 1st tornado can spawn in any weather event, including \u00a7cStage 6\u00a7f.\n\n- Only one of your custom tornadoes can be active at a time.\n\n- Currently, only your 1st tornado will spawn naturally. (See \u00a7lTornado Switch\u00a7f page)";
                }, true);
                this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 12 + 10, 32, 20, (class_2561)class_2561.method_43470((String)"Close"), buttonWidgetX -> this.method_25419()));
                this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(38, startY + offsetY * 12 + 10, 32, 20, (class_2561)class_2561.method_43470((String)"Menu"), buttonWidgetX -> {
                    this.closing = true;
                    WeatherClassicClient.defaultDebugPage = (byte)-1;
                }));
                if (this.tornadoSwitchingRef != 2) {
                    if (this.page < 5) {
                        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(108, startY + offsetY * 12 + 10, 32, 20, (class_2561)class_2561.method_43470((String)"Next"), buttonWidgetX -> {
                            this.page = (byte)(this.page + 1);
                            this.page = (byte)class_3532.method_15340((int)this.page, (int)0, (int)5);
                        }));
                    }
                    if (this.page > 0) {
                        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(73, startY + offsetY * 12 + 10, 32, 20, (class_2561)class_2561.method_43470((String)"Prev"), buttonWidgetX -> {
                            this.page = (byte)(this.page - 1);
                            this.page = (byte)class_3532.method_15340((int)this.page, (int)0, (int)5);
                        }));
                    }
                }
            }
            if (this.doneAnimating && (this.prevPage != this.page || this.tornadoSwitchingRef != ClientGlobal.customTornadoSwitchType)) {
                this.tornadoSwitchingRef = ClientGlobal.customTornadoSwitchType;
                if (this.tornadoSwitchingRef == 2) {
                    this.page = (byte)5;
                }
                this.prevPage = this.page;
                this.refreshChildren = true;
                this.method_37067();
            }
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25421() {
        return false;
    }

    private void createSwitchScreen(int startY, int offsetY) {
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 11, 137, 20, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte b = (byte)(ClientGlobal.customTornadoSwitchType + 1);
            if (b > 2) {
                b = 0;
            }
            WCNetworkClient.sendCustomTornadoSpawningPayload(ClientCustomTornadoConfig.getWeatherEventType(), ClientCustomTornadoConfig.getSpawnPercent(), ClientCustomTornadoConfig.getBiomeLockType(), b);
        }));
    }

    private void createSpawningScreen(int startY, int offsetY) {
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 3, 137, 20, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte b = (byte)(ClientCustomTornadoConfig.getWeatherEventType() + 1);
            if (b > (ClientCustomTornadoConfig.USING_ALT ? (byte)6 : (byte)8)) {
                b = 0;
            }
            WCNetworkClient.sendCustomTornadoSpawningPayload(b, ClientCustomTornadoConfig.getSpawnPercent(), ClientCustomTornadoConfig.getBiomeLockType(), ClientGlobal.customTornadoSwitchType);
        }));
        this.createAdditionSubtractionWidget(124, startY + offsetY * 5 + 24, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getSpawnPercent() - 0.05);
            if ((double)num < 0.01) {
                num = 0.0f;
            }
            num = class_3532.method_15363((float)num, (float)0.0f, (float)1.0f);
            WCNetworkClient.sendCustomTornadoSpawningPayload(ClientCustomTornadoConfig.getWeatherEventType(), num, ClientCustomTornadoConfig.getBiomeLockType(), ClientGlobal.customTornadoSwitchType);
        }, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getSpawnPercent() + 0.05);
            if ((double)(num = class_3532.method_15363((float)num, (float)0.0f, (float)1.0f)) > 0.95) {
                num = 1.0f;
            }
            WCNetworkClient.sendCustomTornadoSpawningPayload(ClientCustomTornadoConfig.getWeatherEventType(), num, ClientCustomTornadoConfig.getBiomeLockType(), ClientGlobal.customTornadoSwitchType);
        });
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 8 + 2, 137, 20, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte b = (byte)(ClientCustomTornadoConfig.getBiomeLockType() + 1);
            if (b > 5) {
                b = 0;
            }
            WCNetworkClient.sendCustomTornadoSpawningPayload(ClientCustomTornadoConfig.getWeatherEventType(), ClientCustomTornadoConfig.getSpawnPercent(), b, ClientGlobal.customTornadoSwitchType);
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 11, 137, 20, (class_2561)class_2561.method_43470((String)"\u00a7aTEST TORNADO"), buttonWidgetX -> WCNetworkClient.sendCustomTornadoSpawnPayload()));
    }

    private void createExtrasScreen(int startY, int offsetY) {
        this.createAdditionSubtractionWidget(129, startY + offsetY * 2 + 12, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getExtraParticleInterval() - 1);
            num = (short)class_3532.method_15340((int)num, (int)1, (int)10);
            WCNetworkClient.sendCustomTornadoExtrasPayload(num, ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        }, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getExtraParticleInterval() + 1);
            num = (short)class_3532.method_15340((int)num, (int)1, (int)10);
            WCNetworkClient.sendCustomTornadoExtrasPayload(num, ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        });
        this.createAdditionSubtractionWidget(117, startY + offsetY * 3 + 16, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getExtraParticleDistance() - 1);
            num = (byte)class_3532.method_15340((int)num, (int)1, (int)9);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), num, ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        }, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getExtraParticleDistance() + 1);
            num = (byte)class_3532.method_15340((int)num, (int)1, (int)9);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), num, ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        });
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(78, startY + offsetY * 5 + 2, 21, 14, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), !ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType())));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(82, startY + offsetY * 6 + 6, 21, 14, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), !ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType())));
        this.createAdditionSubtractionWidgetVertical(33, startY + offsetY * 7 + 8, buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            Vector3f colors = ClientCustomTornadoConfig.getColors();
            float num = (float)((double)colors.x - 0.1);
            num = (float)class_3532.method_15350((double)num, (double)0.1, (double)1.0);
            colors.set(num, colors.y, colors.z);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), colors, ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        }, buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            Vector3f colors = ClientCustomTornadoConfig.getColors();
            float num = (float)((double)colors.x + 0.1);
            num = (float)class_3532.method_15350((double)num, (double)0.1, (double)1.0);
            colors.set(num, colors.y, colors.z);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), colors, ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        });
        this.createAdditionSubtractionWidgetVertical(75, startY + offsetY * 7 + 8, buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            Vector3f colors = ClientCustomTornadoConfig.getColors();
            float num = (float)((double)colors.y - 0.1);
            num = (float)class_3532.method_15350((double)num, (double)0.1, (double)1.0);
            colors.set(colors.x, num, colors.z);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), colors, ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        }, buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            Vector3f colors = ClientCustomTornadoConfig.getColors();
            float num = (float)((double)colors.y + 0.1);
            num = (float)class_3532.method_15350((double)num, (double)0.1, (double)1.0);
            colors.set(colors.x, num, colors.z);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), colors, ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        });
        this.createAdditionSubtractionWidgetVertical(117, startY + offsetY * 7 + 8, buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            Vector3f colors = ClientCustomTornadoConfig.getColors();
            float num = (float)((double)colors.z - 0.1);
            num = (float)class_3532.method_15350((double)num, (double)0.1, (double)1.0);
            colors.set(colors.x, colors.y, num);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), colors, ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        }, buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            Vector3f colors = ClientCustomTornadoConfig.getColors();
            float num = (float)((double)colors.z + 0.1);
            num = (float)class_3532.method_15350((double)num, (double)0.1, (double)1.0);
            colors.set(colors.x, colors.y, num);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), colors, ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        });
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(71, startY + offsetY * 8 + 16, 21, 14, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            if (!ClientCustomTornadoConfig.getColorOverride()) {
                return;
            }
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), !ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType());
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(112, startY + offsetY * 10 + 4, 21, 14, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), !ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), ClientCustomTornadoConfig.getPassiveSoundType())));
        this.createAdditionSubtractionWidget(92, startY + offsetY * 11 + 10, buttonWidgetX -> {
            int num = ClientCustomTornadoConfig.getSoundDist() - 10;
            num = class_3532.method_15340((int)num, (int)0, (int)150);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), num, ClientCustomTornadoConfig.getPassiveSoundType());
        }, buttonWidgetX -> {
            int num = ClientCustomTornadoConfig.getSoundDist() + 10;
            num = class_3532.method_15340((int)num, (int)0, (int)150);
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), num, ClientCustomTornadoConfig.getPassiveSoundType());
        });
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(126, startY + offsetY * 11 + 8, 11, 14, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getPassiveSoundType() + 1);
            if (num > 4) {
                num = 0;
            }
            WCNetworkClient.sendCustomTornadoExtrasPayload(ClientCustomTornadoConfig.getExtraParticleInterval(), ClientCustomTornadoConfig.getExtraParticleDistance(), ClientCustomTornadoConfig.getCreateClouds(), ClientCustomTornadoConfig.getColorOverride(), ClientCustomTornadoConfig.getCloudColorOverride(), ClientCustomTornadoConfig.getColors(), ClientCustomTornadoConfig.getTakeSurroundingColor(), ClientCustomTornadoConfig.getSoundDist(), num);
        }));
    }

    private void createParticlesScreen(int startY, int offsetY) {
        this.createAdditionSubtractionWidget(117, startY + offsetY * 2 + 17, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getParticleCount() - 1);
            num = (byte)class_3532.method_15340((int)num, (int)1, (int)20);
            WCNetworkClient.sendCustomTornadoParticlesPayload(num, ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), ClientCustomTornadoConfig.getMidParticleSizeIncrease(), ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        }, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getParticleCount() + 1);
            num = (byte)class_3532.method_15340((int)num, (int)1, (int)20);
            WCNetworkClient.sendCustomTornadoParticlesPayload(num, ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), ClientCustomTornadoConfig.getMidParticleSizeIncrease(), ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        });
        this.createAdditionSubtractionWidget(123, startY + offsetY * 4 + 15, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getBaseParticleSizeIncrease() - 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), num, ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), ClientCustomTornadoConfig.getMidParticleSizeIncrease(), ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        }, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getBaseParticleSizeIncrease() + 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), num, ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), ClientCustomTornadoConfig.getMidParticleSizeIncrease(), ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        });
        this.createAdditionSubtractionWidget(117, startY + offsetY * 6 + 13, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getBottomParticleSizeIncrease() - 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), num, ClientCustomTornadoConfig.getMidParticleSizeIncrease(), ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        }, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getBottomParticleSizeIncrease() + 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), num, ClientCustomTornadoConfig.getMidParticleSizeIncrease(), ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        });
        this.createAdditionSubtractionWidget(113, startY + offsetY * 8 + 11, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getMidParticleSizeIncrease() - 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), num, ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        }, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getMidParticleSizeIncrease() + 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), num, ClientCustomTornadoConfig.getTopParticleSizeIncrease());
        });
        this.createAdditionSubtractionWidget(119, startY + offsetY * 10 + 9, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getTopParticleSizeIncrease() - 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), ClientCustomTornadoConfig.getMidParticleSizeIncrease(), num);
        }, buttonWidgetX -> {
            float num = (float)((double)ClientCustomTornadoConfig.getTopParticleSizeIncrease() + 0.05);
            num = (float)class_3532.method_15350((double)num, (double)0.0, (double)0.3);
            WCNetworkClient.sendCustomTornadoParticlesPayload(ClientCustomTornadoConfig.getParticleCount(), ClientCustomTornadoConfig.getBaseParticleSizeIncrease(), ClientCustomTornadoConfig.getBottomParticleSizeIncrease(), ClientCustomTornadoConfig.getMidParticleSizeIncrease(), num);
        });
    }

    private void createShapeScreen(int startY, int offsetY) {
        this.createAdditionSubtractionWidget(66, startY + offsetY * 2 + 17, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getParticleRadiusLvl() - 1);
            num = (byte)class_3532.method_15340((int)num, (int)0, (int)9);
            WCNetworkClient.sendCustomTornadoShapePayload(num, ClientCustomTornadoConfig.getFunnelWidth(), ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        }, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getParticleRadiusLvl() + 1);
            num = (byte)class_3532.method_15340((int)num, (int)0, (int)9);
            WCNetworkClient.sendCustomTornadoShapePayload(num, ClientCustomTornadoConfig.getFunnelWidth(), ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        });
        this.createAdditionSubtractionWidget(101, startY + offsetY * 4 + 15, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getFunnelWidth() - 1);
            num = (short)class_3532.method_15340((int)num, (int)0, (int)50);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), num, ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        }, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getFunnelWidth() + 1);
            num = (short)class_3532.method_15340((int)num, (int)0, (int)50);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), num, ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        });
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(116, startY + offsetY * 4 + 15, 20, 10, (class_2561)class_2561.method_43470((String)"< >"), buttonWidgetX -> {
            short num = ClientCustomTornadoConfig.getFunnelWidth();
            if (num >= 25 && num < 50) {
                num = 50;
            } else if (num == 50) {
                num = 0;
            } else if (num < 25 && num > 0) {
                num = 0;
            } else if (num == 0) {
                num = 50;
            }
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), num, ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        }));
        this.createAdditionSubtractionWidget(82, startY + offsetY * 6 + 13, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getFunnelPointedness() - 1);
            num = (byte)class_3532.method_15340((int)num, (int)1, (int)4);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), ClientCustomTornadoConfig.getFunnelWidth(), num, ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        }, buttonWidgetX -> {
            byte num = (byte)(ClientCustomTornadoConfig.getFunnelPointedness() + 1);
            num = (byte)class_3532.method_15340((int)num, (int)1, (int)4);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), ClientCustomTornadoConfig.getFunnelWidth(), num, ClientCustomTornadoConfig.getFunnelTightening(), ClientCustomTornadoConfig.getScaling());
        });
        this.createAdditionSubtractionWidget(92, startY + offsetY * 8 + 11, buttonWidgetX -> {
            float num = ClientCustomTornadoConfig.getFunnelTightening() - 0.1f;
            num = class_3532.method_15363((float)num, (float)0.0f, (float)1.0f);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), ClientCustomTornadoConfig.getFunnelWidth(), ClientCustomTornadoConfig.getFunnelPointedness(), num, ClientCustomTornadoConfig.getScaling());
        }, buttonWidgetX -> {
            float num = ClientCustomTornadoConfig.getFunnelTightening() + 0.1f;
            num = class_3532.method_15363((float)num, (float)0.0f, (float)1.0f);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), ClientCustomTornadoConfig.getFunnelWidth(), ClientCustomTornadoConfig.getFunnelPointedness(), num, ClientCustomTornadoConfig.getScaling());
        });
        this.createAdditionSubtractionWidget(115, startY + offsetY * 10 + 9, buttonWidgetX -> {
            float num = ClientCustomTornadoConfig.getScaling() - 0.1f;
            num = class_3532.method_15363((float)num, (float)0.5f, (float)3.0f);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), ClientCustomTornadoConfig.getFunnelWidth(), ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), num);
        }, buttonWidgetX -> {
            float num = ClientCustomTornadoConfig.getScaling() + 0.1f;
            num = class_3532.method_15363((float)num, (float)0.5f, (float)3.0f);
            WCNetworkClient.sendCustomTornadoShapePayload(ClientCustomTornadoConfig.getParticleRadiusLvl(), ClientCustomTornadoConfig.getFunnelWidth(), ClientCustomTornadoConfig.getFunnelPointedness(), ClientCustomTornadoConfig.getFunnelTightening(), num);
        });
    }

    private void createBehaviorScreen(int startY, int offsetY) {
        this.createAdditionSubtractionWidget(64, startY + offsetY * 2 + 7, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getSpeed() - 1);
            num = (short)class_3532.method_15340((int)num, (int)0, (int)9);
            WCNetworkClient.sendCustomTornadoAIPayload(num, this.bypassRipType(), ClientCustomTornadoConfig.getTime(), this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        }, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getSpeed() + 1);
            num = (short)class_3532.method_15340((int)num, (int)1, (int)9);
            WCNetworkClient.sendCustomTornadoAIPayload(num, this.bypassRipType(), ClientCustomTornadoConfig.getTime(), this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        });
        this.createInfoButton("\u00a7c!", 128, startY + offsetY * 2 + 7, "Setting the speed to 0 is recommended while customizing the tornado. This allows you to edit settings and view the tornado at the same time. The tornado can be spawned via the \u00a7lSpawning\u00a7f page.", false);
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(80, startY + offsetY * 3 + 9, 21, 14, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), ClientCustomTornadoConfig.getTime(), this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), !ClientCustomTornadoConfig.getChasePlayers())));
        this.createAdditionSubtractionWidget(122, startY + offsetY * 4 + 15, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getTime() - 100);
            num = (short)class_3532.method_15340((int)num, (int)500, (int)5000);
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), num, this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        }, buttonWidgetX -> {
            short num = (short)(ClientCustomTornadoConfig.getTime() + 100);
            num = (short)class_3532.method_15340((int)num, (int)500, (int)5000);
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), num, this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        });
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 6, 137, 20, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte b = (byte)(this.bypassRipType() + 1);
            if (b > 7) {
                b = 0;
            }
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), b, ClientCustomTornadoConfig.getTime(), this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 7 + 12, 137, 20, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte b = (byte)(this.bypassPullType() + 1);
            if (b > 5) {
                b = 0;
            }
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), ClientCustomTornadoConfig.getTime(), b, ClientCustomTornadoConfig.getDispellerResistance(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(3, startY + offsetY * 8 + 24, 137, 20, (class_2561)class_2561.method_43470((String)""), buttonWidgetX -> {
            byte b = (byte)(ClientCustomTornadoConfig.getDestructionLvlOverride() + 1);
            if (b > 2) {
                b = -1;
            }
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), ClientCustomTornadoConfig.getTime(), this.bypassPullType(), ClientCustomTornadoConfig.getDispellerResistance(), b, ClientCustomTornadoConfig.getChasePlayers());
        }));
        this.createAdditionSubtractionWidgetVertical(129, startY + offsetY * 10 + 17, buttonWidgetX -> {
            float num = ClientCustomTornadoConfig.getDispellerResistance() - 0.1f;
            num = class_3532.method_15363((float)num, (float)0.0f, (float)1.0f);
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), ClientCustomTornadoConfig.getTime(), this.bypassPullType(), num, ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        }, buttonWidgetX -> {
            float num = ClientCustomTornadoConfig.getDispellerResistance() + 0.1f;
            num = class_3532.method_15363((float)num, (float)0.0f, (float)1.0f);
            WCNetworkClient.sendCustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), this.bypassRipType(), ClientCustomTornadoConfig.getTime(), this.bypassPullType(), num, ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers());
        });
    }

    public byte bypassRipType() {
        return ClientCustomTornadoConfig.getRipType(true);
    }

    public byte bypassPullType() {
        return ClientCustomTornadoConfig.getPullType(true);
    }
}

