/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.item;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.Utils;
import net.weather_classic.moving_block.templates.MBTemplate;
import net.weather_classic.moving_block.templates.MBTemplateBuilder;
import net.weather_classic.moving_block.templates.MBTemplateFiles;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCItems;
import org.jetbrains.annotations.Nullable;

public class TemplateConstructor
extends class_1792 {
    private static final class_9279 C = class_9279.method_57456((class_2487)new class_2487());

    public TemplateConstructor(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        textConsumer.accept((class_2561)this.getDescription(stack));
    }

    public class_5250 getDescription(class_1799 stack) {
        if (stack.method_58694(WCItems.TSAVED) != null) {
            return class_2561.method_43471((String)(this.field_8014 + "_saved.desc")).method_27692(class_124.field_1060);
        }
        return class_2561.method_43471((String)(this.field_8014 + ".desc")).method_27692(class_124.field_1080);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5810) {
            return class_1269.field_5814;
        }
        class_1799 stack = user.method_5998(hand);
        if (!this.hasData(stack)) {
            this.setupData(stack);
        }
        if (!world.method_8608()) {
            class_2487 c = this.getData(stack).method_10553();
            int n = 0;
            for (MBTemplate template : MBTemplateFiles.activeTemplates) {
                c.method_10582(n + "---------------", template.templateName);
                int bd = 0;
                ArrayList blocks = new ArrayList();
                for (MBTemplate.TempData data : template.getData()) {
                    class_2248 block = data.state.method_26204();
                    if (blocks.contains(block)) continue;
                    c.method_10569(n + "---------------" + bd, class_2248.method_9507((class_2680)block.method_9564()));
                    ++bd;
                }
                ++n;
            }
            WCNetworkServer.sendCustomItemStatusPayload((class_3222)user, c);
        }
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() == class_1268.field_5810) {
            return class_1269.field_5814;
        }
        class_1657 user = context.method_8036();
        class_1799 itemStack = context.method_8041();
        user.method_6019(context.method_20287());
        if (!this.hasData(itemStack)) {
            this.setupData(itemStack);
        }
        class_2487 data = this.getData(itemStack);
        String name = (String)data.method_10558("template_name").get();
        if (!context.method_8045().method_8608()) {
            if (name.equals("BLANK_TEMPLATE")) {
                user.method_7353((class_2561)class_2561.method_43470((String)"Template cannot be called BLANK_TEMPLATE"), false);
                return class_1269.field_5814;
            }
            if (!user.method_5715()) {
                MBTemplate template = null;
                for (MBTemplate t : MBTemplateFiles.activeTemplates) {
                    if (!name.equals(t.templateName)) continue;
                    template = t;
                    break;
                }
                if (template != null) {
                    byte lvl = (byte)ModConfig.getConstructItemSpeedLvl();
                    MBTemplateBuilder builder = new MBTemplateBuilder(template.copy().rotateTowards(user.method_5735()), context.method_8037().method_10084(), (class_3218)context.method_8045(), data.method_68083("range", 24), data.method_68566("replace", false), lvl);
                    Global.templateBuilders.add(builder);
                    ArrayList<class_2248> blocks = new ArrayList<class_2248>();
                    for (MBTemplate.TempData tempData : template.getData()) {
                        class_2248 block = tempData.state.method_26204();
                        if (blocks.contains(block)) continue;
                        blocks.add(block);
                    }
                    ArrayList<Integer> bids = new ArrayList<Integer>();
                    for (class_2248 b : blocks) {
                        bids.add(class_2248.method_9507((class_2680)b.method_9564()));
                    }
                    int[] nArray = new int[bids.size()];
                    int index = 0;
                    Iterator iterator = bids.iterator();
                    while (iterator.hasNext()) {
                        int i;
                        nArray[index] = i = ((Integer)iterator.next()).intValue();
                        ++index;
                    }
                    data.method_10539("block_list", nArray);
                    this.setData(itemStack, data);
                    user.method_7353((class_2561)class_2561.method_43470((String)"Placed template"), false);
                } else {
                    user.method_7353((class_2561)class_2561.method_43470((String)("Template " + name + " cannot be placed: not yet defined")), false);
                    user.method_7353((class_2561)class_2561.method_43470((String)"Sneak to capture a new template"), false);
                }
                return class_1269.field_52422;
            }
            int[] blockIds = (int[])data.method_10561("block_list").get();
            if (blockIds.length <= 0) {
                user.method_7353((class_2561)class_2561.method_43470((String)"Allowed blocks list is empty"), false);
                return class_1269.field_5814;
            }
            MBTemplate template = MBTemplate.takeSnapshot((class_3218)context.method_8045(), context.method_8037(), data.method_68083("sizeXZ", 16), data.method_68083("sizeY", 16), name, user.method_5735(), blockIds);
            if (template == null) {
                user.method_7353((class_2561)class_2561.method_43470((String)"No allowed blocks found to capture"), false);
                return class_1269.field_21466;
            }
            if (MBTemplateFiles.saveNewTemplateToWorld((class_3218)context.method_8045(), template.asArchetype())) {
                user.method_7353((class_2561)class_2561.method_43470((String)("Saved template " + name + " to world")), false);
                Utils.playSound(null, context.method_8045(), user.method_24515(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.4f);
            } else {
                user.method_7353((class_2561)class_2561.method_43470((String)"You must give the template a name"), false);
            }
        }
        return class_1269.field_52422;
    }

    public void clearData(class_1799 stack) {
        stack.method_57379(WCItems.TEMPLATE_CONSTRUCTOR_DATA, null);
    }

    public void setData(class_1799 stack, class_2487 compound) {
        if (compound.method_10558("template_name").isPresent() && MBTemplateFiles.activeTemplates.stream().anyMatch(p -> p.templateName.equals(compound.method_10558("template_name").get()))) {
            stack.method_57379(WCItems.TSAVED, (Object)C);
        } else {
            stack.method_57379(WCItems.TSAVED, null);
        }
        stack.method_57379(WCItems.TEMPLATE_CONSTRUCTOR_DATA, (Object)class_9279.method_57456((class_2487)compound));
    }

    public class_2487 getData(class_1799 stack) {
        if (!this.hasData(stack)) {
            return null;
        }
        return ((class_9279)stack.method_58694(WCItems.TEMPLATE_CONSTRUCTOR_DATA)).method_57461();
    }

    public boolean hasData(class_1799 stack) {
        return stack.method_58694(WCItems.TEMPLATE_CONSTRUCTOR_DATA) != null;
    }

    public void setupData(class_1799 stack) {
        class_2487 compound = new class_2487();
        compound.method_10582("template_name", "BLANK_TEMPLATE");
        compound.method_10567("strength", (byte)0);
        compound.method_10569("sizeXZ", 8);
        compound.method_10569("sizeY", 8);
        compound.method_10569("range", 24);
        compound.method_10556("replace", false);
        compound.method_10539("block_list", new int[0]);
        compound.method_10567("umid", (byte)0);
        this.setData(stack, compound);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        super.method_7888(stack, world, entity, slot);
        if (this.hasData(stack)) {
            if (entity.method_5715()) {
                stack.method_57379(WCItems.TSAVING, (Object)C);
            } else {
                stack.method_57379(WCItems.TSAVING, null);
            }
            if (world.method_75260() % 200L == 0L) {
                class_2487 compound = this.getData(stack);
                if (compound.method_10558("template_name").isPresent() && MBTemplateFiles.activeTemplates.stream().anyMatch(p -> p.templateName.equals(compound.method_10558("template_name").get()))) {
                    stack.method_57379(WCItems.TSAVED, (Object)C);
                } else {
                    stack.method_57379(WCItems.TSAVED, null);
                }
            }
        }
    }
}

