/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.item;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCItems;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoRipper;
import net.weather_classic.storm.clusters.StormClusterPE;

public class WeatherReader
extends class_1792 {
    private static final class_9279 C = class_9279.method_57456((class_2487)new class_2487());

    public WeatherReader(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, class_1304 slot) {
        if (entity instanceof class_1657) {
            class_1657 user = (class_1657)entity;
            if (this.isSensor(stack)) {
                if (world.method_75260() % 80L == 0L) {
                    TornadoEntity ent = Global.getClosestTornado(entity.method_24515());
                    if (ent != null && ent.isDestructiveStorm() && Utils.squaredDistanceXZ(ent.method_24515(), entity.method_24515()) < (double)(ModConfig.getTornadoDetectorRange() * ModConfig.getTornadoDetectorRange())) {
                        if (!this.isForecasting(stack)) {
                            this.setForecasting(stack, true);
                        }
                        Utils.playSound(entity, (class_1937)world, entity.method_24515(), WeatherClassic.WEATHER_READER_ALERT, class_3419.field_15254, 1.0f, 1.0f);
                    } else if (this.isForecasting(stack)) {
                        this.setForecasting(stack, false);
                    }
                }
            } else if (!user.method_7357().method_7904(stack) && this.isForecasting(stack)) {
                this.setForecasting(stack, false);
                this.negateStatus(stack);
            }
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.method_8608()) {
            return class_1269.field_21466;
        }
        if (user.field_6012 < 10) {
            return class_1269.field_5814;
        }
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715()) {
            this.setSensor(stack, !this.isSensor(stack));
            user.method_7357().method_62835(stack, 20);
            Utils.playSound((class_1297)user, world, user.method_24515(), WeatherClassic.WEATHER_READER_CLICK, class_3419.field_15248, 1.0f, 0.2f);
            return class_1269.field_21466;
        }
        if (this.isSensor(stack)) {
            TornadoEntity tornado = Global.getClosestTornado(user.method_24515());
            if (tornado != null && Utils.distanceXZ(tornado.method_24515(), tornado.method_24515()) < 512.0) {
                TornadoRipper.RipType r = tornado.getStats().ripType;
                String m = "LOW DANGER";
                if (r.asByte() > 2) {
                    m = "\u00a74EXTREME DANGER";
                } else if (r.asByte() > 0) {
                    m = "\u00a7cSIGNIFICANT DANGER";
                }
                user.method_7353((class_2561)class_2561.method_43470((String)("[ Active Tornado: " + m + "\u00a7f ]")), true);
            } else {
                StormClusterPE c = Global.getClosestCluster(user.method_24515());
                if (c != null && Utils.distanceXZ(user.method_24515(), c.getBlockPos()) < 512.0) {
                    String s = "LOW RISK";
                    if ((double)c.getCurrentCap() > 0.8) {
                        s = "\u00a74EXTREME RISK";
                    } else if ((double)c.getCurrentCap() > 0.5) {
                        s = "\u00a7cHIGH RISK";
                    } else if ((double)c.getCurrentCap() > 0.3) {
                        s = "\u00a7eMODERATE RISK";
                    }
                    user.method_7353((class_2561)class_2561.method_43470((String)("[ Storm Cluster Detected: " + s + "\u00a7f ]")), true);
                } else {
                    user.method_7353((class_2561)class_2561.method_43470((String)"[ No Vortices Detected ]"), true);
                }
            }
            user.method_7357().method_62835(stack, 20);
            Utils.playSound((class_1297)user, world, user.method_24515(), WeatherClassic.WEATHER_READER_CLICK, class_3419.field_15248, 1.0f, 1.0f);
            return class_1269.field_21466;
        }
        this.setStatus(stack, WCItems.FORECASTING);
        float p = 1.0f;
        byte b = Global.retrieveGlobalForecast(world, user.method_24515());
        switch (b) {
            case 0: {
                user.method_7353((class_2561)class_2561.method_43470((String)"[ Forecast: CLEAR \u00a7f]"), true);
                this.setStatus(stack, WCItems.CLEAR_FORECASTED);
                break;
            }
            case 1: {
                user.method_7353((class_2561)class_2561.method_43470((String)"[ Forecast: \u00a71RAIN \u00a7f]"), true);
                this.setStatus(stack, WCItems.RAIN_FORECASTED);
                break;
            }
            case 2: {
                user.method_7353((class_2561)class_2561.method_43470((String)"[ Forecast: \u00a77SNOW \u00a7f]"), true);
                this.setStatus(stack, WCItems.SNOW_FORECASTED);
                break;
            }
            case 3: {
                if (Global.wind.getClusterCountdown() > 0 || Global.wind.getWindGustTime() > 0) {
                    user.method_7353((class_2561)class_2561.method_43470((String)"[ Forecast: \u00a76HIGH WIND \u00a7f]"), true);
                } else {
                    user.method_7353((class_2561)class_2561.method_43470((String)"[ Forecast: \u00a7eSTORM CLUSTER \u00a7f]"), true);
                }
                this.setStatus(stack, WCItems.GALE_FORECASTED);
                break;
            }
            case 4: {
                user.method_7353((class_2561)class_2561.method_43470((String)"[ Forecast: \u00a7cSTORM \u00a7f]"), true);
                this.setStatus(stack, WCItems.STORM_FORECASTED);
                break;
            }
            default: {
                p = 0.1f;
            }
        }
        this.cooldown(stack, user);
        Utils.playSound((class_1297)user, world, user.method_24515(), WeatherClassic.WEATHER_READER_CLICK, class_3419.field_15248, 1.0f, p);
        return class_1269.field_21466;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_2680 state = context.method_8045().method_8320(pos);
        if (state.method_27852(WCBlocks.TORNADO_SENSOR) && !context.method_8045().method_8608()) {
            this.setSensor(context.method_8041(), !this.isSensor(context.method_8041()));
            context.method_8036().method_7357().method_62835(context.method_8041(), 20);
            Utils.playSound((class_1297)context.method_8036(), context.method_8045(), context.method_8036().method_24515(), WeatherClassic.WEATHER_READER_CLICK, class_3419.field_15248, 1.0f, 0.2f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void cooldown(class_1799 stack, class_1657 user) {
        if (!user.method_73183().method_8608()) {
            user.method_7357().method_62835(stack, 40);
        }
    }

    public void negateStatus(class_1799 stack) {
        stack.method_57379(WCItems.RAIN_FORECASTED, null);
        stack.method_57379(WCItems.CLEAR_FORECASTED, null);
        stack.method_57379(WCItems.STORM_FORECASTED, null);
        stack.method_57379(WCItems.SNOW_FORECASTED, null);
        stack.method_57379(WCItems.GALE_FORECASTED, null);
        stack.method_57379(WCItems.STORM_FORECASTED, null);
    }

    public void setStatus(class_1799 stack, class_9331<class_9279> forecast) {
        stack.method_57379(forecast, (Object)C);
    }

    public void setForecasting(class_1799 stack, boolean b) {
        stack.method_57379(WCItems.FORECASTING, b ? C : null);
    }

    public boolean isForecasting(class_1799 stack) {
        return stack.method_58694(WCItems.FORECASTING) != null;
    }

    public void setSensor(class_1799 stack, boolean b) {
        stack.method_57379(WCItems.SENSOR, b ? C : null);
    }

    public boolean isSensor(class_1799 stack) {
        return stack.method_58694(WCItems.SENSOR) != null;
    }
}

