/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.moving_block;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2358;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.weather_classic.global.tools.TornadoDestructionInfo;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.moving_block.IMovingBlockState;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.storm.TornadoEntity;
import org.jetbrains.annotations.Nullable;

public class MovingBlockEntity
extends class_1676
implements IMovingBlockState {
    public final class_1937 world;
    private double damageMultiplier = 1.0;
    private double damage = 0.0;
    private float roll = 0.0f;
    private float lastRoll = 0.0f;
    private class_243 snapSpot = null;
    private MoveType moveType = MoveType.SMOOTH;
    private float rollGoal = 0.0f;
    private float pitchGoal = 0.0f;
    private float yawGoal = 0.0f;
    private boolean blockifyOnReachedSnap = false;
    private short hoverTime = (short)-1;
    private float rotationSpeed;
    private class_2338 specificSnapBlockPos = null;
    public static final class_2940<Integer> BLOCK = class_2945.method_12791(MovingBlockEntity.class, (class_2941)class_2943.field_13327);

    public MovingBlockEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
        this.world = world;
        this.method_5803(true);
        this.rotationSpeed = 8.0f + (float)world.method_8409().method_43048(15);
    }

    public static MovingBlockEntity createMB(class_1299<? extends class_1676> entityType, class_1309 owner, class_2680 block, boolean spinning, class_1937 world) {
        MovingBlockEntity debris = new MovingBlockEntity(entityType, world);
        debris.setBlockState(block);
        debris.method_5660(spinning);
        debris.method_7432((class_1297)owner);
        return debris;
    }

    public void method_5711(byte status) {
        super.method_5711(status);
    }

    public void method_5773() {
        super.method_5773();
        this.lastRoll = this.roll;
        this.travel(this.method_18798());
        boolean water = this.method_5869();
        if (water && this.snapSpot == null) {
            if (this.damageMultiplier > 1.0) {
                this.setDamageMultiplier(1.0);
            }
            Utils.setVelocityY((class_1297)this, TornadoDestructionInfo.isProtectiveBlock(this.getBlockState(), (byte)1) ? (double)-0.4f : -0.3);
            if (this.field_5992 || this.field_5976) {
                this.blockifyAt(this.method_24515());
            }
        }
        if (!Utils.isRawXZVelocityZero((class_1297)this)) {
            this.checkCollideWithEntities(false);
        }
        if (this.shouldSpin()) {
            this.method_36456(this.method_36454() + this.rotationSpeed);
            if (this.method_36454() > 359.0f) {
                this.method_36456(0.0f);
            }
            this.roll += this.rotationSpeed / 2.0f;
            if (this.roll > 359.0f) {
                this.roll = 0.0f;
            }
            if (this.method_5628() % 3 == 0) {
                this.method_36457(this.method_36455() + this.rotationSpeed / 2.0f);
                if (this.method_36455() > 359.0f) {
                    this.method_36457(0.0f);
                }
            }
        } else if (this.world.method_8608()) {
            if (this.method_36454() > this.yawGoal) {
                this.method_36456(this.method_36454() - this.rotationSpeed);
                if (this.method_36454() < this.yawGoal) {
                    this.method_36456(this.yawGoal);
                }
            } else if (this.method_36454() < this.yawGoal) {
                this.method_36456(this.method_36454() + this.rotationSpeed);
                if (this.method_36454() > this.yawGoal) {
                    this.method_36456(this.yawGoal);
                }
            }
            if (this.method_36455() > this.pitchGoal) {
                this.method_36457(this.method_36455() - this.rotationSpeed / 2.0f);
                if (this.method_36455() < this.pitchGoal) {
                    this.method_36457(this.pitchGoal);
                }
            } else if (this.method_36455() < this.pitchGoal) {
                this.method_36457(this.method_36455() + this.rotationSpeed / 2.0f);
                if (this.method_36455() > this.pitchGoal) {
                    this.method_36457(this.pitchGoal);
                }
            }
            if (this.roll > this.rollGoal) {
                this.roll -= this.rotationSpeed / 2.0f;
                if (this.roll < this.rollGoal) {
                    this.roll = this.rollGoal;
                }
            } else if (this.roll < this.rollGoal) {
                this.roll += this.rotationSpeed / 2.0f;
                if (this.roll > this.rollGoal) {
                    this.roll = this.rollGoal;
                }
            }
        }
        if (!this.world.method_8608()) {
            if (this.snapSpot != null) {
                switch (this.moveType.ordinal()) {
                    case 0: {
                        if (this.hoverTime > -1 && this.hoverTime < 40) {
                            this.hoverTime = (short)(this.hoverTime + 1);
                            Utils.setVelocityY((class_1297)this, 0.1f);
                            return;
                        }
                        if (Utils.distanceXYZ(this.method_73189(), this.snapSpot) < 1.0) {
                            this.method_18800(0.0, 0.0, 0.0);
                            if (!this.blockifyOnReachedSnap) break;
                            this.blockifyAt(this.specificSnapBlockPos != null ? this.specificSnapBlockPos : BP.of(this.snapSpot));
                            return;
                        }
                        class_243 currentPos = this.method_73189();
                        class_243 targetEntityPos = this.snapSpot;
                        class_243 toTarget = targetEntityPos.method_1020(currentPos).method_1029();
                        class_243 velocity = this.method_18798();
                        double acceleration = 0.1;
                        class_243 desiredVelocity = toTarget.method_1021(1.0);
                        class_243 newVelocity = velocity.method_1021(1.0 - acceleration).method_1019(desiredVelocity.method_1021(acceleration));
                        this.method_18799(newVelocity);
                        this.field_64356 = true;
                        break;
                    }
                    case 2: {
                        this.spinAroundSnapSpot(0.055f, 0.0f);
                        break;
                    }
                    default: {
                        this.method_30634(this.snapSpot.method_10216(), this.snapSpot.method_10214(), this.snapSpot.method_10215());
                        this.method_18800(0.0, 0.0, 0.0);
                        if (!this.blockifyOnReachedSnap) break;
                        this.blockifyAt(this.specificSnapBlockPos != null ? this.specificSnapBlockPos : BP.of(this.snapSpot));
                        return;
                    }
                }
            }
            if (this.field_6012 > 200) {
                this.method_31472();
            }
        }
    }

    public void blockifyOnSnap() {
        this.blockifyOnReachedSnap = true;
    }

    public void setSnapPos(class_243 pos, boolean hover, @Nullable class_2338 spec) {
        this.snapSpot = pos;
        this.moveType = MoveType.SMOOTH;
        this.method_5875(true);
        this.field_5960 = true;
        this.hoverTime = (short)(hover ? 0 : -1);
        this.specificSnapBlockPos = spec;
    }

    public void updateRotationGoals(float pitch, float yaw, float roll) {
        this.yawGoal = yaw;
        this.rollGoal = roll;
        this.pitchGoal = pitch;
        if (!this.world.method_8608()) {
            WCNetworkServer.sendMovingBlockDataPayload((class_3218)this.method_73183(), this.method_5628(), pitch, yaw, roll);
        }
    }

    public float getLerpedRoll(float delta) {
        return class_3532.method_17821((float)delta, (float)this.lastRoll, (float)this.roll);
    }

    public float method_61415(float delta) {
        return class_3532.method_17821((float)delta, (float)this.field_5982, (float)this.method_36454());
    }

    public float method_61414(float delta) {
        return class_3532.method_17821((float)delta, (float)this.field_6004, (float)this.method_36455());
    }

    public void setDamageMultiplier(double d) {
        this.damageMultiplier = d;
    }

    public void checkCollideWithEntities(boolean includeHost) {
        List entities = this.world.method_8333((class_1297)this, this.method_5829().method_1014(0.5), p -> p.method_5709());
        if (!entities.isEmpty()) {
            for (class_1297 ent : entities) {
                if (!includeHost && ent == this.method_24921() || this.world.method_8608()) continue;
                ent.method_64397((class_3218)this.world, this.world.method_48963().method_48798((class_1297)this), 2.0f * (float)this.damageMultiplier);
                if (!(this.getBlockState().method_26204() instanceof class_2358)) continue;
                ent.method_5639(10.0f);
            }
        }
    }

    public void blockifyAt(class_2338 pos) {
        if (!this.world.method_8320(pos).method_26215()) {
            this.world.method_22352(pos, true);
        }
        this.world.method_8501(pos, this.getBlockState());
        Utils.playSound(null, this.world, pos, this.getBlockState().method_26231().method_10598(), this.method_5634(), 1.0f, 1.0f);
        this.method_31472();
    }

    public boolean shouldSpin() {
        return this.method_5715();
    }

    protected void method_7454(class_3966 entityHitResult) {
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_5863() && !entity.field_5960;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_30949(class_1297 other) {
        if (other instanceof TornadoEntity || other instanceof IMovingBlockState) {
            return false;
        }
        return other.method_30948((class_1297)this) && !this.method_5794(other);
    }

    public void method_5982() {
        class_1657 entity = this.method_73183().method_8604(this.method_23317(), this.method_23318(), this.method_23321(), 256.0, null);
        if (entity != null) {
            return;
        }
        this.method_31472();
    }

    public void setBlockState(class_2680 state) {
        this.method_5841().method_12778(BLOCK, (Object)class_2248.method_9507((class_2680)state));
    }

    public class_2680 getBlockState() {
        return class_2248.method_9531((int)((Integer)this.method_5841().method_12789(BLOCK)));
    }

    public boolean method_5640(double distance) {
        int dist = 128;
        return distance < (double)(dist * dist);
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return source == world.method_48963().method_48829() || source == world.method_48963().method_51847() ? super.method_64397(world, source, amount) : false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BLOCK, (Object)class_2248.method_9507((class_2680)class_2246.field_10566.method_9564()));
    }

    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        if (!this.world.method_8608()) {
            nbt.method_71426("blockID", (Codec)Codec.INT).ifPresent(i -> this.setBlockState(class_2248.method_9531((int)i)));
            nbt.method_71426("damage", (Codec)Codec.DOUBLE).ifPresent(i -> {
                this.damage = i;
            });
            nbt.method_71426("damageMult", (Codec)Codec.DOUBLE).ifPresent(i -> {
                this.damageMultiplier = i;
            });
            nbt.method_71426("snapSpot", class_243.field_38277).ifPresent(i -> {
                this.snapSpot = i;
            });
            nbt.method_71426("blockifyOnReach", (Codec)Codec.BOOL).ifPresent(i -> {
                this.blockifyOnReachedSnap = i;
            });
            nbt.method_71426("specifyPos", (Codec)Codec.LONG).ifPresent(i -> {
                class_2338 pos;
                this.specificSnapBlockPos = pos = class_2338.method_10092((long)i);
            });
            nbt.method_71426("noclip", (Codec)Codec.BOOL).ifPresent(i -> {
                this.field_5960 = i;
            });
        }
    }

    public void method_5652(class_11372 nbt) {
        if (!this.world.method_8608()) {
            nbt.method_71465("blockID", ((Integer)this.field_6011.method_12789(BLOCK)).intValue());
            nbt.method_71463("damage", this.damage);
            nbt.method_71463("damageMult", this.damageMultiplier);
            if (this.snapSpot != null) {
                nbt.method_71477("snapSpot", class_243.field_38277, (Object)this.snapSpot);
            }
            nbt.method_71472("blockifyOnReach", this.blockifyOnReachedSnap);
            if (this.specificSnapBlockPos != null) {
                nbt.method_71466("specifyPos", this.specificSnapBlockPos.method_10063());
            }
            nbt.method_71472("noclip", this.field_5960);
        }
        super.method_5652(nbt);
    }

    public void method_18800(double x, double y, double z) {
        this.method_18799(new class_243(x, y, z));
    }

    public void travel(class_243 vel) {
        float f = 0.98f;
        if (this.method_5740()) {
            f = 1.0f;
        }
        double vv = vel.field_1351;
        if (!this.method_5740()) {
            vel = new class_243(vel.field_1352, (vv -= 0.08) * 0.96, vel.field_1350);
        }
        this.method_18800(vel.field_1352 * (double)f, vel.field_1351, vel.field_1350 * (double)f);
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    private void spinAroundSnapSpot(float speed, float velY) {
        double centerX = this.snapSpot.method_10216();
        double centerZ = this.snapSpot.method_10215();
        double dx = this.method_23317() - centerX;
        double dz = this.method_23321() - centerZ;
        double radius = Math.sqrt(dx * dx + dz * dz);
        double angle = Math.atan2(dz, dx);
        double rotationSpeed = speed / 3.0f;
        double targetX = centerX + radius * Math.cos(angle += rotationSpeed);
        double targetZ = centerZ + radius * Math.sin(angle);
        this.method_18800(targetX - this.method_23317(), velY, targetZ - this.method_23321());
    }

    public static enum MoveType {
        SMOOTH,
        TELEPORT,
        ROTATE;

    }
}

