/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.moving_block.templates;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.moving_block.MovingBlockEntity;
import net.weather_classic.registry.WCEntities;

public class MBTemplate {
    private Set<TempData> positions = new HashSet<TempData>();
    private boolean finished = false;
    private byte curSearchIndex = 0;
    private Set<class_2338> filledPositions = new HashSet<class_2338>();
    private int initIndex = 0;
    private boolean init = false;
    private class_2350 savedDirection = class_2350.field_11043;
    public final String templateName;
    private boolean archetype = false;
    private short iterationWithNoLuck = 0;
    public static final short maxBlocks = 3200;
    Set<Pair<class_2338, class_2680>> swapData = new HashSet<Pair<class_2338, class_2680>>();

    public MBTemplate(Set<TempData> positions, class_2350 baseDir, String name) {
        positions.forEach(p -> this.positions.add((TempData)p));
        this.savedDirection = baseDir;
        this.templateName = name;
    }

    public MBTemplate asArchetype() {
        this.archetype = true;
        return this;
    }

    public boolean isArchetype() {
        return this.archetype;
    }

    public Set<TempData> getData() {
        return this.positions;
    }

    public byte getSavedDirectionValue() {
        switch (this.savedDirection) {
            case field_11039: {
                return 1;
            }
            case field_11034: {
                return 2;
            }
            case field_11035: {
                return 3;
            }
        }
        return 0;
    }

    public static class_2350 getTemplateDirectionFromByte(byte b) {
        switch (b) {
            case 1: {
                return class_2350.field_11039;
            }
            case 2: {
                return class_2350.field_11034;
            }
            case 3: {
                return class_2350.field_11035;
            }
        }
        return class_2350.field_11043;
    }

    private class_238 getIndoorCheckArea(class_2338 start, int maxRangeXZ, int maxRangeY, byte t) {
        class_2338 lowerBound;
        class_2338 upperBound = switch (t) {
            case 0 -> {
                lowerBound = start.method_10069(-maxRangeXZ, -maxRangeY, -maxRangeXZ);
                yield start;
            }
            case 1 -> {
                lowerBound = start.method_10069(0, -maxRangeY, -maxRangeXZ);
                yield start.method_10069(maxRangeXZ, 0, 0);
            }
            case 2 -> {
                lowerBound = start.method_10069(-maxRangeXZ, -maxRangeY, 0);
                yield start.method_10069(0, 0, maxRangeXZ);
            }
            case 3 -> {
                lowerBound = start.method_10069(0, -maxRangeY, 0);
                yield start.method_10069(maxRangeXZ, 0, maxRangeXZ);
            }
            case 4 -> {
                lowerBound = start.method_10069(-maxRangeXZ, 0, -maxRangeXZ);
                yield start.method_10069(0, maxRangeY, 0);
            }
            case 5 -> {
                lowerBound = start.method_10069(0, 0, -maxRangeXZ);
                yield start.method_10069(maxRangeXZ, maxRangeY, 0);
            }
            case 6 -> {
                lowerBound = start.method_10069(-maxRangeXZ, 0, 0);
                yield start.method_10069(0, maxRangeY, maxRangeXZ);
            }
            case 7 -> {
                lowerBound = start;
                yield start.method_10069(maxRangeXZ, maxRangeY, maxRangeXZ);
            }
            default -> {
                lowerBound = start;
                yield start.method_10069(maxRangeXZ, maxRangeY, maxRangeXZ);
            }
        };
        return new class_238((double)lowerBound.method_10263(), (double)lowerBound.method_10264(), (double)lowerBound.method_10260(), (double)upperBound.method_10263(), (double)upperBound.method_10264(), (double)upperBound.method_10260());
    }

    public void createStrictTick(int interval, class_2338 around, class_3218 world, int xzRange, int yRange, float probSkip) {
        boolean replace = true;
        if (world.method_75260() % (long)interval != 0L) {
            return;
        }
        boolean oor = this.isOutOfRange(world, around);
        if (this.positions.isEmpty() || this.iterationWithNoLuck > 50) {
            this.finished = true;
            return;
        }
        this.curSearchIndex = (byte)(this.curSearchIndex + 1);
        if (this.curSearchIndex > 7) {
            this.curSearchIndex = 0;
        }
        boolean found = false;
        Iterator it = class_2338.method_62671((class_238)this.getIndoorCheckArea(around, xzRange, yRange, this.curSearchIndex)).iterator();
        while (it.hasNext() && !this.positions.isEmpty()) {
            class_2680 state;
            TempData[] array = this.positions.toArray(new TempData[0]);
            int randomIndex = world.method_8409().method_43048(this.positions.size());
            TempData nextData = array[randomIndex];
            class_2338 toGoTo = around.method_10081(nextData.pos);
            class_2680 toGoStateStart = world.method_8320(toGoTo);
            if (toGoStateStart.equals((Object)nextData.state)) {
                this.positions.remove(nextData);
                this.filledPositions.add(toGoTo);
                continue;
            }
            Iterator<Pair<class_2338, class_2680>> swapIterator = this.swapData.iterator();
            while (swapIterator.hasNext()) {
                Pair<class_2338, class_2680> next = swapIterator.next();
                if (!nextData.state.method_27852(((class_2680)next.getSecond()).method_26204())) continue;
                if (oor) {
                    world.method_8501(toGoTo, nextData.state);
                    this.filledPositions.add(toGoTo);
                    this.positions.remove(nextData);
                    swapIterator.remove();
                    if (toGoStateStart.method_26215()) break;
                    this.swapData.add((Pair<class_2338, class_2680>)Pair.of((Object)toGoTo, (Object)toGoStateStart));
                    break;
                }
                MovingBlockEntity mb = new MovingBlockEntity(WCEntities.MOVING_BLOCK, (class_1937)world);
                mb.method_60949(((class_2338)next.getFirst()).method_61082(), 0.0f, 0.0f);
                mb.setSnapPos(toGoTo.method_46558(), false, toGoTo);
                mb.blockifyOnSnap();
                mb.setBlockState(nextData.state);
                world.method_8649((class_1297)mb);
                this.filledPositions.add(toGoTo);
                this.positions.remove(nextData);
                swapIterator.remove();
                if (toGoStateStart.method_26215()) break;
                this.swapData.add((Pair<class_2338, class_2680>)Pair.of((Object)toGoTo, (Object)toGoStateStart));
                world.method_8501(toGoTo, class_2246.field_10124.method_9564());
                break;
            }
            boolean swap = false;
            if (!toGoStateStart.method_26215() && !replace) {
                swap = true;
            }
            class_2338 next = (class_2338)it.next();
            if (world.method_8409().method_43057() < 0.15f && this.iterationWithNoLuck <= 25 || this.filledPositions.contains(next) || !(state = world.method_8320(next)).method_27852(nextData.state.method_26204())) continue;
            found = true;
            if (oor) {
                if (swap) {
                    this.swapData.add((Pair<class_2338, class_2680>)Pair.of((Object)toGoTo, (Object)toGoStateStart));
                }
                world.method_8501(toGoTo, nextData.state);
                this.filledPositions.add(toGoTo);
                this.positions.remove(nextData);
            } else {
                if (swap) {
                    this.swapData.add((Pair<class_2338, class_2680>)Pair.of((Object)toGoTo, (Object)toGoStateStart));
                    world.method_8501(toGoTo, class_2246.field_10124.method_9564());
                }
                world.method_8501(next, class_2246.field_10124.method_9564());
                MovingBlockEntity mb = new MovingBlockEntity(WCEntities.MOVING_BLOCK, (class_1937)world);
                mb.method_60949(next.method_61082(), 0.0f, 0.0f);
                mb.setSnapPos(toGoTo.method_46558(), false, toGoTo);
                mb.blockifyOnSnap();
                mb.setBlockState(nextData.state);
                world.method_8649((class_1297)mb);
                this.filledPositions.add(toGoTo);
                this.positions.remove(nextData);
            }
            if (!(world.method_8409().method_43057() < probSkip)) continue;
            break;
        }
        this.iterationWithNoLuck = !found ? (short)(this.iterationWithNoLuck + 1) : (short)0;
    }

    public void createMessyTick(int interval, class_2338 around, class_3218 world, int range, int countPerTick) {
        boolean replace = true;
        if (world.method_75260() % (long)interval != 0L) {
            return;
        }
        boolean oor = this.isOutOfRange(world, around);
        if (this.positions.isEmpty() || this.iterationWithNoLuck > 50) {
            this.finished = true;
            return;
        }
        boolean found = false;
        Iterator<TempData> posIterator = this.positions.iterator();
        Iterator it = class_2338.method_34848((class_5819)world.field_9229, (int)countPerTick, (class_2338)around, (int)range).iterator();
        while (it.hasNext() && posIterator.hasNext()) {
            class_2338 next = (class_2338)it.next();
            class_2338 top = world.method_8598(class_2902.class_2903.field_13197, next).method_10074();
            if (Math.abs(top.method_10264() - next.method_10264()) < 24 && (double)world.method_8409().method_43057() < 0.7) {
                next = top;
            }
            class_2680 state = world.method_8320(next);
            TempData nextData = posIterator.next();
            class_2338 toGoTo = around.method_10081(nextData.pos);
            if (!Utils.canPassThrough((class_1936)world, toGoTo) && !replace) {
                posIterator.remove();
                this.filledPositions.add(toGoTo);
                continue;
            }
            if (state.method_26215() || Utils.canPassThrough(state.method_26204()) || this.filledPositions.contains(next)) continue;
            found = true;
            world.method_8501(next, class_2246.field_10124.method_9564());
            if (oor) {
                world.method_8501(toGoTo, state);
                posIterator.remove();
                this.filledPositions.add(toGoTo);
                continue;
            }
            MovingBlockEntity mb = new MovingBlockEntity(WCEntities.MOVING_BLOCK, (class_1937)world);
            mb.method_60949(next.method_61082(), 0.0f, 0.0f);
            posIterator.remove();
            mb.setSnapPos(toGoTo.method_61082(), true, toGoTo);
            mb.blockifyOnSnap();
            mb.setBlockState(state);
            world.method_8649((class_1297)mb);
            this.filledPositions.add(toGoTo);
        }
        this.iterationWithNoLuck = !found ? (short)(this.iterationWithNoLuck + 1) : (short)0;
    }

    private boolean isOutOfRange(class_3218 world, class_2338 pos) {
        if (world.method_18456().isEmpty()) {
            return true;
        }
        int viewDistance = world.method_8503().method_3760().method_14568();
        class_2791 chunk = world.method_22350(pos);
        class_2338 c = chunk.method_12004().method_33943(0);
        class_1657 player = world.method_8604((double)c.method_10263(), (double)c.method_10264(), (double)c.method_10260(), -1.0, null);
        if (player == null) {
            return true;
        }
        int dist = (int)Utils.distanceXZ(chunk.method_12004().field_9181, chunk.method_12004().field_9180, player.method_31476().field_9181, player.method_31476().field_9180);
        if (dist < 2) {
            return false;
        }
        return dist > viewDistance - 2;
    }

    public boolean isDone() {
        return this.finished;
    }

    public boolean isInit() {
        return this.init || this.isArchetype();
    }

    public void initializeTemplateTick(int interval, class_3218 world, class_2338 from) {
        if (world.method_75260() % (long)interval != 0L || this.isInit()) {
            return;
        }
        if (this.positions.isEmpty()) {
            this.finished = true;
            return;
        }
        if (this.initIndex >= this.positions.size()) {
            this.init = true;
            return;
        }
        TempData[] array = this.positions.toArray(new TempData[0]);
        TempData nextData = array[this.initIndex];
        if (nextData != null) {
            class_2338 toGoTo = from.method_10081(nextData.pos);
            for (class_243 v : Utils.getVecLine((class_1937)world, from.method_46558(), toGoTo.method_46558(), (float)Utils.distanceXYZ(toGoTo, from) * 2.0f)) {
                world.method_14199((class_2394)class_2398.field_50252, false, true, v.method_10216(), v.method_10214(), v.method_10215(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            Utils.playSound(null, (class_1937)world, from, class_3417.field_15102, class_3419.field_15245, 2.0f, 0.8f + world.method_8409().method_43057() / 3.0f);
        }
        ++this.initIndex;
    }

    public MBTemplate rotateTowards(class_2350 newDirection) {
        class_2350 oldDirection = this.savedDirection;
        if (oldDirection == newDirection) {
            return this;
        }
        HashSet<TempData> newPositions = new HashSet<TempData>();
        int rotationSteps = this.getRotationSteps(oldDirection, newDirection);
        for (TempData data : this.positions) {
            class_2382 relativePosition = data.pos;
            class_2680 dataState = data.state;
            if (rotationSteps > 0) {
                for (class_2769 property : dataState.method_28501()) {
                    class_2769 cpy;
                    class_2350 oldProp;
                    if (property.method_11902() == class_2350.class && (oldProp = (class_2350)dataState.method_11654(cpy = property)).method_10166().method_10179()) {
                        dataState = (class_2680)dataState.method_11657(cpy, (Comparable)(rotationSteps == 3 ? oldProp.method_10160() : (rotationSteps == 2 ? oldProp.method_10170().method_10170() : oldProp.method_10170())));
                    }
                    if (property.method_11902() == class_2350.class_2351.class && (oldProp = (class_2350.class_2351)dataState.method_11654(cpy = property)).method_10179()) {
                        dataState = (class_2680)dataState.method_11657(cpy, (Comparable)(rotationSteps != 2 ? (oldProp == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048) : oldProp));
                    }
                    if (!(dataState.method_26204() instanceof class_2310)) continue;
                    switch (rotationSteps) {
                        case 2: {
                            dataState = (class_2680)((class_2680)((class_2680)((class_2680)dataState.method_11657((class_2769)class_2310.field_10905, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10904)))).method_11657((class_2769)class_2310.field_10907, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10903)))).method_11657((class_2769)class_2310.field_10904, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10905)))).method_11657((class_2769)class_2310.field_10903, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10907)));
                        }
                        case 3: {
                            dataState = (class_2680)((class_2680)((class_2680)((class_2680)dataState.method_11657((class_2769)class_2310.field_10905, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10907)))).method_11657((class_2769)class_2310.field_10907, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10904)))).method_11657((class_2769)class_2310.field_10904, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10903)))).method_11657((class_2769)class_2310.field_10903, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10905)));
                        }
                    }
                    dataState = (class_2680)((class_2680)((class_2680)((class_2680)dataState.method_11657((class_2769)class_2310.field_10905, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10903)))).method_11657((class_2769)class_2310.field_10907, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10905)))).method_11657((class_2769)class_2310.field_10904, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10907)))).method_11657((class_2769)class_2310.field_10903, (Comparable)((Boolean)dataState.method_11654((class_2769)class_2310.field_10904)));
                }
            }
            class_2382 newRelativePosition = this.rotateAroundY(relativePosition, rotationSteps);
            newPositions.add(new TempData(newRelativePosition, dataState));
        }
        this.positions = newPositions;
        this.savedDirection = newDirection;
        return this;
    }

    private int getRotationSteps(class_2350 oldDir, class_2350 newDir) {
        switch (oldDir) {
            case field_11034: {
                if (newDir == class_2350.field_11035) {
                    return 1;
                }
                if (newDir == class_2350.field_11039) {
                    return 2;
                }
                if (newDir == class_2350.field_11043) {
                    return 3;
                }
                return 0;
            }
            case field_11035: {
                if (newDir == class_2350.field_11043) {
                    return 2;
                }
                if (newDir == class_2350.field_11039) {
                    return 1;
                }
                if (newDir == class_2350.field_11034) {
                    return 3;
                }
                return 0;
            }
            case field_11039: {
                if (newDir == class_2350.field_11035) {
                    return 3;
                }
                if (newDir == class_2350.field_11043) {
                    return 1;
                }
                if (newDir == class_2350.field_11034) {
                    return 2;
                }
                return 0;
            }
        }
        if (newDir == class_2350.field_11035) {
            return 2;
        }
        if (newDir == class_2350.field_11039) {
            return 3;
        }
        if (newDir == class_2350.field_11034) {
            return 1;
        }
        return 0;
    }

    private class_2382 rotateAroundY(class_2382 pos, int steps) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        switch (steps % 4) {
            case 1: {
                return new class_2382(-z, y, x);
            }
            case 2: {
                return new class_2382(-x, y, -z);
            }
            case 3: {
                return new class_2382(z, y, -x);
            }
        }
        return pos;
    }

    public static MBTemplate takeSnapshot(class_3218 world, class_2338 center, int areaXZ, int areaY, String name, class_2350 dir, int[] blockIds) {
        HashSet<class_2248> blocksWL = new HashSet<class_2248>();
        for (int i : blockIds) {
            blocksWL.add(class_2248.method_9531((int)i).method_26204());
        }
        if (blocksWL.isEmpty()) {
            return null;
        }
        HashSet<TempData> posList = new HashSet<TempData>();
        Iterator it = class_2338.method_10097((class_2338)center.method_10069(-(areaXZ /= 2), -1, -areaXZ), (class_2338)center.method_10069(areaXZ, areaY, areaXZ)).iterator();
        int num = 0;
        while (it.hasNext()) {
            class_2338 next = (class_2338)it.next();
            class_2680 state = world.method_8320(next);
            if (!MBTemplate.canTemplateSaveBlock(state) || !blocksWL.contains(state.method_26204())) continue;
            if (++num > 3200) break;
            class_2338 toAdd = next.method_10062().method_10059((class_2382)center);
            posList.add(new TempData((class_2382)toAdd, state));
        }
        return posList.isEmpty() ? null : new MBTemplate(posList, dir, name);
    }

    public MBTemplate copy() {
        HashSet<TempData> posList = new HashSet<TempData>();
        posList.addAll(this.positions);
        return new MBTemplate(posList, this.savedDirection, this.templateName);
    }

    public static boolean canTemplateSaveBlock(class_2680 state) {
        return !Materials.isDecoration(state) && !Materials.isWiring(state) && !Utils.canPassThrough(state.method_26204()) && !(state.method_26204() instanceof class_2343) && !(state.method_26204() instanceof class_2237) && !state.method_27852(class_2246.field_9987) && !state.method_27852(class_2246.field_10499);
    }

    public static class TempData {
        public final class_2382 pos;
        public final class_2680 state;

        public TempData(class_2382 pos, class_2680 state) {
            this.pos = pos;
            this.state = state;
        }
    }
}

