/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.moving_block.templates;

import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.weather_classic.moving_block.templates.MBTemplate;

public class MBTemplateBuilder {
    private final MBTemplate template;
    public final class_2338 pos;
    public final class_3218 world;
    private boolean forceEnd = false;
    private final int range;
    private final boolean useAny;
    private final byte lvl;

    public MBTemplateBuilder(MBTemplate template, class_2338 from, class_3218 world, int range, boolean replace, byte lvl) {
        this.template = template;
        this.pos = from;
        this.world = world;
        this.range = range;
        this.useAny = replace;
        this.lvl = lvl;
    }

    public void run(class_3218 world) {
        if (!world.equals(this.world)) {
            this.forceEnd = true;
            return;
        }
        if (!this.template.isDone()) {
            if (!this.useAny) {
                this.template.createStrictTick(this.getIntervalRateForLvl(false), this.pos, world, this.range, (int)((double)this.range * 0.8), this.getSkipProbForLvl());
            } else {
                this.template.createMessyTick(this.getIntervalRateForLvl(true), this.pos, world, this.range, this.getCountForLvl());
            }
        }
    }

    public int getIntervalRateForLvl(boolean messy) {
        switch (this.lvl) {
            case 0: {
                return this.isUsingFarRange() ? 8 : 6;
            }
            case 1: {
                return this.isUsingFarRange() ? 6 : 4;
            }
        }
        return this.isUsingFarRange() ? 5 : 2;
    }

    public int getCountForLvl() {
        switch (this.lvl) {
            case 2: {
                return 30;
            }
            case 1: {
                return 10;
            }
        }
        return 6;
    }

    public float getSkipProbForLvl() {
        switch (this.lvl) {
            case 2: {
                return this.isUsingFarRange() ? 0.1f : 0.02f;
            }
            case 1: {
                return this.isUsingFarRange() ? 0.4f : 0.3f;
            }
        }
        return this.isUsingFarRange() ? 0.5f : 0.4f;
    }

    public boolean isUsingFarRange() {
        return this.range > 12;
    }

    public boolean isCompleted() {
        return this.template.isDone() || this.forceEnd;
    }
}

