/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.moving_block.templates;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.weather_classic.moving_block.templates.MBTemplate;

public class MBTemplateFiles {
    public static List<MBTemplate> activeTemplates = new ArrayList<MBTemplate>();
    public static final byte MAX_TEMPLATES = 100;
    public static MBTemplate TEST_TEMPLATE;

    public static void initTemplates() {
        HashSet<MBTemplate.TempData> datas = new HashSet<MBTemplate.TempData>();
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                for (int y = 0; y < 36; ++y) {
                    datas.add(new MBTemplate.TempData(new class_2382(x, y, z), class_2246.field_10566.method_9564()));
                }
            }
        }
        TEST_TEMPLATE = new MBTemplate(datas, class_2350.field_11043, "titog");
    }

    public static boolean loadTemplatesForWorld(class_3218 world) {
        File[] templateFiles;
        activeTemplates.clear();
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File mbtemplatesDir = new File(worldDir, "wm_data/mbtemplates");
        if (!mbtemplatesDir.exists()) {
            mbtemplatesDir.mkdirs();
        }
        if ((templateFiles = mbtemplatesDir.listFiles()) != null) {
            int num = 0;
            for (File dataFile : templateFiles) {
                MBTemplate t;
                if (num > 100) break;
                if (!dataFile.isFile() || (t = MBTemplateFiles.loadTemplate(dataFile)) == null) continue;
                activeTemplates.removeIf(p -> p.templateName.equals(t.templateName));
                activeTemplates.add(t);
                ++num;
            }
        }
        return true;
    }

    public static boolean removeTemplateFromWorld(class_3218 world, String name) {
        File[] templateFiles;
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File mbtemplatesDir = new File(worldDir, "wm_data/mbtemplates");
        if (!mbtemplatesDir.exists()) {
            mbtemplatesDir.mkdirs();
        }
        if ((templateFiles = mbtemplatesDir.listFiles()) != null) {
            for (File dataFile : templateFiles) {
                MBTemplate t;
                if (!dataFile.isFile() || (t = MBTemplateFiles.loadTemplate(dataFile)) == null || !t.templateName.equals(name)) continue;
                activeTemplates.removeIf(p -> p.templateName.equals(t.templateName));
                dataFile.delete();
                return true;
            }
        }
        return false;
    }

    public static boolean removeAllTemplatesFromWorld(class_3218 world) {
        File[] templateFiles;
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File mbtemplatesDir = new File(worldDir, "wm_data/mbtemplates");
        if (!mbtemplatesDir.exists()) {
            mbtemplatesDir.mkdirs();
        }
        if ((templateFiles = mbtemplatesDir.listFiles()) != null) {
            for (File dataFile : templateFiles) {
                if (!dataFile.isFile()) continue;
                dataFile.delete();
            }
        }
        activeTemplates.clear();
        return true;
    }

    public static boolean saveNewTemplateToWorld(class_3218 world, MBTemplate template) {
        File newFile;
        if (template.templateName.equals("BLANK_TEMPLATE")) {
            return false;
        }
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File mbtemplatesDir = new File(worldDir, "wm_data/mbtemplates");
        if (!mbtemplatesDir.exists()) {
            mbtemplatesDir.mkdirs();
        }
        if (!(newFile = new File(mbtemplatesDir, template.templateName + ".json")).exists()) {
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed to create new template for Weather Mod!");
            }
        }
        MBTemplateFiles.writeTemplateToFile(newFile, template);
        activeTemplates.removeIf(p -> p.templateName.equals(template.templateName));
        activeTemplates.add(template);
        return true;
    }

    private static void writeTemplateToFile(File dataFile, MBTemplate template) {
        Properties properties = new Properties();
        properties.setProperty("svdDir", String.valueOf(template.getSavedDirectionValue()));
        properties.setProperty("templId", template.templateName);
        int index = 0;
        for (MBTemplate.TempData data : template.getData()) {
            long v = class_2338.method_10064((int)data.pos.method_10263(), (int)data.pos.method_10264(), (int)data.pos.method_10260());
            properties.setProperty(index + "ro", String.valueOf(v));
            int stateId = class_2248.method_9507((class_2680)data.state);
            properties.setProperty(index + "st", String.valueOf(stateId));
            ++index;
        }
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static MBTemplate loadTemplate(File dataFile) {
        Properties properties = new Properties();
        int none = -9291482;
        byte savedDir = 0;
        String name = "NONE_PRESENT";
        HashSet<MBTemplate.TempData> datas = new HashSet<MBTemplate.TempData>();
        try (FileInputStream input = new FileInputStream(dataFile);){
            properties.load(input);
            savedDir = Byte.parseByte(properties.getProperty("svdDir", String.valueOf(0)));
            name = properties.getProperty("templId", name);
            for (int i = 0; i < 3200; ++i) {
                long relativePosition = Long.parseLong(properties.getProperty(i + "ro", String.valueOf(none)));
                int stateId = Integer.parseInt(properties.getProperty(i + "st", String.valueOf(none)));
                if (relativePosition == (long)none) break;
                if (stateId == none) {
                    break;
                }
                class_2338 posI = class_2338.method_10092((long)relativePosition);
                datas.add(new MBTemplate.TempData((class_2382)posI, class_2248.method_9531((int)stateId)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return datas.isEmpty() || name.equals("NONE_PRESENT") ? null : new MBTemplate(datas, MBTemplate.getTemplateDirectionFromByte(savedDir), name);
    }
}

