/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_11944;
import net.minecraft.class_12249;
import net.minecraft.class_1933;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_778;
import net.weather_classic.config.ModConfig;
import net.weather_classic.help.Utils;
import net.weather_classic.particle.TornadoParticle;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class DebrisParticle
extends TornadoParticle {
    public static int activeDebrisParticles = 0;
    private final int id;
    private final class_1087 model;
    private final class_2680 blockState;
    public boolean inWater = false;
    private final class_310 client;
    private float lastAngleX = 0.0f;
    private float lastAngleZ = 0.0f;
    private float lastAngleY = 0.0f;
    private final boolean isFoliage;
    private final boolean rotateYNegative;
    private final boolean rotateOnX;
    private final boolean rotateXZNegative;
    private final float rotationSpeed;
    private Quaternionf rotationProfile = new Quaternionf();
    private static final int DEFAULT_GRASS_COLOR = class_1933.method_49724();
    private static final float DEFAULT_GRASS_R = (float)(DEFAULT_GRASS_COLOR >> 16 & 0xFF) / 255.0f;
    private static final float DEFAULT_GRASS_G = (float)(DEFAULT_GRASS_COLOR >> 8 & 0xFF) / 255.0f;
    private static final float DEFAULT_GRASS_B = (float)(DEFAULT_GRASS_COLOR & 0xFF) / 255.0f;
    private static final int DEFAULT_FOLIAGE_COLOR = class_1933.method_49724();
    private static final float DEFAULT_FOLIAGE_R = (float)(DEFAULT_FOLIAGE_COLOR >> 16 & 0xFF) / 255.0f;
    private static final float DEFAULT_FOLIAGE_G = (float)(DEFAULT_FOLIAGE_COLOR >> 8 & 0xFF) / 255.0f;
    private static final float DEFAULT_FOLIAGE_B = (float)(DEFAULT_FOLIAGE_COLOR & 0xFF) / 255.0f;

    protected DebrisParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_4002 pr) {
        super(clientWorld, d, e, f, g, h, i, pr);
        this.id = clientWorld.field_9229.method_43054();
        this.method_3087(1.0f);
        class_2680 gState = class_2248.method_9531((int)((int)i));
        this.blockState = gState.method_26215() ? class_2246.field_10566.method_9564() : class_2248.method_9531((int)((int)i));
        this.client = class_310.method_1551();
        this.model = this.client.method_1541().method_3349(this.blockState);
        ++activeDebrisParticles;
        this.isFoliage = this.blockState.method_26164(class_3481.field_15503) || this.blockState.method_27852(class_2246.field_10597);
        this.rotateYNegative = (this.id >> 0 & 1) == 0;
        this.rotateOnX = (this.id >> 1 & 1) == 0;
        this.rotateXZNegative = (this.id >> 2 & 1) == 0;
        this.rotationSpeed = 12.0f + (float)clientWorld.field_9229.method_43048(6);
    }

    @Override
    public void method_3070() {
        this.lastAngleX = this.angleX;
        this.lastAngleY = this.angleY;
        this.lastAngleZ = this.angleZ;
        super.method_3070();
        this.angleY += this.rotateYNegative ? -this.rotationSpeed : this.rotationSpeed;
        if (this.rotateOnX) {
            this.angleX += this.rotateXZNegative ? -this.rotationSpeed : this.rotationSpeed;
        } else {
            this.angleZ += this.rotateXZNegative ? -this.rotationSpeed : this.rotationSpeed;
        }
        if ((this.field_3866 + this.id) % 5 == 0) {
            class_2338 pos = this.getEntityPos();
            class_2680 state = this.field_3851.method_8320(pos);
            boolean bl = this.inWater = !state.method_26227().method_15769();
            if (this.client.field_1724 != null) {
                double d = Utils.squaredDistanceTo(pos, this.client.field_1724.method_24515());
                int n = ModConfig.getCullDebrisRendering() ? 16384 : 102400;
                if (d > (double)n) {
                    this.method_3085();
                    return;
                }
            }
        }
        if (this.field_3866 > 40 && !this.field_3862) {
            this.field_3862 = true;
        } else if (this.field_3862) {
            if (this.isOnGround()) {
                this.method_3085();
            }
            if (this.field_3838 == this.getY()) {
                this.method_3085();
                return;
            }
        }
        if (this.getCastedRotator() != null && this.getCastedRotator().getSource().isRemoved() || this.inWater) {
            if (!this.field_3862) {
                this.field_3866 += 5;
            }
            this.motionY -= (double)0.08f;
            if (this.motionX > 0.1) {
                this.motionX -= (double)0.05f;
            } else if (this.motionX < -0.1) {
                this.motionX += (double)0.05f;
            }
            if (this.motionZ > 0.1) {
                this.motionZ -= (double)0.05f;
            } else if (this.motionZ < -0.1) {
                this.motionZ += (double)0.05f;
            }
            if (this.motionY < -4.0) {
                this.motionY = -4.0;
            }
        } else if (this.motionY < -0.7) {
            this.motionY = -0.7;
        }
    }

    @Override
    public void method_3085() {
        super.method_3085();
        if (activeDebrisParticles > 0) {
            --activeDebrisParticles;
        }
    }

    @Override
    protected boolean manualKillCondition() {
        return false;
    }

    @Override
    public float getSpecialColorValue() {
        return 0.0f;
    }

    @Override
    public boolean manuallySetPosFromMotion() {
        return false;
    }

    @Override
    protected boolean emissOption() {
        return this.blockState.method_26213() > 0;
    }

    @Override
    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62639;
    }

    public class_243 getVec() {
        this.method_3074(null, null, DEFAULT_FOLIAGE_B);
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    @Override
    public boolean isFog() {
        return false;
    }

    @Override
    public void method_3074(class_11944 submittable, class_4184 camera, float tickProgress) {
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        matrices.method_22904(this.field_3858 + (this.field_3874 - this.field_3858) * (double)tickProgress - camera.method_71156().field_1352, this.field_3838 + (this.field_3854 - this.field_3838) * (double)tickProgress - camera.method_71156().field_1351, this.field_3856 + (this.field_3871 - this.field_3856) * (double)tickProgress - camera.method_71156().field_1350);
        float pitch = class_3532.method_17821((float)tickProgress, (float)this.lastAngleX, (float)this.angleX);
        float yaw = class_3532.method_17821((float)tickProgress, (float)this.lastAngleY, (float)this.angleY);
        float roll = class_3532.method_17821((float)tickProgress, (float)this.lastAngleZ, (float)this.angleZ);
        this.rotationProfile.rotationYXZ((float)Math.toRadians(yaw), (float)Math.toRadians(pitch), (float)Math.toRadians(roll));
        matrices.method_22907((Quaternionfc)this.rotationProfile);
        matrices.method_22904(-0.5, -0.5, -0.5);
        float r = this.isFoliage ? DEFAULT_FOLIAGE_R : DEFAULT_GRASS_R;
        float g = this.isFoliage ? DEFAULT_FOLIAGE_G : DEFAULT_GRASS_G;
        float b = this.isFoliage ? DEFAULT_FOLIAGE_B : DEFAULT_GRASS_B;
        class_4597.class_4598 vertexConsumers = this.client.method_22940().method_23001();
        class_778.method_3367((class_4587.class_4665)matrices.method_23760(), (class_4588)vertexConsumers.method_73477(class_12249.method_75972()), (class_1087)this.model, (float)r, (float)g, (float)b, (int)(this.emissOption() ? 0xF000F0 : 0xFFFFFF), (int)class_4608.field_21444);
        matrices.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        final class_4002 pr;

        public DefaultFactory(class_4002 spriteProvider) {
            this.pr = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_5819 random) {
            return new DebrisParticle(clientWorld, d, e, f, g, h, i, this.pr);
        }
    }
}

