/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.clouds;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.weather_classic.config.ModConfig;
import net.weather_classic.help.Utils;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.source.ClientClusterParticleSource;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class StormCloudParticle
extends StormParticle {
    private byte animTime = 0;
    private final class_4002 pr;
    private final boolean isForCluster;
    public boolean freezeOutwardMotion = false;
    public final short id;
    public final byte frameTime;
    private float clusterStr = 1.0f;
    private float alp = 1.0f;
    public float startingClusterStrength = 0.0f;
    public float lostSpeed = 0.0f;
    private boolean initLost = false;

    protected StormCloudParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_4002 pr) {
        super(clientWorld, d, e, f, g, 0.0, i, pr);
        this.field_17867 = 19.0f;
        this.angleX = ModConfig.getMimicOld() ? 90.0f : (float)(90 + this.field_3840.method_43048(60) - this.field_3840.method_43048(60));
        this.field_3847 = 20;
        this.angleY = ModConfig.getMimicOld() ? 0.0f : (float)this.field_3840.method_43048(360);
        this.angleZ = ModConfig.getMimicOld() ? 0.0f : (float)this.field_3840.method_43048(360);
        this.field_3862 = false;
        this.method_74308(0.0f);
        this.pr = pr;
        this.isForCluster = (int)h == -100;
        this.id = (short)this.field_3840.method_43048(6000);
        this.frameTime = (byte)(this.isForCluster ? 15 + clientWorld.field_9229.method_43048(20) : 15);
    }

    public float getClusterStrength() {
        return this.clusterStr;
    }

    public void setClusterStrength(float str) {
        this.clusterStr = str;
        if ((double)str > 0.7) {
            this.alp = 1.0f;
            return;
        }
        this.alp = Math.clamp(this.clusterStr + 0.1f, 0.3f, 1.0f);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (this.rotator == null) {
            this.getParticleRotator();
        } else {
            class_2338 pos;
            TornadoParticleSource source = this.getCastedRotator().getSource();
            if (source.isRemoved()) {
                this.field_3866 += 2;
            } else if (this.isForCluster && (this.field_3866 + this.id) % 20 == 0 && Utils.squaredDistanceXZ(this.field_3874, this.field_3871, source.getEmitter()) > 29584.0) {
                this.method_3085();
            }
            if (!this.freezeOutwardMotion) {
                if ((double)this.field_3866 > (double)this.method_3082() / 2.2) {
                    if (this.field_17867 < 25.0f) {
                        this.field_17867 += 0.1f;
                    }
                    if ((double)this.field_3866 > (double)this.method_3082() / 1.8) {
                        if (this.angleX > 90.0f || this.angleX < 90.0f) {
                            if (this.angleX > 90.0f) {
                                this.angleX -= (float)(1 + this.field_3840.method_43048(4));
                                if (this.angleX < 90.0f) {
                                    this.angleX = 90.0f;
                                }
                            } else if (this.angleX < 90.0f) {
                                this.angleX += (float)(1 + this.field_3840.method_43048(4));
                                if (this.angleX > 90.0f) {
                                    this.angleX = 90.0f;
                                }
                            }
                        } else if (!this.initLost) {
                            if (this.id % (source.getStrength() < 100.0f || source.isRemoved() ? 20 : 200) == 0) {
                                this.lostSpeed = 0.8f + this.field_3840.method_43057();
                                this.lostSpeed = Math.min(this.lostSpeed, 1.2f);
                                this.motionX *= (double)this.lostSpeed;
                                this.motionZ *= (double)this.lostSpeed;
                            }
                            this.initLost = true;
                        }
                    }
                }
            } else {
                this.field_17867 += 0.05f;
            }
            if (this.field_62636 < this.alp) {
                this.method_74308(this.field_62636 + 0.05f);
                this.field_62636 = class_3532.method_15363((float)this.field_62636, (float)0.0f, (float)this.alp);
            } else if (this.field_62636 > this.alp) {
                this.method_74308(this.field_62636 - 0.05f);
                this.field_62636 = class_3532.method_15363((float)this.field_62636, (float)this.alp, (float)1.0f);
            }
            if (!(ModConfig.getCityDestructionMode() || this.field_3866 % 5 != 0 || this.field_3851.method_8311(pos = this.getEntityPos()) || Utils.canPassThrough((class_1936)this.field_3851, pos))) {
                this.setDead();
            }
            if (this.lostSpeed > 0.0f) {
                this.motionX *= (double)0.99f;
                this.motionZ *= (double)0.99f;
            }
        }
        this.animTime = (byte)(this.animTime + 1);
        if (this.animTime > this.frameTime) {
            this.animTime = 0;
        }
        this.method_74307(this.pr.method_18138((int)this.animTime, (int)this.frameTime));
    }

    @Override
    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    @Override
    protected void getParticleRotator() {
        Optional<StormParticleRotator> r;
        if (this.isForCluster) {
            Optional<StormParticleRotator> r2;
            TornadoParticleSource source = ClientClusterParticleSource.getFor(this);
            if (source != null && (r2 = ClientClusterParticleSource.getCloudRotator(source)).isPresent()) {
                this.rotator = r2.get();
                this.rotator.prepare(this, true);
                return;
            }
            this.setDead();
            return;
        }
        TornadoParticleSource source = ClientTornadoParticleSource.getFor(this);
        if (source != null && (r = ClientTornadoParticleSource.getCloudRotator(source)).isPresent()) {
            this.rotator = r.get();
            this.rotator.prepare(this, false);
            return;
        }
        this.setDead();
    }

    @Override
    protected boolean manualKillCondition() {
        return false;
    }

    @Override
    public float getSpecialColorValue() {
        return 0.0f;
    }

    @Override
    public boolean manuallySetPosFromMotion() {
        return false;
    }

    protected StormParticleRotator getCastedRotator() {
        return (StormParticleRotator)this.rotator;
    }

    @Override
    protected boolean lerpAngleY() {
        return this.freezeOutwardMotion;
    }

    @Override
    protected boolean emissOption() {
        return !ModConfig.getEmissiveParticles() ? false : !this.isForCluster || (double)this.startingClusterStrength > 0.5;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_5819 random) {
            return new StormCloudParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

