/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.rotator;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.weather_classic.WeatherClassicClient;
import net.weather_classic.config.ModConfig;
import net.weather_classic.config.TornadoParticleConfig;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.TornadoParticle;
import net.weather_classic.particle.TornadoWindParticle;
import net.weather_classic.particle.block.DebrisParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TornadoParticleRotator
extends StormParticleRotator {
    private TornadoParticleConfig overrideConfig;

    public TornadoParticleRotator(TornadoParticleSource source) {
        super(source);
        this.overrideConfig = WeatherClassicClient.CLIENT_PARTICLE_OVERRIDE_CONFIGS.get(source.getTornadoType());
    }

    public void resetOverrideConfig() {
        this.overrideConfig = WeatherClassicClient.CLIENT_PARTICLE_OVERRIDE_CONFIGS.get(this.source.getTornadoType());
    }

    @Override
    public void prepare(StormParticle particle, boolean wind) {
        boolean debris;
        class_5819 random = particle.getWorld().method_8409();
        boolean customAge = this.getSource().getTornadoType() == 5 || ModConfig.getGenerateOverrides();
        boolean bl = debris = !wind && particle instanceof DebrisParticle;
        if (!debris) {
            if (wind) {
                particle.setScale(0.8f + 0.4f * random.method_43057());
                if (customAge) {
                    particle.method_3077(WeatherClassicClient.getTornadoFunnelScale(this.getSource().getTornadoType() == 5) - 40 + random.method_43048(20));
                } else {
                    particle.method_3077(50 + random.method_43048(50));
                }
                particle.method_74305(1.0f, 1.0f, 1.0f);
            } else {
                particle.method_3077(customAge ? WeatherClassicClient.getTornadoFunnelScale(this.getSource().getTornadoType() == 5) : (this.getSource().isSpout() ? 200 : (ModConfig.getMimicOld() ? 150 : 120)));
                Vector3f colors = ClientGlobal.getDefaultTornadoParticleColor(this.source, random, false);
                TornadoEntity.TornadoColor color = TornadoEntity.TornadoColor.get(particle.getSpecialColorValue());
                if (color != null) {
                    if (color == TornadoEntity.TornadoColor.UNIQUE_FLARE) {
                        if (colors.x >= 1.0f && colors.y >= 1.0f && colors.z >= 1.0f) {
                            colors.set(class_3532.method_15363((float)random.method_43057(), (float)0.1f, (float)1.0f), class_3532.method_15363((float)random.method_43057(), (float)0.1f, (float)1.0f), class_3532.method_15363((float)random.method_43057(), (float)0.1f, (float)1.0f));
                        } else {
                            colors.set(class_3532.method_15363((float)(colors.x + 0.2f), (float)0.1f, (float)1.0f), class_3532.method_15363((float)(colors.y + 0.2f), (float)0.1f, (float)1.0f), class_3532.method_15363((float)(colors.z + 0.2f), (float)0.1f, (float)1.0f));
                        }
                    } else {
                        Vector3f testColors = TornadoEntity.tornadoColors.get((Object)color);
                        if (color == TornadoEntity.TornadoColor.FIRE && testColors != null) {
                            colors = testColors;
                            float r = random.method_43057() * 0.2f * (float)(random.method_43056() ? -1 : 1);
                            r += colors.x;
                            r = class_3532.method_15363((float)r, (float)0.7f, (float)1.0f);
                            float g = random.method_43057() * 0.5f;
                            colors.set(r, g, colors.z);
                        }
                        colors = testColors != null ? testColors : colors;
                    }
                }
                particle.method_74305(colors.x, colors.y, colors.z);
                particle.setScale(0.0f);
            }
            boolean bend = ((ClientTornadoParticleSource)this.source).xOffset != 0.0f && !this.source.isSpout();
            particle.angleY = random.method_43048(360);
            float f = particle.angleX = bend ? (float)random.method_43048(360) : -30.0f - random.method_43057() - (float)random.method_43048(8);
            particle.angleZ = ModConfig.getMimicOld() && !bend ? 0.0f : (float)(bend ? random.method_43048(360) : random.method_43048(50) - random.method_43048(50));
            particle.setGravity(0.01f);
        } else {
            particle.setAge(0);
            particle.method_3077(500);
            particle.setGravity(0.08f);
        }
        particle.setnoClip(true);
    }

    @Override
    public void rotate(StormParticle p) {
        boolean bend;
        TornadoParticle particle = (TornadoParticle)p;
        boolean wind = particle instanceof TornadoWindParticle;
        boolean debris = particle instanceof DebrisParticle;
        ClientTornadoParticleSource csource = (ClientTornadoParticleSource)this.source;
        boolean bl = bend = csource.xOffset != 0.0f && !this.source.isSpout();
        if (!particle.isDead()) {
            if (!debris) {
                float ticksFade;
                particle.angleY = particle.rotateZ ? (float)((double)particle.angleY - 0.1) : (float)((double)particle.angleY + 0.1);
                float f = ticksFade = this.source.getTornadoType() == 5 && (double)ClientCustomTornadoConfig.getScaling() < 0.65 ? 2.0f : 20.0f;
                if ((float)particle.getAge() < ticksFade) {
                    float maxA = wind ? particle.getSpecialColorValue() / 10.0f : 1.0f;
                    particle.method_74308(class_3532.method_15363((float)((float)particle.getAge() / ticksFade), (float)0.0f, (float)maxA));
                } else if (!this.source.isDemon() && (float)particle.getAge() > (float)particle.method_3082() - ticksFade) {
                    float count = (float)particle.getAge() - ((float)particle.method_3082() - ticksFade);
                    float val = (ticksFade - count) / ticksFade;
                    particle.method_74308(val);
                }
                if (!wind) {
                    boolean override = this.source.getTornadoType() != 5 && ModConfig.getGenerateOverrides() && csource.xOffset == 0.0f && this.overrideConfig != null;
                    float inc = 0.05f;
                    if (override) {
                        float baseO = this.overrideConfig.base();
                        float bottomO = this.overrideConfig.bottom();
                        float midO = this.overrideConfig.mid();
                        float topO = this.overrideConfig.top();
                        switch (this.source.getTornadoType()) {
                            case 0: {
                                if (this.source.isRemoved()) {
                                    p.setAge(p.getAge() + 1);
                                    break;
                                }
                                if (baseO < 0.0f) {
                                    baseO = 0.15f;
                                }
                                if (!(topO < 0.0f)) break;
                                topO = 1.25f;
                                break;
                            }
                            case 1: {
                                if (baseO < 0.0f) {
                                    baseO = 0.15f;
                                }
                                if (!(topO < 0.0f)) break;
                                topO = 0.05f;
                                break;
                            }
                            case 2: {
                                if (baseO < 0.0f) {
                                    baseO = 0.3f;
                                }
                                if (midO < 0.0f) {
                                    midO = 0.15f;
                                }
                                if (!(topO < 0.0f)) break;
                                topO = 0.3f;
                                break;
                            }
                            case 3: {
                                if (baseO < 0.0f) {
                                    baseO = 0.3f;
                                }
                                if (midO < 0.0f) {
                                    midO = 0.25f;
                                }
                                if (!(topO < 0.0f)) break;
                                topO = 0.25f;
                                break;
                            }
                            case 4: {
                                if (baseO < 0.0f) {
                                    baseO = 0.35f;
                                }
                                if (bottomO < 0.0f) {
                                    bottomO = 0.17f;
                                }
                                if (midO < 0.0f) {
                                    midO = 0.55f;
                                }
                                if (!(topO < 0.0f)) break;
                                topO = 15.0f;
                            }
                        }
                        baseO = class_3532.method_15363((float)baseO, (float)0.0f, (float)1.0f);
                        bottomO = class_3532.method_15363((float)bottomO, (float)0.0f, (float)1.0f);
                        midO = class_3532.method_15363((float)midO, (float)0.0f, (float)1.0f);
                        topO = class_3532.method_15363((float)topO, (float)0.0f, (float)1.0f);
                        inc += p.getAge() > 30 && p.getAge() < 55 ? baseO : 0.0f;
                        if (p.getAge() < 10) {
                            inc += bottomO;
                        }
                        if (p.getAge() > 15 && p.getAge() < 35) {
                            inc += midO;
                        }
                        if (p.getAge() > 50 && p.getAge() < 60) {
                            inc += topO;
                        }
                    } else {
                        inc = 0.1f;
                        boolean sparse = ModConfig.getMimicOld();
                        boolean isClassicShape = (this.source.getUuid().getMostSignificantBits() & 1L) == 0L;
                        switch (this.source.getTornadoType()) {
                            case 0: {
                                if (this.source.isRemoved()) {
                                    p.setAge(p.getAge() + 1);
                                    break;
                                }
                                if (csource.xOffset != 0.0f) {
                                    if (p.getAge() < 10) {
                                        inc += 0.1f;
                                    }
                                    inc += p.getAge() > 30 && p.getAge() < 80 ? 0.1f : 0.0f;
                                    break;
                                }
                                if (isClassicShape) {
                                    if (p.getAge() > 65 && p.getAge() < 70) {
                                        inc += 1.2f;
                                    }
                                    inc += p.getAge() > 30 && p.getAge() < 80 ? 0.1f : 0.0f;
                                    break;
                                }
                                inc += p.getAge() > 50 && p.getAge() < 90 ? 0.1f : 0.0f;
                                break;
                            }
                            case 1: {
                                if (bend) {
                                    inc = 0.0f;
                                    if (p.getAge() < 30) {
                                        inc = 0.1f;
                                    }
                                    if (p.getAge() > 40) {
                                        inc = 0.12f;
                                    }
                                    if (p.getAge() <= 60) break;
                                    inc += 0.2f;
                                    break;
                                }
                                inc += p.getAge() > 40 && p.getAge() < 50 ? (sparse ? 0.05f : 0.15f) : 0.0f;
                                if (p.getAge() > 50 && p.getAge() < 65) {
                                    inc += sparse ? 0.05f : 0.18f;
                                }
                                if (!sparse || p.getAge() <= 60 || p.getAge() >= 80 || this.source.isRemoved()) break;
                                inc += 0.5f;
                                break;
                            }
                            case 2: {
                                inc += p.getAge() > 30 && p.getAge() < 53 ? (sparse ? 0.0f : 0.25f) : 0.0f;
                                if (p.getAge() > 10 && p.getAge() < 30) {
                                    inc += sparse ? 0.0f : 0.05f;
                                }
                                if (!sparse) break;
                                if (p.getAge() == 50) {
                                    inc += 3.0f;
                                    break;
                                }
                                inc += 0.03f;
                                break;
                            }
                            case 3: {
                                inc += p.getAge() > 30 && p.getAge() < 53 ? 0.25f : 0.0f;
                                if (!isClassicShape && p.getAge() < 10) {
                                    inc += sparse ? 0.15f : 0.2f;
                                }
                                if (!isClassicShape || p.getAge() <= 10 || p.getAge() >= 30) break;
                                inc += sparse ? 0.07f : 0.15f;
                                break;
                            }
                            case 4: {
                                inc += p.getAge() > 30 && p.getAge() < 53 ? (sparse ? 0.2f : 0.3f) : 0.0f;
                                if (p.getAge() < 10) {
                                    inc += sparse ? 0.1f : 0.12f;
                                }
                                if (p.getAge() > 10 && p.getAge() < 30) {
                                    inc += sparse ? 0.07f : 0.25f;
                                }
                                if (p.getAge() > 40 && p.getAge() < 50) {
                                    inc += sparse ? 0.1f : (isClassicShape ? 0.3f : 0.25f);
                                }
                                if (!sparse || p.getAge() <= 50) break;
                                inc += 0.25f;
                                break;
                            }
                            case 5: {
                                float baseIncrease = ClientCustomTornadoConfig.getBaseParticleSizeIncrease();
                                float bottomIncrease = ClientCustomTornadoConfig.getBottomParticleSizeIncrease();
                                float midIncrease = ClientCustomTornadoConfig.getMidParticleSizeIncrease();
                                float topIncrease = ClientCustomTornadoConfig.getTopParticleSizeIncrease();
                                inc += p.getAge() > 30 && p.getAge() < 53 ? baseIncrease : 0.0f;
                                if (p.getAge() < 10) {
                                    inc += bottomIncrease;
                                }
                                if (p.getAge() > 10 && p.getAge() < 30) {
                                    inc += midIncrease;
                                }
                                if (p.getAge() <= 40 || p.getAge() >= 50) break;
                                inc += topIncrease;
                            }
                        }
                    }
                    particle.setScale(particle.getScale() + inc);
                }
            }
            if (!this.source.isRemoved()) {
                this.spin(particle, debris);
            }
        }
    }

    private void spin(StormParticle particle, boolean debris) {
        double dx = this.getSourcePos().method_10216() - particle.getX();
        double dz = this.getSourcePos().method_10215() - particle.getZ();
        float ang = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        if (!debris) {
            boolean straight;
            ClientTornadoParticleSource csource = (ClientTornadoParticleSource)this.source;
            boolean bl = straight = csource.xOffset == 0.0f && csource.zOffset == 0.0f || this.source.isSpout();
            if (straight) {
                particle.angleY = ang;
            } else {
                particle.angleY += 2.0f;
                particle.angleZ += 2.0f;
            }
            this.spinAroundSource(particle, csource.xOffset, csource.zOffset, csource);
        } else {
            this.spinDebrisAroundSource(particle);
        }
    }

    private void spinAroundSource(StormParticle particle, float xOffset, float zOffset, ClientTornadoParticleSource source) {
        float r;
        float r2;
        if (this.getStats() == null) {
            return;
        }
        double maxHeight = 60.0;
        double radius = 10.0;
        byte type = source.getTornadoType();
        boolean cyclone = type == 0 && xOffset != 0.0f;
        double scaling = type > 4 ? (double)ClientCustomTornadoConfig.getScaling() : (double)this.getStats().scaling;
        float scaleBonus = source.scaleBonus;
        if (type == 4) {
            scaling += (double)Math.max(2.0f, scaleBonus);
        }
        if (type == 3) {
            scaling += (double)scaleBonus;
        }
        if (type == 2) {
            scaling += (double)scaleBonus;
        }
        if (type == 1 && xOffset == 0.0f) {
            scaling += (double)scaleBonus;
        }
        if (type == 0) {
            scaling += (double)scaleBonus;
        }
        if (cyclone) {
            xOffset = 0.0f;
            zOffset = 0.0f;
        }
        double dx = this.getSourcePos().method_10216() + (double)xOffset - particle.getX();
        double dz = this.getSourcePos().method_10215() + (double)zOffset - particle.getZ();
        double distY = particle.getY() - this.getSourcePos().method_10214();
        if (distY < 0.0) {
            distY = 1.0;
        }
        if (distY > maxHeight) {
            distY = maxHeight;
        }
        if ((r2 = (r = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f) % 360.0f) >= 180.0f) {
            r2 -= 360.0f;
        } else if (r2 < -180.0f) {
            r2 += 360.0f;
        }
        double distXZS = Math.abs(dx) + Math.abs(dz);
        double intensity = (double)(10.0f / this.getParticleResistance(particle)) * (Math.abs(maxHeight - distY) / maxHeight);
        float liftY = 0.0f;
        liftY += this.getStats().liftSpeed / (this.getParticleResistance(particle) / 2.0f);
        if (distXZS > 25.0) {
            intensity *= radius / Math.sqrt(distXZS);
        }
        float rs = source.getStats().grabSpeed;
        if (type > 4) {
            rs = ClientCustomTornadoConfig.getGrabSpeed();
        }
        if (!source.isSpout()) {
            isClassicShape = (source.getUuid().getMostSignificantBits() & 1L) == 0L;
            switch (type) {
                case 1: {
                    if (!source.isDemon()) {
                        intensity += isClassicShape ? -16.0 : -22.0;
                        if (particle.getAge() < 30) {
                            rs = (float)((double)rs / (isClassicShape ? 1.8 : 2.2));
                        }
                        if (xOffset == 0.0f || particle.getAge() <= 40) break;
                        intensity += 60.0;
                        break;
                    }
                    intensity += particle.getAge() < 60 ? -3.0 : 0.0;
                    if (particle.getAge() >= 30) break;
                    rs = (float)((double)rs * 1.2);
                    break;
                }
                case 2: {
                    if (!source.isDemonic()) {
                        intensity += isClassicShape ? -26.0 : -33.0;
                        if (particle.getAge() >= 40) break;
                        rs = (float)((double)rs / (isClassicShape ? 1.7 : (double)1.9f));
                        break;
                    }
                    intensity += particle.getAge() < 20 ? -10.0 : 0.0;
                    if (particle.getAge() <= 40) break;
                    rs = (float)((double)rs * 2.5);
                    break;
                }
                case 3: {
                    if (!source.isDemonic()) {
                        intensity += -30.0;
                        if (particle.getAge() < 20) {
                            rs /= isClassicShape ? 1.4f : 1.6f;
                            break;
                        }
                        if (particle.getAge() <= 20) break;
                        intensity += (double)(isClassicShape ? 55 : 45);
                        break;
                    }
                    intensity += -30.0;
                    if (particle.getAge() < 20) {
                        rs /= 1.1f;
                        break;
                    }
                    if (particle.getAge() <= 20) break;
                    intensity += 50.0;
                    break;
                }
                case 4: {
                    if (!source.isDemonic()) {
                        rs = (float)((double)rs + 0.1);
                        intensity += (double)(isClassicShape ? -10 : -15);
                        if (particle.getAge() < 20) {
                            rs /= 1.3f;
                            break;
                        }
                        if (particle.getAge() <= 20) break;
                        intensity += (double)(isClassicShape ? 43 : 55);
                        break;
                    }
                    rs = (float)((double)rs + 0.2);
                    intensity += -20.0;
                    if (particle.getAge() < 20) {
                        rs /= 1.2f;
                        break;
                    }
                    if (particle.getAge() <= 20) break;
                    intensity += 80.0;
                    break;
                }
                case 5: {
                    short funnelWidth = ClientCustomTornadoConfig.getFunnelWidth();
                    byte funnelPointedness = ClientCustomTornadoConfig.getFunnelPointedness();
                    float funnelTightening = (float)funnelWidth * (ClientCustomTornadoConfig.getFunnelTightening() * 1.2f);
                    intensity += (double)(-funnelWidth);
                    if (particle.getAge() < 30) {
                        rs /= (float)funnelPointedness;
                        break;
                    }
                    if (particle.getAge() <= 30) break;
                    intensity += (double)funnelTightening;
                }
            }
        } else if (cyclone) {
            boolean bl = isClassicShape = (source.getUuid().getMostSignificantBits() & 1L) == 0L;
            if (isClassicShape) {
                intensity += -30.0;
                if (particle.getAge() > 20) {
                    intensity += 50.0;
                }
            } else {
                intensity += -30.0;
                if (particle.getAge() < 50 && particle.getAge() > 20) {
                    intensity += 60.0;
                } else if (particle.getAge() > 60) {
                    intensity += 20.0;
                }
            }
        }
        r2 = (float)((double)r2 + (75.0 + intensity - 10.0 * scaling));
        float rx = (float)Math.cos(-r2 * 0.01745329f - (float)Math.PI);
        float rz = (float)Math.sin(-r2 * 0.01745329f - (float)Math.PI);
        float moveX = rx * -rs;
        float moveZ = rz * rs;
        particle.motionX += (double)moveX;
        particle.motionZ += (double)moveZ;
        particle.motionY += (double)(liftY *= this.getSource().getStrength() / 100.0f);
    }

    private float getParticleResistance(StormParticle d) {
        boolean wind = d instanceof TornadoWindParticle;
        if (wind) {
            return 1.4f + (float)d.getAge() / 200.0f;
        }
        return 5.0f + (float)d.getAge() / 200.0f;
    }

    private void spinDebrisAroundSource(StormParticle particle) {
        float r;
        float r2;
        double distY;
        float debrisMaxRotBend;
        double ringDist;
        boolean careless;
        if (this.getStats() == null || ((DebrisParticle)particle).inWater) {
            return;
        }
        double maxHeight = 60.0;
        byte type = this.getSource().getTornadoType();
        double scaling = type > 4 ? (double)ClientCustomTornadoConfig.getScaling() : (double)this.getStats().scaling;
        boolean bl = careless = ((ClientTornadoParticleSource)this.source).xOffset != 0.0f || type == 5 && (ClientCustomTornadoConfig.getPullType(true) == 0 || ClientCustomTornadoConfig.getPullType(true) == 5);
        if (type == 4) {
            scaling = 2.7f;
        }
        if (type == 3) {
            scaling = 2.2f;
        }
        double dx = this.getSourcePos().method_10216() - particle.getX();
        double dz = this.getSourcePos().method_10215() - particle.getZ();
        double distXZS = dx * dx + dz * dz;
        int ageR = switch (this.source.getTornadoTypeForRotator()) {
            case 0 -> {
                ringDist = 32.0;
                debrisMaxRotBend = 0.02f;
                yield 40;
            }
            case 2 -> {
                debrisMaxRotBend = 0.1f;
                ringDist = 52.0;
                yield 45;
            }
            case 3 -> {
                debrisMaxRotBend = 0.2f;
                ringDist = 60.0;
                yield 50;
            }
            case 4 -> {
                debrisMaxRotBend = 0.5f;
                ringDist = 64.0;
                yield 60;
            }
            default -> {
                debrisMaxRotBend = 0.05f;
                ringDist = 40.0;
                yield 55;
            }
        };
        boolean tall = false;
        if (type == 5 && (double)ClientCustomTornadoConfig.getScaling() != 1.2 || type != 5 && ModConfig.getGenerateOverrides() && (double)ModConfig.getGlobalHeightScaleOverride() != 1.2) {
            float minScale = 0.5f;
            float maxScale = 3.0f;
            float min = -17.0f;
            float max = 64.0f;
            float denom = maxScale - minScale;
            float t = denom == 0.0f ? 0.0f : ((type == 5 ? ClientCustomTornadoConfig.getScaling() : ModConfig.getGlobalHeightScaleOverride()) - minScale) / denom;
            float height = min + (t = Math.max(0.0f, Math.min(1.0f, t))) * (max - min);
            if (height > 40.0f) {
                tall = true;
                debrisMaxRotBend += 0.12f;
            }
            height = class_3532.method_15363((float)height, (float)-17.0f, (float)45.0f);
            ageR = (short)((float)ageR + height);
        }
        boolean down = false;
        boolean suspend = false;
        float mult = 1.0f;
        double ceiling = this.source.getCloudY();
        if (particle.getAge() > ageR) {
            if (careless || particle.getAge() > 260) {
                down = true;
            } else {
                suspend = true;
                if (distXZS > ringDist * ringDist) {
                    double centerX = this.getSourcePos().method_10216();
                    double centerZ = this.getSourcePos().method_10215();
                    double dxx = particle.getX() - centerX;
                    double dzz = particle.getZ() - centerZ;
                    double rad = Math.sqrt(dxx * dxx + dzz * dzz);
                    double angle = Math.atan2(dzz, dxx);
                    float f = (float)(angle * 180.0 / Math.PI) - 90.0f;
                    particle.prevAngleY = particle.angleY;
                    particle.angleY = f;
                    double rotationSpeed = this.source.getStats().grabSpeed / 2.0f;
                    double targetX = centerX + rad * Math.cos(angle += rotationSpeed);
                    double targetZ = centerZ + rad * Math.sin(angle);
                    double desiredX = targetX - particle.getX();
                    double desiredZ = targetZ - particle.getZ();
                    double ease = 0.98;
                    particle.motionX += (desiredX - particle.motionX) * ease;
                    particle.motionZ += (desiredZ - particle.motionZ) * ease;
                    particle.motionY += (0.0 - particle.motionY) * ease;
                    return;
                }
                mult = 2.2f;
            }
        }
        if ((distY = particle.getY() - this.getSourcePos().method_10214()) < 0.0) {
            distY = 1.0;
        }
        if (distY > maxHeight) {
            distY = maxHeight;
        }
        if ((r2 = (r = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f) % 360.0f) >= 180.0f) {
            r2 -= 360.0f;
        } else if (r2 < -180.0f) {
            r2 += 360.0f;
        }
        double intensity = (double)(1.0f + (float)particle.getAge() / 200.0f) * (Math.abs(maxHeight - distY) / maxHeight);
        float liftY = particle.getAge() < 10 ? 0.01f : 0.0f;
        liftY += this.getStats().liftSpeed / (this.getParticleResistance(particle) / 2.0f);
        float rs = this.source.getStats().grabSpeed - 0.05f;
        if (type > 4) {
            rs = ClientCustomTornadoConfig.getGrabSpeed();
        }
        r2 = (float)((double)r2 + (75.0 + intensity - 10.0 * scaling));
        float rx = (float)Math.cos(-r2 * 0.01745329f - (float)Math.PI);
        float rz = (float)Math.sin(-r2 * 0.01745329f - (float)Math.PI);
        float moveX = rx * -rs;
        float moveZ = rz * rs;
        liftY *= this.getSource().getStrength() / 100.0f;
        if (down) {
            particle.motionY = particle.motionY - (double)(tall ? 0.4f : 0.08f);
        } else if (suspend) {
            if (particle.motionY > 0.0) {
                particle.motionY -= (double)0.1f;
                if (particle.motionY < 0.0) {
                    particle.motionY = 0.0;
                }
            } else if (particle.motionY < 0.0) {
                particle.motionY += (double)0.1f;
                if (particle.motionY > 0.0) {
                    particle.motionY = 0.0;
                }
            } else {
                particle.motionY = 0.0;
            }
        } else if (careless ? particle.getAge() < ageR : particle.getY() <= ceiling) {
            particle.motionY += (double)liftY;
        }
        if (down && distXZS > ringDist * ringDist) {
            double distXZ = Math.sqrt(distXZS);
            double pullX = dx / distXZ;
            double pullZ = dz / distXZ;
            double pullStrength = debrisMaxRotBend;
            particle.motionX += pullX * pullStrength;
            particle.motionZ += pullZ * pullStrength;
            return;
        }
        particle.motionX += (double)(moveX *= mult);
        particle.motionZ += (double)(moveZ *= mult);
    }
}

