/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.rotator;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.weather_classic.help.BP;
import net.weather_classic.item.core_related.SimpleParticleSource;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.base.SimpleParticleRotator;
import net.weather_classic.storm.TornadoEntity;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class WindCoreTornadoParticleRotator
extends SimpleParticleRotator {
    public WindCoreTornadoParticleRotator(SimpleParticleSource source) {
        super(source);
    }

    @Override
    public void prepare(StormParticle particle, boolean b) {
        class_5819 random = particle.getWorld().method_8409();
        particle.angleY = random.method_43048(360);
        particle.angleX = -30.0f - random.method_43057() - (float)random.method_43048(8);
        particle.angleZ = random.method_43048(50) - random.method_43048(50);
        particle.setGravity(0.01f);
        particle.setnoClip(false);
        particle.setScale(0.05f);
        particle.method_74308(0.7f + random.method_43057() * 0.2f);
        particle.method_74305(0.87f, 0.87f, 1.0f);
        if (particle.getWorld().method_75260() % 1L == 0L) {
            class_2338 sPos = BP.of(this.getSourcePos()).method_10074();
            if (particle.getWorld().method_8320(sPos).method_27852(class_2246.field_10036)) {
                Vector3f colors = TornadoEntity.tornadoColors.get((Object)TornadoEntity.TornadoColor.FIRE);
                float r = random.method_43057() * 0.2f * (float)(random.method_43056() ? -1 : 1);
                r += colors.x;
                r = class_3532.method_15363((float)r, (float)0.7f, (float)1.0f);
                float g = random.method_43057() * 0.5f;
                colors.set(r, g, colors.z);
                particle.method_74305(colors.x, colors.y, colors.z);
            }
        }
        particle.method_3077(this.isRepelling() ? 10 : (this.isStage5() ? 40 : 30));
    }

    @Override
    protected void rotate(StormParticle particle) {
        this.spin(particle);
        if (this.isStage5()) {
            particle.setScale(particle.getScale() + 0.07f);
        } else {
            particle.setScale(particle.getScale() + 0.05f);
        }
    }

    private void spin(StormParticle particle) {
        float ang;
        double dx = this.getSourcePos().method_10216() - particle.getX();
        double dz = this.getSourcePos().method_10215() - particle.getZ();
        particle.angleY = ang = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        this.spinAroundSource(particle);
    }

    private void spinAroundSource(StormParticle particle) {
        float f1;
        double d1 = this.getSourcePos().method_10216() - particle.getX();
        double d2 = this.getSourcePos().method_10215() - particle.getZ();
        float f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        for (f1 = f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double grab = 2.0 + (double)((float)particle.getAge() / 75.0f);
        if (distXZ > 2.0) {
            grab *= 10.0 / distXZ;
        }
        f1 = (float)((double)f1 + ((double)(this.isRepelling() ? -150 : 75) + grab - 0.4));
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = this.isStage5() ? 0.2f : 0.1f;
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        particle.motionX += (double)(-moveX);
        particle.motionZ += (double)moveZ;
        particle.motionY += (double)0.01f;
    }

    private boolean isRepelling() {
        return this.source.getInfo() == 2 || this.source.getInfo() == 3;
    }

    private boolean isStage5() {
        return this.source.getInfo() == 1 || this.source.getInfo() == 3;
    }
}

