/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.TornadoReviver;
import net.weather_classic.help.BP;
import net.weather_classic.help.Direction2D;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.registry.WCParticles;
import net.weather_classic.storm.TornadoRipper;
import net.weather_classic.storm.TornadoRotator;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.clusters.StormClusterPE;
import net.weather_classic.storm.debris.DebrisEntity;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.joml.Vector3f;

public class TornadoEntity
extends class_1314
implements TornadoParticleSource {
    private final class_1937 world;
    private boolean initialized = false;
    private float realYaw;
    private float prevRealYaw;
    private class_2338 currentTarget;
    private TornadoStats stats;
    private final TornadoRotator rotator;
    private final TornadoRipper ripper;
    private int pullStrengthVariation = 0;
    private boolean worldUnload = true;
    private boolean biasing = false;
    private final int timeRandomness;
    private class_1923 prevChunkPos;
    private final TornadoStats.Type tornadoType;
    private int colorChangeTicks = 0;
    private TornadoColor currentColor = null;
    public static final Map<TornadoColor, Vector3f> tornadoColors = new HashMap<TornadoColor, Vector3f>();
    private boolean shortenedLife = false;
    private int biasRangeEnd = 20;
    private boolean ascendToGroundLevel = false;
    private boolean demon;
    private final byte speedVary;
    private short dispels = 0;
    private boolean closeToPlayer = false;
    private byte boundToAlt = 0;
    private boolean firenado;
    private boolean modifyGroundLevel = false;
    private boolean freezeYPos = false;
    private StormClusterPE clusterBound = null;
    private boolean triedCombine = false;
    public boolean skipBinding = false;
    public float xOffset = 0.0f;
    public float zOffset = 0.0f;
    public float xOffsetGoal = 0.0f;
    public float zOffsetGoal = 0.0f;
    public boolean variant = false;
    public float scaleBonus = 0.0f;
    private boolean dyingScale = false;
    private final float scaleVolatility;
    private final boolean alterScale;
    private float maxScalePercent = 1.0f;
    public static final class_2940<Boolean> DYING = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SPAWNING = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> STRENGTH = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Integer> STORM_CLOUD_Y = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13327);

    public TornadoEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.tornadoType = TornadoEntity.getTornadoTypeFromEntity(entityType);
        this.field_5960 = true;
        this.method_5875(true);
        this.stats = TornadoStats.get(this.tornadoType, false);
        this.rotator = new TornadoRotator(this);
        this.ripper = new TornadoRipper(this);
        this.world = world;
        this.timeRandomness = world.method_8409().method_43048(7200);
        this.prevChunkPos = null;
        this.speedVary = (byte)world.method_8409().method_43048(this.isSpout() ? 3 : ((double)world.method_8409().method_43057() < 0.15 ? 7 : 5));
        this.firenado = entityType != WCEntities.SPOUT && world.method_8409().method_43057() < (float)ModConfig.getPassiveFirenadoChance() / 100.0f;
        this.scaleBonus = 0.0f;
        if (this.getTornadoTypeForRotator() == 2) {
            this.scaleBonus = 0.4f;
        } else if (this.getTornadoTypeForRotator() == 3) {
            this.scaleBonus = 1.5f;
        } else if (this.getTornadoTypeForRotator() == 4) {
            this.scaleBonus = 3.3f;
        }
        if ((double)this.field_5974.method_43057() < 0.4) {
            this.alterScale = true;
            this.scaleBonus = this.field_5974.method_43057() * this.stats.maxScaleBonus;
            this.dyingScale = this.field_5974.method_43056();
            this.maxScalePercent = 0.75f + this.field_5974.method_43057() * 0.25f;
            this.scaleVolatility = this.stats.maxScaleBonus * Math.max(this.field_5974.method_43057() * 0.1f, 0.03f);
        } else {
            this.alterScale = false;
            this.scaleVolatility = 0.0f;
        }
    }

    public TornadoEntity asVariant() {
        if (this.tornadoType != TornadoStats.Type.STAGE2 && this.tornadoType != TornadoStats.Type.SPOUT) {
            return this;
        }
        this.variant = true;
        this.stats = TornadoStats.get(this.tornadoType, true);
        this.rotator.updatePullVals(this);
        return this;
    }

    public TornadoEntity enable() {
        this.worldUnload = false;
        return this;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DYING, (Object)false);
        builder.method_56912(SPAWNING, (Object)false);
        builder.method_56912(STRENGTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(STORM_CLOUD_Y, (Object)128);
        super.method_5693(builder);
    }

    public TornadoEntity asDemon() {
        this.demon = true;
        this.firenado = false;
        return this;
    }

    public TornadoEntity getWithShorterLifespan() {
        this.shortenedLife = true;
        return this;
    }

    public boolean isPassiveFirenado() {
        return this.firenado;
    }

    public boolean boundToAlt() {
        return this.boundToAlt > 0;
    }

    public void bindToAlt() {
        if (this.getTornadoType() != 5) {
            return;
        }
        this.boundToAlt = (byte)2;
    }

    public void bindToCluster(StormClusterPE cluster) {
        if (this.tornadoType == TornadoStats.Type.STAGEX || this.tornadoType == TornadoStats.Type.SPOUT) {
            return;
        }
        this.clusterBound = cluster;
    }

    public boolean isBoundToCluster() {
        return this.clusterBound != null;
    }

    public StormClusterPE getBoundCluster() {
        return this.clusterBound;
    }

    public void method_5711(byte status) {
        if (status == 35) {
            this.field_6012 = 0;
            this.shortenedLife = true;
            if (this.isSpout()) {
                this.freezeYPos = true;
            }
        } else {
            super.method_5711(status);
        }
    }

    private void initTornado() {
        if (!this.worldUnload && this.world.method_27983() == class_1937.field_25179) {
            Global.addTornado(this);
            this.initialized = true;
            if (!this.getStats().hasDemons && this.demon) {
                this.demon = false;
            }
        }
        if (this.boundToAlt != 2) {
            this.boundToAlt = (byte)(this.tornadoType == TornadoStats.Type.STAGEX && CustomTornadoConfig.USING_ALT ? 1 : 0);
        }
        class_2791 chunk = this.world.method_22350(this.method_24515());
        int p = chunk.method_12005(class_2902.class_2903.field_13197, 8, 8);
        int heightAdd = this.getTornadoType() == 5 || ModConfig.getGenerateOverrides() ? ModConfig.getTornadoCloudScale(this.getTornadoType() == 5) : 72;
        int height = Math.min(p + heightAdd, 256);
        this.method_5725(new class_2338(this.method_31477(), height, this.method_31479()), 0.0f, 0.0f);
        this.setCloudY(height);
        this.setSpawning(true);
        this.updateDisabledReviver();
        if (!this.isSpout()) {
            Utils.playSound((class_1297)this, this.world, this.method_24515().method_10086(20), WeatherClassic.TORNADO_WIND_DIRECTIONAL, this.method_5634(), 4.0f, 1.0f);
        }
        StormClusterPE cluster = Global.getClosestClusterNoTornado(this.method_24515());
        if (!this.skipBinding && cluster != null && Utils.distanceXZ(cluster.getBlockPos(), this.method_24515()) <= 10.0 && !this.variant) {
            this.bindToCluster(cluster);
        }
    }

    public class_3419 method_5634() {
        return class_3419.field_15252;
    }

    @Override
    public boolean isDestructiveStorm() {
        return this.getStats().ripType != TornadoRipper.RipType.NONE;
    }

    @Override
    public boolean isSpout() {
        return this.tornadoType == TornadoStats.Type.SPOUT;
    }

    @Override
    public byte getTornadoType() {
        return this.tornadoType.getByte();
    }

    @Override
    public byte getTornadoTypeForRotator() {
        if (this.tornadoType == TornadoStats.Type.STAGEX) {
            return CustomTornadoConfig.getPullType(false);
        }
        return this.getTornadoType();
    }

    private void handleDirectionalWindSound() {
        if (!(this.field_6012 % 10 != 0 && this.field_6012 != 20 || this.world.method_8608())) {
            boolean tear;
            int time;
            float pitch;
            byte type = this.getTornadoType();
            if (type >= 5) {
                type = CustomTornadoConfig.getPassiveSoundType();
            }
            float vol = switch (type) {
                case 0 -> {
                    pitch = 1.0f;
                    time = 140;
                    yield this.variant ? 8.0f : 6.0f;
                }
                case 2 -> {
                    pitch = 0.9f;
                    time = 160;
                    yield 14.0f;
                }
                case 3 -> {
                    pitch = 0.6f;
                    time = 200;
                    yield 18.0f;
                }
                case 4 -> {
                    pitch = 0.4f;
                    time = 210;
                    yield 22.0f;
                }
                default -> {
                    pitch = 0.95f;
                    time = 150;
                    yield 10.0f;
                }
            };
            vol -= 0.5f;
            if (this.field_6012 % time == 0) {
                WCNetworkServer.sendDirectionalWindPayload((class_3218)this.world, this, vol, pitch, false);
            }
            boolean bl = tear = this.isDestructiveStorm() && this.world.method_8409().method_43048(2) == 0;
            if (tear) {
                switch (type) {
                    case 0: {
                        pitch = 0.9f;
                        time = 50;
                        vol = 4.0f;
                        break;
                    }
                    case 2: {
                        pitch = 0.85f;
                        time = 50;
                        vol = 12.0f;
                        break;
                    }
                    case 3: {
                        pitch = 0.83f;
                        time = 50;
                        vol = 16.0f;
                        break;
                    }
                    case 4: {
                        pitch = 0.8f;
                        time = 60;
                        vol = 20.0f;
                        break;
                    }
                    default: {
                        pitch = 0.88f;
                        time = 50;
                        vol = 8.0f;
                    }
                }
                if (this.field_6012 % time == 0) {
                    WCNetworkServer.sendDirectionalWindPayload((class_3218)this.world, this, vol, pitch, true);
                }
            }
        }
    }

    public void method_5773() {
        this.prevChunkPos = this.method_31476();
        super.method_5773();
        if (!this.world.method_8608()) {
            if (!this.initialized) {
                this.initTornado();
            } else if (!this.method_31481()) {
                Global.addTornado(this);
            }
            if (this.getTornadoType() == 5) {
                if (!ModConfig.getEnableCustomTornadoes()) {
                    this.killStorm();
                    Global.messageServer("\u00a7cCustom Tornadoes are Currently Disabled", (class_3218)this.world);
                    return;
                }
                if (CustomTornadoConfig.getRipType(true) == 6 && !this.firenado) {
                    this.firenado = true;
                }
                if (CustomTornadoConfig.USING_ALT != this.boundToAlt > 0) {
                    if (!WCNetworkServer.awaitingBigUpdate()) {
                        this.killStorm();
                    }
                    return;
                }
            }
            if (this.field_6012 % 300 == 0 && this.field_5974.method_43048(2) == 0) {
                this.pullStrengthVariation = this.field_5974.method_43048(15);
            }
            this.handleTargetting();
            this.ripper.tick();
            this.rotator.grabEntities();
            this.handleStrength();
            this.tickFX();
            if (!this.demon) {
                this.handleDirectionalWindSound();
            }
            if (Global.overMaxTornadoes() && Global.activeTornadoes.get(0) == this) {
                this.killStorm();
                return;
            }
            if (this.killDueToPlayersUnavailable()) {
                this.initialized = false;
            }
            if (this.world.method_75260() % 60L == 0L) {
                this.updateDisabledReviver();
                if (this.killDueToInvalidPosition()) {
                    this.killStorm();
                }
            }
            if (!this.initialized) {
                this.killStorm();
                if (!this.worldUnload && !this.getDying()) {
                    Global.weather.addTornadoReviver(new TornadoReviver((class_3218)this.world, this.method_24515(), this.getTornadoType(), this.demon, this.variant, this.scaleBonus).with(this.currentTarget).binded(this.boundToAlt()));
                }
            }
        }
    }

    private void updateDisabledReviver() {
        Global.weather.addTornadoReviver(new TornadoReviver((class_3218)this.world, this.method_24515(), this.getTornadoType(), this.demon, this.variant, this.scaleBonus).off(this.method_5628(), this.getDying()).binded(this.boundToAlt()));
    }

    public int getRandomStrengthVariationFallOff() {
        return this.pullStrengthVariation;
    }

    @Override
    public TornadoStats getStats() {
        return this.stats;
    }

    public int getLifetime() {
        int tr = this.stats.time < 1000 ? this.timeRandomness / 3 : this.timeRandomness;
        int end = this.getStats().time + tr;
        end = (int)((double)end * (this.shortenedLife ? 0.6 : 1.0));
        return end;
    }

    public class_1923 getPrevChunkPos() {
        return this.prevChunkPos;
    }

    public boolean shouldPursuePlayers() {
        return this.demon || this.tornadoType == TornadoStats.Type.STAGEX && CustomTornadoConfig.getChasePlayers();
    }

    public void handleTargetting() {
        if (this.currentTarget != null) {
            this.handleMovement();
            if (this.field_6012 % 20 == 0 && Utils.distanceXZ(this.currentTarget, this.method_24515()) < (double)this.biasRangeEnd) {
                this.currentTarget = null;
                this.biasing = false;
                this.biasRangeEnd = 20;
            }
        } else {
            class_1657 player;
            this.method_18800(0.0, 0.0, 0.0);
            if ((this.getSpawning() && ModConfig.getTornadoesBiasTowardsPlayers() || this.shouldPursuePlayers()) && (player = this.world.method_18460((class_1297)this, -1.0)) != null && Utils.distanceXZ(player.method_24515(), this.method_24515()) > (double)this.biasRangeEnd) {
                this.bias(BP.of(player.method_23317(), player.method_23318(), player.method_23321()));
                if (this.demon) {
                    WeatherClassic.curseWithStormFury((class_1309)player, false);
                }
                return;
            }
            this.currentTarget = this.getNewTarget();
        }
    }

    private class_2338 getNewTarget() {
        int dist1;
        Direction2D dir = this.getTornadoDirections();
        class_2338 pos = null;
        boolean shortPath = this.shouldPursuePlayers();
        int n = shortPath ? 40 : (this.field_5974.method_43048(4) == 0 ? 80 : (dist1 = this.field_5974.method_43056() ? 120 : 200));
        int dist2 = shortPath ? 40 : (this.field_5974.method_43048(4) == 0 ? 80 : (this.field_5974.method_43056() ? 120 : 200));
        dist1 += this.field_5974.method_43048(40);
        dist2 += this.field_5974.method_43048(40);
        if (dir.getDirection1() != null && dir.getDirection1() != this.method_5755().method_10153()) {
            pos = this.method_24515().method_10079(dir.getDirection1(), dist1);
        }
        if (dir.getDirection2() != null && dir.getDirection2() != this.method_5755().method_10153()) {
            pos = pos == null ? this.method_24515().method_10079(dir.getDirection2(), dist2) : pos.method_10079(dir.getDirection2(), dist2);
        }
        return pos;
    }

    public void bias(class_2338 pos) {
        byte lvl = this.shortenedLife ? (byte)0 : ModConfig.getTornadoBiasIntensityLvl();
        int range = switch (lvl) {
            case 0 -> {
                this.biasRangeEnd = 80 + this.field_5974.method_43048(40);
                yield 50;
            }
            case 2 -> {
                this.biasRangeEnd = 20 + this.field_5974.method_43048(40);
                yield 18;
            }
            default -> {
                this.biasRangeEnd = 40 + this.field_5974.method_43048(40);
                yield 30;
            }
        };
        if (this.shouldPursuePlayers() && !this.getSpawning()) {
            this.biasRangeEnd = 20;
        }
        this.currentTarget = this.shouldPursuePlayers() ? pos : pos.method_10079(Utils.randomHorizontal(this.field_5974), 1 + this.field_5974.method_43048(range)).method_10079(Utils.randomHorizontal(this.field_5974), 1 + this.field_5974.method_43048(range / 2));
        this.biasing = true;
    }

    private Direction2D getTornadoDirections() {
        int roll = this.field_5974.method_43048(18);
        switch (roll) {
            case 0: {
                return new Direction2D(class_2350.field_11043, class_2350.field_11034);
            }
            case 1: {
                return new Direction2D(class_2350.field_11035, class_2350.field_11034);
            }
            case 2: {
                return new Direction2D(class_2350.field_11043, class_2350.field_11039);
            }
            case 3: {
                return new Direction2D(class_2350.field_11035, class_2350.field_11039);
            }
            case 4: {
                return new Direction2D(class_2350.field_11034, class_2350.field_11043);
            }
            case 5: {
                return new Direction2D(class_2350.field_11034, class_2350.field_11035);
            }
            case 6: {
                return new Direction2D(class_2350.field_11039, class_2350.field_11043);
            }
            case 7: {
                return new Direction2D(class_2350.field_11039, class_2350.field_11035);
            }
            case 8: 
            case 9: {
                return new Direction2D(class_2350.field_11035, null);
            }
            case 10: 
            case 11: {
                return new Direction2D(class_2350.field_11043, null);
            }
            case 12: 
            case 13: {
                return new Direction2D(class_2350.field_11034, null);
            }
            case 14: 
            case 15: {
                return new Direction2D(class_2350.field_11039, null);
            }
        }
        return new Direction2D(class_2350.field_11043, null);
    }

    private void handleMovement() {
        if (this.field_6012 % (this.demon ? 100 : 200) == 0) {
            this.closeToPlayer = false;
            for (class_1657 player : Utils.getPlayersIn(this.world, this.method_5829().method_1009(128.0, 64.0, 128.0))) {
                if (player.method_7325()) continue;
                if (!this.closeToPlayer && this.method_5858((class_1297)player) < 3600.0) {
                    this.closeToPlayer = true;
                    if (this.demon && (double)this.field_5974.method_43057() < 0.55) {
                        Utils.playSound((class_1297)this, this.world, this.method_24515(), WeatherClassic.GALE_WIGHT_RAGE, this.method_5634(), 5.0f, 0.2f + this.field_5974.method_43057() * 0.1f);
                    }
                }
                if (this.isSpout()) {
                    WeatherClassic.OCEAN_BREEZE.trigger((class_3222)player, this.method_24515(), this.getTornadoType());
                    continue;
                }
                if (this.demon) continue;
                WeatherClassic.TWISTER.trigger((class_3222)player, this.method_24515(), this.getTornadoType());
            }
        }
        this.updateAngles();
        class_243 vec = Utils.convertBlockPosToVec(this.currentTarget);
        Utils.lookAtVec((class_1297)this, vec, this.field_6012 < 20 ? 90.0f : (this.biasing || this.shouldPursuePlayers() ? 2.0f : 0.1f), 0.0f);
        double rads = Math.toRadians(this.realYaw + 90.0f);
        short speed = (short)(!this.demon ? this.getStats().speed + this.speedVary : 15);
        if (this.getStats().speed == 0) {
            speed = 0;
        }
        if (this.isBoundToCluster()) {
            speed = (short)((double)speed / 1.5);
        }
        double vx = Math.cos(rads) * (double)speed * 0.015;
        double vz = Math.sin(rads) * (double)speed * 0.015;
        double vy = this.getAppropriateYVelocity();
        this.method_18800(vx, vy, vz);
    }

    public double getAppropriateYVelocity() {
        int y;
        if (this.freezeYPos) {
            return 0.0;
        }
        if (this.demon) {
            if (this.currentTarget != null) {
                if (this.method_23318() > (double)this.currentTarget.method_10264()) {
                    if (this.method_23318() < (double)(this.world.method_31607() + 1)) {
                        return 0.0;
                    }
                    return -0.2;
                }
                if (this.method_23318() < (double)(this.currentTarget.method_10264() - 1) && !this.world.method_8320(this.method_24515().method_10084()).method_26215()) {
                    return 0.2;
                }
            }
            return 0.0;
        }
        int generousness = 3;
        if (this.field_6012 % 100 == 0 && !this.ascendToGroundLevel) {
            y = this.world.method_8598(class_2902.class_2903.field_13203, this.method_24515()).method_10264();
            int thicknessThreshold = 8;
            if (this.method_23318() < (double)(y - generousness)) {
                int thickness = 0;
                for (int i = 0; i < Math.abs(y - this.method_31478()) && i <= 52; ++i) {
                    class_2680 state = this.world.method_8320(this.method_24515().method_10086(i));
                    if (Utils.canPassThrough(state.method_26204())) continue;
                    if (!Materials.isGeneralStone(state) && !Materials.isAggregate(state)) {
                        --thickness;
                        continue;
                    }
                    if (++thickness <= thicknessThreshold) continue;
                    this.ascendToGroundLevel = true;
                    break;
                }
            }
        }
        if (this.ascendToGroundLevel) {
            y = this.world.method_8598(class_2902.class_2903.field_13203, this.method_24515()).method_10264();
            if (this.method_23318() > (double)(y + 1)) {
                this.ascendToGroundLevel = false;
            } else {
                return 0.2;
            }
        }
        if (this.world.method_8320(this.method_24515()).method_26215()) {
            if (this.method_23318() < (double)(this.world.method_31607() + 1)) {
                return 0.0;
            }
            return -0.2f;
        }
        if (this.field_6012 % 60 == 0) {
            this.modifyGroundLevel = this.tooDeepInGround();
        }
        if (this.modifyGroundLevel) {
            if (this.world.method_8320(this.method_24515().method_10084()).method_26215()) {
                this.modifyGroundLevel = false;
            }
            return 0.2;
        }
        return 0.0;
    }

    private boolean tooDeepInGround() {
        if (ModConfig.getTornadoDestructionLvl() > 1 || this.getTornadoType() == 5 && CustomTornadoConfig.getDestructionLvlOverride() > 1) {
            class_2338.class_2339 pos = this.method_24515().method_25503();
            for (int i = 1; i < 5; ++i) {
                pos.method_33098(this.method_31478() + i);
                if (!this.world.method_8320((class_2338)pos).method_26215()) continue;
                return false;
            }
            return true;
        }
        return !this.world.method_8320(this.method_24515().method_10084()).method_26215();
    }

    private void updateAngles() {
        this.prevRealYaw = this.realYaw = Utils.wrapAngleAround(this.realYaw, this.method_5791());
        this.prevRealYaw = Utils.wrapAngleAround(this.prevRealYaw, this.realYaw);
        this.realYaw += (this.method_5791() - this.realYaw) * 0.6f;
    }

    public void killStorm() {
        for (DebrisEntity debris : this.rotator.getDebris()) {
            if (debris.getTornadoHost() == null && !(debris.method_24921() instanceof TornadoEntity)) continue;
            debris.setTornadoHost(null);
            debris.method_7432(null);
        }
        if ((double)this.field_5974.method_43057() < 0.75 && this.getTornadoType() != 5 && !this.world.method_8608() && this.field_6012 > 20) {
            boolean useColor = this.isSpout() || (double)this.field_5974.method_43057() < 0.6;
            int width = this.isSpout() && !this.variant ? 4 : Math.max((int)((double)this.stats.pathSize * 2.5), 8);
            for (int i = 0; i < this.stats.particleCount * (this.getTornadoType() + 1); ++i) {
                TornadoColor color;
                class_2338 floor = this.world.method_8598(class_2902.class_2903.field_13202, this.method_24515().method_10079(Utils.randomHorizontal(this.field_5974), 2 + this.field_5974.method_43048(width)).method_10079(Utils.randomHorizontal(this.field_5974), 2 + this.field_5974.method_43048(width)));
                float ctu = -1.0f;
                if (useColor && (color = this.getTornadoColorFromAround(floor)) != null) {
                    ctu = color.asFloat();
                }
                Utils.forceImportantParticles((class_3218)this.world, WCParticles.TORNADO_DEATH_PARTICLE, (double)floor.method_10263() + 0.5, (double)floor.method_10264() + 0.5, (double)floor.method_10260() + 0.5, 0, 0.0, 1.0, this.isSpout() ? 1.0 : 0.0, ctu);
            }
        }
        ArrayList<TornadoReviver> blackList = new ArrayList<TornadoReviver>();
        for (TornadoReviver reviver : Global.weather.getRevivers()) {
            if (reviver.isOn() || reviver.getID() != this.method_5628()) continue;
            blackList.add(reviver);
        }
        blackList.forEach(r -> Global.weather.getRevivers().remove(r));
        if (!this.method_31481()) {
            this.method_31472();
        }
        if (this.getTornadoType() == 5) {
            WCNetworkServer.forceBigUpdate();
        }
    }

    private void handleStrength() {
        if (this.getSpawning()) {
            if (this.getStrength() < 40.0f) {
                this.setStrength(40.0f);
            } else if (this.getStrength() >= 100.0f) {
                this.setStrength(100.0f);
            }
            this.setStrength(this.getStrength() + 0.05f);
            if (this.method_55667().method_26215() && this.world.method_8320(this.method_24515().method_10074()).method_26215()) {
                double yPos = this.method_23318();
                if ((yPos -= (double)0.2f - this.field_5974.method_43059() * 2.0) < (double)(this.world.method_31607() + 2)) {
                    yPos = this.method_23318();
                }
                this.method_5808(this.method_23317(), yPos, this.method_23321(), this.method_36454(), 0.0f);
            } else {
                this.setSpawning(false);
            }
        } else if (this.getDying()) {
            if (this.getStrength() < 40.0f) {
                this.setStrength(40.0f);
            } else if (this.getStrength() >= 100.0f) {
                this.setStrength(100.0f);
            }
            this.setStrength(this.getStrength() - 0.01f);
            if (this.method_23318() < (double)this.getCloudY()) {
                double yPos = this.method_23318();
                yPos += (double)0.3f + this.field_5974.method_43059() * 2.0;
                if (!this.world.method_8320(this.method_24515().method_10087(2)).method_26215() && yPos <= this.method_23318() || yPos < (double)(this.world.method_31607() + 2)) {
                    yPos = this.method_23318();
                }
                this.method_5808(this.method_23317(), yPos, this.method_23321(), this.method_36454(), 0.0f);
            } else {
                float persistProb = 0.05f;
                if (Global.weather.isSevereStorm() && !Global.weather.isStormDying()) {
                    persistProb = 0.1f;
                }
                if (this.field_5974.method_43057() < persistProb && !this.shortenedLife && this.dispels <= 0) {
                    this.setDying(false);
                    this.field_6012 = 0;
                    this.shortenedLife = true;
                    this.currentTarget = null;
                    if (this.isSpout()) {
                        this.freezeYPos = true;
                        this.method_5725(BP.of(this.field_6014, this.method_23318() - (double)this.field_5974.method_43048(5), this.field_5969), this.method_36454(), this.method_36455());
                    } else {
                        this.setSpawning(true);
                    }
                    this.world.method_8421((class_1297)this, (byte)35);
                } else {
                    this.killStorm();
                }
            }
        } else if (this.field_6012 % 20 == 0) {
            this.setStrength((float)this.field_5974.method_43048(30) * 1.0f + 100.0f);
            int height = this.getTornadoType() == 5 || ModConfig.getGenerateOverrides() ? ModConfig.getTornadoCloudScale(this.getTornadoType() == 5) : 72;
            this.setCloudY(this.method_31478() + height);
            if (this.field_6012 > this.getLifetime() || this.isSpout() && TornadoEntity.isInvalidForSpout(this.method_55667())) {
                this.startDissipate();
            }
            if (this.alterScale && (double)this.field_5974.method_43057() < 0.051) {
                float jump = this.scaleVolatility;
                this.scaleBonus = !this.dyingScale ? (this.scaleBonus += jump) : (this.scaleBonus -= jump);
                if (this.scaleBonus >= this.stats.maxScaleBonus * this.maxScalePercent) {
                    this.dyingScale = (double)this.field_5974.method_43057() < 0.4;
                } else if ((double)this.scaleBonus <= 1.0E-4 || this.getTornadoTypeForRotator() == 4 && this.scaleBonus < 2.0f) {
                    this.scaleBonus = this.getTornadoTypeForRotator() == 4 ? 2.0f : 0.0f;
                    this.dyingScale = false;
                }
            }
            if (!this.variant) {
                WCNetworkServer.sendTornadoMiscPacket((class_3218)this.world, this);
            }
        }
        if (this.variant && this.field_6012 % 7 == 0) {
            if (!this.isSpout()) {
                float max = 12.0f;
                if (this.xOffset <= this.xOffsetGoal) {
                    this.xOffset = (float)((double)this.xOffset + 2.2);
                    if (this.xOffset > this.xOffsetGoal) {
                        this.xOffsetGoal = this.field_5974.method_43057() * max;
                        this.xOffsetGoal *= (float)(this.field_5974.method_43056() ? -1 : 1);
                    }
                } else if (this.xOffset > this.xOffsetGoal) {
                    this.xOffset = (float)((double)this.xOffset - (0.2 + (double)(this.speedVary / 3)));
                    if (this.xOffset <= this.xOffsetGoal) {
                        this.xOffsetGoal = this.field_5974.method_43057() * max;
                        this.xOffsetGoal *= (float)(this.field_5974.method_43056() ? -1 : 1);
                    }
                }
                if (this.zOffset <= this.zOffsetGoal) {
                    this.zOffset = (float)((double)this.zOffset + (0.2 + (double)(this.speedVary / 3)));
                    if (this.zOffset > this.zOffsetGoal) {
                        this.zOffsetGoal = this.field_5974.method_43057() * max;
                        this.zOffsetGoal *= (float)(this.xOffsetGoal > 0.0f ? -1 : 1);
                    }
                } else if (this.zOffset > this.zOffsetGoal) {
                    this.zOffset = (float)((double)this.zOffset - (0.2 + (double)(this.speedVary / 3)));
                    if (this.zOffset <= this.zOffsetGoal) {
                        this.zOffsetGoal = this.field_5974.method_43057() * max;
                        this.zOffsetGoal *= (float)(this.xOffsetGoal > 0.0f ? -1 : 1);
                    }
                }
            } else {
                this.zOffset = -1.0f;
                this.xOffset = -1.0f;
            }
            WCNetworkServer.sendTornadoMiscPacket((class_3218)this.world, this);
        }
    }

    public void dispel() {
        this.dispels = (short)(this.dispels + 1);
        if (this.dispels > this.getDispellerCountForResistance()) {
            this.startDissipate();
            for (class_1657 player : Utils.getPlayersIn(this.world, this.method_5829().method_1009(86.0, 64.0, 86.0))) {
                WeatherClassic.DISPEL.trigger((class_3222)player, this.getTornadoType());
            }
        }
    }

    public void startDissipate() {
        this.setDying(true);
        this.setSpawning(false);
    }

    private void tickFX() {
        byte c;
        boolean override;
        boolean allowColor;
        if (this.field_6012 < 5) {
            return;
        }
        class_3218 sworld = (class_3218)this.world;
        boolean bl = allowColor = this.tornadoType != TornadoStats.Type.STAGEX && !this.demon || this.tornadoType == TornadoStats.Type.STAGEX && CustomTornadoConfig.getTakeSurroundingColor();
        if (!this.isSpout()) {
            if (this.colorChangeTicks <= 0) {
                if (this.currentColor != null) {
                    this.currentColor = null;
                }
                if (this.field_6012 % 30 == 0 && this.field_5974.method_43048(8) == 0 && allowColor) {
                    this.colorChangeTicks = 10 + this.field_5974.method_43048(40);
                    if ((double)this.field_5974.method_43057() < 0.3) {
                        this.colorChangeTicks = 80 + this.field_5974.method_43048(120);
                    }
                }
            } else {
                if (this.currentColor == null) {
                    TornadoColor tornadoColor = this.currentColor = this.firenado ? TornadoColor.FIRE : this.getTornadoColorFromAround(this.method_24515());
                    if (this.currentColor == null) {
                        this.colorChangeTicks = 0;
                        return;
                    }
                }
                --this.colorChangeTicks;
                if (this.colorChangeTicks <= 0 && (this.currentColor == TornadoColor.BLUE || this.currentColor == TornadoColor.AQUA_BLUE)) {
                    this.currentColor = this.getTornadoColorFromAround(this.method_24515());
                    if (this.currentColor == TornadoColor.BLUE || this.currentColor == TornadoColor.AQUA_BLUE) {
                        this.colorChangeTicks = 80 + this.field_5974.method_43048(120);
                    }
                }
            }
        } else if (this.getCurrentTornadoColor() == null || this.field_6012 % 50 == 0) {
            this.currentColor = this.getTornadoColorFromAround(this.method_24515());
        }
        float cval = this.currentColor != null ? this.currentColor.asFloat() : -1.0f;
        int totalTornadoes = Global.activeTornadoes.size();
        int totalClusters = Global.activeClusters.size();
        int totalStorms = totalClusters + totalTornadoes;
        boolean beyondRange = this.getRipper().isFarOut() && (totalTornadoes > 1 || totalClusters > 1);
        boolean cullFunnel = beyondRange || totalTornadoes > 3 || totalClusters > 3 || totalStorms > 4;
        boolean cullClouds = cullFunnel || totalTornadoes > 1 || totalClusters > 2 || totalStorms > 3;
        boolean cullCloudsGreatly = cullFunnel || totalTornadoes > 2;
        short pCount = (byte)this.getStats().particleCount;
        boolean bl2 = override = ModConfig.getGenerateOverrides() && this.getTornadoType() != 5 && ModConfig.PARTICLE_OVERRIDE_CONFIGS.containsKey(this.getTornadoType());
        if (override && (c = ModConfig.PARTICLE_OVERRIDE_CONFIGS.get(this.getTornadoType()).count()) >= 0) {
            pCount = c;
        }
        int count = (int)(cullFunnel ? 2.0 : (this.isDemonic() ? (double)this.getStats().particleCount / 1.5 : (double)(pCount + (this.scaleBonus > this.stats.bigScaleThreshold ? 2 : 0))));
        float add = this.demon ? 0.5f : 0.0f;
        boolean extra = this.field_5974.method_43057() < this.getStats().extraParticleChance && !this.getDying();
        int multiple = extra ? (int)this.stats.extraParticleDistance : 2;
        for (int funnelCount = 0; funnelCount < count; ++funnelCount) {
            if (this.field_5974.method_43048(5) == 0 && extra && this.colorChangeTicks <= 0) {
                if (allowColor) {
                    TornadoColor color = this.getTornadoColorFromAround(this.method_24515());
                    if (color != null) {
                        cval = color.asFloat();
                        if (this.firenado) {
                            cval = TornadoColor.FIRE.asFloat();
                        }
                    }
                } else if (CustomTornadoConfig.getColorOverride() && !this.demon) {
                    cval = TornadoColor.UNIQUE_FLARE.asFloat();
                }
            }
            if (this.demon && this.isCloseToPlayer()) {
                cval = TornadoColor.FIRE.asFloat();
            }
            double tryX = this.method_23317() + (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple) - (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple);
            double tryZ = this.method_23321() + (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple) - (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple);
            Utils.forceImportantParticles(sworld, WCParticles.TORNADO_PARTICLE, tryX, this.method_23318() + 0.01, tryZ, 0, 0.0, 1.0, 0.0, cval);
        }
        if (this.method_59922().method_43048(2) == 0 && (!this.demon || this.isCloseToPlayer())) {
            double gy = this.world.method_67393(class_2902.class_2903.field_13202, this.method_24515());
            byte tfr = this.getTornadoTypeForRotator();
            for (int windCount = 0; windCount < (tfr < 1 ? 4 : 8); ++windCount) {
                double tryX = 10 + this.field_5974.method_43048((int)this.getStats().particleGetRange);
                double tryZ = 10 + this.field_5974.method_43048((int)this.getStats().particleGetRange);
                tryX *= this.field_5974.method_43056() ? -1.0 : 1.0;
                tryZ *= this.field_5974.method_43056() ? -1.0 : 1.0;
                tryX += this.method_23317();
                tryZ += this.method_23321();
                double tryY = gy + (double)this.field_5974.method_43048(20);
                if (!this.demon) {
                    float randOpacity = 0.9f - this.field_5974.method_43057() * 0.3f;
                    Utils.forceImportantParticles(sworld, WCParticles.TORNADO_WIND_PARTICLE, tryX, tryY, tryZ, 0, 0.0, 1.0, 0.0, randOpacity *= 10.0f);
                    continue;
                }
                Utils.forceImportantParticles(sworld, class_2398.field_11240, tryX, tryY, tryZ, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.getStats().createClouds && !this.isBoundToCluster() && (!cullCloudsGreatly || (double)this.field_5974.method_43057() < 0.8)) {
            int num;
            int n = num = this.field_6012 < 100 ? 4 : 2;
            if (cullClouds || this.getTornadoType() == 5 && CustomTornadoConfig.getScaling() < 0.75f) {
                num = 1;
            }
            for (int cloudCount = 0; cloudCount < num; ++cloudCount) {
                byte distX = (byte)(this.field_6012 < 100 || this.field_6012 % (this.getTornadoTypeForRotator() == 4 ? 5 : 20) == 0 ? (float)this.stats.particleGetRange * this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1) : 0.0f);
                byte distZ = (byte)(this.field_6012 < 100 || this.field_6012 % (this.getTornadoTypeForRotator() == 4 ? 5 : 20) == 0 ? (float)this.stats.particleGetRange * this.field_5974.method_43057() * (float)(this.field_5974.method_43056() ? -1 : 1) : 0.0f);
                Utils.forceImportantParticles(sworld, WCParticles.STORM_CLOUD_PARTICLE, this.method_23317() + (double)distX, this.getCloudY(), this.method_23321() + (double)distZ, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private TornadoColor getTornadoColorFromAround(class_2338 pos) {
        boolean redG;
        class_2338 down = pos.method_10074();
        if (this.isSpout() || Materials.isWater(this.world.method_8320(pos)) || Materials.isWater(this.world.method_8320(down))) {
            TornadoColor c = !ModConfig.getMimicOld() && Utils.isTropicalOcean((class_5321<class_1959>)((class_5321)this.world.method_23753(pos).method_40230().get())) ? TornadoColor.AQUA_BLUE : TornadoColor.BLUE;
            return c;
        }
        int dirt = 0;
        int snow = 0;
        int sand = 0;
        int red = 0;
        int leaves = 0;
        class_2338.class_2339 test = pos.method_25503();
        int range = 4;
        for (int xx = pos.method_10263() - range; xx < pos.method_10263() + range; xx += 2) {
            for (int zz = pos.method_10260() - range; zz < pos.method_10260() + range; zz += 2) {
                for (int yy = pos.method_10264() - 1; yy < pos.method_10264() + 8; yy += 2) {
                    test.method_10103(xx, yy, zz);
                    class_2680 state = this.world.method_8320((class_2338)test);
                    if (state.method_26215()) continue;
                    if (leaves < 4 && Materials.isLeaves(state)) {
                        ++leaves;
                        continue;
                    }
                    if (Materials.isSand(state)) {
                        if (Materials.isRedSand(state)) {
                            ++red;
                            continue;
                        }
                        ++sand;
                        continue;
                    }
                    if (Materials.isDirt(state)) {
                        ++dirt;
                        continue;
                    }
                    if (!Materials.isSnow(state)) continue;
                    ++snow;
                }
            }
        }
        boolean dirtG = dirt > 4;
        class_6880 biome = this.world.method_23753(pos);
        boolean leavesG = (leaves > 3 || Utils.isBiomeForest((class_6880<class_1959>)biome)) && this.field_5974.method_43057() < 0.3f;
        boolean snowG = snow > 4;
        boolean sandG = !ModConfig.getMimicOld() && sand > 4;
        boolean bl = redG = red > 4;
        if (leavesG) {
            return TornadoColor.GREEN;
        }
        return redG ? TornadoColor.RED : (sandG ? TornadoColor.SANDY : (snowG ? TornadoColor.WHITISH : (dirtG ? TornadoColor.BROWN : null)));
    }

    public TornadoColor getCurrentTornadoColor() {
        return this.currentColor;
    }

    protected boolean method_5876() {
        return false;
    }

    protected class_3414 method_5737() {
        return null;
    }

    public TornadoRipper getRipper() {
        return this.ripper;
    }

    public TornadoRotator getRotator() {
        return this.rotator;
    }

    public boolean isCloseToPlayer() {
        return this.closeToPlayer;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source == world.method_48963().method_51847()) {
            this.startDissipate();
        } else if (source == world.method_48963().method_48829()) {
            this.killStorm();
        }
        return false;
    }

    public int getMaxRangeForTracking(boolean inChunks) {
        return this.method_5864().method_18387() * (inChunks ? 1 : 16);
    }

    public boolean method_5974(double distanceSquared) {
        int dist = ModConfig.getMaxTornadoLoadDist();
        boolean despawn = distanceSquared > (double)(dist * dist);
        return despawn;
    }

    public void method_5982() {
        if (this.method_73183().method_8407() == class_1267.field_5801 && !this.method_5864().method_72390()) {
            this.killStorm();
        } else if (!this.method_5947() && !this.method_17326()) {
            class_1657 entity = this.method_73183().method_18460((class_1297)this, -1.0);
            if (entity != null) {
                int i;
                int j;
                double d = entity.method_5858((class_1297)this);
                if (d > (double)(j = (i = this.method_5864().method_5891().method_27919()) * i) && this.method_5974(d)) {
                    this.killStorm();
                }
                int k = this.method_5864().method_5891().method_27920();
                int l = k * k;
                if (this.field_6278 > 600 && this.field_5974.method_43048(800) == 0 && d > (double)l && this.method_5974(d)) {
                    this.killStorm();
                } else if (d < (double)l) {
                    this.field_6278 = 0;
                }
            }
        } else {
            this.field_6278 = 0;
        }
    }

    public boolean method_17326() {
        return false;
    }

    public boolean method_5947() {
        return this.method_17326();
    }

    @Override
    public float getStrength() {
        return ((Float)this.method_5841().method_12789(STRENGTH)).floatValue();
    }

    public void setStrength(float f) {
        this.method_5841().method_12778(STRENGTH, (Object)Float.valueOf(f));
    }

    public void setSpawning(boolean b) {
        this.method_5841().method_12778(SPAWNING, (Object)b);
    }

    public boolean getSpawning() {
        return (Boolean)this.method_5841().method_12789(SPAWNING);
    }

    public void setDying(boolean b) {
        this.method_5841().method_12778(DYING, (Object)b);
    }

    public boolean getDying() {
        return (Boolean)this.method_5841().method_12789(DYING);
    }

    public void setCloudY(int i) {
        this.method_5841().method_12778(STORM_CLOUD_Y, (Object)i);
    }

    @Override
    public int getCloudY() {
        return (Integer)this.method_5841().method_12789(STORM_CLOUD_Y);
    }

    public void setCurrentTarget(class_2338 pos) {
        this.currentTarget = pos;
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5873(class_1297 entity, boolean force, boolean event) {
        return false;
    }

    public boolean method_5931() {
        return false;
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        if (!this.world.method_8608() && nbt.method_71426("unload", (Codec)Codec.BOOL).isPresent()) {
            nbt.method_71426("unload", (Codec)Codec.BOOL).ifPresent(p -> {
                if (p.booleanValue()) {
                    this.worldUnload = true;
                    this.currentTarget = Utils.readBlockPos(nbt, "targ");
                }
            });
        }
    }

    public void method_5652(class_11372 nbt) {
        if (!this.world.method_8608() && this.world.method_18456().isEmpty()) {
            nbt.method_71472("unload", true);
            if (this.currentTarget != null) {
                nbt.method_71465("targX", this.currentTarget.method_10263());
                nbt.method_71465("targY", this.currentTarget.method_10264());
                nbt.method_71465("targZ", this.currentTarget.method_10260());
            }
            Global.removeTornado(this);
        }
        super.method_5652(nbt);
    }

    public static boolean isInvalidForSpout(class_2680 state) {
        return !Materials.isOcean(state) && !state.method_26215();
    }

    @Override
    public class_243 getEmitter() {
        return this.method_73189();
    }

    public boolean killDueToPlayersUnavailable() {
        if (!this.world.method_18456().isEmpty()) {
            return false;
        }
        boolean fullOther = false;
        for (class_3218 w : this.world.method_8503().method_3738()) {
            if (w.method_27983() == class_1937.field_25179 || w.method_18456().isEmpty()) continue;
            fullOther = true;
            break;
        }
        return !this.world.method_8503().method_3760().method_14571().isEmpty() && fullOther;
    }

    public boolean killDueToInvalidPosition() {
        if (!this.world.method_8621().method_11952(this.method_24515()) || this.method_31478() < this.world.method_31607() - 1 || this.world.method_27983() != class_1937.field_25179) {
            return true;
        }
        class_1657 player = this.world.method_8604(this.method_23317(), this.method_23318(), this.method_23321(), -1.0, p -> p.method_7325());
        if (player != null) {
            int distLimit = ModConfig.getMaxTornadoLoadDist() - 16;
            if (this.method_5707(player.method_33571()) > (double)(distLimit * distLimit)) {
                return true;
            }
        }
        if (this.isBoundToCluster()) {
            this.clusterBound.tornado = this;
            if (this.clusterBound.isRemoved()) {
                return true;
            }
        }
        if (this.demon && TornadoEntity.invalidForDemon(this.world)) {
            return true;
        }
        if (this.triedCombine) {
            return false;
        }
        TornadoEntity tornado = Global.getClosestOtherTornado(this);
        if (tornado == null) {
            return false;
        }
        if (Utils.squaredDistanceXZ(this.method_73189(), tornado.method_73189()) >= 784.0) {
            return false;
        }
        byte his = tornado.getTornadoType();
        byte mine = this.getTornadoType();
        byte higher = (byte)Math.max(his, mine);
        TornadoEntity better = null;
        better = higher == his ? tornado : this;
        if (higher < TornadoStats.Type.STAGE5.getByte()) {
            if ((double)this.field_5974.method_43057() < 0.1 && !this.isSpout()) {
                byte level = (byte)(higher + 1);
                TornadoEntity newT = new TornadoEntity(TornadoEntity.getEntityTypeFrom(level), this.world).enable();
                newT.method_5725(better.method_24515(), 0.0f, 0.0f);
                Global.forceChunksForTornadoSpawn((class_3218)this.world, tornado, better.method_31476());
                this.world.method_8649((class_1297)newT);
                tornado.killStorm();
                return true;
            }
            this.triedCombine = true;
        }
        return false;
    }

    public static boolean invalidForDemon(class_1937 world) {
        long t = world.method_8532() % 24000L;
        return t <= 12000L || t >= 22000L || !world.method_8546();
    }

    @Override
    public int getPullRadius() {
        return this.rotator.getPullRadius();
    }

    public double method_23320() {
        return this.method_23318() + (double)TornadoEntity.getMidCalculation();
    }

    public static int getMidCalculation() {
        return 20;
    }

    @Override
    public boolean isDemonic() {
        return this.demon || this.isBoundToCluster() && this.tornadoType != TornadoStats.Type.STAGE2;
    }

    public short getDispellerCountForResistance() {
        float res = this.getStats().dispellerResistance;
        short r = (short)class_3532.method_15375((float)(res * 10.0f));
        return (short)class_3532.method_15340((int)r, (int)0, (int)10);
    }

    public static TornadoStats.Type getTornadoTypeFrom(byte b) {
        switch (b) {
            case 0: {
                return TornadoStats.Type.SPOUT;
            }
            case 1: {
                return TornadoStats.Type.STAGE2;
            }
            case 2: {
                return TornadoStats.Type.STAGE3;
            }
            case 3: {
                return TornadoStats.Type.STAGE4;
            }
            case 4: {
                return TornadoStats.Type.STAGE5;
            }
            case 5: {
                return TornadoStats.Type.STAGEX;
            }
        }
        return TornadoStats.Type.STAGE2;
    }

    public static class_1299<? extends class_1314> getEntityTypeFrom(byte b) {
        switch (b) {
            case 0: {
                return WeatherClassic.SPOUT;
            }
            case 1: {
                return WeatherClassic.STAGE2;
            }
            case 2: {
                return WeatherClassic.STAGE3;
            }
            case 3: {
                return WeatherClassic.STAGE4;
            }
            case 4: {
                return WeatherClassic.STAGE5;
            }
            case 5: {
                return WeatherClassic.STAGEX;
            }
        }
        return WeatherClassic.STAGE2;
    }

    public static TornadoStats.Type getTornadoTypeFromEntity(class_1299<? extends class_1314> type) {
        return type == WeatherClassic.SPOUT ? TornadoStats.Type.SPOUT : (type == WeatherClassic.STAGE3 ? TornadoStats.Type.STAGE3 : (type == WeatherClassic.STAGE4 ? TornadoStats.Type.STAGE4 : (type == WeatherClassic.STAGE5 ? TornadoStats.Type.STAGE5 : (type == WeatherClassic.STAGEX ? TornadoStats.Type.STAGEX : TornadoStats.Type.STAGE2))));
    }

    static {
        tornadoColors.put(TornadoColor.SANDY, new Vector3f(0.95f, 0.9f, 0.75f));
        tornadoColors.put(TornadoColor.RED, new Vector3f(0.92f, 0.57f, 0.33f));
        tornadoColors.put(TornadoColor.WHITISH, new Vector3f(0.93f, 1.0f, 1.0f));
        tornadoColors.put(TornadoColor.BLUE, new Vector3f(0.0f, 0.26f, 0.86f));
        tornadoColors.put(TornadoColor.AQUA_BLUE, new Vector3f(0.0f, 0.55f, 0.84f));
        tornadoColors.put(TornadoColor.BROWN, new Vector3f(0.76f, 0.51f, 0.3f));
        tornadoColors.put(TornadoColor.GREEN, new Vector3f(0.18f, 0.92f, 0.0f));
        tornadoColors.put(TornadoColor.FIRE, new Vector3f(0.9f, 0.3f, 0.0f));
    }

    public static enum TornadoColor {
        BROWN(0.0f),
        GREEN(1.0f),
        SANDY(2.0f),
        RED(3.0f),
        WHITISH(4.0f),
        BLUE(5.0f),
        AQUA_BLUE(6.0f),
        UNIQUE_FLARE(7.0f),
        FIRE(10.0f);

        final float colorFloat;

        private TornadoColor(float f) {
            this.colorFloat = f;
        }

        public float asFloat() {
            return this.colorFloat;
        }

        public static TornadoColor get(float f) {
            int i = (int)f;
            switch (i) {
                case 0: {
                    return BROWN;
                }
                case 1: {
                    return GREEN;
                }
                case 2: {
                    return SANDY;
                }
                case 3: {
                    return RED;
                }
                case 4: {
                    return WHITISH;
                }
                case 5: {
                    return BLUE;
                }
                case 6: {
                    return AQUA_BLUE;
                }
                case 7: {
                    return UNIQUE_FLARE;
                }
                case 10: {
                    return FIRE;
                }
            }
            return null;
        }
    }
}

