/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_10255;
import net.minecraft.class_11187;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1542;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5702;
import net.minecraft.class_8836;
import net.weather_classic.block.PuddleBlock;
import net.weather_classic.block.TornadoDispellerBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.BP;
import net.weather_classic.help.MutableTriplet;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core_related.DebrisManipulator;
import net.weather_classic.misc.EntityVelocityDemander;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.debris.DebrisEntity;
import net.weather_classic.storm.player.PlayerInputAccount;
import net.weather_classic.storm.source.TornadoParticleSource;

public class TornadoRotator {
    private final TornadoEntity storm;
    private List<DebrisEntity> debris = new ArrayList<DebrisEntity>();
    private List<class_1309> mobs = new ArrayList<class_1309>();
    private List<class_8836> vehicles = new ArrayList<class_8836>();
    private List<class_1297> prevList;
    private final MutableTriplet<Integer, Integer, Integer> spoutPullVals;
    private MutableTriplet<Integer, Integer, Integer> tornadoPullVals;
    private List<class_1309> tempList = new ArrayList<class_1309>();
    private List<class_1657> playersForDebrisUpdates = null;

    public TornadoRotator(TornadoEntity tornado) {
        this.storm = tornado;
        this.spoutPullVals = MutableTriplet.of(10, 15, this.getPullRadius());
        this.updatePullVals(tornado);
        this.prevList = List.of();
    }

    public void updatePullVals(TornadoEntity tornado) {
        this.tornadoPullVals = MutableTriplet.of(class_3532.method_15357((double)((double)this.getPullRadius() * 0.37)), class_3532.method_15357((double)((double)this.getPullRadius() * 0.73)), this.getPullRadius());
        byte t = tornado.getTornadoTypeForRotator();
        switch (t) {
            case 2: {
                this.tornadoPullVals.updateA(52);
                break;
            }
            case 3: {
                this.tornadoPullVals.updateA(72);
                this.tornadoPullVals.updateB(92);
                break;
            }
            case 4: {
                this.tornadoPullVals.updateA(112);
                this.tornadoPullVals.updateB(132);
            }
        }
        if (tornado.isSpout() && tornado.variant) {
            this.spoutPullVals.updateA(32);
        }
    }

    public boolean hasMob(class_1309 ent) {
        return this.mobs.contains(ent);
    }

    public List<DebrisEntity> getDebris() {
        return this.debris;
    }

    public List<class_1309> getRotatingMobs() {
        return this.mobs;
    }

    public boolean maxMobsReached() {
        return this.mobs.size() >= ModConfig.getMaxMobsPerTornado() + this.storm.getTornadoTypeForRotator() * 2;
    }

    public boolean maxDebrisReached() {
        int num = ModConfig.getMaxDebrisPerTornado();
        switch (this.storm.getStats().ripType) {
            case STAGE3: {
                num += 5;
                break;
            }
            case STAGE4: {
                num += 10;
                break;
            }
            case STAGE5: {
                num += 15;
                break;
            }
        }
        return this.debris.size() >= num + (this.storm.isDemon() ? 20 : 0);
    }

    public int getPullRadius() {
        return this.storm.getStats().grabDistance;
    }

    private class_238 getGrabBox(boolean tempBox) {
        int downwardOffset = 8;
        int bobbingRegion = 6;
        class_238 b = new class_238(this.storm.method_24515().method_10086(32)).method_1009((double)this.getPullRadius(), 64.0, (double)this.getPullRadius());
        int height = 64;
        if (this.storm.getTornadoType() == 5 || ModConfig.getGenerateOverrides()) {
            int scale;
            height = scale = ModConfig.getTornadoBoxScale(this.storm.getTornadoType() == 5);
        }
        b = tempBox ? b.method_35575((double)(this.storm.method_31478() + this.storm.getStats().idealLiftHeight)).method_35578((double)(this.storm.method_31478() + height + bobbingRegion)) : b.method_35575((double)(this.storm.method_31478() - downwardOffset)).method_35578((double)(this.storm.method_31478() + this.storm.getStats().idealLiftHeight + bobbingRegion));
        return b;
    }

    public void grabEntities() {
        if (this.storm.getRipper() != null && this.storm.getRipper().isBeyondLoadedRange()) {
            if (!this.mobs.isEmpty()) {
                this.mobs.clear();
            }
            if (!this.vehicles.isEmpty()) {
                this.vehicles.clear();
            }
            if (!this.debris.isEmpty()) {
                Iterator<DebrisEntity> debrisIterator = this.debris.iterator();
                while (debrisIterator.hasNext()) {
                    DebrisEntity ent = debrisIterator.next();
                    if (ent.method_5869() || Utils.inInvalidMode((class_1297)ent) || ent.method_24921() != this.storm) {
                        debrisIterator.remove();
                        continue;
                    }
                    ent.method_31472();
                    ent.method_5773();
                }
            }
            return;
        }
        if ((this.storm.isDemon() && this.storm.isCloseToPlayer() || this.storm.isPassiveFirenado() && !this.storm.variant || this.storm.getTornadoType() == 5 && CustomTornadoConfig.getRipType(true) == 6) && this.storm.field_6012 % 2 == 0) {
            class_2338 spso = this.storm.method_24515().method_10086(10 + this.storm.method_59922().method_43048(30)).method_10079(Utils.randomHorizontal(this.storm.method_59922()), this.storm.method_59922().method_43048(this.storm.getStats().pathSize + 2));
            if (this.storm.field_6012 % 10 == 0 && this.storm.method_73183().method_8320(spso).method_26215() && !this.maxDebrisReached()) {
                DebrisEntity deb = DebrisEntity.createDebris(WCEntities.DEBRIS, this.storm, spso, class_2246.field_10036.method_9564(), true);
                deb.method_5725(this.storm.method_24515().method_10086(20), 0.0f, 0.0f);
                deb.method_73183().method_8649((class_1297)deb);
                this.getDebris().add(deb);
            }
            int totalTornadoes = Global.activeTornadoes.size();
            float f = this.storm.method_59922().method_43057();
            float f2 = totalTornadoes > 3 ? 0.05f : (totalTornadoes > 2 ? 0.1f : (totalTornadoes > 1 ? 0.2f : 0.4f));
            if (f < f2) {
                WCNetworkServer.forceDebrisParticlesWithin((class_3218)this.storm.method_73183(), 212, spso, class_2248.method_9507((class_2680)class_2246.field_10036.method_9564()));
            }
        }
        if (this.storm.field_6012 % 35 == 0) {
            List list = this.storm.method_73183().method_8390(class_1297.class, this.getGrabBox(false), p -> !p.method_5869() && !Utils.inInvalidMode(p) && !Utils.isWindImmuneMob(p));
            for (class_1297 entity : list) {
                boolean isDebris;
                if (entity instanceof class_1420 || entity instanceof class_1542) continue;
                if (entity instanceof class_8836) {
                    class_8836 v = (class_8836)entity;
                    double distXZ = Utils.distanceXZ(v.method_24515(), this.storm.method_24515());
                    float limit = (float)(this.storm.getTornadoTypeForRotator() <= 0 ? 2.0 : 1.2);
                    if (distXZ < (double)((float)this.getPullRadius() / limit) && !this.vehicles.contains(v) && this.vehicles.size() < ModConfig.getMaxMobsPerTornado()) {
                        this.vehicles.add(v);
                    }
                }
                boolean normal = entity.method_5709();
                boolean bl = isDebris = entity.method_5864() == WCEntities.DEBRIS;
                if (this.mobs.contains(entity) || this.debris.contains(entity) || normal && this.maxMobsReached() && !entity.method_31747() || !normal && this.maxDebrisReached()) continue;
                if (normal) {
                    if (this.mobs.contains(entity)) continue;
                    this.mobs.add((class_1309)entity);
                    if (!this.tempList.contains(entity)) continue;
                    this.tempList.remove(entity);
                    continue;
                }
                if (!isDebris || this.debris.contains(entity)) continue;
                DebrisEntity debris = (DebrisEntity)entity;
                class_1297 class_12972 = debris.method_24921();
                if (class_12972 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12972;
                    DebrisManipulator data = (DebrisManipulator)player;
                    if (data.getManipulatingDebris() == entity) continue;
                    if (debris.isSegmentOfWorm()) {
                        debris.disconnectFromHead();
                    }
                    if (debris.isWorm()) {
                        if (debris.field_6012 <= 60) continue;
                        debris.method_31472();
                        continue;
                    }
                }
                debris.method_7432((class_1297)this.storm);
                debris.setTornadoHost(this.storm.method_5667());
                this.debris.add(debris);
                entity.method_5660(true);
            }
            this.prevList = list;
        }
        this.pullEntitiesAboveTemporarily();
        if (!this.vehicles.isEmpty()) {
            float limit = (float)(this.storm.getTornadoTypeForRotator() <= 0 ? 2.0 : 1.2);
            Iterator<class_8836> vehicleIterator = this.vehicles.iterator();
            while (vehicleIterator.hasNext()) {
                double distXZ;
                class_8836 v = vehicleIterator.next();
                if (v.method_5869() || Utils.inInvalidMode((class_1297)v) || !this.prevList.contains(v)) {
                    v.method_5855(v.method_5748());
                    vehicleIterator.remove();
                    continue;
                }
                if (this.canEntitySeeTornado((class_1297)v) && v.method_31478() < this.storm.method_31478() + this.storm.getStats().idealLiftHeight) {
                    if (this.storm.isSpout() && !this.storm.variant && v instanceof class_10255) {
                        class_10255 boa = (class_10255)v;
                        if (this.storm.field_6012 % 4 == 0) {
                            v.method_64397((class_3218)this.storm.method_73183(), this.storm.method_73183().method_48963().method_48830(), 0.4f);
                        }
                        double distXZSq = Utils.squaredDistanceXZ(this.storm.method_73189(), v.method_73189());
                        byte pullType = this.getPullingType(true, distXZSq);
                        class_243 ddd = v.method_73189().method_1020(this.storm.method_73189()).method_1029().method_1021(pullType == 0 ? -0.35 : (pullType == 1 ? -0.2 : -0.1));
                        ((EntityVelocityDemander)boa).forceVelocity(ddd.field_1352, v.method_18798().field_1351, ddd.field_1350);
                    } else {
                        this.spinEntity((class_1297)v, true);
                    }
                }
                if (!((distXZ = Utils.distanceXZ(v.method_24515(), this.storm.method_24515())) > (double)((float)this.getPullRadius() / limit))) continue;
                vehicleIterator.remove();
            }
        }
        Iterator<class_1309> mobsIterator = this.mobs.iterator();
        while (mobsIterator.hasNext()) {
            class_1309 ent = mobsIterator.next();
            if (ent.method_5869() || Utils.inInvalidMode((class_1297)ent) || !this.prevList.contains(ent)) {
                ent.method_5855(ent.method_5748());
                mobsIterator.remove();
                continue;
            }
            if (this.canEntitySeeTornado((class_1297)ent) && ent.method_31478() < this.storm.method_31478() + this.storm.getStats().idealLiftHeight) {
                this.spinEntity((class_1297)ent, false);
            }
            if (!this.storm.isDemon() || ent.field_6012 % 100 != 0 || !this.storm.isCloseToPlayer()) continue;
            ent.method_5639(6.0f);
        }
        Iterator<DebrisEntity> debrisIterator = this.debris.iterator();
        while (debrisIterator.hasNext()) {
            DebrisEntity ent = debrisIterator.next();
            if (ent.method_5869() || Utils.inInvalidMode((class_1297)ent) || ent.method_24921() != this.storm) {
                debrisIterator.remove();
                continue;
            }
            if (ent.method_31478() < this.storm.method_31478() + this.storm.getStats().idealLiftHeight) {
                this.spinEntity((class_1297)ent, false);
            }
            ent.tickM();
            if (!ent.isDispeller() || ent.method_5669() <= 350) continue;
            TornadoDispellerBlock.dispel((class_3218)this.storm.method_73183(), ent.method_24515(), true);
            if (ent.method_5669() <= 400) continue;
            ent.forceCollide();
        }
    }

    public boolean canEntitySeeTornado(class_1297 ent) {
        class_2338.class_2339 simple = this.storm.method_24515().method_25503();
        for (int i = 0; i <= 7; ++i) {
            simple.method_33097(this.storm.method_31477());
            simple.method_33099(this.storm.method_31479());
            simple.method_33098(this.storm.method_31478() + 9 * i);
            if (ent.method_31747() || ent.method_5817()) {
                if (TornadoRotator.canSeePosDirectFarPlayer(ent, (class_2338)simple, this.getPullRadius() + 72)) {
                    return true;
                }
                if (i <= 0 || !this.storm.getStats().ripType.shouldUseWideDestruction() || i % 4 != 0) continue;
                for (class_2350 dir : class_2350.values()) {
                    if (dir.method_10166() == class_2350.class_2351.field_11052) continue;
                    simple.method_33097(this.storm.method_31477());
                    simple.method_33099(this.storm.method_31479());
                    simple = simple.method_10104(dir, 24);
                    if (!TornadoRotator.canSeePosDirectFarPlayer(ent, (class_2338)simple, this.getPullRadius() + 72)) continue;
                    return true;
                }
                continue;
            }
            if (!TornadoRotator.canSeePosDirectFar(ent, (class_2338)simple, this.getPullRadius() + 72)) continue;
            return true;
        }
        return false;
    }

    public static boolean canEntitySeeSource(class_1297 ent, TornadoParticleSource source) {
        class_2338.class_2339 simple = BP.of(source.getEmitter()).method_25503();
        for (int i = 0; i <= 7; ++i) {
            simple.method_33098((int)(source.getEmitter().field_1351 + (double)(9 * i)));
            if (!TornadoRotator.canSeePosDirectFar(ent, (class_2338)simple, source.getPullRadius() + 72)) continue;
            return true;
        }
        return false;
    }

    private static boolean canSeePosDirectFar(class_1297 ent, class_2338 pos, int dist) {
        class_243 vec3d = new class_243(ent.method_23317(), ent.method_23320(), ent.method_23321());
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1025(vec3d) > (double)(dist * dist)) {
            return false;
        }
        return ent.method_73183().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, ent)).method_17783() == class_239.class_240.field_1333;
    }

    private static boolean canSeePosDirectFarPlayer(class_1297 ent, class_2338 pos, int dist) {
        class_243 vec = ent.method_33571();
        class_243 vec3d = new class_243(vec.field_1352, vec.field_1351, vec.field_1350);
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1022(vec3d) > (double)(dist * dist)) {
            return false;
        }
        return ent.method_73183().method_32880(new class_5702(vec3d, vec3d2, p -> !(p.method_26204() instanceof class_2397) && !Utils.canPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public void spinEntity(class_1297 entity, boolean vehicle) {
        PlayerInputAccount account;
        double distXZSq = Utils.squaredDistanceXZ(this.storm.method_73189(), entity.method_73189());
        if (entity.method_5854() != null) {
            return;
        }
        boolean custom = this.storm.getTornadoType() == 5;
        boolean spout = this.storm.isSpout();
        boolean terrain = entity instanceof DebrisEntity;
        byte pullType = this.getPullingType(spout, distXZSq);
        boolean weak = this.storm.variant && !spout || custom && CustomTornadoConfig.getPullType(true) == 5;
        boolean airLimitReached = entity.method_5669() > (this.storm.getStats().idealLiftHeight > 80 ? 650 : 600) - (terrain ? 100 : 0);
        boolean airLimitReaching = entity.method_5669() > (this.storm.getStats().idealLiftHeight > 80 ? 550 : 500) - (terrain ? 100 : 0);
        boolean inWater = entity.method_5799();
        double scale = this.storm.getStats().scaling - (!this.storm.isSpout() ? 0.2f : 0.0f);
        double d1 = this.storm.method_23317() + (double)this.storm.xOffset - entity.method_23317();
        double d2 = this.storm.method_23321() + (double)this.storm.zOffset - entity.method_23321();
        float r = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
        float r2 = r % 360.0f;
        if (r2 >= 180.0f) {
            r2 -= 360.0f;
        } else if (r2 < -180.0f) {
            r2 += 360.0f;
        }
        float lift = this.getLift(spout, this.storm.getStats().liftSpeed, inWater, pullType, terrain);
        if (terrain && this.storm.getStats().ripType.shouldUseWideDestruction() && entity.field_6012 < 10 && Utils.squaredDistanceXZ(entity.method_24515(), this.storm.method_24515()) > (double)(this.storm.getStats().pathSize * this.storm.getStats().pathSize)) {
            lift *= 2.0f;
        }
        double radius = (float)(!this.storm.isSpout() ? -16 : -1) * (terrain ? (airLimitReaching ? 4.0f : 2.0f) : 1.0f);
        r2 = class_3532.method_15393((float)((float)((double)r2 + (75.0 + radius - 10.0 * scale))));
        float xSpin = (float)Math.cos(-r2 * 0.01745329f - (float)Math.PI);
        float zSpin = (float)Math.sin(-r2 * 0.01745329f - (float)Math.PI);
        float speed = this.storm.getStats().grabSpeed * (airLimitReaching ? (entity instanceof class_1657 ? 3.2f : 2.5f) : 1.0f);
        if (weak && terrain) {
            speed /= 2.0f;
        }
        float moveX = xSpin * (speed *= this.storm.getStats().grabMultiplierForMobs);
        float moveZ = zSpin * speed;
        float multiple = this.getGrabSpeed(inWater, spout, entity.method_24828() && entity.method_31747(), terrain, pullType);
        moveX *= multiple;
        moveZ *= multiple;
        float str = airLimitReached ? (entity.method_24828() ? 3 : 70 - this.storm.method_59922().method_43048(20)) : 100 - this.storm.getRandomStrengthVariationFallOff();
        lift *= str / 100.0f;
        class_243 motion = new class_243(0.0, 0.0, 0.0);
        if (entity.method_31747() && (account = Global.wind.getInputAccount(entity.method_5667(), this.storm.method_5667())) != null) {
            if (entity.method_55667().method_26204() instanceof PuddleBlock) {
                moveX *= pullType < 2 ? 2.0f : 3.0f;
                moveZ *= pullType < 2 ? 2.0f : 3.0f;
                lift *= pullType < 2 ? 1.5f : 3.0f;
                if (entity.field_6012 % 10 == 0) {
                    Utils.playSound(null, this.storm.method_73183(), entity.method_24515(), class_3417.field_14756, class_3419.field_15245, 1.0f, 1.5f + entity.method_59922().method_43057() * 0.5f);
                }
            } else {
                float sideways = account.getSidewaysInput();
                float forward = account.getForwardInput();
                class_243 lookingDir = entity.method_5720();
                class_243 rightDir = new class_243(lookingDir.field_1350, 0.0, -lookingDir.field_1352).method_1029();
                motion = lookingDir.method_1021((double)forward).method_1019(rightDir.method_1021((double)sideways));
                if (motion.method_1027() > 0.0) {
                    motion = motion.method_1029();
                }
                float mult = 0.0f;
                if (pullType == 2) {
                    mult = 0.03f;
                    if (!entity.method_24828()) {
                        mult = 0.02f;
                    } else if (entity.method_5624()) {
                        mult = 0.06f;
                    }
                }
                if (custom && CustomTornadoConfig.getPullType(true) == 5 && entity.method_24828() && entity.method_5715()) {
                    mult = 0.15f;
                    lift = 0.0f;
                }
                motion = motion.method_1021((double)mult);
            }
        }
        if (pullType != 0) {
            float maxAnnoyance = this.storm.getStats().maxGrabAnnoyance;
            float maxSpeed = pullType == 2 ? maxAnnoyance : maxAnnoyance + 0.05f;
            moveX = class_3532.method_15363((float)moveX, (float)(-maxSpeed), (float)maxSpeed);
            moveZ = class_3532.method_15363((float)moveZ, (float)(-maxSpeed), (float)maxSpeed);
        }
        double XFinal = entity.method_18798().field_1352 + motion.field_1352;
        double YFinal = entity.method_18798().field_1351;
        double ZFinal = entity.method_18798().field_1350 + motion.field_1350;
        class_243 newVelocity = new class_243(XFinal += (double)(-moveX), YFinal += (double)lift, ZFinal += (double)moveZ);
        double maxAllowedVelocity = 5.21;
        if (newVelocity.method_1033() > maxAllowedVelocity) {
            newVelocity = newVelocity.method_1029().method_1021(maxAllowedVelocity);
        }
        XFinal = newVelocity.field_1352;
        YFinal = newVelocity.field_1351;
        if (pullType != 0 && airLimitReaching && this.storm.getTornadoTypeForRotator() > 2) {
            YFinal -= (double)0.05f;
        }
        ZFinal = newVelocity.field_1350;
        if (entity instanceof class_1309 || terrain || vehicle) {
            if (airLimitReached) {
                if (entity.method_24828()) {
                    if (vehicle && entity.method_5669() != entity.method_5748()) {
                        entity.method_64397((class_3218)entity.method_73183(), entity.method_73183().method_48963().method_48830(), 2.0f + (float)entity.method_59922().method_43048(8));
                    }
                    entity.method_5855(entity.method_5748());
                } else if (this.storm.method_59922().method_43048(4) == 0 && this.storm.field_6012 % 50 == 0 && !terrain) {
                    entity.method_5855(entity.method_5748());
                }
            } else if (!entity.method_5799()) {
                entity.method_5855(entity.method_5669() + 1);
            }
            if (vehicle) {
                if (entity instanceof class_10255) {
                    class_10255 boa = (class_10255)entity;
                    if (entity.method_5799()) {
                        entity.method_5855(entity.method_5748());
                    }
                    class_243 ddd = boa.method_73189().method_1020(this.storm.method_73189().method_1031(0.0, 32.0, 0.0)).method_1029().method_1021(-0.5);
                    double y = pullType != 0 && boa.method_5799() ? entity.method_18798().method_10214() : (airLimitReaching ? -0.5 : ddd.field_1351);
                    class_243 vec = new class_243(XFinal, 0.0, ZFinal);
                    double magnitude = Math.sqrt(vec.field_1352 * vec.field_1352 + vec.field_1351 * vec.field_1351 + vec.field_1350 * vec.field_1350);
                    double maxMag = pullType != 0 && boa.method_5799() ? 0.5 : 1.0;
                    if (magnitude > (maxMag *= (double)this.storm.getStats().grabMultiplierForMobs)) {
                        vec = vec.method_1029().method_1021(airLimitReaching ? maxMag + 0.5 : maxMag);
                    }
                    ((EntityVelocityDemander)boa).forceVelocity(vec.field_1352, y, vec.field_1350);
                } else {
                    XFinal *= (double)this.storm.getStats().grabMultiplierForMobs;
                    ZFinal *= (double)this.storm.getStats().grabMultiplierForMobs;
                    if (this.storm.getTornadoTypeForRotator() > 1) {
                        if (pullType != 0) {
                            YFinal = entity.method_18798().method_10214();
                        } else if (entity.method_5669() > 450) {
                            YFinal = -0.5;
                        }
                        entity.method_18800(XFinal, YFinal, ZFinal);
                    } else {
                        entity.method_18800(XFinal, entity.method_18798().method_10214(), ZFinal);
                    }
                }
            } else {
                entity.method_18800(XFinal, YFinal, ZFinal);
                boolean hg = entity instanceof class_11187;
                if (hg || entity instanceof class_1571) {
                    if (hg) {
                        ((EntityVelocityDemander)entity).forceVelocity(XFinal, YFinal, ZFinal);
                    }
                    if (airLimitReaching) {
                        Utils.setVelocityY(entity, -0.4);
                    } else if (entity.method_23318() > this.storm.method_23318() + (double)this.storm.getStats().idealLiftHeight - 6.0) {
                        Utils.setVelocityY(entity, -0.2);
                    }
                }
            }
            if (ModConfig.forceDebrisVelocityUpdates() && terrain) {
                WCNetworkServer.sendDebrisVelocityPacket((DebrisEntity)entity, XFinal, YFinal, ZFinal, this.playersForDebrisUpdates);
            }
            if (entity.method_31747() || entity.method_5817()) {
                entity.field_6037 = true;
            }
            if (custom && entity.method_5709() && CustomTornadoConfig.getPullType(true) == 5) {
                entity.field_6017 = 0.0;
            }
        }
    }

    private byte getPullingType(boolean spout, double distSq) {
        int a = this.tornadoPullVals.getA();
        int b = this.tornadoPullVals.getB();
        if (spout) {
            a = this.spoutPullVals.getA();
            b = this.spoutPullVals.getB();
            if (distSq <= (double)(a * a)) {
                return 0;
            }
            if (distSq <= (double)(b * b)) {
                return 1;
            }
            return 2;
        }
        if (distSq <= (double)(a * a)) {
            return 0;
        }
        if (distSq <= (double)(b * b)) {
            return 1;
        }
        return 2;
    }

    private float getLift(boolean spout, float input, boolean inWater, byte val, boolean debris) {
        float debrisMult = this.storm.getTornadoTypeForRotator() == 1 ? 1.2f : 1.0f;
        switch (val) {
            case 0: {
                return input * 2.0f * (debris ? debrisMult : 1.0f);
            }
            case 1: {
                return (inWater ? input * 1.0f : input * 1.4f) * (debris ? debrisMult : 1.0f);
            }
        }
        return inWater ? input * 0.6f : input * 0.7f * (debris ? debrisMult : 1.0f);
    }

    private float getGrabSpeed(boolean inWater, boolean spout, boolean playerOnGround, boolean debris, byte val) {
        float base = debris ? 0.4f : 0.0f;
        switch (this.storm.getTornadoTypeForRotator()) {
            case 2: {
                switch (val) {
                    case 0: {
                        return base + (playerOnGround ? 3.5f : 1.0f);
                    }
                    case 1: {
                        return inWater ? 0.65f : (playerOnGround ? 5.0f : 1.2f);
                    }
                }
                return inWater ? 0.4f : (playerOnGround ? 2.0f : 1.0f);
            }
            case 3: {
                switch (val) {
                    case 0: {
                        return base + (playerOnGround ? 3.5f : 1.0f);
                    }
                    case 1: {
                        return inWater ? 0.7f : (playerOnGround ? 5.9f : 1.3f);
                    }
                }
                return inWater ? 0.45f : (playerOnGround ? 2.2f : 1.0f);
            }
            case 4: {
                switch (val) {
                    case 0: {
                        return base + (playerOnGround ? 3.5f : 1.0f);
                    }
                    case 1: {
                        return inWater ? 0.75f : (playerOnGround ? 6.5f : 1.5f);
                    }
                }
                return inWater ? 0.5f : (playerOnGround ? 2.4f : 1.0f);
            }
        }
        switch (val) {
            case 0: {
                return base + (playerOnGround ? 3.5f : 1.0f);
            }
            case 1: {
                return inWater ? 0.6f : (playerOnGround ? 4.3f : 0.9f);
            }
        }
        return inWater ? 0.4f : (playerOnGround ? 1.8f : 0.8f);
    }

    private void pullEntitiesAboveTemporarily() {
        boolean customSmall;
        if (this.storm.field_6012 % 80 == 0) {
            List list;
            if (ModConfig.forceDebrisVelocityUpdates()) {
                this.playersForDebrisUpdates = Utils.getPlayersIn(this.storm.method_73183(), new class_238(BP.of(this.storm.method_33571())).method_1014(128.0));
            } else if (this.playersForDebrisUpdates != null) {
                this.playersForDebrisUpdates = null;
            }
            class_238 b = this.getGrabBox(true);
            this.tempList = list = this.storm.method_73183().method_8390(class_1309.class, b, p -> !this.mobs.contains(p) && !p.method_5869() && !Utils.inInvalidMode((class_1297)p) && !Utils.isWindImmuneMob((class_1297)p));
        }
        boolean bl = customSmall = this.storm.getTornadoType() == 5 && CustomTornadoConfig.getScaling() <= 0.55f;
        if (customSmall) {
            return;
        }
        int num = 0;
        for (class_1309 entity : this.tempList) {
            if (entity.method_5869() || Utils.inInvalidMode((class_1297)entity) || !entity.method_31747() && num > ModConfig.getMaxMobsPerTornado() / 2) continue;
            if (this.canEntitySeeTornado((class_1297)entity) && entity.method_31478() < this.storm.method_31478() + 64) {
                this.spinEntity((class_1297)entity, false);
            }
            num = (byte)(num + 1);
        }
    }

    public static float getTornadoFarSuction(byte type, boolean entity) {
        if (entity) {
            switch (type) {
                case 0: {
                    return 0.005f;
                }
                case 2: {
                    return 0.05f;
                }
                case 3: {
                    return 0.08f;
                }
                case 4: {
                    return 0.1f;
                }
            }
            return 0.02f;
        }
        switch (type) {
            case 0: {
                return 0.02f;
            }
            case 2: {
                return 0.08f;
            }
            case 3: {
                return 0.1f;
            }
            case 4: {
                return 0.15f;
            }
        }
        return 0.06f;
    }
}

