/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import net.minecraft.class_3218;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoRipper;

public class TornadoStats {
    public short speed;
    public float grabSpeed;
    public float liftSpeed;
    public float particleSpawnRadius;
    public short pathSize;
    public float scaling;
    public int time;
    public float maxGrabAnnoyance;
    public short particleCount;
    public float extraParticleChance;
    public boolean hasDemons;
    public float grabMultiplierForMobs;
    public short grabDistance;
    public short idealLiftHeight;
    public TornadoRipper.RipType ripType;
    public short extraParticleDistance;
    public short particleGetRange;
    public boolean createClouds;
    public int soundDist;
    public float dispellerResistance;
    public float maxScaleBonus;
    public float bigScaleThreshold;
    private final Type type;
    private boolean variant = false;

    private TornadoStats(Type t) {
        this.type = t;
    }

    public static TornadoStats create(Type type) {
        TornadoStats config = new TornadoStats(type);
        switch (type.ordinal()) {
            case 0: {
                config.createSpoutStats();
                break;
            }
            case 1: {
                config.createStage2Stats();
                break;
            }
            case 2: {
                config.createStage3Stats();
                break;
            }
            case 3: {
                config.createStage4Stats();
                break;
            }
            case 4: {
                config.createStage5Stats();
                break;
            }
            case 5: {
                config.createStageXStats();
                break;
            }
        }
        return config;
    }

    public static TornadoStats createRope() {
        TornadoStats config = new TornadoStats(Type.STAGE2);
        config.createStage2RopeStats();
        config.variant = true;
        return config;
    }

    public static TornadoStats createCyclone() {
        TornadoStats config = new TornadoStats(Type.SPOUT);
        config.createCycloneStats();
        config.variant = true;
        return config;
    }

    public static TornadoStats get(Type type, boolean variant) {
        switch (type.ordinal()) {
            case 0: {
                return variant ? WeatherClassic.CYCLONE_CONFIG : WeatherClassic.SPOUT_CONFIG;
            }
            case 1: {
                return variant ? WeatherClassic.STAGE2ROPE_CONFIG : WeatherClassic.STAGE2_CONFIG;
            }
            case 2: {
                return WeatherClassic.STAGE3_CONFIG;
            }
            case 3: {
                return WeatherClassic.STAGE4_CONFIG;
            }
            case 4: {
                return WeatherClassic.STAGE5_CONFIG;
            }
            case 5: {
                return WeatherClassic.STAGEX_CONFIG;
            }
        }
        return null;
    }

    private void createCycloneStats() {
        this.speed = (short)5;
        this.grabSpeed = 0.07f;
        this.liftSpeed = 0.05f;
        this.particleSpawnRadius = 10.0f;
        this.pathSize = (short)24;
        this.scaling = 0.9f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 2400 : 1200;
        this.maxGrabAnnoyance = 0.4f;
        this.particleCount = (short)6;
        this.extraParticleChance = 0.5f;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.0f;
        this.grabDistance = (short)82;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 40.0);
        this.ripType = TornadoRipper.RipType.NONE;
        this.extraParticleDistance = (short)8;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = false;
        this.soundDist = 46;
        this.dispellerResistance = 0.0f;
        this.maxScaleBonus = 0.1f;
        this.bigScaleThreshold = 0.1f;
    }

    private void createSpoutStats() {
        this.speed = (short)5;
        this.grabSpeed = 0.03f;
        this.liftSpeed = 0.05f;
        this.particleSpawnRadius = 1.5f;
        this.pathSize = (short)8;
        this.scaling = 0.8f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 2400 : 800;
        this.maxGrabAnnoyance = 0.12f;
        this.particleCount = (short)5;
        this.extraParticleChance = 0.1f;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.0f;
        this.grabDistance = (short)64;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 50.0);
        this.ripType = TornadoRipper.RipType.NONE;
        this.extraParticleDistance = (short)4;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = false;
        this.soundDist = 46;
        this.dispellerResistance = 0.0f;
        this.maxScaleBonus = 1.0f;
        this.bigScaleThreshold = 1.0f;
    }

    private void createStage2RopeStats() {
        this.speed = (short)3;
        this.grabSpeed = 0.06f;
        this.liftSpeed = 0.05f;
        this.particleSpawnRadius = 0.5f;
        this.pathSize = 1;
        this.scaling = 0.8f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? ModConfig.getBaseTornadoDuration() * 2 : ModConfig.getBaseTornadoDuration();
        this.maxGrabAnnoyance = 0.2f;
        this.particleCount = (short)3;
        this.extraParticleChance = 0.1f;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.05f;
        this.grabDistance = (short)68;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 37.0);
        this.ripType = TornadoRipper.RipType.STAGE2;
        this.extraParticleDistance = (short)8;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 52;
        this.dispellerResistance = 0.0f;
        this.maxScaleBonus = 0.1f;
        this.bigScaleThreshold = 0.1f;
    }

    private void createStage2Stats() {
        this.speed = (short)6;
        this.grabSpeed = 0.08f;
        this.liftSpeed = 0.05f;
        this.particleSpawnRadius = 2.0f;
        this.pathSize = (short)2;
        this.scaling = 1.2f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? ModConfig.getBaseTornadoDuration() * 2 : ModConfig.getBaseTornadoDuration();
        this.maxGrabAnnoyance = 0.15f;
        this.particleCount = (short)9;
        this.extraParticleChance = 0.12f;
        this.hasDemons = true;
        this.grabMultiplierForMobs = 1.1f;
        this.grabDistance = (short)72;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 40.0);
        this.ripType = TornadoRipper.RipType.STAGE2;
        this.extraParticleDistance = (short)3;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 64;
        this.dispellerResistance = 0.0f;
        this.maxScaleBonus = 0.5f;
        this.bigScaleThreshold = 0.4f;
    }

    private void createStage3Stats() {
        this.speed = (short)7;
        this.grabSpeed = 0.0935f;
        this.liftSpeed = 0.051f;
        this.particleSpawnRadius = 8.0f;
        this.pathSize = (short)4;
        this.scaling = 1.3f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? ModConfig.getBaseTornadoDuration() * 2 : ModConfig.getBaseTornadoDuration();
        this.maxGrabAnnoyance = 0.25f;
        this.particleCount = (short)9;
        this.extraParticleChance = 0.15f;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.15f;
        this.grabDistance = (short)96;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 43.0);
        this.ripType = TornadoRipper.RipType.STAGE3;
        this.extraParticleDistance = (short)2;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 72;
        this.dispellerResistance = 0.2f;
        this.maxScaleBonus = 2.0f;
        this.bigScaleThreshold = 1.0f;
    }

    private void createStage4Stats() {
        this.speed = (short)5;
        this.grabSpeed = 0.1f;
        this.liftSpeed = 0.052f;
        this.particleSpawnRadius = 30.0f;
        this.pathSize = (short)16;
        this.scaling = 1.6f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? ModConfig.getBaseTornadoDuration() * 2 : ModConfig.getBaseTornadoDuration();
        this.maxGrabAnnoyance = 0.5f;
        this.particleCount = (short)9;
        this.extraParticleChance = 0.15f;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.25f;
        this.grabDistance = (short)120;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 46.0);
        this.ripType = TornadoRipper.RipType.STAGE4;
        this.extraParticleDistance = (short)2;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 86;
        this.dispellerResistance = 0.4f;
        this.maxScaleBonus = 3.0f;
        this.bigScaleThreshold = 2.0f;
    }

    private void createStage5Stats() {
        this.speed = (short)4;
        this.grabSpeed = 0.12f;
        this.liftSpeed = 0.053f;
        this.particleSpawnRadius = 50.0f;
        this.pathSize = (short)32;
        this.scaling = 1.8f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? ModConfig.getBaseTornadoDuration() * 2 : ModConfig.getBaseTornadoDuration();
        this.maxGrabAnnoyance = 0.75f;
        this.particleCount = (short)10;
        this.extraParticleChance = 0.3f;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.3f;
        this.grabDistance = (short)164;
        this.idealLiftHeight = (short)(ModConfig.getGenerateOverrides() ? (double)ModConfig.getTornadoCloudScale(false) / ((double)ModConfig.getGlobalHeightScaleOverride() < 0.65 ? 3.0 : 1.5) : 50.0);
        this.ripType = TornadoRipper.RipType.STAGE5;
        this.extraParticleDistance = (short)2;
        this.particleGetRange = (short)(this.particleSpawnRadius * 2.0f);
        this.createClouds = true;
        this.soundDist = 132;
        this.dispellerResistance = 0.6f;
        this.maxScaleBonus = 3.7f;
        this.bigScaleThreshold = 3.4f;
    }

    private void createStageXStats() {
        this.speed = CustomTornadoConfig.getSpeed();
        this.liftSpeed = 0.05f;
        this.hasDemons = false;
        switch (CustomTornadoConfig.getPullType(true)) {
            case 0: {
                this.maxGrabAnnoyance = WeatherClassic.SPOUT_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.SPOUT_CONFIG.grabMultiplierForMobs + 0.05f;
                this.grabDistance = (short)(WeatherClassic.SPOUT_CONFIG.grabDistance + 6);
                this.maxScaleBonus = WeatherClassic.SPOUT_CONFIG.maxScaleBonus;
                break;
            }
            case 2: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE3_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE3_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE3_CONFIG.grabDistance;
                this.maxScaleBonus = WeatherClassic.STAGE3_CONFIG.maxScaleBonus;
                break;
            }
            case 3: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE4_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE4_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE4_CONFIG.grabDistance;
                this.maxScaleBonus = WeatherClassic.STAGE4_CONFIG.maxScaleBonus;
                break;
            }
            case 4: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE5_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE5_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE5_CONFIG.grabDistance;
                this.maxScaleBonus = WeatherClassic.STAGE5_CONFIG.maxScaleBonus;
                break;
            }
            case 5: {
                this.maxGrabAnnoyance = WeatherClassic.SPOUT_CONFIG.maxGrabAnnoyance - 0.02f;
                this.grabMultiplierForMobs = WeatherClassic.SPOUT_CONFIG.grabMultiplierForMobs;
                this.grabDistance = (short)(WeatherClassic.SPOUT_CONFIG.grabDistance - 4);
                this.maxScaleBonus = WeatherClassic.SPOUT_CONFIG.maxScaleBonus;
                break;
            }
            default: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE2_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE2_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE2_CONFIG.grabDistance;
                this.maxScaleBonus = WeatherClassic.STAGE2_CONFIG.maxScaleBonus;
            }
        }
        this.scaling = CustomTornadoConfig.getScaling();
        this.idealLiftHeight = (double)this.scaling != 1.2 ? (short)((double)ModConfig.getTornadoCloudScale(true) / ((double)this.scaling < 0.65 ? 3.0 : 1.5)) : WeatherClassic.STAGE2_CONFIG.idealLiftHeight;
        this.grabSpeed = CustomTornadoConfig.getGrabSpeed();
        this.ripType = TornadoRipper.RipType.fromByte(CustomTornadoConfig.getRipType(false));
        this.particleSpawnRadius = CustomTornadoConfig.getTornadoParticleRadiusFromLvl();
        this.particleGetRange = CustomTornadoConfig.getTornadoParticleFindRangeFromLvl();
        this.time = CustomTornadoConfig.getTime() + (ModConfig.getTornadoesExtraLongDuration() ? 1200 : 0);
        switch (CustomTornadoConfig.getRipType(true)) {
            case 0: {
                this.pathSize = 0;
                break;
            }
            case 2: {
                this.pathSize = WeatherClassic.STAGE3_CONFIG.pathSize;
                break;
            }
            case 3: {
                this.pathSize = WeatherClassic.STAGE4_CONFIG.pathSize;
                break;
            }
            case 4: {
                this.pathSize = WeatherClassic.STAGE5_CONFIG.pathSize;
                break;
            }
            case 5: {
                this.pathSize = (short)(WeatherClassic.STAGE5_CONFIG.pathSize + 8);
                break;
            }
            case 6: {
                this.pathSize = 0;
                break;
            }
            case 7: {
                this.pathSize = (short)(WeatherClassic.STAGE2_CONFIG.pathSize - 1);
                break;
            }
            default: {
                this.pathSize = WeatherClassic.STAGE2_CONFIG.pathSize;
            }
        }
        this.extraParticleChance = (float)CustomTornadoConfig.getExtraParticleInterval() * 0.1f;
        this.extraParticleDistance = CustomTornadoConfig.getExtraParticleDistance();
        this.createClouds = CustomTornadoConfig.getCreateClouds();
        this.particleCount = CustomTornadoConfig.getParticleCount();
        this.soundDist = CustomTornadoConfig.getSoundDist();
        this.dispellerResistance = CustomTornadoConfig.getDispellerResistance();
        Global.getAllActiveCustomTornadoes().forEach(p -> p.getRotator().updatePullVals((TornadoEntity)p));
    }

    public void reinit(boolean switched) {
        switch (this.type.ordinal()) {
            case 0: {
                if (this.variant) {
                    this.createCycloneStats();
                    break;
                }
                this.createSpoutStats();
                break;
            }
            case 1: {
                if (this.variant) {
                    this.createStage2RopeStats();
                    break;
                }
                this.createStage2Stats();
                break;
            }
            case 2: {
                this.createStage3Stats();
                break;
            }
            case 3: {
                this.createStage4Stats();
                break;
            }
            case 4: {
                this.createStage5Stats();
                break;
            }
            case 5: {
                if (Global.weather != null && Global.weather.getWorld() != null) {
                    CustomTornadoConfig.updateCustomTornadoInfo((class_3218)Global.weather.getWorld(), !switched, CustomTornadoConfig.USING_ALT);
                }
                this.createStageXStats();
            }
        }
    }

    public static TornadoStats getFrom(byte b, boolean rope) {
        switch (b) {
            case 0: {
                return rope ? WeatherClassic.CYCLONE_CONFIG : WeatherClassic.SPOUT_CONFIG;
            }
            case 2: {
                return WeatherClassic.STAGE3_CONFIG;
            }
            case 3: {
                return WeatherClassic.STAGE4_CONFIG;
            }
            case 4: {
                return WeatherClassic.STAGE5_CONFIG;
            }
            case 5: {
                return WeatherClassic.STAGEX_CONFIG;
            }
        }
        return rope ? WeatherClassic.STAGE2ROPE_CONFIG : WeatherClassic.STAGE2_CONFIG;
    }

    public static enum Type {
        SPOUT,
        STAGE2,
        STAGE3,
        STAGE4,
        STAGE5,
        STAGEX;


        public byte getByte() {
            switch (this.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return 1;
        }

        public static Type fromByte(byte b) {
            switch (b) {
                case 0: {
                    return SPOUT;
                }
                case 2: {
                    return STAGE3;
                }
                case 3: {
                    return STAGE4;
                }
                case 4: {
                    return STAGE5;
                }
                case 5: {
                    return STAGEX;
                }
            }
            return STAGE2;
        }

        public static byte fromSevereStormStage(byte stage) {
            switch (stage) {
                case 0: {
                    return STAGE2.getByte();
                }
                case 1: {
                    return STAGE3.getByte();
                }
                case 2: {
                    return STAGE4.getByte();
                }
                case 3: {
                    return STAGE5.getByte();
                }
            }
            return STAGE2.getByte();
        }
    }
}

