/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.player;

import java.util.UUID;

public class PlayerInputAccount {
    private final UUID id;
    private final UUID tornadoId;
    private float sideways = 0.0f;
    private float forward = 0.0f;
    private boolean updated = false;
    private int updateInterval = 0;
    private boolean inactive = false;

    public PlayerInputAccount(UUID id, UUID tornadoId) {
        this.id = id;
        this.tornadoId = tornadoId;
    }

    public PlayerInputAccount updateInput(float x, float y) {
        this.sideways = x;
        this.forward = y;
        this.updated = true;
        return this;
    }

    public void tick() {
        if (this.inactive) {
            return;
        }
        if (!this.updated) {
            if (this.updateInterval++ > 5) {
                this.inactive = true;
            }
        } else {
            this.updateInterval = 0;
            this.updated = false;
        }
    }

    public UUID getPlayer() {
        return this.id;
    }

    public UUID getStorm() {
        return this.tornadoId;
    }

    public float getSidewaysInput() {
        return this.sideways;
    }

    public float getForwardInput() {
        return this.forward;
    }

    public boolean discard() {
        return this.inactive;
    }
}

