/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.structures.puzzle_chamber.pieces;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3491;
import net.minecraft.class_3719;
import net.minecraft.class_3793;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.weather_classic.WeatherClassic;
import net.weather_classic.block.TurbineBlock;
import net.weather_classic.block.VentilatedCellBlock;
import net.weather_classic.block.WindChannelBlock;
import net.weather_classic.block.entity.TurbineBlockEntity;
import net.weather_classic.block.entity.VentilatedCellBlockEntity;
import net.weather_classic.block.entity.WindChannelBlockEntity;
import net.weather_classic.config.ModConfig;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCItems;
import net.weather_classic.structures.WCStructures;
import net.weather_classic.structures.api.StructureBlockEntityData;
import net.weather_classic.structures.base.CustomSimpleStructurePiece;
import net.weather_classic.structures.processor.TuffWeatheringStructureProcessor;
import org.jetbrains.annotations.Nullable;

public class PuzzleChamberStructurePiece
extends CustomSimpleStructurePiece {
    private List<class_3491> processors = new ArrayList<class_3491>();
    private boolean ignoreAir = false;
    private final DifficultyLevel lvl;

    public PuzzleChamberStructurePiece(class_2338 pos, int xSize, int ySize, int zSize, class_2470 rotation, String nbtName, DifficultyLevel lvl) {
        super(WCStructures.PUZZLE_CHAMBER_PIECE_TYPE, pos, xSize, ySize, zSize, rotation, nbtName);
        this.lvl = lvl;
        this.processors.add(new TuffWeatheringStructureProcessor(0.05f));
    }

    public PuzzleChamberStructurePiece(class_2487 nbt) {
        super(WCStructures.PUZZLE_CHAMBER_PIECE_TYPE, nbt);
        this.lvl = nbt.method_10545("hard") && nbt.method_10577("hard").isPresent() && (Boolean)nbt.method_10577("hard").get() != false ? DifficultyLevel.HARD : DifficultyLevel.EASY;
        this.processors.add(new TuffWeatheringStructureProcessor(0.05f));
        if (nbt.method_10545("ignoreAir") && nbt.method_10577("ignoreAir").isPresent() && ((Boolean)nbt.method_10577("ignoreAir").get()).booleanValue()) {
            this.processors.add((class_3491)new class_3793(List.of(class_2246.field_10124)));
        }
    }

    public PuzzleChamberStructurePiece ignoreAir() {
        this.processors.add((class_3491)new class_3793(List.of(class_2246.field_10124)));
        this.ignoreAir = true;
        return this;
    }

    @Override
    @Nullable
    public class_2248 getDownwardFillBlock() {
        return null;
    }

    @Override
    public List<class_3491> getProcessors() {
        return this.processors;
    }

    @Override
    protected void writeCustomNbt(class_2487 nbt) {
        nbt.method_10556("hard", this.lvl == DifficultyLevel.HARD);
        nbt.method_10556("ignoreAir", this.ignoreAir);
    }

    @Override
    protected void readCustomNbt(class_2487 nbt) {
    }

    @Override
    protected void onGeneration(class_5281 world, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 placement) {
        this.setupBlockEntityData(StructureBlockEntityData.with(p -> p instanceof WindChannelBlockEntity, (blockEnt, worldAccess) -> {
            class_2350 d = Utils.randomHorizontal(random);
            if (d == blockEnt.method_11010().method_11654((class_2769)WindChannelBlock.field_11177)) {
                d = random.method_43057() < 0.2f ? d : d.method_10153();
            }
            world.method_8652(blockEnt.method_11016(), (class_2680)blockEnt.method_11010().method_11657((class_2769)WindChannelBlock.field_11177, (Comparable)d), 16);
        }), StructureBlockEntityData.with(p -> p instanceof TurbineBlockEntity, (blockEnt, worldAccess) -> {
            boolean a;
            boolean bl = a = (double)random.method_43057() < 0.05;
            if (a) {
                world.method_8652(blockEnt.method_11016(), (class_2680)((class_2680)blockEnt.method_11010().method_11657((class_2769)TurbineBlock.RANGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)TurbineBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 16);
            } else {
                int r = random.method_43057() < 0.6f ? 0 : random.method_43048(3);
                world.method_8652(blockEnt.method_11016(), (class_2680)blockEnt.method_11010().method_11657((class_2769)TurbineBlock.RANGE, (Comparable)Integer.valueOf(r)), 16);
            }
        }), StructureBlockEntityData.with(p -> p instanceof VentilatedCellBlockEntity, (blockEnt, worldAccess) -> {
            if (((Boolean)blockEnt.method_11010().method_11654((class_2769)VentilatedCellBlock.LENIENT)).booleanValue()) {
                world.method_8652(blockEnt.method_11016(), (class_2680)blockEnt.method_11010().method_11657((class_2769)VentilatedCellBlock.LENIENT, (Comparable)Boolean.valueOf(false)), 16);
            }
            if (((VentilatedCellBlockEntity)((Object)blockEnt)).getStack() != null && !((VentilatedCellBlockEntity)((Object)blockEnt)).getStack().method_7960()) {
                return;
            }
            class_1799 stack = this.getStackForCell(random);
            double d = random.method_43057();
            double d2 = ModConfig.getDisablePuzzleChambers() ? 1.0 : 0.47;
            if (d <= d2) {
                int add = this.lvl == DifficultyLevel.HARD ? 1 : 0;
                stack = new class_1799((class_1935)WCItems.WEATHER_DEVICE, 1 + add);
            }
            ((VentilatedCellBlockEntity)((Object)blockEnt)).setStack(stack);
        }), StructureBlockEntityData.with(p -> p instanceof class_2595, (blockEnt, worldAccess) -> ((class_2595)blockEnt).method_54867(WeatherClassic.PUZZLE_CHAMBER_LOOT, random.method_43055())), StructureBlockEntityData.with(p -> p instanceof class_3719, (blockEnt, worldAccess) -> ((class_3719)blockEnt).method_54867(WeatherClassic.PUZZLE_CHAMBER_LOOT, random.method_43055())));
    }

    private class_1799 getStackForCell(class_5819 random) {
        int i = random.method_43048(8);
        switch (i) {
            case 1: {
                return new class_1799((class_1935)class_1802.field_8802, 1);
            }
            case 2: {
                return new class_1799((class_1935)class_1802.field_8477, 1 + random.method_43048(5));
            }
            case 3: {
                return new class_1799((class_1935)class_1802.field_8687, 1 + random.method_43048(20));
            }
            case 4: {
                return new class_1799((class_1935)class_1802.field_8367, 1 + random.method_43048(7));
            }
            case 5: {
                return new class_1799((class_1935)class_1802.field_8494, 1 + random.method_43048(4));
            }
        }
        return new class_1799((class_1935)WCItems.TORNADO_GUN, 1);
    }

    public static enum DifficultyLevel {
        EASY,
        HARD;

    }
}

