/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9749;
import net.weather_classic.block.TurbineBlock;
import net.weather_classic.block.WindChannelBlock;
import net.weather_classic.block.entity.TurbineBlockEntity;
import net.weather_classic.entity.breezling.BreezlingEntity;
import net.weather_classic.global.Global;
import net.weather_classic.global.Wind;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.registry.WCParticles;

public class WindChannelBlockEntity
extends class_2586 {
    private int windAmount = 0;
    private int age = 0;
    private boolean windAligned = false;
    private boolean receivingRedstonePower = false;
    private Pair<class_2338, class_2338> turbinePowerSource = null;
    private int linkNum = -1;
    private static final class_5362 EXPLOSION_BEHAVIOR = new class_9749(true, true, Optional.of(Float.valueOf(1.22f)), class_7923.field_41175.method_46733(class_3481.field_49051).map(Function.identity()));

    public WindChannelBlockEntity(class_2338 pos, class_2680 state) {
        super(WCBlocks.WIND_CHANNEL_BLOCK_ENTITY, pos, state);
    }

    public boolean isReceivingRedstonePower() {
        return this.receivingRedstonePower;
    }

    public void setReceivingRedstonePower(boolean bl) {
        this.receivingRedstonePower = bl;
    }

    public void incrementWindStorage() {
        int next = this.getWindStored() + 1;
        if (next < 0) {
            return;
        }
        if (next > 4) {
            if (Global.wind.isGale() && (double)this.field_11863.method_8409().method_43057() < 0.25) {
                this.field_11863.method_22352(this.field_11867, false);
                this.field_11863.method_8454(null, null, EXPLOSION_BEHAVIOR, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, 2.0f, false, class_1937.class_7867.field_51779, (class_2394)class_2398.field_49139, (class_2394)class_2398.field_49140, Utils.EXPLOSION_BLOCK_PARTICLES_COPY, (class_6880)class_3417.field_49044);
                Utils.playSound(null, this.field_11863, this.field_11867, class_3417.field_15081, class_3419.field_15245, 2.0f, 1.0f);
                Utils.playSound(null, this.field_11863, this.field_11867, class_3417.field_47193, class_3419.field_15245, 1.0f, 0.9f + this.field_11863.method_8409().method_43057() / 3.0f);
                if (this.field_11863.method_8407() != class_1267.field_5801) {
                    BreezlingEntity breezling = new BreezlingEntity(WCEntities.BREEZLING, this.field_11863);
                    breezling.method_5725(this.field_11867, 0.0f, 0.0f);
                    this.field_11863.method_8649((class_1297)breezling);
                }
            }
            this.windAmount = 0;
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)WindChannelBlock.WIND_STORED, (Comparable)Integer.valueOf(next)));
        this.windAmount = 0;
    }

    public void decrementWindStorage() {
        int prev = this.getWindStored() - 1;
        if (prev > 4 || prev < 0) {
            return;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)WindChannelBlock.WIND_STORED, (Comparable)Integer.valueOf(prev)));
    }

    public int getWindStored() {
        return (Integer)this.method_11010().method_11654((class_2769)WindChannelBlock.WIND_STORED);
    }

    public void updateWindAlignmentState() {
        class_2680 belowState = this.field_11863.method_8320(this.field_11867.method_10074());
        this.field_11863.method_41410(belowState, this.field_11867.method_10074(), this.method_11010().method_26204(), null, false);
        if (this.turbinePowerSource != null) {
            TurbineBlockEntity t;
            class_2586 ent = this.field_11863.method_8321((class_2338)this.turbinePowerSource.getFirst());
            if (ent instanceof TurbineBlockEntity && (t = (TurbineBlockEntity)ent).method_11010().method_11654((class_2769)TurbineBlock.field_10927) == ((class_2350)this.method_11010().method_11654((class_2769)WindChannelBlock.field_11177)).method_10153() && ((Boolean)t.method_11010().method_11654((class_2769)TurbineBlock.POWERED)).booleanValue() && ((Boolean)t.method_11010().method_11654((class_2769)TurbineBlock.ACTIVE)).booleanValue() && !t.isWindDisturbed()) {
                this.windAligned = true;
                return;
            }
            this.turbinePowerSource = null;
            this.linkNum = -1;
        }
        if (this.isWeathered()) {
            if (!this.isIntake()) {
                this.windAligned = false;
                return;
            }
            if (!Global.wind.gusty()) {
                this.windAligned = false;
                return;
            }
        }
        if (!Global.wind.isWindyDay()) {
            this.windAligned = false;
            return;
        }
        class_2350 dir = (class_2350)this.method_11010().method_11654((class_2769)WindChannelBlock.field_11177);
        class_243 windVec = Global.getGlobalWindVectorForPosition(Utils.convertBlockPosToVec(this.field_11867));
        class_2350 windDir = class_2350.method_10142((double)windVec.field_1352, (double)0.0, (double)windVec.field_1350);
        boolean bl = this.windAligned = dir == windDir.method_10153();
        if (this.windAligned) {
            this.windAligned = Wind.isOutsideInWindArea(Utils.convertBlockPosToVec(this.field_11867.method_10093(dir)), this.field_11863);
        }
        this.linkNum = -1;
    }

    public boolean isWindAligned() {
        return this.windAligned;
    }

    public Pair<class_2338, class_2338> getTurbinePowerSource() {
        return this.turbinePowerSource;
    }

    public void setWindAligned(boolean b, Pair<class_2338, class_2338> turbinePos, int linkNum) {
        this.windAligned = b;
        this.linkNum = linkNum + 1;
        if (this.turbinePowerSource == null || !this.turbinePowerSource.equals(turbinePos)) {
            this.turbinePowerSource = turbinePos;
        }
    }

    public int linkNum() {
        return this.linkNum;
    }

    public boolean isWeathered() {
        return this.method_11010().method_26204() == WCBlocks.WEATHERED_WIND_CHANNEL || this.method_11010().method_26204() == WCBlocks.INTAKE_WEATHERED_WIND_CHANNEL;
    }

    public boolean isIntake() {
        return this.method_11010().method_26204() == WCBlocks.INTAKE_WEATHERED_WIND_CHANNEL;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, WindChannelBlockEntity block) {
        ++block.age;
        if (block.age % 80 == 0) {
            block.updateWindAlignmentState();
            return;
        }
        if (block.windAligned) {
            class_2350 dir = (class_2350)state.method_11654((class_2769)WindChannelBlock.field_11177);
            class_2382 v = dir.method_62675();
            if (world.method_8409().method_43048(10) == 0 && block.turbinePowerSource == null) {
                boolean gust = Global.wind.gusty();
                if (world.method_8409().method_43048(gust ? 2 : 12) == 0) {
                    boolean varyX = dir.method_10166() == class_2350.class_2351.field_11051;
                    boolean varyZ = dir.method_10166() == class_2350.class_2351.field_11048;
                    boolean varyY = dir.method_10166() != class_2350.class_2351.field_11052;
                    float mult = 1.0f + world.field_9229.method_43057() * 3.0f;
                    ((class_3218)world).method_65096((class_2394)WCParticles.WIND_PARTICLE, (double)pos.method_10263() + (0.5 + (double)(varyX ? Utils.getVerySmallFloat(world.field_9229, 0.2f) * (float)(world.method_8409().method_43056() ? -1 : 1) : 0.0f)) + (double)((float)v.method_10263() * mult), (double)pos.method_10264() + (0.5 + (double)(varyY ? Utils.getVerySmallFloat(world.field_9229, 0.2f) * (float)(world.method_8409().method_43056() ? -1 : 1) : 0.0f)) + (double)((float)v.method_10264() * mult), (double)pos.method_10260() + (0.5 + (double)(varyZ ? Utils.getVerySmallFloat(world.field_9229, 0.2f) * (float)(world.method_8409().method_43056() ? -1 : 1) : 0.0f)) + (double)((float)v.method_10260() * mult), 0, 0.0, 0.0, 1.0, (double)Utils.getWindParticleDirectionForManual(dir.method_10153()));
                    if ((double)world.method_8409().method_43057() < 0.5) {
                        mult = 0.6f;
                        ((class_3218)world).method_65096((class_2394)class_2398.field_50252, (double)pos.method_10263() + (0.5 + (double)(varyX ? Utils.getVerySmallFloat(world.field_9229, 0.2f) * (float)(world.method_8409().method_43056() ? -1 : 1) : 0.0f)) + (double)((float)v.method_10263() * mult), (double)pos.method_10264() + (0.5 + (double)(varyY ? Utils.getVerySmallFloat(world.field_9229, 0.2f) * (float)(world.method_8409().method_43056() ? -1 : 1) : 0.0f)) + (double)((float)v.method_10264() * mult), (double)pos.method_10260() + (0.5 + (double)(varyZ ? Utils.getVerySmallFloat(world.field_9229, 0.2f) * (float)(world.method_8409().method_43056() ? -1 : 1) : 0.0f)) + (double)((float)v.method_10260() * mult), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (!block.isWeathered()) {
                if (block.turbinePowerSource != null && block.age % 5 != 0) {
                    return;
                }
                short val = (short)(Global.wind.gusty() ? 2400 : 3200);
                block.windAmount = block.windAmount + (Global.wind.isGale() ? 2 : 1);
                if (block.windAmount > val) {
                    block.incrementWindStorage();
                }
            }
        }
    }

    protected void method_11014(class_11368 nbt) {
        super.method_11014(nbt);
        nbt.method_71426("windAmount", (Codec)Codec.INT).ifPresent(p -> {
            this.windAmount = p;
        });
        nbt.method_71426("redstonePowered", (Codec)Codec.BOOL).ifPresent(p -> {
            this.receivingRedstonePower = p;
        });
        nbt.method_71426("windAligned", (Codec)Codec.BOOL).ifPresent(p -> {
            this.windAligned = p;
        });
        nbt.method_71426("linkNum", (Codec)Codec.INT).ifPresent(p -> {
            this.linkNum = p;
        });
        class_2338 tps = Utils.readBlockPos(nbt, "tPos");
        class_2338 ip = Utils.readBlockPos(nbt, "iPos");
        if (tps != null) {
            this.turbinePowerSource = Pair.of((Object)tps, (Object)ip);
        }
    }

    protected void method_11007(class_11372 nbt) {
        super.method_11007(nbt);
        nbt.method_71465("windAmount", this.windAmount);
        nbt.method_71472("redstonePowered", this.receivingRedstonePower);
        nbt.method_71472("windAligned", this.windAligned);
        nbt.method_71465("linkNum", this.linkNum);
        if (this.getTurbinePowerSource() != null) {
            class_2338 ip;
            class_2338 tps = (class_2338)this.getTurbinePowerSource().getFirst();
            if (tps != null) {
                nbt.method_71465("tPosX", tps.method_10263());
                nbt.method_71465("tPosY", tps.method_10264());
                nbt.method_71465("tPosZ", tps.method_10260());
            }
            if ((ip = (class_2338)this.getTurbinePowerSource().getSecond()) != null) {
                nbt.method_71465("iPosX", ip.method_10263());
                nbt.method_71465("iPosY", ip.method_10264());
                nbt.method_71465("iPosZ", ip.method_10260());
            }
        }
    }
}

