/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.weather_classic.WeatherClassicClient;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.gui.ButtonWidgetBuilder;
import net.weather_classic.gui.TornadoCreationScreen;
import net.weather_classic.networking.client.WCNetworkClient;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.block.DebrisParticle;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class DebugMenuScreen
extends class_437 {
    public static final class_2960 MENU_TEXTURE = class_2960.method_60655((String)"weather_classic", (String)"textures/gui/debug_menu.png");
    private int ySize;
    private int xSize;
    private int xOffset;
    private byte shakingOffsetXZ = 0;
    private byte shakingOffsetY = 0;

    public DebugMenuScreen() {
        super(class_333.field_18967);
    }

    protected void method_25426() {
        this.xSize = 176;
        this.ySize = 200;
        this.xOffset = (int)((double)(this.field_22789 / 4) * 1.92);
        this.method_37067();
        int offsetY = -16;
        int startX = (this.field_22789 - this.xSize) / 2 + this.xOffset + 6;
        int startY = (this.field_22790 - this.ySize) / 2 + 23;
        int div = 22;
        if (WeatherClassicClient.debugMenuAlt) {
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Increase Wind"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)0, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 1 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Spawn Storm"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)6, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 2 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Kill Storms"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)7, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 3 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Cycle Info"), buttonWidgetX -> {
                if ((WeatherClassicClient.debugInfo = (byte)(WeatherClassicClient.debugInfo + 1)) > 2) {
                    WeatherClassicClient.debugInfo = 0;
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 4 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)(WeatherClassicClient.debugInfoStuck ? "- Debug Info -" : "+ Debug Info +")), buttonWidgetX -> {
                WeatherClassicClient.debugInfoStuck = !WeatherClassicClient.debugInfoStuck;
                this.method_25426();
            }));
        } else {
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Toggle Downfall"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)1, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 1 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Force Tornado"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)2, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 2 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Kill Tornadoes"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)5, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 3 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Prev Stage"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)3, this.field_22787);
                }
            }));
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 4 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Next Stage"), buttonWidgetX -> {
                if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                    WCNetworkClient.sendDebugMenuPayload((byte)4, this.field_22787);
                }
            }));
        }
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 5 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"\u00a77Toggle View"), buttonWidgetX -> {
            WeatherClassicClient.debugMenuAlt = !WeatherClassicClient.debugMenuAlt;
            this.method_25426();
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 6 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Close"), buttonWidgetX -> this.method_25419()));
        if (this.field_22787.field_1724.method_68878() && ModConfig.getEnableCustomTornadoes()) {
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(2, this.field_22790 - 23, 90, 20, (class_2561)class_2561.method_43470((String)((ClientCustomTornadoConfig.getSpawnPercent() > 0.0f ? "\u00a7a" : "") + "Custom Tornado")), buttonWidgetX -> {
                this.field_22787.method_1507((class_437)WeatherClassicClient.CUSTOM_TORNADO_SCREEN);
                WeatherClassicClient.defaultDebugPage = 0;
            }));
        }
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 == null) {
            this.method_25419();
            return;
        }
        int imageSize = 256;
        int x = (this.field_22789 - this.xSize) / 2;
        int y = (this.field_22790 - this.ySize) / 2;
        context.method_25290(class_10799.field_56883, MENU_TEXTURE, x + this.xOffset, y, 0.0f, 0.0f, this.xSize, this.ySize, imageSize, imageSize);
        context.method_25300(this.field_22793, WeatherClassicClient.debugMenuAlt ? "Wind Menu" : "Weather Menu", (this.field_22789 - this.xSize) / 2 + (this.xOffset + 50), y - 10, -1);
        if (!WeatherClassicClient.debugInfoStuck) {
            DebugMenuScreen.createWeatherInfo(context, 40, y - 5, delta, this.field_22787, this.field_22793, this.shakingOffsetXZ, this.shakingOffsetY);
        }
        if (this.field_22787.field_1724.method_68878() && ModConfig.getEnableCustomTornadoes()) {
            context.method_25290(class_10799.field_56883, TornadoCreationScreen.MENU_TEXTURE, -98, this.field_22790 - 30, 0.0f, 0.0f, 236, 219, imageSize, imageSize);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public static void createWeatherInfo(class_332 context, int x, int y, float delta, class_310 client, class_327 textRenderer, byte shakingOffsetXZ, byte shakingOffsetY) {
        boolean stage6;
        boolean ss;
        int offset = 10;
        byte stageReal = DebugMenuScreen.getStage();
        float rg = client.field_1687.method_8430(delta);
        float tg = client.field_1687.method_8478(delta);
        short sst = ClientGlobal.severeStormTransitionTicks;
        boolean bl = ss = sst >= 50;
        if (tg < 1.0f) {
            stageReal = 0;
        } else if (sst <= 0) {
            stageReal = 1;
        }
        boolean dying = ClientGlobal.stormDying;
        int rainTime = ClientGlobal.rainTime;
        boolean rain = stageReal <= 0 && rg >= 1.0f;
        boolean thunder = tg >= 1.0f;
        boolean transition = rg > 0.0f && rg < 1.0f || tg > 0.0f && tg < 1.0f || sst > 0 && sst < 50;
        float intensity = tg > 0.0f ? ClientGlobal.stormIntensity : 0.0f;
        int adjustableMult = 3;
        boolean bl2 = stage6 = ClientCustomTornadoConfig.getWeatherEventType() == 8 && (double)intensity > 1.1;
        if (stage6) {
            stageReal = 6;
        }
        boolean downpour = ClientGlobal.downpour;
        if (WeatherClassicClient.debugInfoStuck) {
            context.method_25303(textRenderer, "+", x - offset, y + offset * 10 + 5, -1);
        }
        context.method_25303(textRenderer, "Stage: " + (String)(rain ? "0.5" : (stage6 ? "\u00a7c" : "") + stageReal) + (transition ? " < >" : ""), x - offset, y + offset, -1);
        context.method_25303(textRenderer, DebugMenuScreen.colorIndicator(thunder, "\u00a71") + "stormTime: " + rainTime, x - offset, y + offset * 2, -1);
        context.method_25303(textRenderer, DebugMenuScreen.colorIndicator(stage6, "\u00a7c") + "stormIntensity: " + WeatherClassicClient.LONG_FORMAT.format(intensity), x - offset + shakingOffsetXZ, y + offset * adjustableMult + shakingOffsetY, -1);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(textRenderer, "stormDying: " + dying, x - offset, y + offset * adjustableMult, -1);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(textRenderer, "severe: " + ss, x - offset, y + offset * adjustableMult, -1);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(textRenderer, DebugMenuScreen.colorIndicator(downpour, "\u00a73") + "downfall: " + (rg >= 1.0f ? (downpour ? "heavy" : "light") : "none"), x - offset, y + offset * adjustableMult, -1);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(textRenderer, "debrisParticles: " + DebrisParticle.activeDebrisParticles, x - offset, y + offset * adjustableMult, -1);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(textRenderer, "rotParticles: " + StormParticle.activeRotParticles, x - offset, y + offset * adjustableMult, -1);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(textRenderer, "activeTornadoes: " + ClientGlobal.activeTornadoSources.size(), x - offset, y + offset * adjustableMult, -1);
        if (WeatherClassicClient.debugInfo > 0) {
            int m = 10;
            m += 2;
            if (WeatherClassicClient.debugInfo == 1) {
                boolean windy = ClientGlobal.windy;
                boolean g = ClientGlobal.gale;
                float strength = ClientGlobal.windStrength / 0.035f;
                if ((double)strength > 1.14) {
                    strength = 1.5f;
                }
                int wstage = strength > 1.0f ? 5 : ((double)strength > 0.8 ? 4 : (strength > 0.6f ? 3 : (strength > 0.4f ? 2 : (strength > 0.2f ? 1 : 0))));
                context.method_25303(textRenderer, "Wind Stage: " + wstage, x - offset, y + offset * m, -1);
                context.method_25303(textRenderer, DebugMenuScreen.colorIndicator(windy, g ? "\u00a7e" : "\u00a76") + "windStrength: " + WeatherClassicClient.LONG_FORMAT.format(strength), x - offset, y + offset * ++m, -1);
                int gt = ClientGlobal.windGustTime;
                boolean gh = ClientGlobal.ghastlyGale;
                int wlvl = gh ? 2 : (ClientGlobal.gusty || gt > 0 ? 1 : 0);
                context.method_25303(textRenderer, "windLvl: " + wlvl, x - offset, y + offset * ++m, -1);
                context.method_25303(textRenderer, "windAim: " + Math.round(ClientGlobal.windAngle), x - offset, y + offset * ++m, -1);
                context.method_25303(textRenderer, DebugMenuScreen.colorIndicator(gt > 0, "\u00a71") + "Wind Gust Event: " + gt, x - offset, y + offset * ++m, -1);
                context.method_25303(textRenderer, "Wind Risk: " + (WCNetworkClient.inCluster || WCNetworkClient.nearbyTornado ? "MOBS, ITEMS, BLOCKS" : (g ? (gh ? "ITEMS, BLOCKS" : "ITEMS") : "NONE")), x - offset, y + offset * ++m, -1);
            } else {
                TornadoParticleSource source = WCNetworkClient.closestCluster;
                Object display = "null";
                if (source != null) {
                    display = WeatherClassicClient.SHORT_FORMAT.format(source.getEmitter().field_1352) + ", " + WeatherClassicClient.SHORT_FORMAT.format(source.getEmitter().field_1350);
                }
                context.method_25303(textRenderer, "Closest Cluster: " + (String)display, x - offset, y + offset * m, -1);
                display = source != null ? WeatherClassicClient.LONG_FORMAT.format(source.getStrength()) : "0";
                context.method_25303(textRenderer, "stormStrength: " + (String)display, x - offset, y + offset * ++m, -1);
                display = source != null && (double)source.getStrength() > 0.5 ? "true" : "false";
                context.method_25303(textRenderer, "allowsTornado: " + (String)display, x - offset, y + offset * ++m, -1);
                short cd = ClientGlobal.clusterCountdown;
                context.method_25303(textRenderer, DebugMenuScreen.colorIndicator(cd > 0, "\u00a71") + "nextClusterTime: " + cd, x - offset, y + offset * ++m, -1);
                context.method_25303(textRenderer, "activeStorms: " + ClientGlobal.activeClusterSources.size(), x - offset, y + offset * ++m, -1);
            }
        }
    }

    private static byte getStage() {
        return (byte)(ClientGlobal.stormStage + 2);
    }

    private static String colorIndicator(boolean threshold, String color) {
        if (threshold) {
            return color;
        }
        return "";
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if ((double)ClientGlobal.stormIntensity > 1.1 && ClientGlobal.stormStage >= 3 && this.field_22787.field_1687.method_8546()) {
            this.shakingOffsetXZ = (byte)this.field_22787.field_1687.method_8409().method_43048(3);
            this.shakingOffsetY = (byte)this.field_22787.field_1687.method_8409().method_43048(3);
        } else if (this.shakingOffsetXZ > 0 || this.shakingOffsetY > 0) {
            this.shakingOffsetXZ = 0;
            this.shakingOffsetY = 0;
        }
        if (this.field_22787.field_1687 == null || this.field_22787.field_1687.method_27983() != class_1937.field_25179) {
            this.method_25419();
            return;
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }
}

