/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.help;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_10376;
import net.minecraft.class_11368;
import net.minecraft.class_11749;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5321;
import net.minecraft.class_5702;
import net.minecraft.class_5819;
import net.minecraft.class_6012;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7260;
import net.minecraft.class_8949;
import net.minecraft.class_9892;
import net.weather_classic.entity.breezling.BreezlingEntity;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoStats;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static final int GLOW = 0xF000F0;
    public static final class_2338 effectivelyNull = class_2338.field_10980.method_10086(322);
    public static final class_6012<class_11749> EXPLOSION_BLOCK_PARTICLES_COPY = class_6012.method_66215().method_54453((Object)new class_11749((class_2394)class_2398.field_11203, 0.5f, 1.0f)).method_54453((Object)new class_11749((class_2394)class_2398.field_11251, 1.0f, 1.0f)).method_34974();

    public static double distanceXZ(class_243 vec, class_243 vec2) {
        float dx = (float)(vec.field_1352 - vec2.field_1352);
        float dz = (float)(vec.field_1350 - vec2.field_1350);
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double distanceXYZ(class_243 vec, class_243 vec2) {
        float dx = (float)(vec.field_1352 - vec2.field_1352);
        float dy = (float)(vec.field_1351 - vec2.field_1351);
        float dz = (float)(vec.field_1350 - vec2.field_1350);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceXZ(int x, int z, int x2, int z2) {
        float dx = x - x2;
        float dz = z - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double distanceXZ(class_2338 vec, class_2338 vec2) {
        float dx = vec.method_10263() - vec2.method_10263();
        float dz = vec.method_10260() - vec2.method_10260();
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double distanceXYZ(class_2338 vec, class_2338 vec2) {
        float dx = vec.method_10263() - vec2.method_10263();
        float dy = vec.method_10264() - vec2.method_10264();
        float dz = vec.method_10260() - vec2.method_10260();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceXZ(double x, double y, double z, class_243 vec2) {
        float dx = (float)(x - vec2.field_1352);
        float dz = (float)(z - vec2.field_1350);
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double distanceXYZ(double x, double y, double z, class_243 vec2) {
        float dx = (float)(x - vec2.field_1352);
        float dy = (float)(y - vec2.field_1351);
        float dz = (float)(z - vec2.field_1350);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double squaredDistanceXZ(double x, double z, class_243 vec2) {
        double d = x - vec2.method_10216();
        double f = z - vec2.method_10215();
        return d * d + f * f;
    }

    public static double squaredDistanceXZ(class_2338 pos, class_2338 pos2) {
        double d = pos.method_10263() - pos2.method_10263();
        double f = pos.method_10260() - pos2.method_10260();
        return d * d + f * f;
    }

    public static double squaredDistanceXZ(class_243 v1, class_243 v2) {
        double d = v1.method_10216() - v2.method_10216();
        double f = v1.method_10215() - v2.method_10215();
        return d * d + f * f;
    }

    public static double squaredDistanceTo(class_2338 pos, class_2338 pos2) {
        double d = pos.method_10263() - pos2.method_10263();
        double e = pos.method_10264() - pos2.method_10264();
        double f = pos.method_10260() - pos2.method_10260();
        return d * d + e * e + f * f;
    }

    public static double squaredDistanceTo(class_243 pos, class_243 pos2) {
        double d = pos.method_10216() - pos2.method_10216();
        double e = pos.method_10214() - pos2.method_10214();
        double f = pos.method_10215() - pos2.method_10215();
        return d * d + e * e + f * f;
    }

    public static double squaredDistanceTo(double x, double y, double z, class_2338 pos2) {
        double d = x - (double)pos2.method_10263();
        double e = y - (double)pos2.method_10264();
        double f = z - (double)pos2.method_10260();
        return d * d + e * e + f * f;
    }

    public static double squaredDistanceTo(double x, double y, double z, class_243 vec) {
        double d = x - vec.method_10216();
        double e = y - vec.method_10214();
        double f = z - vec.method_10215();
        return d * d + e * e + f * f;
    }

    public static double manhattanDistanceXYZ(class_2338 pos1, class_2338 pos2) {
        double f = Math.abs(pos1.method_10263() - pos2.method_10263());
        double g = Math.abs(pos1.method_10264() - pos2.method_10264());
        double h = Math.abs(pos1.method_10260() - pos2.method_10260());
        return f + g + h;
    }

    public static boolean canSeePosDirectOnlyAir(class_1297 ent, class_2338 pos) {
        class_243 vec3d = new class_243(ent.method_23317(), ent.method_23320(), ent.method_23321());
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1025(vec3d) > 16384.0) {
            return false;
        }
        return ent.method_73183().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, ent)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canSeePosDirect(class_1297 ent, class_2338 pos) {
        class_243 vec3d = new class_243(ent.method_23317(), ent.method_23320(), ent.method_23321());
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1025(vec3d) > 29584.0) {
            return false;
        }
        return ent.method_73183().method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, ent)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canSeePosWithLeaves(class_1937 world, class_243 vec, class_2338 pos) {
        class_243 vec3d = new class_243(vec.field_1352, vec.field_1351, vec.field_1350);
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1022(vec3d) > 128.0) {
            return false;
        }
        return world.method_32880(new class_5702(vec3d, vec3d2, p -> !(p.method_26204() instanceof class_2397) && !Utils.canPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canSeePos(class_1937 world, class_243 vec, class_2338 pos) {
        class_243 vec3d = new class_243(vec.field_1352, vec.field_1351, vec.field_1350);
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1025(vec3d) > 16384.0) {
            return false;
        }
        return world.method_32880(new class_5702(vec3d, vec3d2, p -> !Utils.canPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canSeePos(class_1937 world, class_2338 start, class_2338 pos) {
        class_243 vec3d = new class_243((double)start.method_10263() + 0.5, (double)start.method_10264() + 0.5, (double)start.method_10260() + 0.5);
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1025(vec3d) > 16384.0) {
            return false;
        }
        return world.method_32880(new class_5702(vec3d, vec3d2, p -> !Utils.canPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canSeePosIgnoreLeaves(class_1937 world, class_2338 start, class_2338 pos) {
        class_243 vec3d = new class_243((double)start.method_10263() + 0.5, (double)start.method_10264() + 0.5, (double)start.method_10260() + 0.5);
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1025(vec3d) > 16384.0) {
            return false;
        }
        return world.method_32880(new class_5702(vec3d, vec3d2, p -> !Utils.canPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canSeeGenerous(class_1297 ent, class_2338 pos) {
        if (Utils.canSeePosDirect(ent, pos)) {
            return true;
        }
        for (int i = 1; i < 2; ++i) {
            for (class_2350 dir : class_2350.values()) {
                if (Utils.canSeePosDirect(ent, pos.method_10079(dir, i))) {
                    return true;
                }
                for (class_2350 dir2 : class_2350.values()) {
                    if (!Utils.canSeePosDirect(ent, pos.method_10079(dir, i).method_10093(dir2))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canSeeFairOnlyAir(class_1297 ent, class_2338 pos) {
        if (Utils.canSeePosDirectOnlyAir(ent, pos)) {
            return true;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!Utils.canSeePosDirectOnlyAir(ent, pos.method_10093(dir))) continue;
            return true;
        }
        return false;
    }

    public static boolean canSeeFair(class_1297 ent, class_2338 pos) {
        if (Utils.canSeePosDirect(ent, pos)) {
            return true;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!Utils.canSeePosDirect(ent, pos.method_10093(dir))) continue;
            return true;
        }
        return false;
    }

    public static boolean canSolidPositionSee(class_1937 world, class_2338 start, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!Utils.canSeePos(world, start.method_10093(dir), pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean canSeeVec(class_1937 world, class_243 vec, class_243 vec2) {
        class_243 vec3d = new class_243(vec.field_1352, vec.field_1351, vec.field_1350);
        class_243 vec3d2 = new class_243(vec2.method_10216() + 0.5, vec2.method_10214() + 0.5, vec2.method_10215() + 0.5);
        if (vec3d2.method_1025(vec3d) > 16384.0) {
            return false;
        }
        return world.method_32880(new class_5702(vec3d, vec3d2, p -> !Utils.canPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean inInvalidMode(class_1297 ent) {
        if (ent == null || ent.method_24515() == effectivelyNull) {
            return true;
        }
        return ent instanceof class_1657 && ((class_1657)ent).method_68878() || ent.method_7325() || ent instanceof class_1309 && ((class_1309)ent).method_29504() || ent.method_31481();
    }

    public static boolean isPet(class_1297 entity) {
        boolean isTame = entity instanceof class_1496 && ((class_1496)entity).method_6727() || entity instanceof class_6025 && ((class_6025)entity).method_35057() != null;
        return isTame;
    }

    public static class_2350 closestFace(class_2338 pos, class_243 collider, boolean xz) {
        class_243 center = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        double westDist = Utils.distanceXYZ(collider, center.method_1031(-0.5, 0.0, 0.0));
        double eastDist = Utils.distanceXYZ(collider, center.method_1031(0.5, 0.0, 0.0));
        double northDist = Utils.distanceXYZ(collider, center.method_1031(0.0, 0.0, -0.5));
        double southDist = Utils.distanceXYZ(collider, center.method_1031(0.0, 0.0, 0.5));
        double upDist = Utils.distanceXYZ(collider, center.method_1031(0.0, 0.5, 0.0));
        double downDist = Utils.distanceXYZ(collider, center.method_1031(0.0, -0.5, 0.0));
        double shortest1 = Math.min(westDist, eastDist);
        double shortest2 = Math.min(northDist, southDist);
        double shortest3 = xz ? Double.MAX_VALUE : Math.min(upDist, downDist);
        double finalDist = Math.min(shortest1, shortest2);
        double finalestDist = Math.min(finalDist, shortest3);
        return finalestDist == westDist ? class_2350.field_11039 : (finalestDist == eastDist ? class_2350.field_11034 : (finalestDist == northDist ? class_2350.field_11043 : (finalestDist == southDist ? class_2350.field_11035 : (finalestDist == upDist ? class_2350.field_11036 : class_2350.field_11033))));
    }

    public static boolean hasSnow(class_1937 world, class_2338 pos) {
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        return biome.method_48162(pos, world.method_8615()) == class_1959.class_1963.field_9383;
    }

    public static boolean canPassThrough(class_2248 block) {
        return block.method_9538(block.method_9564()) || !block.method_9564().method_26227().method_15769() || block instanceof class_10376;
    }

    public static boolean canPassThrough(class_1936 world, class_2338 pos) {
        return Utils.canPassThrough(world.method_8320(pos).method_26204());
    }

    public static boolean canPassThrough(class_1922 world, class_2338 pos) {
        return Utils.canPassThrough(world.method_8320(pos).method_26204());
    }

    public static void playSound(@Nullable class_1297 entity, class_1937 world, class_2338 pos, class_3414 event, class_3419 category, float volume, float pitch) {
        if (entity != null) {
            world.method_43129(null, entity, event, category, volume, pitch);
        } else {
            world.method_8396(null, pos, event, category, volume, pitch);
        }
    }

    public static boolean isPosInWater(class_1297 ent) {
        return Materials.isWater(ent.method_55667());
    }

    public static void setVelocityY(class_1297 ent, double speed) {
        ent.method_18800(ent.method_18798().field_1352, speed, ent.method_18798().field_1350);
    }

    public static boolean isVelocityZero(class_1297 ent) {
        return ent.field_6014 == ent.method_23317() && ent.field_6036 == ent.method_23318() && ent.field_5969 == ent.method_23321();
    }

    public static boolean isRawXZVelocityZero(class_1297 ent) {
        return ent.method_18798().field_1352 == 0.0 && ent.method_18798().field_1350 == 0.0;
    }

    public static int getGroundY(class_1937 world, class_2338 pos) {
        for (int i = 0; i < 320; ++i) {
            class_2338 test = pos.method_10087(i);
            class_2248 block = world.method_8320(test).method_26204();
            if (Utils.canPassThrough(block)) continue;
            return test.method_10264();
        }
        return pos.method_10264();
    }

    public static float wrapAngleAround(float angle, float goal) {
        while (goal - angle >= 180.0f) {
            angle += 360.0f;
        }
        while (goal - angle < -180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public static void lookAtVec(class_1297 ent, class_243 target, float maxYawChange, float maxPitchChange) {
        Utils.lookAtVec(ent, target, maxYawChange, maxPitchChange, false);
    }

    public static void lookAtVec(class_1297 ent, class_243 target, float maxYawChange, float maxPitchChange, boolean headYaw) {
        double d = target.method_10216() - ent.method_23317();
        double e = target.method_10215() - ent.method_23321();
        double g = target.method_10214() - ent.method_23318();
        double h = Math.sqrt(d * d + e * e);
        float i = (float)(class_3532.method_15349((double)e, (double)d) * 57.2957763671875) - 90.0f;
        float j = (float)(-(class_3532.method_15349((double)g, (double)h) * 57.2957763671875));
        ent.method_36457(Utils.changeAngle(ent.method_36455(), j, maxPitchChange));
        if (headYaw) {
            ent.method_5847(Utils.changeAngle(ent.method_5791(), i, maxYawChange));
        } else {
            ent.method_36456(Utils.changeAngle(ent.method_36454(), i, maxYawChange));
        }
    }

    public static void lookAtVecS(class_1297 ent, class_243 target, float maxYawChange, float maxPitchChange, boolean noYaw) {
        double d = target.method_10216() - ent.method_23317();
        double e = target.method_10215() - ent.method_23321();
        double g = target.method_10214() - ent.method_23318();
        double h = Math.sqrt(d * d + e * e);
        float i = (float)(class_3532.method_15349((double)e, (double)d) * 57.2957763671875) - 90.0f;
        float j = (float)(-(class_3532.method_15349((double)g, (double)h) * 57.2957763671875));
        ent.method_36457(Utils.changeAngle(ent.method_36455(), j, maxPitchChange));
        if (!noYaw) {
            ent.method_36456(Utils.changeAngle(ent.method_36454(), i, maxYawChange));
        }
    }

    private static float changeAngle(float oldAngle, float newAngle, float maxChangeInAngle) {
        float f = class_3532.method_15393((float)(newAngle - oldAngle));
        if (f > maxChangeInAngle) {
            f = maxChangeInAngle;
        }
        if (f < -maxChangeInAngle) {
            f = -maxChangeInAngle;
        }
        return oldAngle + f;
    }

    public static class_243 convertBlockPosToVec(class_2338 pos) {
        return new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    public static class_243 getOffsetVecForRotation(class_1297 entity, float x, float y, float z, boolean useHeadYaw) {
        class_243 addedVec = new class_243((double)x, (double)y, (double)z).method_1024((useHeadYaw ? -entity.method_5791() : -entity.method_73188()) * ((float)Math.PI / 180) - 1.5707964f);
        class_243 vec = new class_243(entity.method_23317() + addedVec.field_1352, entity.method_23318() + addedVec.field_1351, entity.method_23321() + addedVec.field_1350);
        return vec;
    }

    public static class_2350 randomHorizontal(class_5819 random) {
        int i = random.method_43048(4);
        switch (i) {
            case 0: {
                return class_2350.field_11043;
            }
            case 1: {
                return class_2350.field_11034;
            }
            case 2: {
                return class_2350.field_11039;
            }
        }
        return class_2350.field_11035;
    }

    public static List<class_1657> getPlayers(class_1937 world, class_2338 pos, Predicate<class_1657> predicate, int dist) {
        ArrayList<class_1657> list = new ArrayList<class_1657>();
        class_238 box = new class_238(pos).method_1014((double)dist);
        for (class_1657 player : world.method_18456()) {
            if (!predicate.test(player) || !box.method_1008(player.method_23317(), player.method_23318(), player.method_23321())) continue;
            list.add(player);
        }
        return list;
    }

    public static class_1309 getClosestEntity(class_1937 world, @Nullable class_1309 host, class_2338 pos, int size, Predicate<? super class_1297> predicate) {
        List list = world.method_8333((class_1297)host, new class_238(pos).method_1014((double)size), p -> p instanceof class_1309 && predicate.test((class_1297)p));
        if (list.isEmpty()) {
            return null;
        }
        double dist = 2.147483647E9;
        class_1309 closest = null;
        for (class_1297 ent : list) {
            int test = (int)Utils.distanceXYZ(pos, ent.method_24515());
            if (!((double)test < dist)) continue;
            dist = test;
            closest = (class_1309)ent;
        }
        return closest;
    }

    public static List<class_2338> getBlockPosLine(class_1937 world, class_2338 start, class_2338 end, float densityMultiplier) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        float density = (int)(Utils.distanceXYZ(start, end) * (double)densityMultiplier);
        double tx = start.method_10263();
        double ty = start.method_10264();
        double tz = start.method_10260();
        int i = 0;
        while ((float)i < density) {
            double trailFactor = (double)i / ((double)density - 1.0);
            tx = (double)start.method_10263() + (double)(end.method_10263() - start.method_10263()) * trailFactor;
            ty = (double)start.method_10264() + (double)(end.method_10264() - start.method_10264()) * trailFactor;
            tz = (double)start.method_10260() + (double)(end.method_10260() - start.method_10260()) * trailFactor;
            list.add(BP.of(tx, ty, tz));
            ++i;
        }
        return list;
    }

    public static List<class_243> getVecLine(class_1937 world, class_243 start, class_243 end, float densityMultiplier) {
        ArrayList<class_243> list = new ArrayList<class_243>();
        float density = (int)(Utils.distanceXYZ(start, end) * (double)densityMultiplier);
        double tx = start.method_10216();
        double ty = start.method_10214();
        double tz = start.method_10215();
        int i = 0;
        while ((float)i < density) {
            double trailFactor = (double)i / ((double)density - 1.0);
            tx = start.method_10216() + (end.method_10216() - start.method_10216()) * trailFactor;
            ty = start.method_10214() + (end.method_10214() - start.method_10214()) * trailFactor;
            tz = start.method_10215() + (end.method_10215() - start.method_10215()) * trailFactor;
            list.add(new class_243(tx, ty, tz));
            ++i;
        }
        return list;
    }

    public static <T extends class_2394> int forceImportantParticles(class_3218 world, T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        class_2675 particleS2CPacket = new class_2675(particle, true, true, x, y, z, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        int i = 0;
        for (int j = 0; j < world.method_18456().size(); ++j) {
            class_3222 serverPlayerEntity = (class_3222)world.method_18456().get(j);
            if (!world.method_14191(serverPlayerEntity, true, x, y, z, (class_2596)particleS2CPacket)) continue;
            ++i;
        }
        return i;
    }

    public static float getVerySmallFloat(class_5819 random, float percent) {
        return random.method_43057() * percent;
    }

    public static boolean isTropicalOcean(class_5321<class_1959> biome) {
        return biome == class_1972.field_9408 || biome == class_1972.field_9441 || biome == class_1972.field_9439;
    }

    public static boolean isTooHighFromGround(class_1937 world, class_2338 pos, int dist) {
        for (int i = 0; i < dist + 1; ++i) {
            class_2680 state = world.method_8320(pos.method_10087(i));
            if (Utils.canPassThrough(state.method_26204()) && state.method_26227().method_15769()) continue;
            return false;
        }
        return true;
    }

    public static boolean withinTornadoSoundRange(class_243 pos1, class_243 tornado, byte type) {
        TornadoStats stats = TornadoStats.getFrom(type, false);
        boolean small = type == 5 && stats.scaling < 0.55f;
        int yi = small ? 16 : 32;
        int yr = small ? 24 : 64;
        return Utils.distanceXZ(pos1, tornado) < (double)stats.soundDist && Math.abs(pos1.field_1351 - (tornado.field_1351 + (double)yi)) < (double)yr;
    }

    public static int interpolateColor(int startColor, int endColor, int currentTick, int time) {
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int currentRed = (int)((double)startRed + (double)(endRed - startRed) * ((double)currentTick / (double)time));
        int currentGreen = (int)((double)startGreen + (double)(endGreen - startGreen) * ((double)currentTick / (double)time));
        int currentBlue = (int)((double)startBlue + (double)(endBlue - startBlue) * ((double)currentTick / (double)time));
        return currentRed << 16 | currentGreen << 8 | currentBlue;
    }

    public static int interpolateColorT(int startColor, int endColor, float t) {
        t = class_3532.method_15363((float)t, (float)0.0f, (float)1.0f);
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int currentRed = (int)((float)startRed + (float)(endRed - startRed) * t);
        int currentGreen = (int)((float)startGreen + (float)(endGreen - startGreen) * t);
        int currentBlue = (int)((float)startBlue + (float)(endBlue - startBlue) * t);
        return currentRed << 16 | currentGreen << 8 | currentBlue;
    }

    public static void tryMergeStack(List<Pair<class_1799, class_2338>> stacks, class_1799 stack, class_2338 pos) {
        for (int i = 0; i < stacks.size(); ++i) {
            Pair<class_1799, class_2338> pair = stacks.get(i);
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemStack, (class_1799)stack)) continue;
            stacks.set(i, (Pair<class_1799, class_2338>)Pair.of((Object)class_1542.method_24018((class_1799)itemStack, (class_1799)stack, (int)16), (Object)((class_2338)pair.getSecond())));
            if (!stack.method_7960()) continue;
            return;
        }
        stacks.add((Pair<class_1799, class_2338>)Pair.of((Object)stack, (Object)pos));
    }

    public static void windChargeInteract(class_3218 world, class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof class_2323 && state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609) {
            pos = pos.method_10074();
        }
        ArrayList list = new ArrayList();
        class_9892 e = new class_9892(world, null, null, null, Utils.convertBlockPosToVec(pos), 0.0f, false, class_1927.class_4179.field_47331);
        world.method_8320(pos).method_55225(world, pos, (class_1927)e, (stack, pp) -> Utils.tryMergeStack(list, stack, pp));
    }

    public static boolean isWindImmuneMob(class_1297 ent) {
        return ent instanceof class_8949 || ent instanceof BreezlingEntity || ent instanceof TornadoEntity || ent instanceof class_1510 || ent instanceof class_1508 || ent instanceof class_1528 || ent instanceof class_7260;
    }

    public static byte getWindParticleDirectionForManual(class_2350 dir) {
        switch (dir) {
            case field_11034: {
                return 100;
            }
            case field_11039: {
                return 101;
            }
            case field_11035: {
                return 102;
            }
            case field_11043: {
                return 103;
            }
            case field_11033: {
                return 104;
            }
        }
        return 105;
    }

    public static class_243 getWindParticleVectorFromByte(byte b) {
        class_2382 v;
        switch (b) {
            case 100: {
                v = class_2350.field_11034.method_62675();
                break;
            }
            case 101: {
                v = class_2350.field_11039.method_62675();
                break;
            }
            case 102: {
                v = class_2350.field_11035.method_62675();
                break;
            }
            case 103: {
                v = class_2350.field_11043.method_62675();
                break;
            }
            case 104: {
                v = class_2350.field_11033.method_62675();
                break;
            }
            case 105: {
                v = class_2350.field_11036.method_62675();
                break;
            }
            default: {
                return null;
            }
        }
        class_243 vector = new class_243((double)v.method_10263(), (double)v.method_10264(), (double)v.method_10260()).method_1021((double)0.3f);
        return vector;
    }

    public static List<class_1657> getPlayersIn(class_1937 world, class_238 box) {
        ArrayList list = Lists.newArrayList();
        for (class_1657 playerEntity : world.method_18456()) {
            if (!box.method_1008(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321())) continue;
            list.add(playerEntity);
        }
        return list;
    }

    public static boolean isPlayerWithin(class_1937 world, class_238 box) {
        if (world.method_18456().isEmpty() || world.method_18456().size() > 50) {
            return false;
        }
        for (class_1657 playerEntity : world.method_18456()) {
            if (!box.method_1008(playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321())) continue;
            return true;
        }
        return false;
    }

    public static class_2350 directionFromBlockRotation(class_2470 r) {
        if (r == null) {
            return class_2350.field_11043;
        }
        switch (r) {
            case field_11463: {
                return class_2350.field_11034;
            }
            case field_11464: {
                return class_2350.field_11035;
            }
            case field_11465: {
                return class_2350.field_11039;
            }
        }
        return class_2350.field_11043;
    }

    public static class_2470 blockRotationFromDirection(class_2350 dir) {
        if (dir == null) {
            return class_2470.field_11467;
        }
        switch (dir) {
            case field_11034: {
                return class_2470.field_11463;
            }
            case field_11039: {
                return class_2470.field_11465;
            }
            case field_11035: {
                return class_2470.field_11464;
            }
        }
        return class_2470.field_11467;
    }

    public static <B extends class_2586> List<class_2586> getBlockEntities(class_1936 world, class_2338 pos, int chunks, Predicate<Object> typeCheck, Predicate<class_2586> predicate) {
        ArrayList<class_2586> bes = new ArrayList<class_2586>();
        class_1923 originalPos = new class_1923(pos);
        for (int xx = -chunks; xx <= chunks; ++xx) {
            for (int zz = -chunks; zz <= chunks; ++zz) {
                class_1923 cpos = new class_1923(originalPos.field_9181 + xx, originalPos.field_9180 + zz);
                for (class_2338 p : world.method_22350(cpos.method_8323()).method_12021()) {
                    class_2586 be = world.method_8321(p);
                    if (be == null || !typeCheck.test(be) || predicate != null && !predicate.test(be)) continue;
                    bes.add(be);
                }
            }
        }
        return bes;
    }

    public static boolean isStructureNearby(class_2791 chunk) {
        return !chunk.method_12179().isEmpty();
    }

    public static boolean isBiomeForest(class_6880<class_1959> biome) {
        return biome.method_40220(class_6908.field_36517) || biome.method_40220(class_6908.field_36516) || biome.method_40220(class_6908.field_36515);
    }

    public static class_2338 readBlockPos(class_11368 nbt, String name) {
        class_2338 ip = null;
        if (nbt.method_71426(name + "X", (Codec)Codec.INT).isPresent() && nbt.method_71426(name + "Y", (Codec)Codec.INT).isPresent() && nbt.method_71426(name + "Z", (Codec)Codec.INT).isPresent()) {
            Optional x = nbt.method_71426(name + "X", (Codec)Codec.INT);
            Optional y = nbt.method_71426(name + "Y", (Codec)Codec.INT);
            Optional z = nbt.method_71426(name + "Z", (Codec)Codec.INT);
            if (x.isPresent() && y.isPresent() && z.isPresent()) {
                ip = BP.of((Integer)x.get(), (Integer)y.get(), (Integer)z.get());
            }
        }
        return ip;
    }

    public static class_2338 readBlockPosForNbt(class_2487 nbt, String name) {
        class_2338 ip = null;
        if (nbt.method_10545(name + "X") && nbt.method_10545(name + "Y") && nbt.method_10545(name + "Z")) {
            Optional x = nbt.method_10550(name + "X");
            Optional y = nbt.method_10550(name + "Y");
            Optional z = nbt.method_10550(name + "Z");
            if (x.isPresent() && y.isPresent() && z.isPresent()) {
                ip = BP.of((Integer)x.get(), (Integer)y.get(), (Integer)z.get());
            }
        }
        return ip;
    }

    public static boolean isInteger(String str) {
        if (str == null || str.trim().isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str.trim());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

