/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.mixin;

import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1496;
import net.minecraft.class_1506;
import net.minecraft.class_1538;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5635;
import net.minecraft.class_5819;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9747;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.Weather;
import net.weather_classic.global.Wind;
import net.weather_classic.help.Utils;
import net.weather_classic.misc.EntityVelocityDemander;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoRotator;
import net.weather_classic.storm.clusters.StormClusterPE;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    private boolean field_6282;
    @Unique
    private boolean inBlizzard = false;
    @Unique
    private short timeInBlizzard = 0;
    @Unique
    private boolean canSeeTornado = false;
    @Unique
    private boolean canBeBlownByWind = false;
    @Unique
    private TornadoParticleSource tornadoSource = null;
    @Unique
    private boolean inCluster = false;

    @Inject(method={"method_32325()V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void addPowderSnowSlowIfNeededMixin(CallbackInfo info) {
        if (this.inBlizzard) {
            info.cancel();
        }
    }

    @Inject(method={"method_26318(Lnet/minecraft/class_243;F)Lnet/minecraft/class_243;"}, at={@At(value="HEAD")}, cancellable=true)
    public void applyMovementInputMixin(class_243 movementInput, float slipperiness, CallbackInfoReturnable<class_243> info) {
        class_1309 thiss = (class_1309)this;
        if (Global.weather != null && Global.weather.isDownpour() && !Utils.inInvalidMode((class_1297)thiss)) {
            if ((thiss.field_6012 + thiss.method_5628()) % 250 == 0 && thiss.method_32316()) {
                boolean bl = this.inBlizzard = ModConfig.getFreezing() && !Wind.isBlizzardImmune((class_1297)thiss) && this.hasSnow(thiss.method_73183(), thiss.method_24515(), thiss.method_33571());
                if (this.inBlizzard) {
                    boolean bl2 = this.inBlizzard = !Wind.hasNearbyHeatSource(thiss.method_33571(), thiss.method_73183());
                }
            }
            if (this.inBlizzard || thiss.method_73183().method_8311(thiss.method_24515())) {
                if (this.inBlizzard) {
                    if (this.timeInBlizzard < 700) {
                        this.timeInBlizzard = (short)(this.timeInBlizzard + 1);
                    }
                    if (this.timeInBlizzard > Global.wind.getTimeForBlizzardFreeze()) {
                        thiss.method_32319(true);
                        if (thiss.method_32316()) {
                            thiss.method_32317(Math.min(thiss.method_32315(), thiss.method_32312() + 1));
                        }
                    }
                } else if (this.timeInBlizzard > 0) {
                    this.timeInBlizzard = (short)(this.timeInBlizzard - 1);
                }
                if (thiss.method_24828() || this.field_6282) {
                    float mult = Weather.downpourMovementSpeedMultiplier(thiss.field_27857);
                    movementInput = movementInput.method_18805((double)mult, 1.0, (double)mult);
                    thiss.method_5724(this.invokeMovementSpeed(slipperiness), movementInput);
                    thiss.method_18799(this.invokeApplyClimbingSpeed(thiss.method_18798()));
                    thiss.method_5784(class_1313.field_6308, thiss.method_18798());
                    class_243 vec3d = thiss.method_18798();
                    if ((thiss.field_5976 || this.field_6282) && (thiss.method_6101() || thiss.method_55667().method_27852(class_2246.field_27879) && class_5635.method_32355((class_1297)thiss))) {
                        vec3d = new class_243(vec3d.field_1352, 0.2, vec3d.field_1350);
                    }
                    info.setReturnValue((Object)vec3d);
                }
            }
        } else if (this.inBlizzard || this.timeInBlizzard > 0) {
            this.inBlizzard = false;
            this.timeInBlizzard = (short)(this.timeInBlizzard - 2);
            if (this.timeInBlizzard < 0) {
                this.timeInBlizzard = 0;
            }
        }
    }

    private boolean hasSnow(class_1937 world, class_2338 pos, class_243 l) {
        boolean snow;
        class_1959 biome = (class_1959)world.method_23753(pos).comp_349();
        boolean bl = snow = biome.method_48162(pos, world.method_8615()) == class_1959.class_1963.field_9383;
        if (!snow) {
            return false;
        }
        return Wind.isOutsideInWindAreaClient(l, world);
    }

    @Invoker(value="method_18801")
    protected abstract class_243 invokeApplyClimbingSpeed(class_243 var1);

    @Invoker(value="method_18802")
    protected abstract float invokeMovementSpeed(float var1);

    @Invoker(value="method_49484")
    protected abstract float invokeOffGroundSpeed();

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")}, cancellable=true)
    public void tickMixin(CallbackInfo info) {
        TornadoEntity tornado;
        Object cluster;
        class_1309 thiss = (class_1309)this;
        if (!thiss.method_73183().method_8608() && ModConfig.getSevereStormLightningStrikesMobs() && thiss.field_6012 % 800 == 0 && Global.weather != null && Global.weather.isSevereStorm() && thiss.method_73183().method_8407() != class_1267.field_5801) {
            boolean validEntity;
            boolean bl = validEntity = this.isLightningInteractable(thiss) || thiss.method_5864() == class_1299.field_6137;
            if (validEntity && !thiss.method_6109()) {
                class_3218 world = (class_3218)thiss.method_73183();
                if (thiss.method_59922().method_43048(Weather.getSevereStormLightningAggressionForInt()) == 0 && thiss.method_24828() && !Utils.inInvalidMode((class_1297)thiss) && world.method_8520(thiss.method_24515())) {
                    if (thiss.method_5864() == class_1299.field_6077 && Utils.isStructureNearby(world.method_22350(thiss.method_24515()))) {
                        info.cancel();
                        return;
                    }
                    class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883((class_1937)world, class_3730.field_16459);
                    lightningEntity.method_29495(class_243.method_24955((class_2382)thiss.method_24515()));
                    lightningEntity.method_29498(thiss.method_5864() == class_1299.field_6137);
                    world.method_8649((class_1297)lightningEntity);
                    if (thiss.method_5864() == class_1299.field_6137) {
                        class_1613 skeletonEntity2;
                        Utils.playSound(null, (class_1937)world, thiss.method_24515(), class_3417.field_14721, class_3419.field_15251, 1.0f, 0.8f + thiss.method_59922().method_43057() * 0.3f);
                        class_1266 dif = world.method_8404(thiss.method_24515());
                        class_1496 abstractHorseEntity = this.getHorse(world, dif, thiss.method_24515());
                        if (abstractHorseEntity != null && (skeletonEntity2 = this.getSkeleton(dif, abstractHorseEntity)) != null) {
                            skeletonEntity2.method_5804((class_1297)abstractHorseEntity);
                            world.method_30771((class_1297)abstractHorseEntity);
                        }
                        thiss.method_31472();
                    }
                }
            }
        }
        if (thiss instanceof class_1506 && ((class_1506)thiss).method_5961() && ((class_1506)thiss).method_5996(class_5134.field_23716).method_6201() > 18.0) {
            if (thiss.method_73183().method_8608() && thiss.field_6012 % 5 == 0) {
                thiss.method_73183().method_8406((class_2394)class_2398.field_11237, thiss.method_23322(1.0), thiss.method_23318() + 0.5 + (double)thiss.method_59922().method_43057(), thiss.method_23325(1.0), 0.0, 0.0, 0.0);
            } else if (thiss.field_6012 % 30 == 0 && !thiss.method_5703(p -> p.method_5864() == class_1299.field_6137)) {
                for (int i = 0; i < 50; ++i) {
                    ((class_3218)thiss.method_73183()).method_65096((class_2394)class_2398.field_11237, thiss.method_23322(1.2), thiss.method_23318() + (double)0.2f + (double)thiss.method_59922().method_43057() + (double)thiss.method_59922().method_43057(), thiss.method_23325(1.2), 0, 0.0, 0.0, 0.0, 0.0);
                }
                Utils.playSound(null, thiss.method_73183(), thiss.method_24515(), class_3417.field_28606, class_3419.field_15251, 0.6f, 0.8f + thiss.method_59922().method_43057() * 0.4f);
                thiss.method_31472();
            }
        }
        if ((thiss.field_6012 + thiss.method_5628()) % 80 == 0 && !thiss.method_73183().method_8608()) {
            if (!(Global.activeClusters.isEmpty() && Global.activeTornadoes.isEmpty() || thiss.method_5869() || Utils.isWindImmuneMob((class_1297)thiss))) {
                this.canBeBlownByWind = thiss.method_73183().method_8311(thiss.method_24515());
                TornadoEntity closest = Global.getClosestTornado(thiss.method_33571());
                if (closest != null && closest.getStrength() < 100.0f) {
                    closest = null;
                }
                if (this.tornadoSource != closest) {
                    this.tornadoSource = closest;
                }
                if (this.tornadoSource != null) {
                    this.canSeeTornado = TornadoRotator.canEntitySeeSource((class_1297)thiss, closest);
                } else {
                    double distSq;
                    cluster = Global.getClosestCluster(thiss.method_24515());
                    this.inCluster = cluster != null ? ((distSq = Utils.squaredDistanceXZ(thiss.method_73189(), ((StormClusterPE)cluster).getEntityPos())) < 4096.0 ? this.canBeBlownByWind : false) : false;
                    this.canSeeTornado = false;
                }
            } else if (this.canSeeTornado || this.canBeBlownByWind || this.tornadoSource != null || this.inCluster) {
                this.canBeBlownByWind = false;
                this.canSeeTornado = false;
                this.tornadoSource = null;
                this.inCluster = false;
            }
        }
        if (this.tornadoSource != null && (cluster = this.tornadoSource) instanceof TornadoEntity && !(tornado = (TornadoEntity)cluster).method_31481()) {
            short grab;
            int maxDist;
            int maxDistSq;
            double distSq = Utils.squaredDistanceXZ(thiss.method_73189(), tornado.getEmitter());
            if (distSq <= (double)(maxDistSq = (maxDist = (grab = tornado.getStats().grabDistance) + 72) * maxDist) && this.canBeBlownByWind && !tornado.getRotator().hasMob(thiss)) {
                short minDist = grab;
                int minDistSq = minDist * minDist;
                float maxVel = TornadoRotator.getTornadoFarSuction(tornado.getTornadoTypeForRotator(), true);
                float t = (float)((distSq - (double)minDistSq) / (double)(maxDistSq - minDistSq));
                t = Math.max(0.0f, Math.min(1.0f, t));
                float curVel = maxVel * (1.0f - t);
                class_243 dif = thiss.method_73189().method_1020(tornado.getEmitter()).method_1029().method_1021((double)(-curVel));
                thiss.method_5762(dif.field_1352, 0.0, dif.field_1350);
            }
        } else if (this.inCluster) {
            Wind.pushFromWind((class_1297)thiss, 0.5f);
        }
    }

    private boolean isLightningInteractable(class_1309 entity) {
        return entity.method_5864() == class_1299.field_6093 || entity.method_5864() == class_1299.field_6046 || entity.method_5864() == class_1299.field_6077;
    }

    private class_1496 getHorse(class_3218 world, class_1266 localDifficulty, class_2338 pos) {
        class_1506 skeletonHorseEntity = (class_1506)class_1299.field_6075.method_5883((class_1937)world, class_3730.field_16468);
        if (skeletonHorseEntity != null) {
            skeletonHorseEntity.method_5943((class_5425)world, localDifficulty, class_3730.field_16461, null);
            skeletonHorseEntity.method_5814((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            skeletonHorseEntity.field_6008 = 60;
            skeletonHorseEntity.method_5971();
            skeletonHorseEntity.method_6766(true);
            skeletonHorseEntity.method_5614(0);
            skeletonHorseEntity.method_5937(true);
            skeletonHorseEntity.method_5996(class_5134.field_23716).method_6192(20.0);
            skeletonHorseEntity.method_6025(20.0f);
        }
        return skeletonHorseEntity;
    }

    private class_1613 getSkeleton(class_1266 localDifficulty, class_1496 vehicle) {
        class_1613 skeletonEntity = (class_1613)class_1299.field_6137.method_5883(vehicle.method_73183(), class_3730.field_16468);
        if (skeletonEntity != null) {
            skeletonEntity.method_5943((class_5425)((class_3218)vehicle.method_73183()), localDifficulty, class_3730.field_16461, null);
            skeletonEntity.method_5814(vehicle.method_23317(), vehicle.method_23318(), vehicle.method_23321());
            skeletonEntity.field_6008 = 60;
            skeletonEntity.method_5971();
            if (skeletonEntity.method_6118(class_1304.field_6169).method_7960()) {
                skeletonEntity.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
            }
            this.enchantEquipment(skeletonEntity, class_1304.field_6173, localDifficulty);
            this.enchantEquipment(skeletonEntity, class_1304.field_6169, localDifficulty);
        }
        return skeletonEntity;
    }

    private void enchantEquipment(class_1613 rider, class_1304 slot, class_1266 localDifficulty) {
        class_1799 itemStack = rider.method_6118(slot);
        itemStack.method_57379(class_9334.field_49633, (Object)class_9304.field_49385);
        class_1890.method_60137((class_1799)itemStack, (class_5455)rider.method_73183().method_30349(), (class_5321)class_9747.field_51771, (class_1266)localDifficulty, (class_5819)rider.method_59922());
        rider.method_5673(slot, itemStack);
    }

    @Inject(method={"method_49483(Lnet/minecraft/class_1657;Lnet/minecraft/class_243;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void travelControlledMixin(class_1657 controllingPlayer, class_243 movementInput, CallbackInfo info) {
        EntityVelocityDemander d;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof EntityVelocityDemander && (d = (EntityVelocityDemander)((Object)livingEntityMixin)).hasForcedVelocity()) {
            ((class_1309)this).method_6091(movementInput);
            info.cancel();
        }
    }
}

