/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.networking.client;

import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.weather_classic.WeatherClassic;
import net.weather_classic.WeatherClassicClient;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Wind;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.packet.C2SGlobalCommunicationPayload;
import net.weather_classic.networking.packet.ClusterStatusPayload;
import net.weather_classic.networking.packet.CustomItemStatusPayload;
import net.weather_classic.networking.packet.DebrisParticlePayload;
import net.weather_classic.networking.packet.DebugMenuPayload;
import net.weather_classic.networking.packet.ItemEntityVelocityPayload;
import net.weather_classic.networking.packet.PlayerVelocityPayload;
import net.weather_classic.networking.packet.StormIntensityPayload;
import net.weather_classic.networking.packet.TornadoDirectionalWindSoundPayload;
import net.weather_classic.networking.packet.TornadoMiscPayload;
import net.weather_classic.networking.packet.TornadoStatusPayload;
import net.weather_classic.networking.packet.WeatherStatusPayload;
import net.weather_classic.networking.packet.WindStatusPayload;
import net.weather_classic.networking.packet.assembler.AssemblerUpdatePayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoAIPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoExtrasPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoParticlesPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoShapePayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoSpawningPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoSwitchPayload;
import net.weather_classic.networking.packet.debris.DebrisVelocityPayload;
import net.weather_classic.networking.packet.turbine.TurbineSoundPayload;
import net.weather_classic.networking.packet.turbine.TurbineStatePayload;
import net.weather_classic.networking.packet.wind_core.WindCorePayload;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.block.DebrisParticle;
import net.weather_classic.registry.WCParticles;
import net.weather_classic.sound.TurbineSoundInstance;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoRotator;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.sound.StormSoundInfo;
import net.weather_classic.storm.source.ClientClusterParticleSource;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;
import net.weather_classic.wind_core.ClientWindCoreParticleSource;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class WCNetworkClient {
    private static int recentTornadoDeathTime = 0;
    public static TornadoParticleSource closestCluster = null;
    public static boolean hasNightVision = false;
    public static boolean canBeBlownByWind = false;
    public static boolean seesTornado = false;
    public static boolean inCluster = false;
    public static boolean nearbyTornado = false;

    public static void setupClientNetworking() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WCNetworkClient.resetWeatherOnClient());
        ClientPlayNetworking.registerGlobalReceiver(TornadoStatusPayload.ID, (packet, context) -> {
            if (!packet.living()) {
                boolean killAll = packet.killAll();
                UUID id = packet.id2();
                if (!killAll) {
                    if (id != null && ClientGlobal.activeTornadoSources.containsKey(id)) {
                        ClientGlobal.activeTornadoSources.remove(id);
                    }
                } else {
                    ClientGlobal.activeTornadoSources.clear();
                }
                recentTornadoDeathTime = 800;
            } else {
                UUID id = packet.id();
                double x = packet.x();
                double y = packet.y();
                double z = packet.z();
                class_243 vec = new class_243(x, y, z);
                byte type = packet.type();
                float strength = packet.strength();
                int cloudY = packet.height();
                boolean demon = packet.demon();
                if (!ClientGlobal.activeTornadoSources.containsKey(id)) {
                    ClientGlobal.activeTornadoSources.put(id, new ClientTornadoParticleSource(id, vec, cloudY, type, strength, demon));
                } else {
                    ClientGlobal.activeTornadoSources.replace(id, new ClientTornadoParticleSource(id, vec, cloudY, type, strength, demon));
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(TornadoMiscPayload.ID, (packet, context) -> {
            UUID id = packet.id();
            float xO = packet.xOffset();
            float zO = packet.zOffset();
            TornadoParticleSource source = ClientGlobal.activeTornadoSources.get(id);
            if (source != null && source instanceof ClientTornadoParticleSource) {
                ClientTornadoParticleSource cs = (ClientTornadoParticleSource)source;
                cs.xOffset = xO;
                cs.zOffset = zO;
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(WindStatusPayload.ID, (packet, context) -> {
            class_310 client = context.client();
            if (!packet.world()) {
                if (client.field_1724 == null) {
                    return;
                }
                class_5819 random = class_5819.method_43047();
                float vol = packet.vol();
                float pitch = packet.pitch();
                String info = packet.soundData();
                String[] parts = info.split(":");
                String data = parts[0];
                int id = Integer.parseInt(parts[1]);
                class_1297 entity = client.field_1687.method_8469(id);
                StormSoundInfo ssi = StormSoundInfo.getExisting(data);
                if (inCluster && ssi.getName().contains("blow")) {
                    ssi = WeatherClassic.GALE_WIND.getSound(random);
                }
                class_1106 instance = new class_1106(ssi.getSoundEvent(), class_3419.field_15252, vol, pitch, (class_1297)(entity != null ? entity : client.field_1724), random.method_43055());
                if (!context.client().method_1483().method_4877((class_1113)instance)) {
                    context.client().method_1483().method_4873((class_1113)instance);
                }
            } else {
                float angle = packet.angle();
                float strength = packet.strength();
                boolean windy = packet.windy();
                boolean gusty = packet.gusty();
                boolean gale = packet.gale();
                short clCountdown = packet.clCountdown();
                boolean ghastly = packet.ghastly();
                short gustTime = packet.windGust();
                ClientGlobal.windAngle = angle;
                ClientGlobal.windStrength = strength;
                ClientGlobal.windy = windy;
                ClientGlobal.gusty = gusty;
                ClientGlobal.gale = gale;
                ClientGlobal.ghastlyGale = ghastly;
                ClientGlobal.windGustTime = gustTime;
                ClientGlobal.clusterCountdown = clCountdown;
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(WeatherStatusPayload.ID, (packet, context) -> {
            byte stormStage;
            boolean downpour = packet.downpour();
            boolean severe = packet.severeStorm();
            short stormTransitionTicks = packet.stormTransitionTicks();
            short downpourTransitionTicks = packet.downpourTransitionTicks();
            ClientGlobal.stormStage = stormStage = packet.stormStage();
            ClientGlobal.downpour = downpour;
            ClientGlobal.severeStorm = severe;
            ClientGlobal.severeStormTransitionTicks = stormTransitionTicks;
            ClientGlobal.downpourTransitionTicks = downpourTransitionTicks;
        });
        ClientPlayNetworking.registerGlobalReceiver(StormIntensityPayload.ID, (packet, context) -> {
            boolean dying = packet.stormDying();
            float intensity = packet.stormIntensity();
            int time = packet.stormTime();
            ClientGlobal.stormDying = dying;
            ClientGlobal.stormIntensity = intensity;
            ClientGlobal.rainTime = time;
        });
        ClientPlayNetworking.registerGlobalReceiver(TornadoStatusPayload.ID, (packet, context) -> {
            if (!packet.living()) {
                boolean killAll = packet.killAll();
                UUID id = packet.id2();
                if (!killAll) {
                    if (id != null && ClientGlobal.activeTornadoSources.containsKey(id)) {
                        ClientGlobal.activeTornadoSources.remove(id);
                    }
                } else {
                    ClientGlobal.activeTornadoSources.clear();
                }
            } else {
                UUID id = packet.id();
                double x = packet.x();
                double y = packet.y();
                double z = packet.z();
                class_243 vec = new class_243(x, y, z);
                byte type = packet.type();
                float strength = packet.strength();
                int cloudY = packet.height();
                boolean demon = packet.demon();
                if (!ClientGlobal.activeTornadoSources.containsKey(id)) {
                    ClientGlobal.activeTornadoSources.put(id, new ClientTornadoParticleSource(id, vec, cloudY, type, strength, demon));
                } else {
                    ClientGlobal.activeTornadoSources.replace(id, new ClientTornadoParticleSource(id, vec, cloudY, type, strength, demon));
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(TornadoDirectionalWindSoundPayload.ID, (packet, context) -> {
            class_1297 ent;
            boolean tear = packet.tear();
            float vol = packet.vol();
            float pitch = packet.pitch();
            int id = packet.id();
            class_310 client = context.client();
            boolean tooClose = packet.tooClose();
            if (tooClose) {
                if (tear) {
                    return;
                }
                vol /= 2.0f;
            }
            if ((ent = client.field_1687.method_8469(id)) == null) {
                return;
            }
            if (ent instanceof TornadoEntity) {
                TornadoEntity torn = (TornadoEntity)ent;
                if (torn.getTornadoType() > TornadoStats.Type.STAGE3.getByte()) {
                    client.field_1687.method_8486(ent.method_23317(), ent.method_23318(), ent.method_23321(), tear ? WeatherClassic.TORNADO_TEAR_DIRECTIONAL : WeatherClassic.TORNADO_WIND_DIRECTIONAL, class_3419.field_15252, tooClose ? vol / 2.0f : vol, pitch, false);
                } else {
                    client.field_1687.method_55116(ent, tear ? WeatherClassic.TORNADO_TEAR_DIRECTIONAL : WeatherClassic.TORNADO_WIND_DIRECTIONAL, class_3419.field_15252, tooClose ? vol / 2.0f : vol, pitch);
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(TurbineSoundPayload.ID, (packet, context) -> {
            class_2338 pos = packet.pos();
            TurbineSoundInstance instance = new TurbineSoundInstance(pos);
            boolean forceOff = packet.off();
            if (forceOff) {
                context.client().method_1483().method_4870((class_1113)instance);
            } else if (!context.client().method_1483().method_4877((class_1113)instance)) {
                context.client().method_1483().method_4873((class_1113)instance);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ItemEntityVelocityPayload.ID, (packet, context) -> {
            class_310 client = context.client();
            class_1297 ent = client.field_1687.method_8469(packet.id());
            if (ent != null) {
                ent.method_5762(packet.velX(), 0.0, packet.velZ());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(WindCorePayload.ID, (packet, context) -> {
            UUID id = packet.playerID();
            class_243 pos = packet.pos();
            byte info = packet.info();
            if (info < 0) {
                ClientGlobal.activeCoreTornadoSources.remove(id);
                return;
            }
            if (!ClientGlobal.activeCoreTornadoSources.containsKey(id)) {
                ClientGlobal.activeCoreTornadoSources.put(id, new ClientWindCoreParticleSource(id, pos, info));
            } else {
                ClientGlobal.activeCoreTornadoSources.replace(id, new ClientWindCoreParticleSource(id, pos, info));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(DebrisVelocityPayload.ID, (packet, context) -> {
            class_310 client = context.client();
            class_1297 ent = client.field_1687.method_8469(packet.id());
            if (ent != null) {
                ent.method_18800(packet.velX(), packet.velY(), packet.velZ());
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(DebrisParticlePayload.ID, (packet, context) -> {
            if (DebrisParticle.activeDebrisParticles > ModConfig.getMaxDebrisParticles()) {
                return;
            }
            class_310 client = context.client();
            class_638 world = client.field_1687;
            class_2338 pos = class_2338.method_10092((long)packet.pos());
            world.method_8466((class_2394)WCParticles.DEBRIS_PARTICLE, true, true, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0.0, 0.0, (double)packet.id());
        });
        ClientPlayNetworking.registerGlobalReceiver(ClusterStatusPayload.ID, (packet, context) -> {
            if (!packet.living()) {
                boolean killAll = packet.killAll();
                UUID id = packet.id2();
                if (!killAll) {
                    if (id != null && ClientGlobal.activeClusterSources.containsKey(id)) {
                        ClientGlobal.activeClusterSources.remove(id);
                    }
                } else {
                    ClientGlobal.activeClusterSources.clear();
                }
                recentTornadoDeathTime = 800;
            } else {
                UUID id = packet.id();
                if (id == null) {
                    return;
                }
                double x = packet.x();
                double y = packet.y();
                double z = packet.z();
                class_243 vec = new class_243(x, y, z);
                float strength = packet.strength();
                if (!ClientGlobal.activeClusterSources.containsKey(id)) {
                    ClientGlobal.activeClusterSources.put(id, new ClientClusterParticleSource(id, vec, strength));
                } else {
                    ClientGlobal.activeClusterSources.replace(id, new ClientClusterParticleSource(id, vec, strength));
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(CustomItemStatusPayload.ID, (packet, context) -> {
            class_2487 nbt = packet.compound();
            if (nbt.method_10545("umid") && nbt.method_10571("umid").isPresent()) {
                byte b = (Byte)nbt.method_10571("umid").get();
                switch (b) {
                    default: 
                }
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) return;
            if (client.field_1724 == null) {
                return;
            }
            class_638 world = client.field_1687;
            if (world.method_27983() != ClientGlobal.CURRENT_WORLD_KEY) {
                ClientGlobal.CURRENT_WORLD_KEY = world.method_27983();
            }
            if (world.method_8510() % 20L == 0L) {
                TornadoParticleSource c;
                hasNightVision = client.field_1724.method_6059(class_1294.field_5925);
                if (closestCluster != null && closestCluster.isRemoved()) {
                    closestCluster = null;
                } else if (!ClientGlobal.activeClusterSources.isEmpty() && closestCluster != (c = ClientGlobal.getClosestCluster(client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321(), 1024))) {
                    closestCluster = c;
                }
            }
            if (ModConfig.getDebug() && client.field_1687.method_27983() == class_1937.field_25179) {
                while (WeatherClassicClient.DEBUG_MENU_BINDING.method_1436() || WeatherClassicClient.DEBUG_MENU_BINDING_ALT.method_1436()) {
                    if (WeatherClassicClient.defaultDebugPage >= 0) {
                        client.method_1507((class_437)WeatherClassicClient.CUSTOM_TORNADO_SCREEN);
                        continue;
                    }
                    client.method_1507(WeatherClassicClient.DEBUG_MENU_SCREEN);
                }
            }
            if (client.method_1493()) {
                return;
            }
            ClientGlobal.tickWeatherFX();
            if (ClientGlobal.windGustTime > 0) {
                --ClientGlobal.windGustTime;
            }
            if (ClientGlobal.gusty && world.method_8510() % (long)(ClientGlobal.gale || !ClientGlobal.activeTornadoSources.isEmpty() ? 20 : ((double)ClientGlobal.windStrength > 0.025 ? 30 : 40)) == 0L && client.field_1687.method_27983() == class_1937.field_25179 && ClientGlobal.clientOutdoors) {
                float f = world.method_8409().method_43057();
                int n = ClientGlobal.gale ? 60 : 20;
                if (f < (float)n) {
                    for (int windCount = 0; windCount < (ClientGlobal.gale || !ClientGlobal.activeTornadoSources.isEmpty() ? 10 : 5); ++windCount) {
                        double tryX = 5 + world.field_9229.method_43048(15);
                        double tryZ = 5 + world.field_9229.method_43048(15);
                        tryX *= (double)(world.field_9229.method_43056() ? -1 : 1);
                        tryZ *= (double)(world.field_9229.method_43056() ? -1 : 1);
                        double tryY = (double)((float)world.field_9229.method_43048(10) * world.field_9229.method_43057()) + 0.5;
                        tryY *= (double)world.field_9229.method_43057() < 0.25 ? -1.0 : 1.0;
                        world.method_8406((class_2394)WCParticles.WIND_PARTICLE, tryX += client.field_1724.method_23317(), tryY += client.field_1724.method_23318(), tryZ += client.field_1724.method_23321(), 0.0, 0.0, 0.0);
                    }
                }
            }
            if (world.method_8510() % 200L == 0L) {
                ClientGlobal.activeCoreTornadoSources.clear();
                ClientGlobal.clientOutdoors = Wind.isOutsideInWindAreaClient(client.field_1724.method_33571(), (class_1937)world);
            }
            if (ClientGlobal.activeTornadoSources.isEmpty()) {
                seesTornado = false;
                nearbyTornado = false;
                if (recentTornadoDeathTime > 0) {
                    --recentTornadoDeathTime;
                }
                if (world.method_8510() % 800L == 0L) {
                    DebrisParticle.activeDebrisParticles = 0;
                    if (recentTornadoDeathTime <= 0) {
                        DebrisParticle.activeRotParticles = 0;
                    }
                }
                if (ClientGlobal.activeClusterSources.isEmpty()) {
                    canBeBlownByWind = false;
                    inCluster = false;
                    return;
                }
            }
            TornadoParticleSource closest = ClientGlobal.getClosestTornado(client.field_1724.method_33571());
            double dist = -1.0;
            if (closest != null) {
                dist = Utils.distanceXZ(client.field_1724.method_73189(), closest.getEmitter());
            }
            if (closest != null && closest instanceof ClientTornadoParticleSource) {
                ClientTornadoParticleSource tornado = (ClientTornadoParticleSource)closest;
                if (dist < (double)(closest.getStats().grabDistance + 72) && dist >= 0.0) {
                    if (((long)client.field_1724.method_5628() + world.method_8510()) % 40L == 0L) {
                        nearbyTornado = true;
                        seesTornado = TornadoRotator.canEntitySeeSource((class_1297)client.field_1724, tornado);
                        if (closest.getStrength() >= 100.0f) {
                            canBeBlownByWind = Wind.isSkyVisibleThroughLeaves((class_1937)world, client.field_1724.method_24515());
                            if (!canBeBlownByWind) {
                                canBeBlownByWind = Wind.isOutsideInWindArea(client.field_1724.method_33571(), (class_1937)world);
                            }
                        } else {
                            canBeBlownByWind = false;
                        }
                    }
                    if (!tornado.isInGrabRange(client.field_1724.method_73189())) {
                        if (!(dist <= (double)(closest.getStats().grabDistance + 72))) return;
                        if (!canBeBlownByWind) return;
                        if (Utils.inInvalidMode((class_1297)client.field_1724)) return;
                        int maxDist = closest.getStats().grabDistance + 72;
                        short minDist = closest.getStats().grabDistance;
                        float maxVel = TornadoRotator.getTornadoFarSuction(closest.getTornadoTypeForRotator(), false);
                        float t = (float)((dist - (double)minDist) / (double)(maxDist - minDist));
                        t = Math.max(0.0f, Math.min(1.0f, t));
                        float curVel = maxVel * (1.0f - t);
                        class_243 dif = client.field_1724.method_73189().method_1020(closest.getEmitter()).method_1029().method_1021((double)(-curVel));
                        client.field_1724.method_5762(dif.field_1352, 0.0, dif.field_1350);
                        return;
                    }
                    ClientPlayNetworking.send((class_8710)new PlayerVelocityPayload(client.field_1724.method_5667(), client.field_1724.field_3913.method_3128().field_1343, client.field_1724.field_3913.method_3128().field_1342, closest.getUuid()));
                    if (!(dist > (double)(closest.getStats().grabDistance - 5))) {
                        if (seesTornado) return;
                    }
                    if (!canBeBlownByWind) return;
                    if (Utils.inInvalidMode((class_1297)client.field_1724)) return;
                    class_243 dif = client.field_1724.method_73189().method_1020(closest.getEmitter()).method_1029().method_1021((double)(-TornadoRotator.getTornadoFarSuction(closest.getTornadoTypeForRotator(), false)));
                    client.field_1724.method_5762(dif.field_1352, 0.0, dif.field_1350);
                    return;
                }
            }
            if (seesTornado) {
                seesTornado = false;
            }
            if (closestCluster == null) return;
            TornadoParticleSource patt0$temp = closestCluster;
            if (!(patt0$temp instanceof ClientClusterParticleSource)) return;
            ClientClusterParticleSource cluster = (ClientClusterParticleSource)patt0$temp;
            if (((long)client.field_1724.method_5628() + world.method_8510()) % 40L == 0L) {
                dist = Utils.distanceXZ(client.field_1724.method_73189(), cluster.getEmitter());
                if ((double)cluster.getStrength() > 0.001 && dist < 64.0) {
                    canBeBlownByWind = Wind.isSkyVisibleThroughLeaves((class_1937)world, client.field_1724.method_24515());
                    if (!canBeBlownByWind) {
                        canBeBlownByWind = Wind.isOutsideInWindArea(client.field_1724.method_33571(), (class_1937)world);
                    }
                    inCluster = canBeBlownByWind;
                } else {
                    inCluster = canBeBlownByWind = false;
                }
            }
            if (!canBeBlownByWind) return;
            if (client.field_1724.method_5869()) return;
            if (Utils.inInvalidMode((class_1297)client.field_1724)) return;
            if (!client.field_1724.method_24828()) return;
            class_243 vector = ClientGlobal.getGlobalWindVectorForPositionClient(client.field_1724.method_73189());
            float mult = (float)(ClientGlobal.ghastlyGale ? 1.5 : 1.0);
            client.field_1724.method_5762(vector.field_1352 * (double)mult, 0.0, vector.field_1350 * (double)mult);
        });
        WCNetworkClient.registerCustomTornadoRecievers();
    }

    public static void sendCustomItemStatusPayload(class_2487 nbt, UUID id) {
        ClientPlayNetworking.send((class_8710)new CustomItemStatusPayload(nbt, id));
    }

    public static void sendTurbineStatePayload(class_2338 pos, byte range) {
        ClientPlayNetworking.send((class_8710)new TurbineStatePayload(range, pos));
    }

    public static void sendDebugMenuPayload(byte b, class_310 client) {
        ClientPlayNetworking.send((class_8710)new DebugMenuPayload(b, client.field_1724.method_5667()));
    }

    public static void sendCustomTornadoSpawnPayload() {
        ClientPlayNetworking.send((class_8710)new CustomTornadoAIPayload(ClientCustomTornadoConfig.getSpeed(), ClientCustomTornadoConfig.getRipType(true), ClientCustomTornadoConfig.getTime(), ClientCustomTornadoConfig.getPullType(true), ClientCustomTornadoConfig.getScaling(), ClientCustomTornadoConfig.getDestructionLvlOverride(), ClientCustomTornadoConfig.getChasePlayers(), true));
    }

    public static void sendCustomTornadoAIPayload(short speed, byte ripType, short time, byte pullType, float resistance, byte override, boolean chase) {
        ClientPlayNetworking.send((class_8710)new CustomTornadoAIPayload(speed, ripType, time, pullType, resistance, override, chase, false));
    }

    public static void sendCustomTornadoExtrasPayload(short particleInterval, byte particleDistance, boolean clouds, boolean color, boolean cloudColor, Vector3f colors, boolean takeColor, int sound, byte passiveSound) {
        ClientPlayNetworking.send((class_8710)new CustomTornadoExtrasPayload(particleInterval, particleDistance, clouds, color, cloudColor, colors, takeColor, sound, passiveSound));
    }

    public static void sendCustomTornadoParticlesPayload(byte particleCount, float baseInc, float bottomInc, float midInc, float topInc) {
        ClientPlayNetworking.send((class_8710)new CustomTornadoParticlesPayload(particleCount, baseInc, bottomInc, midInc, topInc));
    }

    public static void sendCustomTornadoShapePayload(byte particleRadius, short funnelWidth, byte pointedness, float tightening, float scaling) {
        ClientPlayNetworking.send((class_8710)new CustomTornadoShapePayload(particleRadius, funnelWidth, pointedness, tightening, scaling));
    }

    public static void sendCustomTornadoSpawningPayload(byte weatherEvent, float spawningPercent, byte biomeLock, byte switchType) {
        ClientPlayNetworking.send((class_8710)new CustomTornadoSpawningPayload(weatherEvent, spawningPercent, biomeLock, switchType));
    }

    public static void sendC2SGlobalComsPayload(byte b, String s) {
        ClientPlayNetworking.send((class_8710)new C2SGlobalCommunicationPayload(b, s));
    }

    public static void sendAssemblerUpdatePayload(class_2338 pos, boolean activate, byte oX, byte oY, byte oZ) {
        ClientPlayNetworking.send((class_8710)new AssemblerUpdatePayload(pos.method_10063(), activate, oX, oY, oZ));
    }

    private static void resetWeatherOnClient() {
        closestCluster = null;
        ClientGlobal.activeTornadoSources.clear();
        ClientGlobal.gusty = false;
        ClientGlobal.windy = false;
        ClientGlobal.windAngle = 0.0f;
        ClientGlobal.windStrength = 0.0f;
        ClientGlobal.downpour = false;
        ClientGlobal.severeStorm = false;
        ClientGlobal.severeStormTransitionTicks = 0;
        ClientGlobal.downpourTransitionTicks = 0;
        ClientGlobal.activeCoreTornadoSources.clear();
        ClientGlobal.activeClusterSources.clear();
        StormParticle.activeRotParticles = 0;
        DebrisParticle.activeDebrisParticles = 0;
        hasNightVision = false;
        inCluster = false;
        seesTornado = false;
        canBeBlownByWind = false;
        nearbyTornado = false;
        WeatherClassicClient.debugInfoStuck = false;
    }

    private static void registerCustomTornadoRecievers() {
        ClientPlayNetworking.registerGlobalReceiver(CustomTornadoAIPayload.ID, (packet, context) -> {
            short speed = packet.speed();
            byte pullType = packet.pullType();
            byte ripType = packet.ripType();
            float dResistance = packet.dispellerResistance();
            short time = packet.time();
            byte override = packet.destructionOverride();
            boolean chase = packet.chase();
            ClientCustomTornadoConfig.setChasePlayers(chase);
            ClientCustomTornadoConfig.setDestructionLvlOverride(override);
            ClientCustomTornadoConfig.setSpeed(speed);
            ClientCustomTornadoConfig.setTime(time);
            ClientCustomTornadoConfig.setPullType(pullType);
            ClientCustomTornadoConfig.setRipType(ripType);
            ClientCustomTornadoConfig.setDispellerResistance(dResistance);
        });
        ClientPlayNetworking.registerGlobalReceiver(CustomTornadoShapePayload.ID, (packet, context) -> {
            short width = packet.funnelWidth();
            byte particleRadius = packet.particleRadius();
            byte pointedness = packet.pointedness();
            float tightening = packet.tightening();
            float scaling = packet.scaling();
            ClientCustomTornadoConfig.setScaling(scaling);
            ClientCustomTornadoConfig.setFunnelWidth(width);
            ClientCustomTornadoConfig.setParticleRadiusLvl(particleRadius);
            ClientCustomTornadoConfig.setFunnelPointedness(pointedness);
            ClientCustomTornadoConfig.setFunnelTightening(tightening);
        });
        ClientPlayNetworking.registerGlobalReceiver(CustomTornadoExtrasPayload.ID, (packet, context) -> {
            byte extraParticleDist = packet.particleDistance();
            short extraParticleInterval = packet.particleInterval();
            boolean cloudColor = packet.cloudColor();
            boolean colorOverride = packet.color();
            Vector3f colors = packet.colors();
            boolean spawnClouds = packet.clouds();
            boolean surroundingColor = packet.getColorsAround();
            int soundDist = packet.soundDist();
            byte soundType = packet.passiveSound();
            ClientCustomTornadoConfig.setPassiveeSoundType(soundType);
            ClientCustomTornadoConfig.setSoundDist(soundDist);
            ClientCustomTornadoConfig.setTakeSurroundingColor(surroundingColor);
            ClientCustomTornadoConfig.setExtraParticleDistance(extraParticleDist);
            ClientCustomTornadoConfig.setExtraParticleInterval(extraParticleInterval);
            ClientCustomTornadoConfig.setCloudColorOverride(cloudColor);
            ClientCustomTornadoConfig.setColorOverride(colorOverride);
            ClientCustomTornadoConfig.setCreateClouds(spawnClouds);
            ClientCustomTornadoConfig.setRed(colors.x);
            ClientCustomTornadoConfig.setGreen(colors.y);
            ClientCustomTornadoConfig.setBlue(colors.z);
        });
        ClientPlayNetworking.registerGlobalReceiver(CustomTornadoParticlesPayload.ID, (packet, context) -> {
            float baseInc = packet.baseInc();
            byte particleCount = packet.particleCount();
            float bottomInc = packet.bottomInc();
            float midInc = packet.midInc();
            float topInc = packet.topInc();
            ClientCustomTornadoConfig.setBaseParticleSizeIncrease(baseInc);
            ClientCustomTornadoConfig.setParticleCount(particleCount);
            ClientCustomTornadoConfig.setBottomParticleSizeIncrease(bottomInc);
            ClientCustomTornadoConfig.setMidParticleSizeIncrease(midInc);
            ClientCustomTornadoConfig.setTopParticleSizeIncrease(topInc);
        });
        ClientPlayNetworking.registerGlobalReceiver(CustomTornadoSpawningPayload.ID, (packet, context) -> {
            byte switchType;
            byte weatherEventType = packet.weatherEventType();
            byte biomeLockType = packet.biomeLock();
            float spawnPercent = packet.spawnPercent();
            ClientGlobal.customTornadoSwitchType = switchType = packet.switchType();
            ClientCustomTornadoConfig.setWeatherEventType(weatherEventType);
            ClientCustomTornadoConfig.setBiomeLockType(biomeLockType);
            ClientCustomTornadoConfig.setSpawnPercent(spawnPercent);
        });
        ClientPlayNetworking.registerGlobalReceiver(CustomTornadoSwitchPayload.ID, (packet, context) -> {
            boolean usingAlt;
            ClientCustomTornadoConfig.USING_ALT = usingAlt = packet.alt();
        });
    }
}

