/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2400;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.TornadoWindParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class TornadoParticle
extends StormParticle {
    protected final float colorValue;
    private final boolean glow;
    private int animTime = 0;
    private final class_4002 pr;

    public TornadoParticle(class_638 clientWorld, double x, double y, double z, double vx, double vy, double vz, class_4002 pr) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0, pr);
        this.method_3077(200);
        this.method_3087(1.0f);
        int i = (int)vy;
        this.colorValue = i;
        this.glow = TornadoEntity.TornadoColor.get(this.colorValue) == TornadoEntity.TornadoColor.FIRE;
        this.pr = pr;
    }

    @Override
    protected void getParticleRotator() {
        Optional<StormParticleRotator> r;
        TornadoParticleSource source = ClientTornadoParticleSource.getFor(this);
        if (source != null && (r = ClientTornadoParticleSource.getParticleRotator(source)).isPresent()) {
            this.rotator = r.get();
            this.rotator.prepare(this, this instanceof TornadoWindParticle);
            return;
        }
        this.setDead();
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (this.isFog()) {
            ++this.animTime;
            if (this.animTime > 20) {
                this.animTime = 0;
            }
            this.method_74307(this.pr.method_18138(this.animTime, 20));
        }
    }

    @Override
    public class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    @Override
    protected boolean manualKillCondition() {
        return this.getY() > (double)(this.getCastedRotator().getSource().getCloudY() + (this.getCastedRotator().getSource().isSpout() || this.getCastedRotator().getSource().isCellDemon() ? 50 : 5));
    }

    @Override
    public float getSpecialColorValue() {
        return this.colorValue;
    }

    @Override
    public boolean manuallySetPosFromMotion() {
        return true;
    }

    @Override
    protected boolean emissOption() {
        return this.glow || super.emissOption();
    }

    protected StormParticleRotator getCastedRotator() {
        return (StormParticleRotator)this.rotator;
    }

    public boolean isFog() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_5819 random) {
            return new TornadoParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

