/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.clusters;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCParticles;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoStats;
import org.joml.Vector3f;

public class StormClusterPE {
    private final class_3218 world;
    private class_243 pos;
    private float clusterStrength;
    public int age = 0;
    private class_1923 chunkPos;
    private class_2338.class_2339 blockPos;
    private boolean removed = false;
    private final class_5819 random;
    private final UUID uuid;
    private float strengthCap;
    private float[] subCaps = new float[5];
    private float baseStrengthInc;
    private int maxAge;
    private class_243 problemRangePlayer = null;
    private boolean freezeStorm = false;
    public TornadoEntity tornado = null;
    private boolean spawnTornadoIfDying;
    private int ephemeralAge = 0;

    public StormClusterPE(class_3218 world, int x, int z, int y, float cap) {
        this.world = world;
        this.pos = new class_243((double)x, (double)y, (double)z);
        this.blockPos = BP.of(this.pos).method_25503();
        this.clusterStrength = 0.0f;
        this.chunkPos = new class_1923(this.blockPos.method_10062());
        this.random = world.method_8409();
        this.uuid = UUID.randomUUID();
        this.clusterStrength = 0.0f;
        this.maxAge = 6000 + this.random.method_43048(18000);
        this.spawnTornadoIfDying = (double)this.random.method_43057() < 0.12;
        this.strengthCap = cap > 0.0f ? cap : this.getRandomStrengthCap();
        for (int i = 0; i < 5; ++i) {
            this.subCaps[i] = switch (i) {
                case 1 -> this.getRandomGaleStrength();
                case 2 -> this.getRandomSimpleStormStrength();
                case 3 -> this.getRandomStrongStormStrength();
                case 4 -> this.getRandomInsaneStrength();
                default -> this.getRandomChillStrength();
            };
        }
        if (cap == -1.0f) {
            this.clusterStrength = this.getCurrentCap();
        }
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setMaxAge(int age) {
        this.maxAge = age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean canSupportTornado() {
        return (double)this.clusterStrength > 0.5 && (double)this.strengthCap > 0.5;
    }

    public boolean canSupportTornadoType(TornadoStats.Type type) {
        if (type == TornadoStats.Type.STAGE5) {
            return (double)this.clusterStrength > 0.85 && (double)this.strengthCap > 0.85;
        }
        if (type == TornadoStats.Type.STAGE4) {
            return (double)this.clusterStrength > 0.75 && (double)this.strengthCap > 0.75;
        }
        if (type == TornadoStats.Type.STAGE3) {
            return (double)this.clusterStrength > 0.65 && (double)this.strengthCap > 0.65;
        }
        return (double)this.clusterStrength > 0.5 && (double)this.strengthCap > 0.5;
    }

    private float getRandomChillStrength() {
        float min = 0.05f;
        float max = 0.35f;
        return min + this.world.field_9229.method_43057() * (max - min);
    }

    private float getRandomGaleStrength() {
        float min = 0.35f;
        float max = 0.45f;
        return min + this.world.field_9229.method_43057() * (max - min);
    }

    private float getRandomSimpleStormStrength() {
        float min = 0.45f;
        float max = 0.65f;
        return min + this.world.field_9229.method_43057() * (max - min);
    }

    private float getRandomStrongStormStrength() {
        float min = 0.65f;
        float max = 0.85f;
        return min + this.world.field_9229.method_43057() * (max - min);
    }

    private float getRandomInsaneStrength() {
        float min = 0.85f;
        float max = 1.0f;
        return min + this.world.field_9229.method_43057() * (max - min);
    }

    public float getCurrentCap() {
        if (this.world.method_8419() || Global.wind.isGale()) {
            if (this.world.method_8546()) {
                if (Global.weather.isGreaterStormStage()) {
                    if (Global.weather.isStormStage5()) {
                        return this.subCaps[4];
                    }
                    return this.subCaps[3];
                }
                return this.subCaps[2];
            }
            return this.subCaps[1];
        }
        return this.subCaps[0];
    }

    private float getRandomStrengthCap() {
        if ((double)this.world.field_9229.method_43057() < 0.27) {
            int r = this.random.method_43048(5);
            return switch (r) {
                case 1 -> this.getRandomGaleStrength();
                case 2 -> this.getRandomSimpleStormStrength();
                case 3 -> this.getRandomStrongStormStrength();
                case 4 -> this.getRandomInsaneStrength();
                default -> this.getRandomChillStrength();
            };
        }
        return 1.0f;
    }

    public float getStrengthCap() {
        return this.strengthCap;
    }

    public void setStrength(float str) {
        this.clusterStrength = str;
    }

    public void spawnCluster() {
        Global.activeClusters.add(this);
    }

    public boolean playersInOtherDimension() {
        if (!this.world.method_18456().isEmpty()) {
            return false;
        }
        boolean fullOther = false;
        for (class_3218 w : this.world.method_8503().method_3738()) {
            if (w.method_27983() == class_1937.field_25179 || w.method_18456().isEmpty()) continue;
            fullOther = true;
            break;
        }
        return !this.world.method_8503().method_3760().method_14571().isEmpty() && fullOther;
    }

    public void tick() {
        if (this.age++ > this.maxAge) {
            this.killStorm();
            return;
        }
        ++this.ephemeralAge;
        if (this.age % 10 == 0) {
            class_1923 cpos = this.world.method_22350((class_2338)this.blockPos).method_12004();
            if (!cpos.equals((Object)this.chunkPos)) {
                this.chunkPos = cpos;
            }
            double y = this.world.method_67393(class_2902.class_2903.field_13197, this.getBlockPos()) + 86;
            if (this.ephemeralAge > 20) {
                y = this.pos.field_1351 < y ? this.pos.field_1351 + 0.5 : (this.pos.field_1351 > y ? this.pos.field_1351 - 0.5 : this.pos.field_1351);
            }
            if (this.tornado != null) {
                if (this.tornado.method_31481()) {
                    this.tornado = null;
                    return;
                }
                this.pos = new class_243(this.tornado.method_23317(), y, this.tornado.method_23321());
                this.blockPos.method_33098((int)y);
                this.blockPos.method_33097((int)this.tornado.method_23317());
                this.blockPos.method_33099((int)this.tornado.method_23321());
            } else {
                double distOld;
                double dist;
                boolean ok;
                Vector3f windMotion = Global.getSimpleGlobalWindVector().mul(15.0f);
                double dx = this.pos.field_1352 + (double)windMotion.x;
                double dz = this.pos.field_1350 + (double)windMotion.z;
                boolean bl = ok = !this.freezeStorm;
                if (this.problemRangePlayer != null && (dist = Utils.distanceXZ(dx, 0.0, dz, this.problemRangePlayer)) >= (distOld = Utils.distanceXZ(this.pos, this.problemRangePlayer)) && (dist = Utils.distanceXZ(dx = this.pos.field_1352 + (double)(-windMotion.x), 0.0, dz = this.pos.field_1350 + (double)(-windMotion.z), this.problemRangePlayer)) >= distOld) {
                    ok = false;
                }
                if (ok) {
                    this.pos = new class_243(dx, y, dz);
                    this.blockPos.method_33097((int)dx);
                    this.blockPos.method_33099((int)dz);
                }
            }
            if (this.age % 100 == 0) {
                if (Global.overMaxClusters() && Global.activeClusters.get(0) == this) {
                    this.killStorm();
                    return;
                }
                this.freezeStorm = false;
                class_1657 pl = this.world.method_8604(this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, (double)(ModConfig.getMaxTornadoLoadDist() * 2), p -> p != null);
                if (pl == null) {
                    if (this.playersInOtherDimension()) {
                        this.freezeStorm = true;
                    } else {
                        this.killStorm();
                    }
                    return;
                }
                if (Utils.distanceXZ(this.getBlockPos(), pl.method_24515()) > (double)Math.max(128, ModConfig.getMaxTornadoLoadDist())) {
                    this.problemRangePlayer = pl.method_73189();
                } else if (this.problemRangePlayer != null) {
                    this.problemRangePlayer = null;
                }
                float cap = this.getCurrentCap();
                float base = cap / 70.0f;
                float r = 0.8f + this.random.method_43057();
                if (this.tornado != null) {
                    r = 1.2f;
                }
                this.baseStrengthInc = base * r;
                if (this.clusterStrength < cap) {
                    if (this.strengthCap < cap) {
                        this.clusterStrength = (double)this.random.method_43057() < 0.5 ? (this.clusterStrength -= this.baseStrengthInc) : (this.clusterStrength += this.baseStrengthInc);
                        this.clusterStrength = Math.min(this.strengthCap, this.clusterStrength);
                    } else {
                        this.clusterStrength = (double)this.random.method_43057() < 0.1 ? (this.clusterStrength -= this.baseStrengthInc) : (this.clusterStrength += this.baseStrengthInc);
                        this.clusterStrength = Math.min(cap, this.clusterStrength);
                    }
                } else if ((double)this.random.method_43057() < 0.75) {
                    this.clusterStrength = (float)((double)this.clusterStrength - 0.01);
                } else if ((double)this.clusterStrength > 0.5 && this.spawnTornadoIfDying && !this.world.method_8546() && this.tornado == null) {
                    this.killStorm();
                    TornadoEntity tornado = new TornadoEntity(TornadoEntity.getEntityTypeFrom((byte)1), (class_1937)this.world).enable();
                    tornado.method_60949(this.pos, 0.0f, 0.0f);
                    tornado.skipBinding = true;
                    Global.forceChunksForTornadoSpawn(this.world, tornado, cpos);
                    this.world.method_8649((class_1297)tornado);
                    return;
                }
                this.clusterStrength = Math.max(0.0f, this.clusterStrength);
            }
        }
        if (this.freezeStorm) {
            return;
        }
        if (this.getStrength() > 0.5f || this.random.method_43057() < this.getCloudDensity() && this.ephemeralAge > 20) {
            for (int cloudCount = 0; cloudCount < (this.isStrong() ? 2 : 1); ++cloudCount) {
                Utils.forceImportantParticles(this.world, WCParticles.STORM_CLOUD_PARTICLE, this.pos.field_1352 + (double)this.random.method_43048(64) - (double)this.random.method_43048(64), this.pos.field_1351, this.pos.field_1350 + (double)this.random.method_43048(64) - (double)this.random.method_43048(64), 0, 0.0, -1.0, 0.0, 100.0);
            }
        }
    }

    public float getCloudDensity() {
        return this.getStrength() + 0.1f;
    }

    public boolean isStrong() {
        return this.getStrength() > 0.7f;
    }

    public boolean isWithinRadius(class_2338 pos) {
        return Utils.squaredDistanceTo(this.getBlockPos(), pos) < 16384.0;
    }

    public class_1923 getChunkPos() {
        return this.chunkPos;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public class_243 getEntityPos() {
        return this.pos;
    }

    public UUID getId() {
        return this.uuid;
    }

    public float getStrength() {
        return this.clusterStrength;
    }

    public void killStorm() {
        this.removed = true;
    }
}

