/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.source;

import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.StormCloudParticleRotator;
import net.weather_classic.particle.rotator.TornadoParticleRotator;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoRipper;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class ClientTornadoParticleSource
implements TornadoParticleSource {
    private class_243 emitter;
    private final UUID id;
    private float strength;
    private int cloudY;
    private final byte type;
    private final TornadoStats stats;
    private final Optional<StormParticleRotator> particleRotator;
    private final Optional<StormParticleRotator> cloudRotator;
    private final boolean demon;
    private class_238 grabBox;
    public float xOffset = 0.0f;
    public float zOffset = 0.0f;

    public ClientTornadoParticleSource(UUID id, class_243 vec, int cloudY, byte type, float strength, boolean demon) {
        this.id = id;
        this.emitter = vec;
        this.cloudY = cloudY;
        this.type = type;
        this.strength = strength;
        TornadoStats.Type t = TornadoEntity.getTornadoTypeFrom(type);
        if (ClientGlobal.activeTornadoSources.containsKey(id)) {
            TornadoParticleSource source = ClientGlobal.activeTornadoSources.get(id);
            if (((ClientTornadoParticleSource)source).particleRotator.isPresent()) {
                this.xOffset = ((ClientTornadoParticleSource)source).xOffset;
                this.zOffset = ((ClientTornadoParticleSource)source).zOffset;
                this.particleRotator = ((ClientTornadoParticleSource)source).particleRotator;
                this.particleRotator.get().setSource(this);
            } else {
                this.particleRotator = Optional.of(new TornadoParticleRotator(this));
            }
            this.stats = TornadoStats.get(t, this.xOffset != 0.0f || this.zOffset != 0.0f);
            if (this.stats.createClouds) {
                if (((ClientTornadoParticleSource)source).cloudRotator.isPresent()) {
                    this.cloudRotator = ((ClientTornadoParticleSource)source).cloudRotator;
                    this.cloudRotator.get().setSource(this);
                } else {
                    this.cloudRotator = Optional.of(new StormCloudParticleRotator(this));
                }
            } else {
                this.cloudRotator = Optional.empty();
            }
        } else {
            this.stats = TornadoStats.get(t, this.xOffset != 0.0f || this.zOffset != 0.0f);
            this.particleRotator = Optional.of(new TornadoParticleRotator(this));
            this.cloudRotator = this.stats.createClouds ? Optional.of(new StormCloudParticleRotator(this)) : Optional.empty();
        }
        this.grabBox = new class_238(BP.of(vec).method_10086(32)).method_1009((double)this.getPullRadius(), 64.0, (double)this.getPullRadius());
        this.demon = demon;
    }

    public boolean isInGrabRange(class_243 vec) {
        return this.grabBox.method_1006(vec);
    }

    @Override
    public class_243 getEmitter() {
        return this.emitter;
    }

    @Override
    public boolean isRemoved() {
        return !ClientGlobal.activeTornadoSources.containsKey(this.id);
    }

    @Override
    public int getCloudY() {
        return this.cloudY;
    }

    @Override
    public TornadoStats getStats() {
        return this.stats;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public UUID getUuid() {
        return this.id;
    }

    public static TornadoParticleSource getFor(StormParticle particle) {
        for (UUID id : ClientGlobal.activeTornadoSources.keySet()) {
            int dist;
            TornadoParticleSource source = ClientGlobal.activeTornadoSources.get(id);
            int range = source.getTornadoType() > 4 ? ClientCustomTornadoConfig.getTornadoParticleFindRangeFromLvl() : source.getStats().particleGetRange;
            int n = dist = !particle.isTornadoParticlePlain() ? range + 25 : range;
            if (!(Utils.squaredDistanceXZ(particle.getX(), particle.getZ(), source.getEmitter()) < (double)(dist * dist)) || source.isRemoved()) continue;
            return source;
        }
        return null;
    }

    @Override
    public int getPullRadius() {
        return this.stats.grabDistance;
    }

    public static Optional<StormParticleRotator> getParticleRotator(TornadoParticleSource source) {
        if (!(source instanceof ClientTornadoParticleSource)) {
            return Optional.empty();
        }
        return ((ClientTornadoParticleSource)source).particleRotator;
    }

    public static Optional<StormParticleRotator> getCloudRotator(TornadoParticleSource source) {
        if (!(source instanceof ClientTornadoParticleSource)) {
            return Optional.empty();
        }
        return ((ClientTornadoParticleSource)source).cloudRotator;
    }

    @Override
    public boolean isDemonic() {
        if (this.type == 5) {
            return false;
        }
        return this.demon;
    }

    @Override
    public boolean isDestructiveStorm() {
        return this.getTornadoType() > 4 ? TornadoRipper.RipType.fromByte(ClientCustomTornadoConfig.getRipType(false)) != TornadoRipper.RipType.NONE : this.getStats().ripType != TornadoRipper.RipType.NONE;
    }

    @Override
    public byte getTornadoType() {
        return this.type;
    }

    @Override
    public boolean isSpout() {
        return this.type == 0;
    }

    @Override
    public byte getTornadoTypeForRotator() {
        if (this.getTornadoType() == TornadoStats.Type.STAGEX.getByte()) {
            return ClientCustomTornadoConfig.getPullType(false);
        }
        return this.getTornadoType();
    }
}

