/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block;

import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import net.minecraft.class_10225;
import net.minecraft.class_10774;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCBlocks;

public class PuddleBlock
extends class_2373 {
    public static final MapCodec<PuddleBlock> CODEC = PuddleBlock.method_54094(PuddleBlock::new);
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final HashSet<class_2248> replaceableBlocks = new HashSet();
    public static final class_2758 FLOOD_DIST = class_2758.method_11867((String)"flood_dist", (int)0, (int)4);

    public PuddleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FLOOD_DIST, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends PuddleBlock> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FLOOD_DIST});
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_31574(class_1802.field_8469)) {
            if (stack.method_7947() > 1) {
                class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991));
            } else {
                if (!player.method_68878()) {
                    stack.method_7934(1);
                }
                player.method_31548().method_7394(class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991));
            }
            world.method_43128((class_1297)player, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14779, class_3419.field_15254, 1.0f, 1.0f);
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28167, pos);
            world.method_8501(pos, class_2246.field_10124.method_9564());
            return class_1269.field_5812;
        }
        return class_1269.field_52423;
    }

    protected class_1799 fill(class_1799 stack, class_1657 player, class_1799 outputStack) {
        player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        return class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)outputStack);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        if (!(entity.method_21749() || entity.method_31747() && entity.field_6037)) {
            entity.method_18799(entity.method_18798().method_18805(0.8, 1.0, 0.8));
        }
        if (world.method_8608()) {
            return;
        }
        if (entity.method_31747() && entity.method_60478().method_1033() < 0.05) {
            return;
        }
        if (!entity.method_31747() && Utils.isVelocityZero(entity)) {
            return;
        }
        int s = (int)(entity.method_60478().method_1033() * 200.0);
        s += 10;
        int sprint = (s += Global.weather.isDownpour() ? 2 : 0) - 2;
        s = class_3532.method_15340((int)s, (int)6, (int)30);
        sprint = class_3532.method_15340((int)sprint, (int)6, (int)30);
        if (entity.method_31747()) {
            s = 10;
            sprint = (s += Global.weather.isDownpour() ? 2 : 0) - 2;
        }
        if (!world.method_8608() && entity.field_6012 % (entity.method_5624() ? sprint : s) == 0 && !entity.method_5715() && Math.abs(entity.method_23318() - (double)pos.method_10264()) < 0.5) {
            double dx = world.field_9229.method_43057() / 2.0f * (float)(world.field_9229.method_43056() ? -1 : 1);
            double dz = world.field_9229.method_43057() / 2.0f * (float)(world.field_9229.method_43056() ? -1 : 1);
            ((class_3218)world).method_65096((class_2394)class_2398.field_11202, entity.method_23317() + dx, entity.method_23318() + 0.3, entity.method_23321() + dz, 0, 0.0, 0.0, 0.0, 0.1);
            Utils.playSound(null, world, pos, WeatherClassic.SPLASH, class_3419.field_15245, !entity.method_31747() ? 0.1f : (Global.weather.isDownpour() ? 0.3f : 0.2f), 1.0f + world.field_9229.method_43057() / 2.0f);
        }
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!state.method_26184(world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        boolean valid;
        class_2680 pState = world.method_8320(pos);
        class_2248 block = pState.method_26204();
        boolean bl = valid = pState.method_26215() || block == WCBlocks.PUDDLE;
        if (!PuddleBlock.validBelow(world, world.method_8320(pos.method_10074()), pos.method_10074())) {
            valid = false;
        }
        return valid;
    }

    public static boolean validBelow(class_4538 world, class_2680 state, class_2338 pos) {
        if (state.method_27852(class_2246.field_10362)) {
            return true;
        }
        return !Materials.isLeaves(state) && state.method_26206((class_1922)world, pos, class_2350.field_11036) && !Materials.isShallowWater(state) && !Utils.canPassThrough(state.method_26204());
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10566) && (double)random.method_43057() < 0.5) {
            world.method_8501(pos.method_10074(), class_2246.field_37576.method_9564());
            world.method_8501(pos, class_2246.field_10124.method_9564());
        } else if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10253)) {
            world.method_8501(pos.method_10074(), class_2246.field_10566.method_9564());
        } else if ((double)random.method_43057() < 0.01 && world.method_8320(pos.method_10074()).method_27852(class_2246.field_10219)) {
            world.method_8501(pos.method_10074(), class_2246.field_10566.method_9564());
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        if (!world.method_8520(pos)) {
            boolean flood;
            boolean bl = flood = (Integer)state.method_11654((class_2769)FLOOD_DIST) > 0;
            if (flood && !Global.getAllActiveCustomTornadoes().isEmpty() && CustomTornadoConfig.getRipType(true) == 6) {
                return;
            }
            world.method_8501(pos, class_2246.field_10124.method_9564());
            if (!world.method_8419()) {
                for (class_2338 next : class_2338.method_25996((class_2338)pos, (int)4, (int)2, (int)4)) {
                    if (!world.method_8320(next).method_27852(WCBlocks.PUDDLE)) continue;
                    world.method_8501(next, class_2246.field_10124.method_9564());
                }
            }
        }
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int dist = (Integer)state.method_11654((class_2769)FLOOD_DIST) + 1;
        if (dist > 4 || dist == 1 || (double)random.method_43057() < 0.25) {
            return;
        }
        for (class_2350 d : class_2350.values()) {
            boolean validDown;
            if (d.method_10166() == class_2350.class_2351.field_11052) continue;
            class_2338 o = pos.method_10093(d);
            class_2680 ostate = world.method_8320(o);
            if (state.method_26184((class_4538)world, o) && !ostate.method_27852(WCBlocks.PUDDLE)) {
                world.method_8501(o, (class_2680)state.method_11657((class_2769)FLOOD_DIST, (Comparable)Integer.valueOf(dist)));
                world.method_64310(o, state.method_26204(), 5);
                continue;
            }
            boolean farm = world.method_8320(o.method_10074()).method_26204() == class_2246.field_10362;
            boolean bl = validDown = PuddleBlock.validBelow((class_4538)world, world.method_8320(o.method_10074()), o.method_10074()) || farm;
            if (!validDown) continue;
            boolean plantMisc = ostate.method_26204() instanceof class_2261;
            boolean replaceable = replaceableBlocks.contains(ostate.method_26204());
            if (!farm && !plantMisc && !replaceable) continue;
            if (farm) {
                world.method_8501(o.method_10074(), class_2246.field_37576.method_9564());
            }
            if (!ostate.method_26215()) {
                class_2248.method_9497((class_2680)ostate, (class_1937)world, (class_2338)pos);
            }
            world.method_8501(o, (class_2680)state.method_11657((class_2769)FLOOD_DIST, (Comparable)Integer.valueOf(dist)));
            world.method_64310(o, state.method_26204(), 5);
        }
    }

    static {
        replaceableBlocks.add(class_2246.field_10091);
        replaceableBlocks.add(class_2246.field_10363);
        replaceableBlocks.add(class_2246.field_10377);
        replaceableBlocks.add(class_2246.field_10450);
        replaceableBlocks.add(class_2246.field_28411);
        replaceableBlocks.add(class_2246.field_10523);
        replaceableBlocks.add(class_2246.field_10336);
    }
}

