/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.networking;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.weather_classic.WeatherClassic;
import net.weather_classic.block.TurbineBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.TornadoReviver;
import net.weather_classic.global.tools.WeatherExecutor;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.packet.C2SGlobalCommunicationPayload;
import net.weather_classic.networking.packet.ClusterStatusPayload;
import net.weather_classic.networking.packet.CustomItemStatusPayload;
import net.weather_classic.networking.packet.DebrisParticlePayload;
import net.weather_classic.networking.packet.DebugMenuPayload;
import net.weather_classic.networking.packet.ItemEntityVelocityPayload;
import net.weather_classic.networking.packet.PlayerVelocityPayload;
import net.weather_classic.networking.packet.StormIntensityPayload;
import net.weather_classic.networking.packet.TornadoDirectionalWindSoundPayload;
import net.weather_classic.networking.packet.TornadoStatusPayload;
import net.weather_classic.networking.packet.WeatherStatusPayload;
import net.weather_classic.networking.packet.WindStatusPayload;
import net.weather_classic.networking.packet.assembler.AssemblerUpdatePayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoAIPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoExtrasPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoParticlesPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoShapePayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoSpawningPayload;
import net.weather_classic.networking.packet.custom_tornado.CustomTornadoSwitchPayload;
import net.weather_classic.networking.packet.debris.DebrisVelocityPayload;
import net.weather_classic.networking.packet.turbine.TurbineSoundPayload;
import net.weather_classic.networking.packet.turbine.TurbineStatePayload;
import net.weather_classic.networking.packet.wind_core.WindCorePayload;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.clusters.StormClusterPE;
import net.weather_classic.storm.debris.DebrisEntity;
import net.weather_classic.storm.sound.StormSoundInfo;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class WCNetworkServer {
    private static byte updateCustomTornadoSettings = 0;
    private static byte prevCustomTornadoSwitchType = 0;
    private static byte forcePeriodicUpdate = 0;

    public static void setupServerNetwork() {
        PayloadTypeRegistry.playS2C().register(TornadoStatusPayload.ID, TornadoStatusPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(WindStatusPayload.ID, WindStatusPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(WeatherStatusPayload.ID, WeatherStatusPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(StormIntensityPayload.ID, StormIntensityPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TornadoDirectionalWindSoundPayload.ID, TornadoDirectionalWindSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TurbineSoundPayload.ID, TurbineSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomTornadoAIPayload.ID, CustomTornadoAIPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomTornadoParticlesPayload.ID, CustomTornadoParticlesPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomTornadoExtrasPayload.ID, CustomTornadoExtrasPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomTornadoShapePayload.ID, CustomTornadoShapePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomTornadoSpawningPayload.ID, CustomTornadoSpawningPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ItemEntityVelocityPayload.ID, ItemEntityVelocityPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(WindCorePayload.ID, WindCorePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomTornadoSwitchPayload.ID, CustomTornadoSwitchPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(DebrisVelocityPayload.ID, DebrisVelocityPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(DebrisParticlePayload.ID, DebrisParticlePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ClusterStatusPayload.ID, ClusterStatusPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(CustomItemStatusPayload.ID, CustomItemStatusPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CustomTornadoAIPayload.ID, CustomTornadoAIPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CustomTornadoParticlesPayload.ID, CustomTornadoParticlesPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CustomTornadoExtrasPayload.ID, CustomTornadoExtrasPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CustomTornadoShapePayload.ID, CustomTornadoShapePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CustomTornadoSpawningPayload.ID, CustomTornadoSpawningPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(TurbineStatePayload.ID, TurbineStatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PlayerVelocityPayload.ID, PlayerVelocityPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(DebugMenuPayload.ID, DebugMenuPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CustomItemStatusPayload.ID, CustomItemStatusPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(C2SGlobalCommunicationPayload.ID, C2SGlobalCommunicationPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(AssemblerUpdatePayload.ID, AssemblerUpdatePayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> Global.markPlayerJoined());
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> WCNetworkServer.saveWorldData(server.method_30002()));
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            boolean check;
            class_3218 world = server.method_30002();
            if (world == null) {
                return;
            }
            Global.incrementTimeFactors(server, server.method_3780());
            if (Global.invalidGlobals(world)) {
                Global.setupGlobals(world);
                if (!WCNetworkServer.loadWorldData(world)) {
                    WCNetworkServer.saveWorldData(server.method_30002());
                }
                boolean switched = WCNetworkServer.switchControl(world);
                CustomTornadoConfig.updateCustomTornadoInfo(world, false, CustomTornadoConfig.USING_ALT);
                WeatherClassic.STAGEX_CONFIG.reinit(switched);
                return;
            }
            if (Global.activeTornadoes.isEmpty() && Global.activeClusters.isEmpty()) {
                if (!Global.forcedTornadoChunks.isEmpty()) {
                    for (class_1923 class_19232 : Global.forcedTornadoChunks) {
                        world.method_17988(class_19232.field_9181, class_19232.field_9180, false);
                    }
                    Global.forcedTornadoChunks.clear();
                }
            } else {
                Object dead;
                if (Global.activeClusters.isEmpty()) {
                    if (world.method_8510() % 500L == 0L) {
                        WCNetworkServer.sendClusterRemovalPacket(world, null);
                    }
                } else {
                    dead = null;
                    for (StormClusterPE cluster : Global.activeClusters) {
                        if (cluster.isRemoved()) {
                            dead = cluster;
                            break;
                        }
                        cluster.tick();
                        if (Global.forceChunksForTornado(world, cluster.getChunkPos(), cluster.isRemoved(), true)) {
                            WCNetworkServer.saveWorldData(world);
                        }
                        if (cluster.age % 10 != 0) continue;
                        WCNetworkServer.sendClusterUpdatePacket(world, cluster);
                    }
                    if (dead != null) {
                        Global.removeCluster(dead);
                        WCNetworkServer.sendClusterRemovalPacket(world, dead);
                    }
                }
                if (Global.activeTornadoes.isEmpty()) {
                    if (world.method_8510() % 500L == 0L) {
                        WCNetworkServer.sendTornadoRemovalPacket(world, null);
                    }
                } else {
                    dead = null;
                    for (TornadoEntity tornado : Global.activeTornadoes) {
                        if (tornado.method_31481()) {
                            dead = tornado;
                            break;
                        }
                        if (!tornado.isBoundToCluster() && Global.forceChunksForTornado(world, tornado.method_31476(), tornado.method_31481(), tornado.getStats().ripType.asByte() > 2)) {
                            WCNetworkServer.saveWorldData(world);
                        }
                        if (tornado.field_6012 % 5 != 0) continue;
                        WCNetworkServer.sendTornadoUpdatePacket(world, tornado);
                    }
                    if (dead != null) {
                        Global.removeTornado((TornadoEntity)dead);
                        WCNetworkServer.sendTornadoRemovalPacket(world, (TornadoEntity)dead);
                    }
                }
            }
            if (world.method_8510() % 800L == 0L || forcePeriodicUpdate > 0) {
                Global.serverSoundManager.update();
                WCNetworkServer.saveWorldData(world);
                Global.tryWarnAboutOutdatedConfig(server);
                boolean switched = WCNetworkServer.switchControl(world);
                if (switched) {
                    WeatherClassic.STAGEX_CONFIG.reinit(switched);
                }
                WCNetworkServer.sendCustomTornadoInfoBackToClient(server, (byte)0);
                forcePeriodicUpdate = 0;
            }
            boolean bl = Global.playerRecentlyJoined() ? Global.getPlayerJoinTime() % 50 == 0 || Global.getPlayerJoinTime() <= 10 : (check = false);
            if (check || updateCustomTornadoSettings > 0) {
                boolean bl2 = WCNetworkServer.switchControl(world);
                if (updateCustomTornadoSettings > 0 || bl2) {
                    WeatherClassic.STAGEX_CONFIG.reinit(bl2);
                }
                WCNetworkServer.sendCustomTornadoInfoBackToClient(server, bl2 ? (byte)0 : updateCustomTornadoSettings);
                updateCustomTornadoSettings = 0;
            }
            Global.wind.tick();
            if (Global.wind.changedState() || check) {
                WCNetworkServer.sendWindStatusPacket(world);
            }
            Global.weather.tick();
            if (Global.weather.changedWeatherState() || check) {
                WCNetworkServer.sendWeatherStatusPacket(world);
            }
            if (world.method_8546() && world.method_8510() % 40L == 0L || Global.weather.forceWeatherUpdates() || check) {
                WCNetworkServer.sendStormIntensityPacket(world);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PlayerVelocityPayload.ID, (packet, context) -> Global.wind.createOrUpdatePlayerInput(packet.id(), packet.sideways(), packet.forward(), packet.tornadoId()));
        ServerPlayNetworking.registerGlobalReceiver(DebugMenuPayload.ID, (packet, context) -> {
            if (!ModConfig.getDebug()) {
                return;
            }
            byte b = packet.info();
            UUID id = packet.playerID();
            switch (b) {
                case 0: {
                    Global.wind.increaseWindFromDebug();
                    break;
                }
                case 1: {
                    Global.weather.setDownpour(!Global.weather.isDownpour());
                    break;
                }
                case 2: {
                    if (id == null) break;
                    Global.weather.forceTornado(id);
                    break;
                }
                case 3: {
                    if (Global.weather.isGreaterStormStage()) {
                        if (Global.weather.isStage6()) {
                            Global.weather.toggleIllusoryStage6(false);
                            break;
                        }
                        Global.weather.setSevereStorm(true, (byte)(Global.weather.getStormStage() + 2 - 1));
                        break;
                    }
                    if (Global.weather.getWorld().method_8546()) {
                        if (Global.weather.isSevereStorm()) {
                            Global.weather.setSevereStorm(false, (byte)0);
                            Global.weather.forceStormTransitionTicks((short)10);
                            break;
                        }
                        Global.setClear((class_3218)Global.weather.getWorld());
                        if (!((double)Global.weather.getWorld().method_8430(1.0f) > 0.9)) break;
                        Global.weather.getWorld().method_8519(0.9f);
                        break;
                    }
                    if (!Global.weather.getWorld().method_8419()) break;
                    Global.setClear((class_3218)Global.weather.getWorld());
                    if (!((double)Global.weather.getWorld().method_8430(1.0f) > 0.9)) break;
                    Global.weather.getWorld().method_8519(0.9f);
                    break;
                }
                case 4: {
                    if (!Global.weather.getWorld().method_8419()) {
                        Global.setRaining((class_3218)Global.weather.getWorld());
                        if (!((double)Global.weather.getWorld().method_8430(1.0f) < 0.9)) break;
                        Global.weather.getWorld().method_8519(0.9f);
                        break;
                    }
                    if (!Global.weather.getWorld().method_8546() && Global.weather.getWorld().method_8430(1.0f) >= 1.0f) {
                        Global.setThundering((class_3218)Global.weather.getWorld());
                        if (!((double)Global.weather.getWorld().method_8478(1.0f) < 0.9)) break;
                        Global.weather.getWorld().method_8496(0.9f);
                        break;
                    }
                    if (!Global.weather.isSevereStorm() && Global.weather.getWorld().method_8478(1.0f) >= 1.0f) {
                        Global.weather.setSevereStorm(true, (byte)2);
                        Global.weather.forceStormTransitionTicks((short)40);
                        break;
                    }
                    if (Global.weather.getSevereStormTransitionTicks() < 50) break;
                    if (!Global.weather.isStormStage5()) {
                        Global.weather.setSevereStorm(true, (byte)(Global.weather.getStormStage() + 2 + 1));
                        break;
                    }
                    if (!Global.weather.isStormStage5() || CustomTornadoConfig.getWeatherEventType() != 8) break;
                    Global.weather.toggleIllusoryStage6(true);
                    break;
                }
                case 5: {
                    Global.killAllStorms();
                    break;
                }
                case 6: {
                    if (id == null) break;
                    Global.weather.forceCluster(id);
                }
            }
        });
        WCNetworkServer.registerCustomTornadoRecievers();
        ServerPlayNetworking.registerGlobalReceiver(TurbineStatePayload.ID, (packet, context) -> {
            class_3218 world = context.player().method_51469();
            class_2680 state = world.method_8320(packet.pos());
            byte val = packet.state();
            if (state.method_26204() instanceof TurbineBlock) {
                switch (val) {
                    case 0: {
                        context.player().method_51469().method_8501(packet.pos(), (class_2680)((class_2680)state.method_11657((class_2769)TurbineBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)TurbineBlock.RANGE, (Comparable)Integer.valueOf(0)));
                        break;
                    }
                    case 1: {
                        context.player().method_51469().method_8501(packet.pos(), (class_2680)((class_2680)state.method_11657((class_2769)TurbineBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)TurbineBlock.RANGE, (Comparable)Integer.valueOf(1)));
                        break;
                    }
                    case 2: {
                        context.player().method_51469().method_8501(packet.pos(), (class_2680)((class_2680)state.method_11657((class_2769)TurbineBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)TurbineBlock.RANGE, (Comparable)Integer.valueOf(2)));
                        break;
                    }
                    default: {
                        context.player().method_51469().method_8501(packet.pos(), (class_2680)((class_2680)state.method_11657((class_2769)TurbineBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TurbineBlock.RANGE, (Comparable)Integer.valueOf(0)));
                    }
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(CustomItemStatusPayload.ID, (packet, context) -> {
            class_2487 nbt = packet.compound();
            UUID id = packet.playerId();
            if (nbt.method_10545("umid") && nbt.method_10571("umid").isPresent()) {
                byte b = (Byte)nbt.method_10571("umid").get();
                switch (b) {
                    default: 
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(C2SGlobalCommunicationPayload.ID, (packet, context) -> {
            byte b = packet.b();
            String s = packet.string();
            switch (b) {
                default: 
            }
        });
    }

    private static void sendCustomTornadoInfoBackToClient(MinecraftServer server, byte b) {
        switch (b) {
            case 1: {
                WCNetworkServer.sendCustomTornadoAIPayloadBackToClient(server);
                break;
            }
            case 2: {
                WCNetworkServer.sendCustomTornadoShapePayloadBackToClient(server);
                break;
            }
            case 3: {
                WCNetworkServer.sendCustomTornadoExtrasPayloadBackToClient(server);
                break;
            }
            case 4: {
                WCNetworkServer.sendCustomTornadoParticlesPayloadBackToClient(server);
                break;
            }
            case 5: {
                WCNetworkServer.sendCustomTornadoSpawningPayloadBackToClient(server);
                break;
            }
            default: {
                WCNetworkServer.sendCustomTornadoAIPayloadBackToClient(server);
                WCNetworkServer.sendCustomTornadoShapePayloadBackToClient(server);
                WCNetworkServer.sendCustomTornadoExtrasPayloadBackToClient(server);
                WCNetworkServer.sendCustomTornadoParticlesPayloadBackToClient(server);
                WCNetworkServer.sendCustomTornadoSpawningPayloadBackToClient(server);
            }
        }
    }

    private static void sendDebrisParticlePacket(class_3218 world, class_2338 at, int blockState) {
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new DebrisParticlePayload(at.method_10063(), blockState)));
    }

    public static int forceDebrisParticlesWithin(class_3218 world, int range, class_2338 at, int blockState) {
        int i = 0;
        for (int j = 0; j < world.method_18456().size(); ++j) {
            class_3222 serverPlayerEntity = (class_3222)world.method_18456().get(j);
            if (!WCNetworkServer.sendDebrisToPlayerIfWithin(serverPlayerEntity, range, at, blockState, world)) continue;
            ++i;
        }
        return i;
    }

    private static boolean sendDebrisToPlayerIfWithin(class_3222 player, int range, class_2338 at, int blockState, class_3218 world) {
        if (player.method_51469() != world) {
            return false;
        }
        class_2338 blockPos = player.method_24515();
        if (Utils.squaredDistanceTo(at, blockPos) < (double)(range * range)) {
            WCNetworkServer.sendDebrisParticlePacket(world, at, blockState);
            return true;
        }
        return false;
    }

    public static void sendWindCorePacket(class_3218 world, UUID id, class_243 pos, byte info) {
        if (pos == null || id == null) {
            return;
        }
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new WindCorePayload(info, id, pos)));
    }

    public static void sendStormIntensityPacket(class_3218 world) {
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new StormIntensityPayload(Global.weather.isStormDying(), Global.weather.getStormIntensity(), Global.weather.getCurrentRainTime())));
    }

    public static void sendTotalWeatherAndWindPacket(class_3218 world) {
        WCNetworkServer.sendWeatherStatusPacket(world);
        WCNetworkServer.sendWindStatusPacket(world);
        WCNetworkServer.sendStormIntensityPacket(world);
    }

    public static void sendWeatherStatusPacket(class_3218 world) {
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new WeatherStatusPayload(Global.weather.isDownpour(), Global.weather.isSevereStorm(), Global.weather.getSevereStormTransitionTicks(), Global.weather.getDownpourTransitionTicks(), Global.weather.getStormStage())));
    }

    public static void sendWindSoundPacket(class_3218 world, class_1657 player, float vol, float pitch, StormSoundInfo info, int tornadoID) {
        String data = info.getName() + ":" + tornadoID;
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_8710)new WindStatusPayload(false, vol, pitch, 0.0f, 0.0f, false, false, data, false, 0, false, 0));
    }

    public static void sendWindStatusPacket(class_3218 world) {
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new WindStatusPayload(true, 0.0f, 0.0f, Global.wind.getWindAngle(), Global.wind.getWindStrength(), Global.wind.isWindyDay(), Global.wind.gusty(), "none", Global.wind.isGale(), Global.wind.getGaleTransitionTicks(), Global.wind.ghastly(), (short)Global.wind.getWindGustTime())));
    }

    public static void sendTornadoUpdatePacket(class_3218 world, TornadoEntity tornado) {
        class_243 pos = tornado.method_19538();
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new TornadoStatusPayload(true, tornado.method_5667(), pos.field_1352, pos.field_1351, pos.field_1350, tornado.getTornadoType(), tornado.getStrength(), tornado.getCloudY(), false, UUID.randomUUID(), tornado.isDemonic())));
    }

    public static void sendTornadoRemovalPacket(class_3218 world, @Nullable TornadoEntity tornado) {
        UUID id = tornado == null ? UUID.randomUUID() : tornado.method_5667();
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new TornadoStatusPayload(false, UUID.randomUUID(), 0.0, 0.0, 0.0, 0, 0.0f, 0, tornado == null, id, false)));
    }

    public static void sendTurbineSoundPacket(class_2338 pos, class_3222 player, boolean forceOff) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TurbineSoundPayload(pos, forceOff));
    }

    public static void sendItemWindVelocityPacket(class_3218 world, int id, double velX, double velZ) {
        world.method_18456().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new ItemEntityVelocityPayload(id, velX, velZ)));
    }

    public static void sendDirectionalWindPayload(class_3218 world, TornadoEntity entity, float vol, float pitch, boolean tear) {
        world.method_18456().forEach(p -> {
            class_2338 pos = entity.method_24515().method_10086(TornadoEntity.getMidCalculation());
            if (Utils.squaredDistanceTo(p.method_24515(), pos) > 44944.0) {
                return;
            }
            if (entity.isSpout() && Utils.squaredDistanceXZ(p.method_24515(), entity.method_24515()) < 16.0) {
                return;
            }
            ServerPlayNetworking.send((class_3222)p, (class_8710)new TornadoDirectionalWindSoundPayload(entity.method_5628(), vol, pitch, tear, Utils.distanceXYZ(pos, p.method_24515()) < (double)entity.getStats().soundDist));
        });
    }

    public static void sendDebrisVelocityPacket(DebrisEntity ent, double x, double y, double z, List<class_1657> players) {
        if (players == null || players.isEmpty()) {
            return;
        }
        players.forEach(p -> ServerPlayNetworking.send((class_3222)((class_3222)p), (class_8710)new DebrisVelocityPayload(ent.method_5628(), x, y, z)));
    }

    public static void sendClusterUpdatePacket(class_3218 world, StormClusterPE cluster) {
        class_243 pos = cluster.getPos();
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new ClusterStatusPayload(true, cluster.getId(), pos.field_1352, pos.field_1351, pos.field_1350, cluster.getStrength(), false, UUID.randomUUID())));
    }

    public static void sendClusterRemovalPacket(class_3218 world, @Nullable StormClusterPE cluster) {
        UUID id = cluster == null ? UUID.randomUUID() : cluster.getId();
        world.method_8503().method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new ClusterStatusPayload(false, UUID.randomUUID(), 0.0, 0.0, 0.0, 0.0f, cluster == null, id)));
    }

    private static void saveWorldData(class_3218 world) {
        int i;
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File dataFile = new File(worldDir, "wswdata_c.properties");
        if (!dataFile.exists()) {
            try {
                if (!dataFile.createNewFile()) {
                    System.err.println("ERROR: Could not create weather data for world!");
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        Properties properties = new Properties();
        properties.setProperty("WARN", "DO NOT EDIT THIS FILE");
        properties.setProperty("wy", String.valueOf(Global.wind.isWindyDay()));
        properties.setProperty("wstr", String.valueOf(Global.wind.getWindStrength()));
        properties.setProperty("wa", String.valueOf(Global.wind.getWindAngle()));
        properties.setProperty("wd", String.valueOf(Global.wind.isStrengthDecreasing()));
        properties.setProperty("dsw", String.valueOf(Global.wind.getDaysSinceWindy()));
        properties.setProperty("wet", String.valueOf(Global.wind.getWindEndingTimer()));
        properties.setProperty("gle", String.valueOf(Global.wind.isGale()));
        properties.setProperty("dsag", String.valueOf(Global.wind.getDaysSinceGale()));
        properties.setProperty("gtly", String.valueOf(Global.wind.ghastly()));
        properties.setProperty("gstr", String.valueOf(Global.wind.getGaleStartTimer()));
        properties.setProperty("wget", String.valueOf(Global.wind.getWindGustTime()));
        properties.setProperty("dg", String.valueOf(Global.weather.isDownpour()));
        properties.setProperty("dsd", String.valueOf(Global.weather.getDaysSinceDownpour()));
        properties.setProperty("dsr", String.valueOf(Global.weather.getDaysSinceRain()));
        properties.setProperty("cs", String.valueOf(Global.weather.isStorming()));
        properties.setProperty("dss", String.valueOf(Global.weather.getDaysSinceStorm()));
        properties.setProperty("sticks", String.valueOf(Global.weather.getStormTicks()));
        properties.setProperty("sth", String.valueOf(Global.weather.getStormThreshold()));
        properties.setProperty("stg", String.valueOf(Global.weather.getCurrentStageGoal()));
        properties.setProperty("sdy", String.valueOf(Global.weather.isStormDying()));
        properties.setProperty("stgt", String.valueOf(Global.weather.getStormStageGoalPercentageThreshold()));
        properties.setProperty("dumbiy", String.valueOf(Global.weather.isUsingDumbStormIntensity()));
        properties.setProperty("trtfs", String.valueOf(Global.weather.getTotalRainTimeForStorm()));
        properties.setProperty("ao", String.valueOf(Global.weather.isApexOnlyOn()));
        properties.setProperty("cyb", String.valueOf(Global.weather.isCursedStorm()));
        properties.setProperty("nstc", String.valueOf(0));
        for (i = 0; i < Global.weather.getStormStageProfile().length; ++i) {
            properties.setProperty("stormProfile" + i, String.valueOf(Global.weather.getStormStageProfile()[i]));
        }
        properties.setProperty("executor", Global.weather.getWeatherExecutor() == null ? "none" : Global.weather.getWeatherExecutor().toString().toUpperCase());
        if (!Global.weather.getRevivers().isEmpty()) {
            i = 0;
            for (TornadoReviver reviver : Global.weather.getRevivers()) {
                if (reviver.isDying()) continue;
                properties.setProperty("reviver" + i + "x", String.valueOf(reviver.getPos().method_10263()));
                properties.setProperty("reviver" + i + "y", String.valueOf(reviver.getPos().method_10264()));
                properties.setProperty("reviver" + i + "z", String.valueOf(reviver.getPos().method_10260()));
                properties.setProperty("reviver" + i + "type", String.valueOf(reviver.getType()));
                properties.setProperty("reviver" + i + "scary", String.valueOf(reviver.isDemon()));
                properties.setProperty("reviver" + i + "altBound", String.valueOf(reviver.boundToAlt()));
                ++i;
            }
        }
        i = 0;
        for (class_1923 pos : Global.forcedTornadoChunks) {
            properties.setProperty("FCaX" + i, String.valueOf(pos.field_9181));
            properties.setProperty("FCaZ" + i, String.valueOf(pos.field_9180));
            ++i;
        }
        properties.setProperty("gfcc", String.valueOf(Global.getGlobalForecastCooldown()));
        properties.setProperty("gfcb", String.valueOf(Global.getGlobalForecast()));
        properties.setProperty("ctst", String.valueOf(Global.getCustomTornadoSwitchType()));
        if (!Global.activeClusters.isEmpty()) {
            int ii = 0;
            for (StormClusterPE cluster : Global.activeClusters) {
                if (cluster.isRemoved()) continue;
                properties.setProperty("cluster" + ii + "x", String.valueOf(cluster.getBlockPos().method_10263()));
                properties.setProperty("cluster" + ii + "y", String.valueOf(cluster.getBlockPos().method_10264()));
                properties.setProperty("cluster" + ii + "z", String.valueOf(cluster.getBlockPos().method_10260()));
                properties.setProperty("cluster" + ii + "str", String.valueOf(cluster.getStrength()));
                properties.setProperty("cluster" + ii + "time", String.valueOf(cluster.age));
                ++ii;
            }
        }
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadWorldData(class_3218 world) {
        File worldDir = world.method_8503().method_27050(class_5218.field_24188).toFile();
        File dataFile = new File(worldDir, "wswdata_c.properties");
        if (!dataFile.exists()) {
            return false;
        }
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(dataFile);){
            int i;
            properties.load(input);
            if (!properties.containsKey("WARN")) {
                boolean bl = false;
                return bl;
            }
            boolean windy = Boolean.parseBoolean(properties.getProperty("wy"));
            float windStr = Float.parseFloat(properties.getProperty("wstr", "0.0"));
            int windAngle = Integer.parseInt(properties.getProperty("wa", "0"));
            boolean windDecreasing = Boolean.parseBoolean(properties.getProperty("wd"));
            int daysSinceWindy = Integer.parseInt(properties.getProperty("dsw", "2"));
            int windEndTimer = Integer.parseInt(properties.getProperty("wet", "0"));
            boolean gale = Boolean.parseBoolean(properties.getProperty("gle"));
            int daysSinceGale = Integer.parseInt(properties.getProperty("dsag", "1"));
            boolean ghastly = Boolean.parseBoolean(properties.getProperty("gtly"));
            int galeStartTimer = Integer.parseInt(properties.getProperty("gstr", "0"));
            int windGustEventTime = Integer.parseInt(properties.getProperty("wget", "0"));
            Global.wind.updateWindData(windy, windStr, windDecreasing, windAngle, daysSinceWindy, windEndTimer, gale, daysSinceGale, ghastly, galeStartTimer, windGustEventTime);
            boolean downpour = Boolean.parseBoolean(properties.getProperty("dg"));
            int daysSinceDownpour = Integer.parseInt(properties.getProperty("dsd", "2"));
            int daysSinceRain = Integer.parseInt(properties.getProperty("dsr", "2"));
            Global.weather.updateDownpourData(downpour, daysSinceDownpour, daysSinceRain);
            boolean currentStorm = Boolean.parseBoolean(properties.getProperty("cs"));
            int fullDaysSinceStorm = Integer.parseInt(properties.getProperty("dss", "2"));
            int stormTicks = Integer.parseInt(properties.getProperty("sticks", "0"));
            String executorString = properties.getProperty("executor");
            WeatherExecutor.WeatherToExecute executor = !executorString.equals("RAIN") && !executorString.equals("THUNDER") ? null : WeatherExecutor.WeatherToExecute.valueOf(executorString);
            int threshold = Integer.parseInt(properties.getProperty("sth", "15600"));
            byte stageGoal = Byte.parseByte(properties.getProperty("stg", "0"));
            boolean stormDying = Boolean.parseBoolean(properties.getProperty("sdy"));
            boolean dumbIntensity = Boolean.parseBoolean(properties.getProperty("dumbiy"));
            int totalRainTimeForStorm = Integer.parseInt(properties.getProperty("trtfs", String.valueOf(Global.weather.getCurrentRainTime())));
            double stageGoalThreshold = Double.parseDouble(properties.getProperty("stgt", "20"));
            boolean apexOnly = Boolean.parseBoolean(properties.getProperty("ao"));
            boolean cursed = Boolean.parseBoolean(properties.getProperty("cyb"));
            int skipped = Integer.parseInt(properties.getProperty("nstc"));
            short[] profile = new short[Global.weather.getStormStageProfile().length];
            for (i = 0; i < Global.weather.getStormStageProfile().length; ++i) {
                short s = Short.parseShort(properties.getProperty("stormProfile" + i, "-1"));
                if (s <= -1) {
                    profile = null;
                    break;
                }
                profile[i] = s;
            }
            for (i = 0; i < ModConfig.getMaxTornadoes() + 1; ++i) {
                int z;
                int y;
                int x = Integer.parseInt(properties.getProperty("reviver" + i + "x", String.valueOf(Utils.effectivelyNull.method_10263())));
                class_2338 pos = BP.of(x, y = Integer.parseInt(properties.getProperty("reviver" + i + "y", String.valueOf(Utils.effectivelyNull.method_10264()))), z = Integer.parseInt(properties.getProperty("reviver" + i + "z", String.valueOf(Utils.effectivelyNull.method_10260()))));
                if (pos.equals((Object)Utils.effectivelyNull)) continue;
                byte type = Byte.parseByte(properties.getProperty("reviver" + i + "type"));
                boolean demon = Boolean.parseBoolean(properties.getProperty("reviver" + i + "scary"));
                boolean altBound = Boolean.parseBoolean(properties.getProperty("reviver" + i + "altBound"));
                Global.weather.addTornadoReviver(new TornadoReviver(world, pos, type, demon).binded(altBound));
            }
            Global.weather.updateStormData(currentStorm, fullDaysSinceStorm, stormTicks, executor, profile, threshold, stageGoal, stormDying, totalRainTimeForStorm, stageGoalThreshold, dumbIntensity, apexOnly, cursed, skipped);
            for (i = 0; i < 10000; ++i) {
                String xval = properties.getProperty("FCaX" + i, "NONE");
                String zval = properties.getProperty("FCaZ" + i, "NONE");
                if (xval.equals("NONE") || zval.equals("NONE")) break;
                int cx = Integer.parseInt(xval);
                int cz = Integer.parseInt(zval);
                class_1923 pos = new class_1923(cx, cz);
                Global.forcedTornadoChunks.add(pos);
                world.method_17988(pos.field_9181, pos.field_9180, false);
            }
            if (ModConfig.getForceChunkRemovalOnWorldLoad()) {
                LongSet longSet = world.method_17984();
                longSet.forEach(c -> world.method_17988(class_1923.method_8325((long)c), class_1923.method_8332((long)c), false));
            }
            int globalForecastCooldown = Integer.parseInt(properties.getProperty("gfcc", "0"));
            byte globalForecast = Byte.parseByte(properties.getProperty("gfcb", "-1"));
            byte switchTypeCustomTornado = Byte.parseByte(properties.getProperty("ctst", "0"));
            Global.setGlobalForecastCooldown(globalForecastCooldown);
            Global.setGlobalForecast(globalForecast);
            Global.setCustomTornadoSwitchType(switchTypeCustomTornado);
            int ii = 0;
            while (ii < 20) {
                int z;
                int y;
                int x = Integer.parseInt(properties.getProperty("cluster" + ii + "x", String.valueOf(Utils.effectivelyNull.method_10263())));
                class_2338 pos = BP.of(x, y = Integer.parseInt(properties.getProperty("cluster" + ii + "y", String.valueOf(Utils.effectivelyNull.method_10264()))), z = Integer.parseInt(properties.getProperty("cluster" + ii + "z", String.valueOf(Utils.effectivelyNull.method_10260()))));
                if (!pos.equals((Object)Utils.effectivelyNull)) {
                    float str = Float.parseFloat(properties.getProperty("cluster" + ii + "str"));
                    int age = Integer.parseInt(properties.getProperty("cluster" + ii + "time"));
                    Global.weather.spawnClusterAt(pos, str, age);
                }
                ++ii;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void registerCustomTornadoRecievers() {
        ServerPlayNetworking.registerGlobalReceiver(CustomTornadoAIPayload.ID, (packet, context) -> {
            if (!ModConfig.getEnableCustomTornadoes()) {
                return;
            }
            boolean spawn = packet.spawn();
            if (spawn) {
                class_3222 player = context.player();
                class_2338 pos = player.method_24515().method_10079(player.method_5755(), 30);
                TornadoEntity ent = new TornadoEntity(TornadoEntity.getEntityTypeFrom(TornadoStats.Type.STAGEX.getByte()), (class_1937)player.method_51469());
                Global.forceChunksForTornadoSpawn(player.method_51469(), ent, new class_1923(pos));
                ent.method_5725(pos, 0.0f, 0.0f);
                player.method_51469().method_8649((class_1297)ent);
                return;
            }
            short speed = packet.speed();
            byte pullType = packet.pullType();
            byte ripType = packet.ripType();
            float dResistance = packet.dispellerResistance();
            short time = packet.time();
            byte override = packet.destructionOverride();
            boolean chase = packet.chase();
            CustomTornadoConfig.setChasePlayers(chase);
            CustomTornadoConfig.setDestructionLvlOverride(override);
            CustomTornadoConfig.setSpeed(speed);
            CustomTornadoConfig.setTime(time);
            CustomTornadoConfig.setPullType(pullType);
            CustomTornadoConfig.setRipType(ripType);
            CustomTornadoConfig.setDispellerResistance(dResistance);
            updateCustomTornadoSettings = 1;
        });
        ServerPlayNetworking.registerGlobalReceiver(CustomTornadoShapePayload.ID, (packet, context) -> {
            if (!ModConfig.getEnableCustomTornadoes()) {
                return;
            }
            short width = packet.funnelWidth();
            byte particleRadius = packet.particleRadius();
            byte pointedness = packet.pointedness();
            float tightening = packet.tightening();
            float scaling = packet.scaling();
            CustomTornadoConfig.setScaling(scaling);
            CustomTornadoConfig.setFunnelWidth(width);
            CustomTornadoConfig.setParticleRadiusLvl(particleRadius);
            CustomTornadoConfig.setFunnelPointedness(pointedness);
            CustomTornadoConfig.setFunnelTightening(tightening);
            updateCustomTornadoSettings = (byte)2;
        });
        ServerPlayNetworking.registerGlobalReceiver(CustomTornadoExtrasPayload.ID, (packet, context) -> {
            if (!ModConfig.getEnableCustomTornadoes()) {
                return;
            }
            byte extraParticleDist = packet.particleDistance();
            short extraParticleInterval = packet.particleInterval();
            boolean cloudColor = packet.cloudColor();
            boolean colorOverride = packet.color();
            Vector3f colors = packet.colors();
            boolean spawnClouds = packet.clouds();
            boolean surroundingColor = packet.getColorsAround();
            int soundDist = packet.soundDist();
            byte soundType = packet.passiveSound();
            CustomTornadoConfig.setPassiveeSoundType(soundType);
            CustomTornadoConfig.setSoundDist(soundDist);
            CustomTornadoConfig.setTakeSurroundingColor(surroundingColor);
            CustomTornadoConfig.setExtraParticleDistance(extraParticleDist);
            CustomTornadoConfig.setExtraParticleInterval(extraParticleInterval);
            CustomTornadoConfig.setCloudColorOverride(cloudColor);
            CustomTornadoConfig.setColorOverride(colorOverride);
            CustomTornadoConfig.setCreateClouds(spawnClouds);
            CustomTornadoConfig.setRed(colors.x);
            CustomTornadoConfig.setGreen(colors.y);
            CustomTornadoConfig.setBlue(colors.z);
            updateCustomTornadoSettings = (byte)3;
        });
        ServerPlayNetworking.registerGlobalReceiver(CustomTornadoParticlesPayload.ID, (packet, context) -> {
            if (!ModConfig.getEnableCustomTornadoes()) {
                return;
            }
            float baseInc = packet.baseInc();
            byte particleCount = packet.particleCount();
            float bottomInc = packet.bottomInc();
            float midInc = packet.midInc();
            float topInc = packet.topInc();
            CustomTornadoConfig.setBaseParticleSizeIncrease(baseInc);
            CustomTornadoConfig.setParticleCount(particleCount);
            CustomTornadoConfig.setBottomParticleSizeIncrease(bottomInc);
            CustomTornadoConfig.setMidParticleSizeIncrease(midInc);
            CustomTornadoConfig.setTopParticleSizeIncrease(topInc);
            updateCustomTornadoSettings = (byte)4;
        });
        ServerPlayNetworking.registerGlobalReceiver(CustomTornadoSpawningPayload.ID, (packet, context) -> {
            if (!ModConfig.getEnableCustomTornadoes()) {
                return;
            }
            byte weatherEventType = packet.weatherEventType();
            byte biomeLockType = packet.biomeLock();
            float spawnPercent = packet.spawnPercent();
            byte switchType = packet.switchType();
            Global.setCustomTornadoSwitchType(switchType);
            CustomTornadoConfig.setWeatherEventType(weatherEventType);
            CustomTornadoConfig.setBiomeLockType(biomeLockType);
            CustomTornadoConfig.setSpawnPercent(spawnPercent);
            updateCustomTornadoSettings = (byte)5;
        });
    }

    public static void sendCustomTornadoAIPayloadBackToClient(MinecraftServer server) {
        server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CustomTornadoAIPayload(CustomTornadoConfig.getSpeed(), CustomTornadoConfig.getRipType(true), CustomTornadoConfig.getTime(), CustomTornadoConfig.getPullType(true), CustomTornadoConfig.getDispellerResistance(), CustomTornadoConfig.getDestructionLvlOverride(), CustomTornadoConfig.getChasePlayers(), false)));
    }

    public static void sendCustomTornadoExtrasPayloadBackToClient(MinecraftServer server) {
        server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CustomTornadoExtrasPayload(CustomTornadoConfig.getExtraParticleInterval(), CustomTornadoConfig.getExtraParticleDistance(), CustomTornadoConfig.getCreateClouds(), CustomTornadoConfig.getColorOverride(), CustomTornadoConfig.getCloudColorOverride(), CustomTornadoConfig.getColors(), CustomTornadoConfig.getTakeSurroundingColor(), CustomTornadoConfig.getSoundDist(), CustomTornadoConfig.getPassiveSoundType())));
    }

    public static void sendCustomTornadoParticlesPayloadBackToClient(MinecraftServer server) {
        server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CustomTornadoParticlesPayload(CustomTornadoConfig.getParticleCount(), CustomTornadoConfig.getBaseParticleSizeIncrease(), CustomTornadoConfig.getBottomParticleSizeIncrease(), CustomTornadoConfig.getMidParticleSizeIncrease(), CustomTornadoConfig.getTopParticleSizeIncrease())));
    }

    public static void sendCustomTornadoShapePayloadBackToClient(MinecraftServer server) {
        server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CustomTornadoShapePayload(CustomTornadoConfig.getParticleRadiusLvl(), CustomTornadoConfig.getFunnelWidth(), CustomTornadoConfig.getFunnelPointedness(), CustomTornadoConfig.getFunnelTightening(), CustomTornadoConfig.getScaling())));
    }

    public static void sendCustomTornadoSpawningPayloadBackToClient(MinecraftServer server) {
        server.method_3760().method_14571().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CustomTornadoSpawningPayload(CustomTornadoConfig.getWeatherEventType(), CustomTornadoConfig.getSpawnPercent(), CustomTornadoConfig.getBiomeLockType(), Global.getCustomTornadoSwitchType())));
    }

    public static void sendCustomTornadoSwitchPacket(class_3218 world) {
        world.method_18456().forEach(p -> ServerPlayNetworking.send((class_3222)p, (class_8710)new CustomTornadoSwitchPayload(CustomTornadoConfig.USING_ALT)));
    }

    public static boolean switchControl(class_3218 world) {
        boolean changed = prevCustomTornadoSwitchType != Global.getCustomTornadoSwitchType();
        prevCustomTornadoSwitchType = Global.getCustomTornadoSwitchType();
        switch (Global.getCustomTornadoSwitchType()) {
            case 1: {
                if (CustomTornadoConfig.USING_ALT) break;
                CustomTornadoConfig.USING_ALT = true;
                WCNetworkServer.sendCustomTornadoSwitchPacket(world);
                return true;
            }
            case 2: {
                boolean alt = false;
                byte event = CustomTornadoConfig.getWeatherEventForAlt(world);
                if (event < 0) break;
                switch (event) {
                    case 1: {
                        if (!world.method_8419() || world.method_8546() || Global.weather.isDownpour()) break;
                        alt = true;
                        break;
                    }
                    case 2: {
                        if (!Global.weather.isDownpour() || world.method_8546()) break;
                        alt = true;
                        break;
                    }
                    case 3: {
                        if (!Global.weather.isStormStage2() || Global.weather.isStormStage2Severe()) break;
                        alt = true;
                        break;
                    }
                    case 4: {
                        if (!Global.weather.isStormStage2Severe()) break;
                        alt = true;
                        break;
                    }
                    case 5: {
                        if (!Global.weather.isStormStage3()) break;
                        alt = true;
                        break;
                    }
                    case 6: {
                        if (!Global.weather.isStormStage4()) break;
                        alt = true;
                        break;
                    }
                    case 7: {
                        if (!Global.weather.isStormStage5()) break;
                        alt = true;
                        break;
                    }
                    default: {
                        if (!Global.wind.isGale() || world.method_8419() || world.method_8546()) break;
                        alt = true;
                    }
                }
                if (forcePeriodicUpdate > 1) {
                    boolean bl = alt = forcePeriodicUpdate == 2;
                }
                if (CustomTornadoConfig.USING_ALT == alt) break;
                boolean allowAuto = true;
                if (alt) {
                    if (Global.activeTornadoes.stream().anyMatch(p -> {
                        if (p.getTornadoType() != 5) {
                            return false;
                        }
                        return !p.boundToAlt() && !Global.weather.isStormStage5();
                    })) {
                        allowAuto = false;
                    }
                } else if (Global.activeTornadoes.stream().anyMatch(p -> {
                    if (p.getTornadoType() != 5) {
                        return false;
                    }
                    return p.boundToAlt() && !Global.weather.isStormStage5();
                })) {
                    allowAuto = false;
                }
                if (!allowAuto) break;
                CustomTornadoConfig.USING_ALT = alt;
                WCNetworkServer.sendCustomTornadoSwitchPacket(world);
                return true;
            }
            default: {
                if (!CustomTornadoConfig.USING_ALT) break;
                CustomTornadoConfig.USING_ALT = false;
                WCNetworkServer.sendCustomTornadoSwitchPacket(world);
                return true;
            }
        }
        WCNetworkServer.sendCustomTornadoSwitchPacket(world);
        return changed;
    }

    public static void forceBigUpdate() {
        forcePeriodicUpdate = 1;
    }

    public static void forceBigUpdateWithCustomTornado(boolean alt) {
        forcePeriodicUpdate = (byte)(alt ? 2 : 3);
    }

    public static boolean awaitingBigUpdate() {
        return forcePeriodicUpdate > 0;
    }

    public static void sendCustomItemStatusPayload(class_3222 player, class_2487 nbt) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new CustomItemStatusPayload(nbt, player.method_5667()));
    }
}

