/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.weather_classic.entity.breezling.WindManipulator;
import net.weather_classic.global.Global;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.registry.WCParticles;

@Environment(value=EnvType.CLIENT)
public class WindParticle
extends class_4003 {
    private boolean fadeIn = true;
    private float angleBegin;
    private final float angleIncrement;
    private final boolean tail;
    private WindManipulator manipulator;
    private byte forceDirection = (byte)-1;
    private byte lifeTimeOverride = (byte)-1;
    private boolean rot = false;

    public WindParticle(class_638 clientWorld, double d, double e, double f, double gr, double hr, double ir, class_4002 pr) {
        super(clientWorld, d, e, f, gr, hr, ir);
        boolean alterLifeAndDir;
        this.method_34753(0.0, 0.0, 0.0);
        this.method_18140(pr);
        this.field_3847 = 60 + clientWorld.field_9229.method_43048(40);
        this.method_3087(0.3f + 0.4f * this.field_3840.method_43057());
        this.angleBegin = (float)Math.toRadians(this.field_3840.method_43056() ? -30.0 : 30.0);
        int h = (int)hr;
        int g = (int)gr;
        int i = (int)ir;
        float f2 = this.field_3840.method_43056() ? (float)Math.toRadians(this.field_3840.method_43056() ? -10.0 : 10.0) : (this.angleIncrement = (float)Math.toRadians(this.field_3840.method_43056() ? -15.0 : 15.0));
        if (h == 300 || h == 301 || h == 302) {
            if (h == 300 || h == 301) {
                this.tail = true;
                this.method_3087(0.2f);
                this.field_3847 = 20;
                this.method_3083(0.5f);
                if (h == 301) {
                    this.manipulator = Global.getBreezeForManipulation((class_1937)clientWorld, this.getBlockPos());
                }
            } else {
                this.tail = false;
                this.manipulator = Global.getBreezeForManipulation((class_1937)clientWorld, this.getBlockPos());
            }
        } else {
            this.tail = false;
        }
        if (this.manipulator == null) {
            this.manipulator = Global.getPlayerForManipulation((class_1937)clientWorld, this.getPos());
        }
        if (this.manipulator != null) {
            this.field_3847 = 20 + clientWorld.field_9229.method_43048(20);
            this.rot = true;
            ++StormParticle.activeRotParticles;
        }
        if ((double)clientWorld.method_8409().method_43057() < 0.2) {
            this.field_3842 = 0.9f;
            this.field_3861 = 0.9f;
        }
        int minCVal = 100;
        int maxCVal = 105;
        if (i >= minCVal && i <= maxCVal) {
            this.forceDirection = (byte)i;
        }
        if (g >= minCVal && g <= maxCVal) {
            switch ((byte)g) {
                case 100: {
                    this.field_3847 = 12;
                    break;
                }
                case 101: {
                    this.field_3847 = 32;
                    break;
                }
                default: {
                    this.field_3847 = 57;
                }
            }
            this.lifeTimeOverride = (byte)g;
        }
        boolean bl = alterLifeAndDir = this.lifeTimeOverride > -1 && this.forceDirection > -1;
        this.method_3083(alterLifeAndDir ? clientWorld.method_8409().method_43057() * 0.7f : (this.forceDirection > -1 || this.lifeTimeOverride > -1 ? clientWorld.method_8409().method_43057() * 0.4f : 0.0f));
        this.field_3862 = false;
        this.updateColorForFXIndex();
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public class_2338 getBlockPos() {
        return BP.of(Math.floor(this.field_3874), Math.floor(this.field_3854), Math.floor(this.field_3871));
    }

    public class_243 getPos() {
        return new class_243(this.field_3874, this.field_3854, this.field_3871);
    }

    protected int method_3068(float tint) {
        if (this.manipulator != null) {
            return 0xF000F0;
        }
        int b = super.method_3068(tint);
        return b <= 0 ? 100 : 0xFFFFFF;
    }

    private void updateColorForFXIndex() {
        if (this.manipulator != null && this.manipulator.getFXIndex() != 0) {
            switch (this.manipulator.getFXIndex()) {
                case 1: {
                    this.method_3084(1.0f, 0.0f, 0.0f);
                    break;
                }
                case 2: {
                    this.method_3084(0.0f, 1.0f, 0.0f);
                    break;
                }
                case 3: {
                    this.method_3084(0.4f, 0.98f, 0.25f);
                }
            }
        }
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866 % 40 == 0) {
            if (this.manipulator == null || !this.manipulator.isBreeze()) {
                this.manipulator = Global.getPlayerForManipulation((class_1937)this.field_3851, this.getPos());
                this.updateColorForFXIndex();
            }
            if (!(this.tail || this.lifeTimeOverride > -1 && this.field_3866 >= 40)) {
                boolean breeze = this.manipulator != null && this.manipulator.isBreeze();
                this.field_3851.method_8406((class_2394)WCParticles.WIND_PARTICLE, this.field_3874, this.field_3854 + 0.001, this.field_3871, this.lifeTimeOverride > -1 ? (double)this.lifeTimeOverride : this.field_3852, (double)(breeze ? 301 : 300), this.forceDirection > -1 ? (double)this.forceDirection : this.field_3850);
            }
        }
        if (this.field_3866++ > this.field_3847) {
            float dec = (float)(this.manipulator != null || this.lifeTimeOverride > -1 ? 0.1 : (double)0.01f);
            this.method_3083(this.field_3841 - dec);
            if ((double)this.field_3841 <= 0.1) {
                this.method_3085();
                return;
            }
        } else if (this.manipulator != null) {
            this.method_3083(this.field_3841 + 0.1f);
            this.field_3841 = class_3532.method_15363((float)this.field_3841, (float)0.0f, (float)1.0f);
        } else if (this.fadeIn) {
            if ((double)this.field_3841 < 0.5) {
                this.method_3083(this.field_3841 + 0.01f);
            }
        } else if ((double)this.field_3841 > 0.2) {
            this.method_3083(this.field_3841 - 0.01f);
        }
        if ((double)this.field_3840.method_43057() < 0.2 && this.field_3866 % 20 == 0) {
            boolean bl = this.fadeIn = !this.fadeIn;
        }
        if (this.forceDirection <= -1 || this.manipulator != null) {
            if (this.forceDirection > -1) {
                this.forceDirection = (byte)-1;
            }
            vec = ClientGlobal.getWindMovementVectorForParticle(this.field_3851, this.getPos(), this.manipulator, true);
            this.field_3852 += (double)vec.x;
            this.field_3850 += (double)vec.z;
            this.field_3869 = 0.0;
        } else {
            vec = Utils.getWindParticleVectorFromByte(this.forceDirection);
            this.field_3852 = vec.field_1352;
            this.field_3869 = vec.field_1351;
            this.field_3850 = vec.field_1350;
        }
        this.angleBegin += this.angleIncrement / 15.0f;
        this.field_3857 = this.field_3839;
        this.field_3839 += this.angleBegin / 15.0f;
        double velLimit = this.manipulator != null || ClientGlobal.isTornadoActive() || this.forceDirection > -1 ? 0.45 : (ClientGlobal.gale ? 0.35 : 0.15);
        this.field_3852 = class_3532.method_15350((double)this.field_3852, (double)(-velLimit), (double)velLimit);
        this.field_3850 = class_3532.method_15350((double)this.field_3850, (double)(-velLimit), (double)velLimit);
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        class_2680 state = this.field_3851.method_8320(this.getBlockPos());
        if (this.field_3866 % 2 != 0) {
            return;
        }
        if (state.method_51367() && !Materials.isVentilated(state) || !state.method_26227().method_15769()) {
            this.method_3085();
        }
    }

    public void method_3069(double dx, double dy, double dz) {
        double d = dx;
        double e = dy;
        double f = dz;
        if (this.field_3862 && (dx != 0.0 || dy != 0.0 || dz != 0.0) && dx * dx + dy * dy + dz * dz < class_3532.method_33723((double)100.0)) {
            class_243 vec3d = class_1297.method_20736(null, (class_243)new class_243(dx, dy, dz), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
            dy = vec3d.field_1351;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.method_3067(this.method_3064().method_989(dx, dy, dz));
            this.method_3072();
        }
        this.field_3845 = e != dy && e < 0.0;
        boolean bl = this.field_3845;
        if (d != dx) {
            this.field_3852 = 0.0;
        }
        if (f != dz) {
            this.field_3850 = 0.0;
        }
    }

    public void method_3085() {
        super.method_3085();
        if (this.rot && StormParticle.activeRotParticles > 0) {
            --StormParticle.activeRotParticles;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new WindParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

