/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.clouds;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.weather_classic.config.ModConfig;
import net.weather_classic.help.Utils;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.source.ClientClusterParticleSource;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class StormCloudParticle
extends StormParticle {
    private int animTime = 0;
    private final class_4002 pr;
    private final boolean isForCluster;
    public boolean freezeOutwardMotion = false;
    public final short id;
    public final byte frameTime;
    private float clusterStr = 1.0f;
    private float alp = 1.0f;

    protected StormCloudParticle(class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_4002 pr) {
        super(clientWorld, d, e, f, g, 0.0, i);
        this.method_18140(pr);
        this.field_17867 = 18.0f;
        this.angleX = 90 + this.field_3840.method_43048(60) - this.field_3840.method_43048(60);
        this.field_3847 = 20;
        this.angleZ = this.field_3840.method_43056() ? 0.0f : 180.0f;
        this.angleY = this.field_3840.method_43048(360);
        this.angleZ = this.field_3840.method_43048(360);
        this.field_3862 = false;
        this.method_3083(0.0f);
        this.pr = pr;
        this.isForCluster = (int)h == -100;
        this.id = (short)this.field_3840.method_43048(32000);
        this.frameTime = (byte)(this.isForCluster ? 30 + clientWorld.field_9229.method_43048(30) : 30);
    }

    public float getClusterStrength() {
        return this.clusterStr;
    }

    public void setClusterStrength(float str) {
        this.clusterStr = str;
        if ((double)str > 0.7) {
            this.alp = 1.0f;
            return;
        }
        this.alp = Math.clamp(this.clusterStr + 0.1f, 0.3f, 1.0f);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (this.rotator == null) {
            this.getParticleRotator();
        } else {
            class_2338 pos;
            if (this.getCastedRotator().getSource().isRemoved()) {
                this.field_3866 += 2;
            } else if (this.isForCluster && (this.field_3866 + this.id) % 20 == 0 && Utils.squaredDistanceXZ(this.field_3874, this.field_3871, this.getCastedRotator().getSource().getEmitter()) > 29584.0) {
                this.method_3085();
            }
            if (!this.freezeOutwardMotion) {
                if ((double)this.field_3866 > (double)this.method_3082() / 1.7) {
                    if (this.angleX > 90.0f || this.angleX < 90.0f) {
                        if (this.angleX > 90.0f) {
                            this.angleX -= (float)(1 + this.field_3840.method_43048(4));
                            if (this.angleX < 90.0f) {
                                this.angleX = 90.0f;
                            }
                        } else if (this.angleX < 90.0f) {
                            this.angleX += (float)(1 + this.field_3840.method_43048(4));
                            if (this.angleX > 90.0f) {
                                this.angleX = 90.0f;
                            }
                        }
                    }
                    if (this.field_17867 < 24.0f) {
                        this.field_17867 += 0.1f;
                    }
                }
            } else {
                this.field_17867 += 0.05f;
            }
            if (this.field_3841 < this.alp) {
                this.method_3083(this.field_3841 + 0.05f);
                this.field_3841 = class_3532.method_15363((float)this.field_3841, (float)0.0f, (float)this.alp);
            } else if (this.field_3841 > this.alp) {
                this.method_3083(this.field_3841 - 0.05f);
                this.field_3841 = class_3532.method_15363((float)this.field_3841, (float)this.alp, (float)1.0f);
            }
            if (!(ModConfig.getTornadoCloudsPersistThroughBlocks() || this.field_3866 % 5 != 0 || this.field_3851.method_8311(pos = this.getPos()) || Utils.canPassThrough((class_1936)this.field_3851, pos))) {
                this.setDead();
            }
        }
        ++this.animTime;
        if (this.animTime > this.frameTime) {
            this.animTime = 0;
        }
        this.method_18141(this.pr.method_18138(this.animTime, (int)this.frameTime));
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Override
    protected void getParticleRotator() {
        Optional<StormParticleRotator> r;
        if (this.isForCluster) {
            Optional<StormParticleRotator> r2;
            TornadoParticleSource source = ClientClusterParticleSource.getFor(this);
            if (source != null && (r2 = ClientClusterParticleSource.getCloudRotator(source)).isPresent()) {
                this.rotator = r2.get();
                this.rotator.prepare(this, true);
                return;
            }
            this.setDead();
            return;
        }
        TornadoParticleSource source = ClientTornadoParticleSource.getFor(this);
        if (source != null && (r = ClientTornadoParticleSource.getCloudRotator(source)).isPresent()) {
            this.rotator = r.get();
            this.rotator.prepare(this, false);
            return;
        }
        this.setDead();
    }

    @Override
    protected boolean manualKillCondition() {
        return false;
    }

    @Override
    public float getSpecialColorValue() {
        return 0.0f;
    }

    @Override
    public boolean manuallySetPosFromMotion() {
        return false;
    }

    protected StormParticleRotator getCastedRotator() {
        return (StormParticleRotator)this.rotator;
    }

    @Override
    protected boolean lerpAngleY() {
        return this.freezeOutwardMotion;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new StormCloudParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

