/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.clusters;

import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.weather_classic.global.Global;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.registry.WCParticles;

public class StormClusterPE {
    private final class_3218 world;
    private class_243 pos;
    private float clusterStrength;
    public int age = 0;
    private class_1923 chunkPos;
    private class_2338.class_2339 blockPos;
    private boolean removed = false;
    private final class_5819 random;
    private final UUID uuid;

    public StormClusterPE(class_3218 world, int x, int z, int y) {
        this.world = world;
        this.pos = new class_243((double)x, (double)y, (double)z);
        this.blockPos = BP.of(this.pos).method_25503();
        this.clusterStrength = 0.0f;
        this.chunkPos = new class_1923(this.blockPos.method_10062());
        this.random = world.method_8409();
        this.uuid = UUID.randomUUID();
        this.clusterStrength = 0.0f;
    }

    public void setStrength(float str) {
        this.clusterStrength = str;
    }

    public void spawnCluster() {
        Global.activeClusters.add(this);
    }

    public void tick() {
        ++this.age;
        if (this.age % 10 == 0) {
            this.clusterStrength = 1.0f;
            this.killStorm();
            return;
        }
        if (this.getStrength() > 0.5f || this.random.method_43057() < this.getCloudDensity()) {
            for (int cloudCount = 0; cloudCount < (this.isStrong() ? 2 : 1); ++cloudCount) {
                Utils.forceImportantParticles(this.world, WCParticles.STORM_CLOUD_PARTICLE, this.pos.field_1352 + (double)this.random.method_43048(64) - (double)this.random.method_43048(64), this.pos.field_1351, this.pos.field_1350 + (double)this.random.method_43048(64) - (double)this.random.method_43048(64), 0, 0.0, -1.0, 0.0, 100.0);
            }
        }
    }

    public float getCloudDensity() {
        return this.getStrength() + 0.1f;
    }

    public boolean isStrong() {
        return this.getStrength() > 0.7f;
    }

    public boolean isWithinRadius(class_2338 pos) {
        return Utils.squaredDistanceTo(this.getBlockPos(), pos) < 16384.0;
    }

    public class_1923 getChunkPos() {
        return this.chunkPos;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public class_243 getPos() {
        return this.pos;
    }

    public UUID getId() {
        return this.uuid;
    }

    public float getStrength() {
        return this.clusterStrength;
    }

    public void killStorm() {
        this.removed = true;
    }
}

