/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.source;

import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.StormCloudParticleRotator;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class ClientClusterParticleSource
implements TornadoParticleSource {
    private class_243 emitter;
    private final UUID id;
    private float strength;
    private final Optional<StormParticleRotator> cloudRotator;

    public ClientClusterParticleSource(UUID id, class_243 pos, float strength) {
        this.emitter = pos;
        this.id = id;
        this.strength = strength;
        if (ClientGlobal.activeClusterSources.containsKey(id)) {
            TornadoParticleSource source = ClientGlobal.activeClusterSources.get(id);
            this.cloudRotator = ((ClientClusterParticleSource)source).cloudRotator.isPresent() ? ((ClientClusterParticleSource)source).cloudRotator : Optional.of(new StormCloudParticleRotator(this));
        } else {
            this.cloudRotator = Optional.of(new StormCloudParticleRotator(this));
        }
    }

    public void updateSource() {
        TornadoParticleSource source;
        if (!this.isRemoved() && (source = ClientGlobal.activeClusterSources.get(this.id)) != null) {
            this.emitter = source.getEmitter();
            this.strength = source.getStrength();
        }
    }

    public static TornadoParticleSource getFor(StormParticle particle) {
        TornadoParticleSource source = ClientGlobal.getClosestCluster(particle.getX(), particle.getY(), particle.getZ(), 128);
        if (source != null && !source.isRemoved()) {
            return source;
        }
        return null;
    }

    public static Optional<StormParticleRotator> getCloudRotator(TornadoParticleSource source) {
        if (!(source instanceof ClientClusterParticleSource)) {
            return Optional.empty();
        }
        return ((ClientClusterParticleSource)source).cloudRotator;
    }

    @Override
    public UUID getUuid() {
        return this.id;
    }

    @Override
    public class_243 getEmitter() {
        return this.emitter;
    }

    @Override
    public boolean isRemoved() {
        return !ClientGlobal.activeClusterSources.containsKey(this.id);
    }

    @Override
    public int getCloudY() {
        return (int)this.emitter.method_10214();
    }

    @Override
    public TornadoStats getStats() {
        return null;
    }

    @Override
    public boolean isDestructiveStorm() {
        return false;
    }

    @Override
    public boolean isSpout() {
        return false;
    }

    @Override
    public byte getTornadoType() {
        return 0;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public int getPullRadius() {
        return 0;
    }

    @Override
    public boolean isDemonic() {
        return false;
    }

    @Override
    public byte getTornadoTypeForRotator() {
        return 0;
    }
}

