/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.weather_classic.block.entity.VentilatedCellBlockEntity;
import net.weather_classic.global.Global;
import net.weather_classic.help.Utils;
import net.weather_classic.mixin.BlockWithEntityInvoker;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.storm.TornadoEntity;
import org.jetbrains.annotations.Nullable;

public class VentilatedCellBlock
extends class_2248
implements class_2343 {
    public static final MapCodec<VentilatedCellBlock> CODEC = VentilatedCellBlock.method_54094(VentilatedCellBlock::new);
    public static final class_2746 LENIENT = class_2746.method_11825((String)"lenient");

    public VentilatedCellBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LENIENT, (Comparable)Boolean.valueOf(true)));
    }

    public MapCodec<? extends VentilatedCellBlock> method_53969() {
        return CODEC;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new VentilatedCellBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? BlockWithEntityInvoker.invokeValidateTicker(type, WCBlocks.VENTILATED_CELL_BLOCK_ENTITY, VentilatedCellBlockEntity::tick) : BlockWithEntityInvoker.invokeValidateTicker(type, WCBlocks.VENTILATED_CELL_BLOCK_ENTITY, VentilatedCellBlock::tornadoCheck);
    }

    public static void tornadoCheck(class_1937 world, class_2338 pos, class_2680 state, VentilatedCellBlockEntity block) {
        TornadoEntity ent;
        if (world.method_8510() % 100L == 0L && Global.tornadoActive() && !block.getStack().method_7960() && (ent = Global.getClosestTornado(new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()))) != null && ent.isDestructiveStorm() && Utils.distanceXZ(pos, ent.method_24515()) < (double)(8 * ent.getTornadoType()) && Math.abs((double)pos.method_10264() - ent.method_23320()) < 32.0) {
            block.popItemOut();
        }
    }

    protected class_1269 method_55765(class_1799 s, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = s.method_7972();
        class_2586 be = world.method_8321(pos);
        if (be instanceof VentilatedCellBlockEntity) {
            VentilatedCellBlockEntity vc = (VentilatedCellBlockEntity)be;
            if (stack.method_7960() || !vc.getStack().method_7960()) {
                return class_1269.field_5814;
            }
            if (world.field_9236) {
                return class_1269.field_5812;
            }
            vc.setStack(stack);
            Utils.playSound((class_1297)player, world, pos, class_3417.field_46940, class_3419.field_15245, 1.0f, 1.2f + world.method_8409().method_43057() / 3.0f);
            s.method_57008(s.method_7947(), (class_1309)player);
            return class_1269.field_21466;
        }
        return class_1269.field_52423;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        VentilatedCellBlockEntity vc;
        class_2586 be = world.method_8321(pos);
        if (be instanceof VentilatedCellBlockEntity && !(vc = (VentilatedCellBlockEntity)be).getStack().method_7960()) {
            Utils.playSound(null, world, pos, class_3417.field_15075, class_3419.field_15245, 1.0f, 0.8f + world.method_8409().method_43057() / 3.0f);
        }
        return super.method_9576(world, pos, state, player);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LENIENT});
    }
}

