/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_10376;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5702;
import net.minecraft.class_7225;
import net.weather_classic.block.TurbineBlock;
import net.weather_classic.block.VentilatedCellBlock;
import net.weather_classic.block.WindChannelBlock;
import net.weather_classic.block.entity.TurbineInventory;
import net.weather_classic.block.entity.VentilatedCellBlockEntity;
import net.weather_classic.block.entity.WindChannelBlockEntity;
import net.weather_classic.config.ModConfig;
import net.weather_classic.entity.breezling.WindManipulator;
import net.weather_classic.global.Global;
import net.weather_classic.global.Wind;
import net.weather_classic.help.BP;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.misc.ItemEntityWindStateAccess;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.registry.WCItems;
import net.weather_classic.registry.WCParticles;

public class TurbineBlockEntity
extends class_2586
implements class_1275 {
    private int savedRange = 0;
    private class_238 pushBox;
    private final TurbineInventory inventory;
    private boolean windDisturbed = false;
    private boolean updatePowerStatus = true;
    private int age;
    private byte foundSignificantBlockType = (byte)-1;
    private short powerAbsorbtionTicks = 0;
    private boolean absorbNextSource = false;
    private byte absorbtionIndicator = 0;
    private boolean receivingRedstonePower = false;
    private List<class_1297> entities;
    private final class_238 soundBox;
    private byte soundUpdateTicks = 0;
    private static final Pair<Short, Short> POWER_VALUES = Pair.of((Object)3600, (Object)4800);
    private class_2338 intakePos = null;
    private int linkNum = -10;
    private int rememberLinkTicks = 0;

    public TurbineBlockEntity(class_2338 pos, class_2680 state) {
        super(WCBlocks.TURBINE_BLOCK_ENTITY, pos, state);
        this.soundBox = new class_238(pos).method_1014(12.0);
        this.updatePushBox(this.savedRange);
        final TurbineBlockEntity turbine = this;
        this.inventory = new TurbineInventory(3, turbine);
        this.inventory.method_5489(new class_1265(){
            final /* synthetic */ TurbineBlockEntity this$0;
            {
                this.this$0 = this$0;
            }

            public void method_5453(class_1263 sender) {
                turbine.method_5431();
                this.this$0.updatePowerStatus = true;
            }
        });
    }

    private void updatePushBox(int range) {
        this.savedRange = range;
        class_2350 dir = (class_2350)this.method_11010().method_11654((class_2769)TurbineBlock.field_10927);
        class_238 box = new class_238(this.field_11867.method_10093(dir));
        int boxLength = switch (this.savedRange) {
            case 0 -> 2;
            case 1 -> 5;
            default -> 9;
        };
        switch (dir.method_10166()) {
            case field_11048: {
                if (dir == class_2350.field_11039) {
                    box = box.method_1009((double)boxLength, 0.0, 0.0).method_989((double)(-boxLength), 0.0, 0.0);
                    break;
                }
                box = box.method_1009((double)boxLength, 0.0, 0.0).method_989((double)boxLength, 0.0, 0.0);
                break;
            }
            case field_11051: {
                if (dir == class_2350.field_11043) {
                    box = box.method_1009(0.0, 0.0, (double)boxLength).method_989(0.0, 0.0, (double)(-boxLength));
                    break;
                }
                box = box.method_1009(0.0, 0.0, (double)boxLength).method_989(0.0, 0.0, (double)boxLength);
                break;
            }
            case field_11052: {
                box = dir == class_2350.field_11033 ? box.method_1009(0.0, (double)boxLength, 0.0).method_989(0.0, (double)(-boxLength), 0.0) : box.method_1009(0.0, (double)boxLength, 0.0).method_989(0.0, (double)boxLength, 0.0);
            }
        }
        this.pushBox = box;
    }

    public void sendSoundUpdates() {
        this.soundUpdateTicks = (byte)20;
    }

    public boolean isReceivingRedstonePower() {
        return this.receivingRedstonePower;
    }

    public void setReceivingRedstonePower(boolean bl) {
        this.receivingRedstonePower = bl;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)TurbineBlock.field_10927);
    }

    public TurbineInventory getInventory() {
        return this.inventory;
    }

    public boolean isWeathered() {
        return this.method_11010().method_26204() == WCBlocks.WEATHERED_TURBINE;
    }

    private boolean hasPowerFromChannel() {
        WindChannelBlockEntity wc;
        class_2586 be;
        class_2680 down;
        WindChannelBlockEntity wc2;
        class_2586 be2;
        class_2680 up = this.field_11863.method_8320(this.field_11867.method_10084());
        if (up.method_26204() instanceof WindChannelBlock && (up.method_27852(WCBlocks.WEATHERED_WIND_CHANNEL) || up.method_27852(WCBlocks.INTAKE_WEATHERED_WIND_CHANNEL)) && (be2 = this.field_11863.method_8321(this.field_11867.method_10084())) instanceof WindChannelBlockEntity && (wc2 = (WindChannelBlockEntity)be2).isWindAligned()) {
            if (up.method_27852(WCBlocks.INTAKE_WEATHERED_WIND_CHANNEL)) {
                if (wc2.linkNum() < this.linkNum || this.linkNum <= -10) {
                    this.linkNum = wc2.linkNum() + 1;
                    this.rememberLinkTicks = 320;
                    this.intakePos = this.field_11867.method_10084();
                    return true;
                }
            } else if (wc2.getTurbinePowerSource() != null && wc2.getTurbinePowerSource().getSecond() != null && (wc2.linkNum() < this.linkNum || this.linkNum <= -10)) {
                this.linkNum = wc2.linkNum() + 1;
                this.rememberLinkTicks = 320;
                this.intakePos = (class_2338)wc2.getTurbinePowerSource().getSecond();
                return true;
            }
        }
        if ((down = this.field_11863.method_8320(this.field_11867.method_10074())).method_26204() instanceof WindChannelBlock && (down.method_27852(WCBlocks.WEATHERED_WIND_CHANNEL) || down.method_27852(WCBlocks.INTAKE_WEATHERED_WIND_CHANNEL)) && (be = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof WindChannelBlockEntity && (wc = (WindChannelBlockEntity)be).isWindAligned()) {
            if (down.method_27852(WCBlocks.INTAKE_WEATHERED_WIND_CHANNEL)) {
                if (wc.linkNum() < this.linkNum || this.linkNum <= -10) {
                    this.linkNum = wc.linkNum() + 1;
                    this.rememberLinkTicks = 320;
                    this.intakePos = this.field_11867.method_10074();
                    return true;
                }
            } else if (wc.getTurbinePowerSource() != null && wc.getTurbinePowerSource().getSecond() != null && (wc.linkNum() < this.linkNum || this.linkNum <= -10)) {
                this.linkNum = wc.linkNum() + 1;
                this.rememberLinkTicks = 320;
                this.intakePos = (class_2338)wc.getTurbinePowerSource().getSecond();
                return true;
            }
        }
        this.intakePos = null;
        return false;
    }

    private void getNewPowerStatus() {
        if (!this.field_11863.field_9236) {
            boolean powerState;
            boolean bl = powerState = this.isWeathered() ? this.hasPowerFromChannel() : this.getInventory().method_43256(p -> p.method_31574(class_1802.field_49098) || p.method_31574(WCItems.FILLED_WIND_VESSEL));
            if ((Boolean)this.method_11010().method_11654((class_2769)TurbineBlock.POWERED) != powerState) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TurbineBlock.POWERED, (Comparable)Boolean.valueOf(powerState)));
                if (powerState && ((Boolean)this.method_11010().method_11654((class_2769)TurbineBlock.ACTIVE)).booleanValue()) {
                    this.foundSignificantBlockType = (byte)2;
                }
            }
        }
        this.updatePowerStatus = false;
    }

    public void markUpdatePowerStatus() {
        this.updatePowerStatus = true;
    }

    private void absorbPower(boolean charge) {
        if (!this.field_11863.field_9236) {
            this.absorbNextSource = false;
            if (!this.getInventory().method_5442()) {
                this.powerAbsorbtionTicks = charge ? (Short)POWER_VALUES.getSecond() : (Short)POWER_VALUES.getFirst();
                this.absorbNextSource = true;
                this.absorbtionIndicator = (byte)3;
                ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
            } else {
                this.absorbtionIndicator = 0;
            }
        }
    }

    public byte getAbsorbtionIndicator() {
        return this.absorbtionIndicator;
    }

    public boolean isWindDisturbed() {
        return this.windDisturbed;
    }

    private boolean canPlaySound() {
        class_2350[] dirs;
        if (!ModConfig.getCullTurbineSound()) {
            return true;
        }
        for (class_2350 dir : dirs = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033}) {
            class_2338 offset = this.field_11867.method_10093(dir);
            class_2680 offsetState = this.field_11863.method_8320(offset);
            if (!(offsetState.method_26204() instanceof TurbineBlock) || !((Boolean)offsetState.method_11654((class_2769)TurbineBlock.POWERED)).booleanValue() || !((Boolean)offsetState.method_11654((class_2769)TurbineBlock.ACTIVE)).booleanValue()) continue;
            return dir.method_10166() == class_2350.class_2351.field_11048 ? this.field_11867.method_10263() % 2 == 0 : (dir.method_10166() == class_2350.class_2351.field_11051 ? this.field_11867.method_10260() % 2 == 0 : this.field_11867.method_10264() % 2 == 0);
        }
        return true;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TurbineBlockEntity block) {
        ++block.age;
        if (block.updatePowerStatus) {
            block.getNewPowerStatus();
        }
        if (block.rememberLinkTicks > 0) {
            --block.rememberLinkTicks;
        } else if (block.linkNum > -10) {
            block.linkNum = -10;
        }
        if (block.isWeathered() && block.age % 60 == 0) {
            block.updatePowerStatus = true;
        }
        if (!((Boolean)state.method_11654((class_2769)TurbineBlock.ACTIVE)).booleanValue() || !((Boolean)state.method_11654((class_2769)TurbineBlock.POWERED)).booleanValue()) {
            return;
        }
        if (!world.field_9236) {
            boolean sound;
            if (block.age % 40 == 0) {
                sound = block.canPlaySound();
                for (class_1657 player : Utils.getPlayersIn(world, block.soundBox)) {
                    WCNetworkServer.sendTurbineSoundPacket(pos, (class_3222)player, !sound);
                }
            }
            if (block.soundUpdateTicks > 0) {
                if (block.soundUpdateTicks % 4 == 0) {
                    sound = block.canPlaySound();
                    for (class_1657 player : Utils.getPlayersIn(world, block.soundBox)) {
                        WCNetworkServer.sendTurbineSoundPacket(pos, (class_3222)player, !sound);
                    }
                }
                block.soundUpdateTicks = (byte)(block.soundUpdateTicks - 1);
            }
        }
        int range = (Integer)state.method_11654((class_2769)TurbineBlock.RANGE);
        if (block.powerAbsorbtionTicks <= 0) {
            boolean charge = false;
            if (block.absorbNextSource) {
                if (block.getInventory().method_43256(s -> s.method_31574(class_1802.field_49098))) {
                    block.getInventory().method_20631(class_1802.field_49098, 1);
                    charge = true;
                } else {
                    block.getInventory().method_20631(WCItems.FILLED_WIND_VESSEL, 1);
                    Utils.playSound(null, world, pos, class_3417.field_15081, class_3419.field_15254, 0.5f, 1.5f);
                }
            }
            block.absorbPower(charge);
        } else {
            block.powerAbsorbtionTicks = (short)(block.powerAbsorbtionTicks - 1);
            if (range > 0 && world.method_8510() % 30L == 0L) {
                block.powerAbsorbtionTicks = (short)(block.powerAbsorbtionTicks - (range > 1 ? 10 : 5));
            }
            if (!world.field_9236) {
                if (block.powerAbsorbtionTicks < (short)((double)((Short)POWER_VALUES.getFirst()).shortValue() * 0.34)) {
                    if (block.absorbtionIndicator != 1) {
                        block.absorbtionIndicator = 1;
                        ((class_3218)world).method_14178().method_14128(pos);
                    }
                } else if (block.powerAbsorbtionTicks < (short)((double)((Short)POWER_VALUES.getFirst()).shortValue() * 0.67) && block.absorbtionIndicator != 2) {
                    block.absorbtionIndicator = (byte)2;
                    ((class_3218)world).method_14178().method_14128(pos);
                }
            }
        }
        if (block.savedRange != range) {
            block.updatePushBox(range);
        }
        class_2350 dir = (class_2350)state.method_11654((class_2769)TurbineBlock.field_10927);
        class_2382 v = dir.method_62675();
        class_243 vector = new class_243((double)v.method_10263(), (double)v.method_10264(), (double)v.method_10260()).method_1021((double)0.1357f);
        if (world.field_9236) {
            boolean varyX = dir.method_10166() != class_2350.class_2351.field_11048;
            boolean varyZ = dir.method_10166() != class_2350.class_2351.field_11051;
            boolean varyY = dir.method_10166() != class_2350.class_2351.field_11052;
            world.method_8406((class_2394)WCParticles.WIND_PARTICLE, (double)pos.method_10263() + (varyX ? (double)world.field_9229.method_43057() : 0.5) + (double)v.method_10263() * 0.6, (double)pos.method_10264() + (varyY ? (double)world.field_9229.method_43057() : 0.5) + (double)v.method_10264() * 0.6, (double)pos.method_10260() + (varyZ ? (double)world.field_9229.method_43057() : 0.5) + (double)v.method_10260() * 0.6, (double)(100 + range), 0.0, block.windDisturbed ? 0.0 : (double)Utils.getWindParticleDirectionForManual(dir));
        }
        if (block.age % 5 == 0) {
            block.entities = world.method_8333(null, block.pushBox, p -> !Utils.inInvalidMode(p) && !Utils.isWindImmuneMob(p));
        }
        if (block.entities == null) {
            return;
        }
        if (!world.field_9236 && (Global.tornadoActive() || !block.entities.isEmpty() || block.windDisturbed) && block.age % 40 == 0) {
            WindManipulator wind = Global.getPlayerForManipulation(world, pos.method_10093(dir));
            if (wind != null || Global.tornadoActive() && Wind.isOutsideInWindArea(Utils.convertBlockPosToVec(pos.method_10093(dir)), world)) {
                if (!block.windDisturbed) {
                    block.windDisturbed = true;
                    ((class_3218)world).method_14178().method_14128(pos);
                    return;
                }
            } else if (block.windDisturbed) {
                block.windDisturbed = false;
                ((class_3218)world).method_14178().method_14128(pos);
            }
        }
        if (block.windDisturbed) {
            return;
        }
        for (class_1297 ent : block.entities) {
            class_243 mv;
            if (!TurbineBlockEntity.canTurbineSeeEntity(world, pos, dir, ent)) continue;
            class_243 class_2432 = mv = ent.method_24828() ? vector : vector.method_1021(0.7);
            if (ent.method_5709() && dir == class_2350.field_11036) {
                ent.field_6017 = 0.0f;
            }
            if (!ent.method_31747()) {
                if (ent instanceof ItemEntityWindStateAccess) {
                    ItemEntityWindStateAccess item = (ItemEntityWindStateAccess)ent;
                    block.handleItemEntityVelocity(world, item, mv, 0.4f, dir);
                    continue;
                }
                if (world.field_9236) continue;
                block.handleNormalEntityVelocity(ent, mv, 0.4f, dir);
                continue;
            }
            block.handleNormalEntityVelocity(ent, mv, 0.4f, dir);
        }
        int length = (int)(dir.method_10166() == class_2350.class_2351.field_11048 ? block.pushBox.method_17939() : (dir.method_10166() == class_2350.class_2351.field_11051 ? block.pushBox.method_17941() : block.pushBox.method_17940()));
        if (world.method_8510() % (long)(switch (block.foundSignificantBlockType) {
            case 0 -> 10;
            case 1 -> 1;
            case 2 -> 100;
            default -> 200;
        }) != 0L) {
            return;
        }
        block.foundSignificantBlockType = (byte)-1;
        for (int i = 1; i < length + 2; ++i) {
            class_2338 offset = pos.method_10079(dir, i);
            class_2680 offsetState = world.method_8320(offset);
            if (offsetState.method_26215()) continue;
            if (offsetState.method_26204() instanceof WindChannelBlock) {
                class_2586 be;
                if (offsetState.method_11654((class_2769)WindChannelBlock.field_11177) != dir.method_10153() || !((be = world.method_8321(offset)) instanceof WindChannelBlockEntity)) break;
                WindChannelBlockEntity wc = (WindChannelBlockEntity)be;
                if (block.isWeathered()) {
                    if (!wc.isWeathered() || wc.isIntake() || world.field_9236) break;
                    wc.setWindAligned(true, (Pair<class_2338, class_2338>)Pair.of((Object)pos, (Object)block.intakePos), block.linkNum);
                    break;
                }
                if (!wc.isIntake() && wc.isWeathered() || world.field_9236) break;
                wc.setWindAligned(true, (Pair<class_2338, class_2338>)Pair.of((Object)pos, null), -2);
                block.foundSignificantBlockType = 0;
                break;
            }
            if (offsetState.method_26204() instanceof VentilatedCellBlock) {
                class_2586 be = world.method_8321(offset);
                if (!(be instanceof VentilatedCellBlockEntity)) break;
                VentilatedCellBlockEntity vc = (VentilatedCellBlockEntity)be;
                if (!((Boolean)offsetState.method_11654((class_2769)VentilatedCellBlock.LENIENT)).booleanValue() && !block.isWeathered() || vc.getStack().method_7960()) break;
                vc.blowItem(dir);
                block.foundSignificantBlockType = 1;
                break;
            }
            if (offsetState.method_26204() instanceof class_2269) {
                if (!((Boolean)offsetState.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                    ((class_2269)offsetState.method_26204()).method_21845(offsetState, world, offset, null);
                }
                block.foundSignificantBlockType = (byte)2;
                break;
            }
            if (!world.method_8320(offset).method_26215()) break;
        }
    }

    private void handleItemEntityVelocity(class_1937 world, ItemEntityWindStateAccess item, class_243 vector, float max, class_2350 dir) {
        if (!world.field_9236 && !item.isTurbineAffected()) {
            item.enableTurbineMotion();
        }
        if (item.isTurbineAffected()) {
            class_1297 ent = (class_1297)item;
            class_243 iv = vector.method_1021(0.7);
            ent.method_5762(iv.field_1352, iv.field_1351, iv.field_1350);
            class_243 velocity = ent.method_18798();
            double clampedX = class_3532.method_15350((double)velocity.field_1352, (double)(-max), (double)max);
            double clampedY = class_3532.method_15350((double)velocity.field_1351, (double)-2.147483648E9, (double)(dir == class_2350.field_11036 ? (double)max : 2.147483647E9));
            double clampedZ = class_3532.method_15350((double)velocity.field_1350, (double)(-max), (double)max);
            ent.method_18800(clampedX, clampedY, clampedZ);
        }
    }

    private void handleNormalEntityVelocity(class_1297 player, class_243 motion, float max, class_2350 dir) {
        player.method_5762(motion.field_1352, motion.field_1351, motion.field_1350);
        class_243 velocity = player.method_18798();
        double clampedX = class_3532.method_15350((double)velocity.field_1352, (double)(-max), (double)max);
        double clampedY = class_3532.method_15350((double)velocity.field_1351, (double)-2.147483648E9, (double)(dir == class_2350.field_11036 ? (double)max : 2.147483647E9));
        double clampedZ = class_3532.method_15350((double)velocity.field_1350, (double)(-max), (double)max);
        player.method_18800(clampedX, clampedY, clampedZ);
    }

    public static boolean canTurbineSeeEntity(class_1937 world, class_2338 turbine, class_2350 facing, class_1297 ent) {
        class_243 vec = Utils.convertBlockPosToVec(turbine.method_10093(facing));
        class_2338 intersectPos = ent.method_24515();
        if (ent.method_31477() == turbine.method_10263() && ent.method_31479() == turbine.method_10260()) {
            return TurbineBlockEntity.canSeePos(world, vec, intersectPos);
        }
        int dist = turbine.method_10264() - ent.method_31478();
        if (dist > 0) {
            intersectPos = intersectPos.method_10086(dist);
        } else if (dist < 0) {
            intersectPos = intersectPos.method_10087(dist);
        }
        return TurbineBlockEntity.canSeePos(world, vec, intersectPos);
    }

    public static boolean canSeePos(class_1937 world, class_243 vec, class_2338 pos) {
        class_243 vec3d = new class_243(vec.field_1352, vec.field_1351, vec.field_1350);
        class_243 vec3d2 = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        if (vec3d2.method_1022(vec3d) > 128.0) {
            return false;
        }
        return world.method_32880(new class_5702(vec3d, vec3d2, p -> !TurbineBlockEntity.canWindPassThrough(p.method_26204()))).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canWindPassThrough(class_2248 block) {
        return block.method_9538(block.method_9564()) || block instanceof class_10376 || Materials.isVentilated(block.method_9564());
    }

    public class_2561 method_5477() {
        return class_2561.method_43470((String)"Turbine");
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (nbt.method_10545("updatingIndicatorOnClient")) {
            this.absorbtionIndicator = nbt.method_10571("indicator");
            this.windDisturbed = nbt.method_10577("windDisturbed");
            return;
        }
        super.method_11014(nbt, registryLookup);
        class_2371 l = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, (class_2371)l, (class_7225.class_7874)registryLookup);
        for (int i = 0; i < l.size(); ++i) {
            this.inventory.method_5447(i, (class_1799)l.get(i));
        }
        this.absorbtionIndicator = nbt.method_10571("absorbtionIndicator");
        this.receivingRedstonePower = nbt.method_10577("redstonePowered");
        this.powerAbsorbtionTicks = nbt.method_10568("powerTicks");
        this.linkNum = nbt.method_10550("linkNum");
        this.rememberLinkTicks = nbt.method_10550("rememberLinkTicks");
        class_2338 ip = null;
        if (nbt.method_10545("iPosX") && nbt.method_10545("iPosY") && nbt.method_10545("iPosZ")) {
            int x = nbt.method_10550("iPosX");
            int y = nbt.method_10550("iPosY");
            int z = nbt.method_10550("iPosZ");
            ip = BP.of(x, y, z);
        }
        this.intakePos = ip;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2371 l = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
        for (int i = 0; i < this.getInventory().method_5439(); ++i) {
            l.set(i, (Object)this.getInventory().method_5438(i));
        }
        class_1262.method_5426((class_2487)nbt, (class_2371)l, (class_7225.class_7874)registryLookup);
        nbt.method_10567("absorbtionIndicator", this.absorbtionIndicator);
        nbt.method_10556("redstonePowered", this.receivingRedstonePower);
        nbt.method_10575("powerTicks", this.powerAbsorbtionTicks);
        nbt.method_10569("linkNum", this.linkNum);
        nbt.method_10569("rememberLinkTicks", this.rememberLinkTicks);
        class_2338 ip = this.intakePos;
        if (ip != null) {
            nbt.method_10569("iPosX", ip.method_10263());
            nbt.method_10569("iPosY", ip.method_10264());
            nbt.method_10569("iPosZ", ip.method_10260());
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return (class_2487)class_156.method_654((Object)new class_2487(), nbt -> {
            nbt.method_10556("updatingIndicatorOnClient", true);
            nbt.method_10567("indicator", this.absorbtionIndicator);
            nbt.method_10556("windDisturbed", this.windDisturbed);
        });
    }
}

