/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;

public class ModConfig {
    private static final Path configDir = FabricLoader.getInstance().getConfigDir().resolve("weather_classic.json");
    public static boolean WARN_DUE_TO_OUTDATED_VERSION = false;
    public static final byte CUR_VER = 9;
    private static int maxTornadoes = 2;
    private static int maxDaysNoRain = 3;
    private static int maxDaysNoStorm = 5;
    private static int maxRainNoDownpour = 5;
    private static int rainChanceBase = 62;
    private static int stormChanceBase = 35;
    private static int rainWorsenChance = 10;
    private static byte tornadoDestructionLvl = (byte)2;
    private static boolean tornadoesBiasTowardsPlayers = true;
    private static boolean tornadoesExtraLongDuration = false;
    private static int tornadoFrequency = 37;
    private static int waterspoutFrequency = 50;
    private static boolean allowMultipleTornadoesSameStorm = false;
    private static int maxDebrisPerTornado = 60;
    private static int maxMobsPerTornado = 25;
    private static boolean terrariaReference = true;
    private static boolean playWindSounds = true;
    private static boolean severeStormLightningStrikesMobs = true;
    private static boolean severeStormLightningStrikesPlayers = true;
    private static byte tornadoesBiasIntensityLvl = 1;
    private static boolean forceChunkRemovalOnWorldLoad = true;
    private static int drownedAttackDuringDownpourChance = 23;
    private static int stormBecomeSevereStormChance = 77;
    private static int maxTornadoLoadDistance = 320;
    private static int apexOnlyChance = 30;
    private static int stageForceHighIfLongStormChance = 45;
    private static int stage2Chance = 72;
    private static int stage3ChanceIfNot2 = 80;
    private static int stage4ChanceIfNot3 = 75;
    private static int maxWindNoGale = 6;
    private static boolean tornadoCloudsPersistThroughBlocks = false;
    private static int cursedStormChance = 2;
    private static boolean cullTurbineSound = false;
    private static boolean forceDebrisVelocityUpdates = true;
    private static boolean doDownpourFlooding = true;
    private static boolean enableCustomTornadoes = true;
    private static int passiveFirenadoChance = 1;
    private static boolean classicTornadoColors = false;
    private static boolean cullDebrisRendering = false;
    private static int tornadoDetectorRange = 128;
    private static boolean disableAllPhantomTornadoes = false;
    private static boolean oldSirenSound = false;
    private static boolean disableGale = false;
    private static boolean debug = false;

    public static boolean getDisableGale() {
        return disableGale;
    }

    public static boolean getDisableAllPhantomTornadoes() {
        return disableAllPhantomTornadoes;
    }

    public static boolean getOldSirenSound() {
        return oldSirenSound;
    }

    public static int getTornadoDetectorRange() {
        return tornadoDetectorRange;
    }

    public static boolean getCullDebrisRendering() {
        return cullDebrisRendering;
    }

    public static boolean getClassicTornadoColors() {
        return classicTornadoColors;
    }

    public static int getPassiveFirenadoChance() {
        return passiveFirenadoChance;
    }

    public static boolean getEnableCustomTornadoes() {
        return enableCustomTornadoes;
    }

    public static boolean doDownpourFlooding() {
        return doDownpourFlooding;
    }

    public static boolean forceDebrisVelocityUpdates() {
        return forceDebrisVelocityUpdates;
    }

    public static boolean getCullTurbineSound() {
        return cullTurbineSound;
    }

    public static int getCursedStormChance() {
        return cursedStormChance;
    }

    public static boolean getTornadoCloudsPersistThroughBlocks() {
        return tornadoCloudsPersistThroughBlocks;
    }

    public static int getMaxWindNoGale() {
        return maxWindNoGale;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static int getApexOnlyChance() {
        return apexOnlyChance;
    }

    public static int getForceHighStageChanceIfLong() {
        return stageForceHighIfLongStormChance;
    }

    public static int getStage2Chance() {
        return stage2Chance;
    }

    public static int getStage3ChanceIfNot2() {
        return stage3ChanceIfNot2;
    }

    public static int getStage4ChanceIfNot3() {
        return stage4ChanceIfNot3;
    }

    public static int getMaxTornadoLoadDist() {
        return maxTornadoLoadDistance;
    }

    public static int getMaxTornadoes() {
        return maxTornadoes;
    }

    public static int getMaxDaysNoRain() {
        return maxDaysNoRain;
    }

    public static int getMaxDaysNoStorm() {
        return maxDaysNoStorm;
    }

    public static int getMaxRainDaysNoDownpour() {
        return maxRainNoDownpour;
    }

    public static int getRainChanceBase() {
        return rainChanceBase;
    }

    public static int getStormChanceBase() {
        return stormChanceBase;
    }

    public static int getRainWorsenChance() {
        return rainWorsenChance;
    }

    public static byte getTornadoDestructionLvl() {
        return tornadoDestructionLvl;
    }

    public static boolean getTornadoesBiasTowardsPlayers() {
        return tornadoesBiasTowardsPlayers;
    }

    public static boolean getTornadoesExtraLongDuration() {
        return tornadoesExtraLongDuration;
    }

    public static float getTornadoFrequency() {
        return (float)tornadoFrequency / 100.0f;
    }

    public static float getWaterspoutFrequency() {
        return (float)waterspoutFrequency / 100.0f;
    }

    public static boolean getAllowMultipleTornadoesSameStorm() {
        return allowMultipleTornadoesSameStorm;
    }

    public static int getMaxMobsPerTornado() {
        return maxMobsPerTornado;
    }

    public static int getMaxDebrisPerTornado() {
        return maxDebrisPerTornado;
    }

    public static boolean getTerrariaReference() {
        return terrariaReference;
    }

    public static boolean getPlayWindSounds() {
        return playWindSounds;
    }

    public static boolean getSevereStormLightningStrikesMobs() {
        return severeStormLightningStrikesMobs;
    }

    public static boolean getSevereStormLightningStrikesPlayers() {
        return severeStormLightningStrikesPlayers;
    }

    public static byte getTornadoBiasIntensityLvl() {
        return tornadoesBiasIntensityLvl;
    }

    public static boolean getForceChunkRemovalOnWorldLoad() {
        return forceChunkRemovalOnWorldLoad;
    }

    public static int getDrownedAttackDuringDownpourChance() {
        return drownedAttackDuringDownpourChance;
    }

    public static int getSevereStormChance() {
        return stormBecomeSevereStormChance;
    }

    public static boolean loadConfig() throws IOException {
        boolean hadToCreate = false;
        File dataFile = configDir.toFile();
        if (!dataFile.exists()) {
            if (!dataFile.createNewFile()) {
                throw new IOException("CRITICAL ERROR: Could not create config for Weather Classic!");
            }
            ModConfig.saveDefaultConfig(dataFile);
            hadToCreate = true;
        }
        ModConfig.loadConfig(dataFile);
        return !hadToCreate;
    }

    private static void saveDefaultConfig(File dataFile) {
        Properties properties = new Properties();
        properties.setProperty("!WCV!", String.valueOf(9));
        properties.setProperty("max_tornadoes", String.valueOf(2));
        properties.setProperty("max_days_no_rain", String.valueOf(3));
        properties.setProperty("max_days_no_storm", String.valueOf(5));
        properties.setProperty("max_rain_no_downpour", String.valueOf(5));
        properties.setProperty("max_wind_no_gale", String.valueOf(6));
        properties.setProperty("base_rain_chance_out_of_100", String.valueOf(62));
        properties.setProperty("base_storm_chance_out_of_100", String.valueOf(35));
        properties.setProperty("rain_worsen_chance_out_of_100", String.valueOf(10));
        properties.setProperty("tornado_destruction_lvl", String.valueOf(2));
        properties.setProperty("tornadoes_bias_towards_players", String.valueOf(true));
        properties.setProperty("tornadoes_extra_long_duration", String.valueOf(false));
        properties.setProperty("tornado_frequency_out_of_100", String.valueOf(37));
        properties.setProperty("waterspout_frequency_out_of_100", String.valueOf(50));
        properties.setProperty("severe_storm_allow_multiple_tornadoes", String.valueOf(false));
        properties.setProperty("max_debris_per_tornado", String.valueOf(60));
        properties.setProperty("max_mobs_per_tornado", String.valueOf(25));
        properties.setProperty("terraria_reference", String.valueOf(true));
        properties.setProperty("R_play_wind_sounds_client", String.valueOf(true));
        properties.setProperty("severe_storm_lightning_strikes_mobs", String.valueOf(true));
        properties.setProperty("severe_storm_lightning_strikes_players", String.valueOf(true));
        properties.setProperty("tornado_bias_intensity_lvl", String.valueOf(1));
        properties.setProperty("ALL_FORCE_CHUNKS_REMOVED_ON_WORLD_LOAD_DEBUG", String.valueOf(true));
        properties.setProperty("downpour_drowned_attack_chance_out_of_100", String.valueOf(23));
        properties.setProperty("severe_storm_chance_out_of_100", String.valueOf(77));
        properties.setProperty("R_max_tornado_load_distance", String.valueOf(320));
        properties.setProperty("severe_storm_restrict_tornadoes_to_high_intensity_chance_out_of_100", String.valueOf(30));
        properties.setProperty("severe_storm_force_high_stage_if_long_chance_out_of_100", String.valueOf(50));
        properties.setProperty("stage_2_chance_out_of_100", String.valueOf(72));
        properties.setProperty("stage_3_chance_out_of_100", String.valueOf(80));
        properties.setProperty("stage_4_chance_out_of_100", String.valueOf(75));
        properties.setProperty("R_debug", String.valueOf(false));
        properties.setProperty("R_tornado_clouds_persist_through_blocks", String.valueOf(false));
        properties.setProperty("cursed_storm_chance_out_of_100", String.valueOf(2));
        properties.setProperty("cull_turbine_sound", String.valueOf(false));
        properties.setProperty("force_debris_velocity_updates", String.valueOf(true));
        properties.setProperty("downpour_minor_flooding_during_severe_storms", String.valueOf(true));
        properties.setProperty("R_enable_custom_tornadoes", String.valueOf(true));
        properties.setProperty("passive_firenado_chance_out_of_100", String.valueOf(1));
        properties.setProperty("R_old_style_tornadoes", String.valueOf(false));
        properties.setProperty("R_cull_debris_rendering", String.valueOf(false));
        properties.setProperty("tornado_detector_range", String.valueOf(128));
        properties.setProperty("disable_all_phantom_tornadoes", String.valueOf(false));
        properties.setProperty("old_siren_sound", String.valueOf(false));
        properties.setProperty("disable_gale", String.valueOf(false));
        try (FileOutputStream output = new FileOutputStream(dataFile);){
            properties.store(output, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File dataFile) {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(dataFile);){
            properties.load(input);
            maxTornadoes = Integer.parseInt(properties.getProperty("max_tornadoes", "2"));
            maxDaysNoRain = Integer.parseInt(properties.getProperty("max_days_no_rain", "3"));
            maxDaysNoStorm = Integer.parseInt(properties.getProperty("max_days_no_storm", "5"));
            maxRainNoDownpour = Integer.parseInt(properties.getProperty("max_rain_no_downpour", "5"));
            maxWindNoGale = Integer.parseInt(properties.getProperty("max_wind_no_gale", "6"));
            disableAllPhantomTornadoes = Boolean.parseBoolean(properties.getProperty("disable_all_phantom_tornadoes", "false"));
            oldSirenSound = Boolean.parseBoolean(properties.getProperty("old_siren_sound", "false"));
            disableGale = Boolean.parseBoolean(properties.getProperty("disable_gale", "false"));
            rainChanceBase = Integer.parseInt(properties.getProperty("base_rain_chance_out_of_100", "62"));
            stormChanceBase = Integer.parseInt(properties.getProperty("base_storm_chance_out_of_100", "35"));
            rainWorsenChance = Integer.parseInt(properties.getProperty("rain_worsen_chance_out_of_100", "10"));
            tornadoDestructionLvl = Byte.parseByte(properties.getProperty("tornado_destruction_lvl", "2"));
            tornadoesBiasTowardsPlayers = Boolean.parseBoolean(properties.getProperty("tornadoes_bias_towards_players", "true"));
            tornadoesExtraLongDuration = Boolean.parseBoolean(properties.getProperty("tornadoes_extra_long_duration", "false"));
            tornadoFrequency = Integer.parseInt(properties.getProperty("tornado_frequency_out_of_100", "37"));
            waterspoutFrequency = Integer.parseInt(properties.getProperty("waterspout_frequency_out_of_100", "50"));
            allowMultipleTornadoesSameStorm = Boolean.parseBoolean(properties.getProperty("severe_storm_allow_multiple_tornadoes", "false"));
            maxDebrisPerTornado = Integer.parseInt(properties.getProperty("max_debris_per_tornado", "60"));
            maxMobsPerTornado = Integer.parseInt(properties.getProperty("max_mobs_per_tornado", "25"));
            terrariaReference = Boolean.parseBoolean(properties.getProperty("terraria_reference", "true"));
            playWindSounds = Boolean.parseBoolean(properties.getProperty("R_play_wind_sounds_client", "true"));
            severeStormLightningStrikesMobs = Boolean.parseBoolean(properties.getProperty("severe_storm_lightning_strikes_mobs", "true"));
            severeStormLightningStrikesPlayers = Boolean.parseBoolean(properties.getProperty("severe_storm_lightning_strikes_players", "true"));
            tornadoesBiasIntensityLvl = Byte.parseByte(properties.getProperty("tornado_bias_intensity_lvl", "1"));
            forceChunkRemovalOnWorldLoad = Boolean.parseBoolean(properties.getProperty("ALL_FORCE_CHUNKS_REMOVED_ON_WORLD_LOAD_DEBUG", "true"));
            drownedAttackDuringDownpourChance = Integer.parseInt(properties.getProperty("downpour_drowned_attack_chance_out_of_100", "23"));
            stormBecomeSevereStormChance = Integer.parseInt(properties.getProperty("severe_storm_chance_out_of_100", "77"));
            maxTornadoLoadDistance = Integer.parseInt(properties.getProperty("R_max_tornado_load_distance", "320"));
            apexOnlyChance = Integer.parseInt(properties.getProperty("severe_storm_restrict_tornadoes_to_high_intensity_chance_out_of_100", "30"));
            stageForceHighIfLongStormChance = Integer.parseInt(properties.getProperty("severe_storm_force_high_stage_if_long_chance_out_of_100", "50"));
            stage2Chance = Integer.parseInt(properties.getProperty("stage_2_chance_out_of_100", "72"));
            stage3ChanceIfNot2 = Integer.parseInt(properties.getProperty("stage_3_chance_out_of_100", "80"));
            stage4ChanceIfNot3 = Integer.parseInt(properties.getProperty("stage_4_chance_out_of_100", "75"));
            tornadoCloudsPersistThroughBlocks = Boolean.parseBoolean(properties.getProperty("R_tornado_clouds_persist_through_blocks", "false"));
            cursedStormChance = Integer.parseInt(properties.getProperty("cursed_storm_chance_out_of_100", "2"));
            cullTurbineSound = Boolean.parseBoolean(properties.getProperty("cull_turbine_sound", "false"));
            forceDebrisVelocityUpdates = Boolean.parseBoolean(properties.getProperty("force_debris_velocity_updates", "true"));
            doDownpourFlooding = Boolean.parseBoolean(properties.getProperty("downpour_minor_flooding_during_severe_storms", "true"));
            enableCustomTornadoes = Boolean.parseBoolean(properties.getProperty("R_enable_custom_tornadoes", "true"));
            passiveFirenadoChance = Integer.parseInt(properties.getProperty("passive_firenado_chance_out_of_100", "1"));
            classicTornadoColors = Boolean.parseBoolean(properties.getProperty("R_old_style_tornadoes", "false"));
            cullDebrisRendering = Boolean.parseBoolean(properties.getProperty("R_cull_debris_rendering", "false"));
            tornadoDetectorRange = Integer.parseInt(properties.getProperty("tornado_detector_range", "128"));
            debug = Boolean.parseBoolean(properties.getProperty("R_debug", "false"));
            maxTornadoes = class_3532.method_15340((int)maxTornadoes, (int)0, (int)10);
            maxDaysNoRain = class_3532.method_15340((int)maxDaysNoRain, (int)0, (int)20);
            maxDaysNoStorm = class_3532.method_15340((int)maxDaysNoStorm, (int)0, (int)20);
            maxRainNoDownpour = class_3532.method_15340((int)maxRainNoDownpour, (int)0, (int)20);
            maxWindNoGale = class_3532.method_15340((int)maxWindNoGale, (int)0, (int)20);
            rainChanceBase = class_3532.method_15340((int)rainChanceBase, (int)0, (int)100);
            stormChanceBase = class_3532.method_15340((int)stormChanceBase, (int)0, (int)100);
            rainWorsenChance = class_3532.method_15340((int)rainWorsenChance, (int)0, (int)100);
            tornadoDestructionLvl = (byte)class_3532.method_15340((int)tornadoDestructionLvl, (int)0, (int)2);
            waterspoutFrequency = class_3532.method_15340((int)waterspoutFrequency, (int)0, (int)100);
            tornadoFrequency = class_3532.method_15340((int)tornadoFrequency, (int)0, (int)100);
            maxDebrisPerTornado = class_3532.method_15340((int)maxDebrisPerTornado, (int)0, (int)300);
            maxMobsPerTornado = class_3532.method_15340((int)maxMobsPerTornado, (int)0, (int)100);
            tornadoesBiasIntensityLvl = (byte)class_3532.method_15340((int)tornadoesBiasIntensityLvl, (int)0, (int)2);
            drownedAttackDuringDownpourChance = class_3532.method_15340((int)drownedAttackDuringDownpourChance, (int)0, (int)100);
            stormBecomeSevereStormChance = class_3532.method_15340((int)stormBecomeSevereStormChance, (int)0, (int)100);
            maxTornadoLoadDistance = class_3532.method_15340((int)maxTornadoLoadDistance, (int)256, (int)512);
            apexOnlyChance = class_3532.method_15340((int)apexOnlyChance, (int)0, (int)100);
            stageForceHighIfLongStormChance = class_3532.method_15340((int)stageForceHighIfLongStormChance, (int)0, (int)100);
            stage2Chance = class_3532.method_15340((int)stage2Chance, (int)0, (int)100);
            stage3ChanceIfNot2 = class_3532.method_15340((int)stage3ChanceIfNot2, (int)0, (int)100);
            stage4ChanceIfNot3 = class_3532.method_15340((int)stage4ChanceIfNot3, (int)0, (int)100);
            cursedStormChance = class_3532.method_15340((int)cursedStormChance, (int)0, (int)100);
            passiveFirenadoChance = class_3532.method_15340((int)passiveFirenadoChance, (int)0, (int)100);
            tornadoDetectorRange = class_3532.method_15340((int)tornadoDetectorRange, (int)16, (int)512);
            WARN_DUE_TO_OUTDATED_VERSION = ModConfig.containsOutdatedInfo(properties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean containsOutdatedInfo(Properties p) {
        return !p.containsKey("!WCV!") || Byte.parseByte(p.getProperty("!WCV!")) != 9;
    }
}

