/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.IGlobal;
import net.weather_classic.global.tools.WeatherEventProbabilityCalculator;
import net.weather_classic.help.BP;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.player.PlayerInputAccount;
import net.weather_classic.storm.sound.StormSound;
import net.weather_classic.storm.sound.StormSoundInfo;
import net.weather_classic.storm.sound.StormSoundManager;

public class Wind
implements IGlobal {
    private final class_3218 world;
    private int prevWindAngle = 0;
    private int windAngle = 0;
    private int goalAngle = 0;
    private float prevWindStrength = 0.0f;
    private float windStrength = 0.0f;
    private final float diminishThreshold = 0.025f;
    private final float gustyThreshold = 0.01f;
    private boolean prevWindy = false;
    private boolean windy = false;
    private boolean diminishing = false;
    private int daysSinceWind = 0;
    private boolean prevGusty = false;
    private int endWindTimer = 0;
    private int daysSinceGale = 0;
    private boolean isGale = false;
    private short galeTransitionTicks = 0;
    private short prevGaleTransitionTicks = 0;
    private boolean ghastly = false;
    private boolean prevGhastly = false;
    private int galeStartTimer = 0;
    private Map<UUID, PlayerInputAccount> playerInputs = new HashMap<UUID, PlayerInputAccount>();

    public Wind(class_3218 world) {
        this.world = world;
    }

    public void tick() {
        TornadoEntity tornado;
        StormSoundManager manager;
        this.tickPlayerInputsForStorms();
        this.updateWindStatusByDay(Global.playersSkippingNight(this.world));
        if (this.windAngle != this.goalAngle) {
            this.incrementWindAngle(this.windAngle > this.goalAngle);
        }
        if (this.world.method_8510() % (long)(this.gusty() ? (this.isGale() ? 100 : 250) : 700) == 0L && this.world.method_8409().method_43048(3) == 0) {
            this.randomizeWindAngle();
            if (!this.windy) {
                float small;
                this.windStrength = small = this.world.field_9229.method_43048(5) == 0 ? 0.0f : Utils.getVerySmallFloat(this.world.field_9229, 0.006f);
            }
        }
        if (!(this.world.method_8510() % 120L != 0L || this.windy && this.gusty() || !Global.tornadoActive() && !this.isGale() && !Global.weather.isSevereStorm() || this.isWindyDay())) {
            this.setWindyDay(true, 1.0f, true);
        }
        if (Global.tornadoActive() && this.world.method_8510() % 20L == 0L) {
            for (class_1657 player : this.world.method_18456()) {
                StormSoundInfo info;
                StormSound sound;
                manager = Global.serverSoundManager.get(player);
                if (manager == null || (tornado = Global.getClosestTornado(player.method_33571())) == null || !tornado.isDestructiveStorm() || !Utils.withinTornadoSoundRange(player.method_33571(), tornado.method_19538(), tornado.getTornadoType()) || !manager.isSoundPlayable(sound = WeatherClassic.TORNADO_TEAR, false) || (info = manager.begin(sound, 600L + (long)this.world.field_9229.method_43048(200), false)) == null) continue;
                float vol = (Utils.distanceXYZ(player.method_24515(), tornado.method_24515()) < 28.0 ? 0.27f : 0.2f) + this.world.method_8409().method_43057() * 0.2f;
                float pitch = 0.8f + this.world.method_8409().method_43057() * 0.25f;
                WCNetworkServer.sendWindSoundPacket(this.world, player, vol, pitch, info, 0);
            }
        }
        if (this.isGale) {
            if (this.galeTransitionTicks < 50) {
                this.galeTransitionTicks = (short)(this.galeTransitionTicks + 1);
            }
        } else if (this.galeTransitionTicks > 0) {
            this.galeTransitionTicks = (short)(this.galeTransitionTicks - 1);
        }
        if (!this.windy) {
            return;
        }
        if (this.world.method_8510() % 200L == 0L && this.world.method_8409().method_43048(2) == 0) {
            this.updateWindStrength();
            if (!this.diminishing && this.windStrength > 0.025f && (double)this.world.method_8409().method_43057() < 0.1 && !Global.weather.isSevereStorm() && !Global.tornadoActive() && !this.isGale) {
                this.diminishing = true;
            }
        }
        if (this.diminishing && this.windStrength <= 0.0f) {
            this.diminishing = false;
        }
        if (!this.gusty() || this.world.method_18456().isEmpty()) {
            return;
        }
        if (this.world.method_8510() % 20L == 0L) {
            for (class_1657 player : this.world.method_18456()) {
                StormSoundInfo info;
                boolean galeSound;
                if (this.world.method_8510() % 100L == 0L) {
                    WeatherClassic.WEATHER_ENCOUNTERED.triggerForWind((class_3222)player);
                }
                if ((manager = Global.serverSoundManager.get(player)) == null) continue;
                tornado = Global.getClosestTornado(player.method_33571());
                boolean bl = galeSound = this.isGale && (double)this.world.method_8409().method_43057() < 0.7;
                StormSound sound = Global.weather.isSevereStorm() && (double)this.world.method_8409().method_43057() < 0.3 ? WeatherClassic.DARK_WIND : (galeSound ? WeatherClassic.GALE_WIND : WeatherClassic.WIND_BLOWING);
                float prob = 0.4f;
                boolean ambient = true;
                boolean spout = false;
                if (tornado != null) {
                    if (Utils.withinTornadoSoundRange(player.method_33571(), tornado.method_19538(), tornado.getTornadoType())) {
                        sound = WeatherClassic.TORNADO_WIND;
                        spout = tornado.method_5864() == WCEntities.SPOUT;
                        prob = spout ? 1.0f : 0.6f;
                        ambient = false;
                    } else if (tornado.isDemon()) {
                        sound = WeatherClassic.DARK_WIND;
                    }
                }
                if (!manager.isSoundPlayable(sound, spout) || !(this.world.method_8409().method_43057() < prob) || ambient && !Wind.isOutsideInWindArea((class_1297)player, (class_1937)this.world) || (info = manager.begin(sound, this.world.method_8409().method_43048(100), spout)) == null) continue;
                WCNetworkServer.sendWindSoundPacket(this.world, player, tornado != null ? 0.27f : this.getWindVolume(galeSound), this.getWindPitch(galeSound), info, 0);
            }
        }
    }

    public static boolean windInteractableWeak(class_2680 state) {
        return state.method_26164(class_3481.field_15494) || state.method_26164(class_3481.field_25147) || state.method_26164(class_3481.field_15491) || state.method_26164(class_3481.field_15477) || state.method_26164(class_3481.field_15499) || state.method_26164(class_3481.field_26983) || state.method_26164(class_3481.field_26984);
    }

    public static boolean windInteractableStrong(class_2680 state) {
        return Wind.windInteractableWeak(state) || state.method_26164(class_3481.field_24076) || state.method_27852(class_2246.field_10363) || state.method_26164(class_3481.field_15493) || state.method_27852(class_2246.field_16332) || state.method_27852(class_2246.field_10528) || state.method_27852(class_2246.field_28048) || state.method_27852(class_2246.field_42752);
    }

    private void handleWindTimers() {
        if (this.endWindTimer > 0) {
            --this.endWindTimer;
            if (this.endWindTimer <= 0) {
                this.setWindyDay(false, 0.0f, true);
            }
        }
        if (this.galeStartTimer > 0) {
            --this.galeStartTimer;
            if (this.galeStartTimer <= 0) {
                this.setGale(true);
            }
        }
    }

    private void updateWindStatusByDay(boolean force) {
        if (this.world.method_8510() % 12000L == 0L || force) {
            if (this.windy) {
                if (this.endWindTimer <= 0) {
                    this.endWindTimer = this.world.method_8409().method_43048(force ? 1200 : 6000);
                }
            } else {
                class_5819 r;
                boolean startWind;
                ++this.daysSinceWind;
                if (!this.windy && (startWind = WeatherEventProbabilityCalculator.shouldWind(r = this.world.method_8409(), this.daysSinceWind))) {
                    this.windy = true;
                    this.daysSinceWind = 0;
                    this.diminishing = false;
                    ++this.daysSinceGale;
                    if (WeatherEventProbabilityCalculator.shouldGale(r, this.daysSinceGale) && this.galeStartTimer <= 0 && !this.isGale()) {
                        if (ModConfig.getDisableGale()) {
                            this.daysSinceGale = 0;
                        } else {
                            this.galeStartTimer = this.world.method_8409().method_43048(12000);
                        }
                    }
                }
            }
        }
        this.handleWindTimers();
    }

    public void setWindyDay(boolean b, float str, boolean asPercent) {
        if (!b) {
            this.windStrength = Utils.getVerySmallFloat(this.world.field_9229, 0.006f);
            if (this.isGale) {
                this.setGale(false);
            }
        } else if (asPercent) {
            if (str >= 0.0f && str <= 1.0f) {
                this.windStrength = this.getMaxWindStrength() * str;
            }
        } else {
            this.setWindStrength(str);
        }
        this.windy = b;
        this.daysSinceWind = 0;
        this.diminishing = false;
        this.endWindTimer = 0;
        WCNetworkServer.sendWindStatusPacket(this.world);
    }

    public void updateWindData(boolean windy, float str, boolean dec, int angle, int days, int windEndTime, boolean gale, int daysSinceGale, boolean ghastly, int galeStartTimer) {
        this.setWindyDay(windy, str, false);
        this.diminishing = dec;
        this.windAngle = angle;
        this.goalAngle = angle;
        this.daysSinceWind = days;
        this.endWindTimer = windEndTime;
        this.isGale = gale;
        this.daysSinceGale = daysSinceGale;
        this.ghastly = ghastly;
        this.galeStartTimer = galeStartTimer;
    }

    public int getGaleStartTimer() {
        return this.galeStartTimer;
    }

    public int getWindEndingTimer() {
        return this.endWindTimer;
    }

    public boolean ghastly() {
        return this.ghastly;
    }

    public boolean isGale() {
        return this.galeTransitionTicks > 0;
    }

    public short getGaleTransitionTicks() {
        return this.galeTransitionTicks;
    }

    public boolean isGaleTransitioning() {
        return this.prevGaleTransitionTicks != this.galeTransitionTicks;
    }

    public int getDaysSinceGale() {
        return this.daysSinceGale;
    }

    public float getWindVolume(boolean galeSound) {
        if (galeSound) {
            return 0.15732f;
        }
        if (Global.weather.isGreaterStormStage()) {
            return 0.3f;
        }
        return this.windStrength > this.diminishThreshold ? 0.25f : 0.1f;
    }

    public float getWindPitch(boolean galeSound) {
        if (galeSound) {
            return 0.6f + this.world.method_8409().method_43057() * 0.1f;
        }
        return 1.0f + this.world.method_8409().method_43057() * 0.2f;
    }

    public boolean gusty() {
        return this.windStrength >= 0.01f && this.windy;
    }

    public int getWindAngle() {
        return this.windAngle;
    }

    public float getWindStrength() {
        return this.windStrength;
    }

    public int getDaysSinceWindy() {
        return this.daysSinceWind;
    }

    public boolean isStrengthDecreasing() {
        return this.diminishing;
    }

    public boolean isWindyDay() {
        return this.windy;
    }

    public void setGale(boolean b) {
        if (this.isGale != b) {
            this.isGale = b;
        }
        this.daysSinceGale = 0;
        this.diminishing = false;
        this.endWindTimer = 0;
        if (b) {
            this.galeStartTimer = 0;
        }
    }

    private void randomizeWindAngle() {
        int newAngle = this.getWindAngle() + 25 + this.world.method_8409().method_43048(45);
        newAngle *= this.getWindAngle() >= 360 ? -1 : (this.getWindAngle() <= 0 ? 1 : (this.world.method_8409().method_43056() ? 1 : -1));
        newAngle = class_3532.method_15340((int)newAngle, (int)0, (int)360);
        this.setWindAngle(newAngle);
    }

    private void incrementWindAngle(boolean neg) {
        this.windAngle += neg ? -1 : 1;
        this.windAngle = class_3532.method_15340((int)this.windAngle, (int)0, (int)360);
    }

    private void setWindAngle(int angle) {
        this.goalAngle = class_3532.method_15340((int)angle, (int)0, (int)360);
    }

    private void setWindStrength(float str) {
        this.windStrength = class_3532.method_15363((float)str, (float)0.0f, (float)this.getMaxWindStrength());
    }

    private float getMaxWindStrength() {
        return this.isGale ? 0.04f : 0.035f;
    }

    private void updateWindStrength() {
        if (Global.tornadoActive() || Global.weather.isSevereStorm() || this.isGale()) {
            float minValue = this.isGale() ? 0.7f : 0.8f;
            this.setWindStrength(this.getMaxWindStrength() * (minValue + this.world.method_8409().method_43057() * 0.3f));
            this.windStrength = class_3532.method_15363((float)this.windStrength, (float)0.01f, (float)this.getMaxWindStrength());
            return;
        }
        float small = Utils.getVerySmallFloat(this.world.field_9229, this.world.method_8419() ? 0.01f : 0.003f);
        this.setWindStrength(this.windStrength += (small *= (float)(this.diminishing || this.world.method_8409().method_43048(6) == 0 ? -1 : 1)));
    }

    public boolean changedState() {
        boolean changed;
        boolean bl = changed = this.prevGusty != this.gusty() || this.prevWindAngle != this.windAngle || this.windStrength != this.prevWindStrength || this.prevWindy != this.windy || this.isGaleTransitioning() || this.ghastly != this.prevGhastly;
        if (this.prevGusty != this.gusty()) {
            this.prevGusty = this.gusty();
        }
        if (this.prevWindy != this.windy) {
            this.prevWindy = this.windy;
        }
        if (this.prevWindAngle != this.windAngle) {
            this.prevWindAngle = this.windAngle;
        }
        if (this.prevWindStrength != this.windStrength) {
            this.prevWindStrength = this.windStrength;
        }
        if (this.isGaleTransitioning()) {
            this.prevGaleTransitionTicks = this.galeTransitionTicks;
            if (this.galeTransitionTicks == 50 || this.galeTransitionTicks == 0) {
                WCNetworkServer.forceBigUpdate();
            }
        }
        if (this.prevGhastly != this.ghastly) {
            this.prevGhastly = this.ghastly;
        }
        return changed;
    }

    public static boolean isOutsideInWindArea(class_1297 ent, class_1937 world) {
        int size = 4;
        int yy = (int)ent.method_23320();
        float total = 0.0f;
        float open = 0.0f;
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                total += 1.0f;
                class_2338 pos = BP.of(ent.method_23317() + (double)xx, (double)yy, ent.method_23321() + (double)zz);
                if (!Utils.canSeePosDirect(ent, pos) || !Wind.isSkyVisibleThroughLeaves(world, pos)) continue;
                open += 1.0f;
            }
        }
        return (double)(open / total) > 0.3;
    }

    public static boolean isOutsideInWindArea(class_243 vec, class_1937 world) {
        int size = 4;
        int yy = (int)vec.field_1351;
        float total = 0.0f;
        float open = 0.0f;
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                total += 1.0f;
                class_2338 pos = BP.of(vec.field_1352 + (double)xx, (double)yy, vec.field_1350 + (double)zz);
                if (!Utils.canSeePos(world, vec, pos) || !Wind.isSkyVisibleThroughLeaves(world, pos)) continue;
                open += 1.0f;
            }
        }
        return (double)(open / total) > 0.3;
    }

    public static boolean isOutsideInWindAreaClient(class_243 vec, class_1937 world, boolean ignoreLeaves) {
        int size = 3;
        int yy = (int)vec.field_1351;
        float total = 0.0f;
        float open = 0.0f;
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                boolean cantSee;
                total += 1.0f;
                class_2338 pos = BP.of(vec.field_1352 + (double)xx, (double)yy, vec.field_1350 + (double)zz);
                boolean bl = ignoreLeaves ? !Utils.canSeePosWithLeaves(world, vec, pos) : (cantSee = !Utils.canSeePos(world, vec, pos));
                if (cantSee || !Wind.isSkyVisible(world, pos)) continue;
                open += 1.0f;
            }
        }
        return (double)(open / total) > 0.3;
    }

    public static boolean isBlockOutsideInWindArea(class_2338 p, class_1937 world) {
        int size = 4;
        int yy = p.method_10264();
        float total = 0.0f;
        float open = 0.0f;
        for (int xx = -size; xx <= size; ++xx) {
            for (int zz = -size; zz <= size; ++zz) {
                total += 1.0f;
                class_2338 pos = BP.of(p.method_10263() + xx, yy, p.method_10260() + zz);
                if (!Utils.canSolidPositionSee(world, p, pos) || !Wind.isSkyVisibleThroughLeaves(world, pos)) continue;
                open += 1.0f;
            }
        }
        return (double)(open / total) > 0.3;
    }

    public static boolean isSkyVisible(class_1937 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13197, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
    }

    public static boolean isSkyVisibleThroughLeaves(class_1937 world, class_2338 pos) {
        return world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()) <= pos.method_10264();
    }

    @Override
    public class_1937 getWorld() {
        return this.world;
    }

    public void tickPlayerInputsForStorms() {
        ArrayList<UUID> blackList = new ArrayList<UUID>();
        for (UUID id : this.playerInputs.keySet()) {
            PlayerInputAccount account = this.playerInputs.get(id);
            account.tick();
            if (!account.discard()) continue;
            blackList.add(id);
        }
        blackList.forEach(this.playerInputs::remove);
    }

    public boolean playerHasInputAccount(UUID id) {
        return this.playerInputs.containsKey(id);
    }

    public void createOrUpdatePlayerInput(UUID id, float sideways, float forward, UUID stormId) {
        if (this.playerInputs.containsKey(id)) {
            this.playerInputs.get(id).updateInput(sideways, forward);
        } else {
            this.playerInputs.put(id, new PlayerInputAccount(id, stormId).updateInput(sideways, forward));
        }
    }

    public PlayerInputAccount getInputAccount(UUID playerID, UUID tornadoID) {
        PlayerInputAccount account = this.playerInputs.get(playerID);
        if (account != null && account.getStorm().equals(tornadoID)) {
            return account;
        }
        return null;
    }

    public void increaseWindFromDebug() {
        if (!this.isWindyDay()) {
            this.setWindyDay(true, 0.0f, false);
        }
        if (this.windStrength >= this.getMaxWindStrength()) {
            if (!this.isGale) {
                this.setGale(true);
                this.setWindStrength(1.0f);
            } else {
                this.setWindStrength(0.0f);
                this.setWindyDay(false, 0.0f, false);
            }
            return;
        }
        this.setWindStrength(this.windStrength + Utils.getVerySmallFloat(this.world.field_9229, 0.005f));
    }

    public static class_243 pushFromWind(class_1297 ent) {
        if (ent.method_5799()) {
            return class_243.field_1353;
        }
        class_243 v = Global.getGlobalWindVectorForPosition(ent.method_19538());
        ent.method_5762(v.field_1352, 0.0, v.field_1350);
        return v;
    }
}

