/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.global.tools;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.WeatherExecutor;

public class WeatherEventProbabilityCalculator {
    public static boolean shouldDownpour(class_5819 r, int rainEventDays) {
        if (rainEventDays > ModConfig.getMaxRainDaysNoDownpour()) {
            return true;
        }
        switch (rainEventDays) {
            case 0: {
                return false;
            }
            case 1: {
                return (double)r.method_43057() < 0.01;
            }
            case 2: {
                return (double)r.method_43057() < 0.03;
            }
            case 3: {
                return (double)r.method_43057() < 0.05;
            }
        }
        return (double)r.method_43057() < 0.1;
    }

    public static boolean shouldStorm(class_1937 world, class_5819 r, int days, boolean test) {
        if (days > ModConfig.getMaxDaysNoStorm()) {
            return true;
        }
        float base = (float)ModConfig.getStormChanceBase() / 100.0f;
        if (base >= 1.0f) {
            return true;
        }
        if (days > ModConfig.getMaxDaysNoStorm() / 2) {
            base = (float)((double)base + 0.05);
            if ((double)days > (double)ModConfig.getMaxDaysNoStorm() / 1.3) {
                base = (float)((double)base + 0.05);
            }
        }
        return days <= 1 ? false : r.method_43057() < base;
    }

    public static boolean shouldRain(class_5819 r, int days) {
        if (days > ModConfig.getMaxDaysNoRain()) {
            return true;
        }
        float base = (float)ModConfig.getRainChanceBase() / 100.0f;
        if (base >= 1.0f) {
            return true;
        }
        if (days > ModConfig.getMaxDaysNoRain() / 2) {
            base = (float)((double)base + 0.05);
            if ((double)days > (double)ModConfig.getMaxDaysNoRain() / 1.3) {
                base = (float)((double)base + 0.05);
            }
        }
        return days <= 1 ? false : r.method_43057() < base;
    }

    public static boolean shouldWind(class_5819 r, int daysSinceWind) {
        return daysSinceWind < 3 ? (double)r.method_43057() < 0.25 : (daysSinceWind < 5 ? (double)r.method_43057() < 0.75 : true);
    }

    public static boolean shouldGale(class_5819 r, int windSinceGale) {
        if (windSinceGale > ModConfig.getMaxWindNoGale()) {
            return true;
        }
        return windSinceGale < 3 ? (double)r.method_43057() < 0.15 : (double)r.method_43057() < 0.25;
    }

    public static byte getLocalForecastAsByte(class_1937 world, class_2338 pos) {
        if (world.method_27983() != class_1937.field_25179) {
            return -1;
        }
        boolean rainyBiome = ((class_1959)world.method_23753(pos).comp_349()).method_48162(pos, world.method_8615()) != class_1959.class_1963.field_9383;
        class_5819 random = world.method_8409();
        WeatherExecutor.WeatherToExecute exec = Global.weather.getWeatherExecutor();
        if (exec != null) {
            if (exec == WeatherExecutor.WeatherToExecute.THUNDER) {
                return WeatherEventProbabilityCalculator.randomizeForecast(random, (byte)4, 0.65f);
            }
            byte bb = (byte)(rainyBiome ? 1 : 2);
            return WeatherEventProbabilityCalculator.randomizeForecast(random, bb, 0.75f);
        }
        if (Global.wind.getGaleStartTimer() > 0 || world.method_8409().method_43057() < 0.08f && Global.wind.gusty()) {
            return WeatherEventProbabilityCalculator.randomizeForecast(random, (byte)3, 0.7f);
        }
        return WeatherEventProbabilityCalculator.randomizeForecast(random, (byte)0, 0.8f);
    }

    public static byte getForecastForCurrentEvent(class_1937 world, class_2338 pos) {
        boolean rainyBiome;
        if (world.method_27983() != class_1937.field_25179) {
            return -1;
        }
        class_1959.class_1963 p = ((class_1959)world.method_23753(pos).comp_349()).method_48162(pos, world.method_8615());
        boolean bl = rainyBiome = p != class_1959.class_1963.field_9383;
        if (world.method_8419()) {
            return (byte)(world.method_8546() ? 4 : (rainyBiome ? 1 : 2));
        }
        if (Global.wind.isGale()) {
            return 3;
        }
        return -2;
    }

    private static byte randomizeForecast(class_5819 random, byte b, float chance) {
        if (random.method_43057() < chance) {
            return b;
        }
        return (byte)(random.method_43048(6) - 1);
    }
}

