/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.weather_classic.WeatherClassicClient;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.gui.ButtonWidgetBuilder;
import net.weather_classic.gui.TornadoCreationScreen;
import net.weather_classic.networking.client.WCNetworkClient;

@Environment(value=EnvType.CLIENT)
public class DebugMenuScreen
extends class_437 {
    public static final class_2960 MENU_TEXTURE = class_2960.method_60655((String)"weather_classic", (String)"textures/gui/debug_menu.png");
    private int ySize;
    private int xSize;
    private int xOffset;
    private byte shakingOffsetXZ = 0;
    private byte shakingOffsetY = 0;

    public DebugMenuScreen() {
        super(class_333.field_18967);
    }

    protected void method_25426() {
        this.xSize = 176;
        this.ySize = 200;
        this.xOffset = (int)((double)(this.field_22789 / 4) * 1.92);
        this.method_37067();
        int offsetY = -16;
        int startX = (this.field_22789 - this.xSize) / 2 + this.xOffset + 6;
        int startY = (this.field_22790 - this.ySize) / 2 + 23;
        int div = 22;
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Increase Wind"), buttonWidgetX -> {
            if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                WCNetworkClient.sendDebugMenuPayload((byte)0, this.field_22787);
            }
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 1 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Toggle Downpour"), buttonWidgetX -> {
            if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                WCNetworkClient.sendDebugMenuPayload((byte)1, this.field_22787);
            }
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 2 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Force Tornado"), buttonWidgetX -> {
            if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                WCNetworkClient.sendDebugMenuPayload((byte)2, this.field_22787);
            }
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 3 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Prev Stage"), buttonWidgetX -> {
            if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                WCNetworkClient.sendDebugMenuPayload((byte)3, this.field_22787);
            }
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 4 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Next Stage"), buttonWidgetX -> {
            if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                WCNetworkClient.sendDebugMenuPayload((byte)4, this.field_22787);
            }
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 5 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Kill Tornadoes"), buttonWidgetX -> {
            if (this.field_22787.field_1687.method_27983() == class_1937.field_25179) {
                WCNetworkClient.sendDebugMenuPayload((byte)5, this.field_22787);
            }
        }));
        this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(startX, startY + div * 6 + offsetY, 90, 20, (class_2561)class_2561.method_43470((String)"Close"), buttonWidgetX -> this.method_25419()));
        if (this.field_22787.field_1724.method_7337() && ModConfig.getEnableCustomTornadoes()) {
            this.method_37063((class_364)ButtonWidgetBuilder.makeWidget(2, this.field_22790 - 23, 90, 20, (class_2561)class_2561.method_43470((String)((ClientCustomTornadoConfig.getSpawnPercent() > 0.0f ? "\u00a7a" : "") + "Custom Tornado")), buttonWidgetX -> {
                this.field_22787.method_1507((class_437)WeatherClassicClient.CUSTOM_TORNADO_SCREEN);
                WeatherClassicClient.defaultDebugPage = 0;
            }));
        }
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.field_22787.field_1687 == null) {
            this.method_25419();
            return;
        }
        int imageSize = 256;
        int x = (this.field_22789 - this.xSize) / 2;
        int y = (this.field_22790 - this.ySize) / 2;
        context.method_25290(class_1921::method_62277, MENU_TEXTURE, x + this.xOffset, y, 0.0f, 0.0f, this.xSize, this.ySize, imageSize, imageSize);
        context.method_25300(this.field_22793, "Weather Menu", (this.field_22789 - this.xSize) / 2 + (this.xOffset + 50), y - 10, 0xFFFFFF);
        this.createWeatherInfo(context, 40, y - 5, delta);
        if (this.field_22787.field_1724.method_7337() && ModConfig.getEnableCustomTornadoes()) {
            context.method_25290(class_1921::method_62277, TornadoCreationScreen.MENU_TEXTURE, -98, this.field_22790 - 30, 0.0f, 0.0f, 236, 219, imageSize, imageSize);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void createWeatherInfo(class_332 context, int x, int y, float delta) {
        boolean stage6;
        boolean ss;
        int offset = 12;
        byte stageReal = this.getStage();
        float rg = this.field_22787.field_1687.method_8430(delta);
        float tg = this.field_22787.field_1687.method_8478(delta);
        short sst = ClientGlobal.severeStormTransitionTicks;
        boolean bl = ss = sst >= 50;
        if (tg < 1.0f) {
            stageReal = 0;
        } else if (sst <= 0) {
            stageReal = 1;
        }
        boolean dying = ClientGlobal.stormDying;
        boolean windy = ClientGlobal.windy;
        boolean downpour = ClientGlobal.downpour;
        int rainTime = ClientGlobal.rainTime;
        boolean rain = stageReal <= 0 && rg >= 1.0f;
        boolean thunder = tg >= 1.0f;
        boolean transition = rg > 0.0f && rg < 1.0f || tg > 0.0f && tg < 1.0f || sst > 0 && sst < 50;
        boolean creative = this.field_22787.field_1724.method_7337();
        byte adjustableMult = (byte)(creative ? 3 : 2);
        boolean g = ClientGlobal.gale;
        float intensity = tg > 0.0f ? ClientGlobal.stormIntensity : 0.0f;
        boolean bl2 = stage6 = ClientCustomTornadoConfig.getWeatherEventType() == 8 && (double)intensity > 1.1;
        if (stage6) {
            stageReal = 6;
        }
        context.method_25303(this.field_22793, "Storm Stage: " + (String)(rain ? "0.5" : (stage6 ? "\u00a7c" : "") + stageReal) + (transition ? " < >" : ""), x - offset, y + offset, 0xFFFFFF);
        if (creative) {
            context.method_25303(this.field_22793, this.colorIndicator(thunder, "\u00a71") + "Storm Time: " + rainTime, x - offset, y + offset * 2, 0xFFFFFF);
        }
        context.method_25303(this.field_22793, this.colorIndicator(thunder, stage6 ? "\u00a7c" : "\u00a71") + "Storm Intensity: " + WeatherClassicClient.LONG_FORMAT.format(intensity), x - offset + this.shakingOffsetXZ, y + offset * adjustableMult + this.shakingOffsetY, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, "Active Tornadoes: " + ClientGlobal.activeTornadoSources.size(), x - offset, y + offset * adjustableMult, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, this.colorIndicator(windy, g ? "\u00a7e" : "\u00a76") + "Wind Speed: " + WeatherClassicClient.LONG_FORMAT.format(ClientGlobal.windStrength) + ((double)ClientGlobal.windStrength >= (ClientGlobal.gale ? 0.039 : 0.035) ? "(MAX)" : ""), x - offset, y + offset * adjustableMult, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, "Wind Angle: " + Math.round(ClientGlobal.windAngle), x - offset, y + offset * adjustableMult, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, "Dying: " + dying, x - offset, y + offset * adjustableMult, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, this.colorIndicator(downpour, "\u00a73") + "Downpour: " + downpour, x - offset, y + offset * adjustableMult, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, this.colorIndicator(ss, "\u00a74") + "Severe: " + ss, x - offset, y + offset * adjustableMult, 0xFFFFFF);
        adjustableMult = (byte)(adjustableMult + 1);
        context.method_25303(this.field_22793, this.colorIndicator(g, "\u00a7e") + "Gale: " + g, x - offset, y + offset * adjustableMult, 0xFFFFFF);
    }

    private byte getStage() {
        return (byte)(ClientGlobal.stormStage + 2);
    }

    private String colorIndicator(boolean threshold, String color) {
        if (threshold) {
            return color;
        }
        return "";
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if (ClientGlobal.stormIntensity > 1.0f && ClientGlobal.stormStage >= 3 && this.field_22787.field_1687.method_8546()) {
            this.shakingOffsetXZ = (byte)this.field_22787.field_1687.method_8409().method_43048(3);
            this.shakingOffsetY = (byte)this.field_22787.field_1687.method_8409().method_43048(3);
        } else if (this.shakingOffsetXZ > 0 || this.shakingOffsetY > 0) {
            this.shakingOffsetXZ = 0;
            this.shakingOffsetY = 0;
        }
        if (this.field_22787.field_1687 == null || this.field_22787.field_1687.method_27983() != class_1937.field_25179) {
            this.method_25419();
            return;
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }
}

