/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.mixin.client;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import net.minecraft.class_4066;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import net.minecraft.class_9976;
import net.weather_classic.WeatherClassic;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.help.BP;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_9976.class})
public abstract class WorldRenderingMixin {
    @Shadow
    @Final
    private float[] field_53155;
    @Shadow
    @Final
    private float[] field_53156;
    @Shadow
    private int field_53154;
    @Unique
    private float heavyRainStrength = 1.0f;
    @Unique
    private float heavyRainSize = 2.0f;

    @Redirect(method={"renderPrecipitation(Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/util/math/Vec3d;IFLjava/util/List;Ljava/util/List;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/WeatherRendering;renderPieces(Lnet/minecraft/client/render/VertexConsumer;Ljava/util/List;Lnet/minecraft/util/math/Vec3d;FIF)V", ordinal=0))
    private void renderPiecesMixin(class_9976 instance, class_4588 vertexConsumer, List<class_9976.class_9977> pieces, class_243 pos, float intensity, int range, float gradient) {
        for (class_9976.class_9977 piece : pieces) {
            float f = (float)((double)piece.comp_3042() + 0.5 - pos.field_1352);
            float g = (float)((double)piece.comp_3043() + 0.5 - pos.field_1350);
            float h = (float)class_3532.method_41189((double)f, (double)g);
            float i = class_3532.method_16439((float)(h / (float)(range * range)), (float)intensity, (float)0.5f) * gradient;
            int j = class_9848.method_61317((float)i);
            int k = (piece.comp_3043() - class_3532.method_15357((double)pos.field_1350) + 16) * 32 + piece.comp_3042() - class_3532.method_15357((double)pos.field_1352) + 16;
            float l = this.field_53155[k] / 2.0f;
            float m = this.field_53156[k] / 2.0f;
            this.tickHeavyRainProgression(BP.of(pos));
            float n = f - (l *= this.heavyRainStrength);
            float o = f + l;
            float p = (float)((double)piece.comp_3045() - pos.field_1351);
            float q = (float)((double)piece.comp_3044() - pos.field_1351);
            float r = g - (m *= this.heavyRainStrength);
            float s = g + m;
            float t = piece.comp_3046() + 0.0f;
            float u = piece.comp_3046() + 1.0f;
            float v = (float)piece.comp_3044() * 0.25f + piece.comp_3047();
            float w = (float)piece.comp_3045() * 0.25f + piece.comp_3047();
            vertexConsumer.method_22912(n, p, r).method_22913(t, v).method_39415(j).method_60803(piece.comp_3048());
            vertexConsumer.method_22912(o, p, s).method_22913(u, v).method_39415(j).method_60803(piece.comp_3048());
            vertexConsumer.method_22912(o, q, s).method_22913(u, w).method_39415(j).method_60803(piece.comp_3048());
            vertexConsumer.method_22912(n, q, r).method_22913(t, w).method_39415(j).method_60803(piece.comp_3048());
        }
    }

    private void tickHeavyRainProgression(class_2338 pos) {
        class_310 client = class_310.method_1551();
        if (this.invokePrecipitationAt((class_1937)client.field_1687, pos) != class_1959.class_1963.field_9382) {
            return;
        }
        if (System.currentTimeMillis() % 100L != 0L) {
            return;
        }
        if (ClientGlobal.downpour) {
            if (this.heavyRainStrength < this.heavyRainSize) {
                this.heavyRainStrength += 1.0E-4f;
            }
        } else if (this.heavyRainStrength > 1.0f) {
            this.heavyRainStrength -= 1.0E-4f;
        }
        this.heavyRainStrength = class_3532.method_15363((float)this.heavyRainStrength, (float)1.0f, (float)this.heavyRainSize);
    }

    @Inject(method={"addParticlesAndSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void addParticlesAndSoundMixin(class_638 world, class_4184 camera, int ticks, class_4066 particlesMode, CallbackInfo info) {
        float f = world.method_8430(1.0f) / (class_310.method_1517() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            class_5819 random = class_5819.method_43049((long)((long)ticks * 312987231L));
            class_2338 blockPos = class_2338.method_49638((class_2374)camera.method_19326());
            class_2338 blockPos2 = null;
            boolean heavyRain = (double)this.heavyRainStrength >= (double)this.heavyRainSize - 0.5;
            int i = (int)(100.0f * f * f) / (particlesMode == class_4066.field_18198 ? 2 : 1);
            i = heavyRain ? (int)((double)i * 1.2) : i;
            for (int j = 0; j < i; ++j) {
                int l;
                int k = random.method_43048(21) - 10;
                class_2338 blockPos3 = world.method_8598(class_2902.class_2903.field_13197, blockPos.method_10069(k, 0, l = random.method_43048(21) - 10));
                if (blockPos3.method_10264() <= world.method_31607() || blockPos3.method_10264() > blockPos.method_10264() + 10 || blockPos3.method_10264() < blockPos.method_10264() - 10 || this.invokePrecipitationAt((class_1937)world, blockPos3) != class_1959.class_1963.field_9382) continue;
                blockPos2 = blockPos3.method_10074();
                if (particlesMode == class_4066.field_18199) break;
                double d = random.method_43058();
                double e = random.method_43058();
                class_2680 blockState = world.method_8320(blockPos2);
                class_3610 fluidState = world.method_8316(blockPos2);
                class_265 voxelShape = blockState.method_26220((class_1922)world, blockPos2);
                double g = voxelShape.method_1102(class_2350.class_2351.field_11052, d, e);
                double h = fluidState.method_15763((class_1922)world, blockPos2);
                double m = Math.max(g, h);
                class_2400 particleEffect = !fluidState.method_15767(class_3486.field_15518) && !blockState.method_27852(class_2246.field_10092) && !class_3922.method_23896((class_2680)blockState) ? class_2398.field_11242 : class_2398.field_11251;
                world.method_8406((class_2394)particleEffect, (double)blockPos2.method_10263() + d, (double)blockPos2.method_10264() + m, (double)blockPos2.method_10260() + e, 0.0, 0.0, 0.0);
            }
            if (blockPos2 != null && random.method_43048(3) < this.field_53154++) {
                this.field_53154 = 0;
                if (blockPos2.method_10264() > blockPos.method_10264() + 1 && world.method_8598(class_2902.class_2903.field_13197, blockPos).method_10264() > class_3532.method_15375((float)blockPos.method_10264())) {
                    float vol = heavyRain ? 0.2f : 0.1f;
                    world.method_45446(blockPos2, class_3417.field_15020, class_3419.field_15252, vol, 0.5f, false);
                } else {
                    float pitch;
                    class_3414 sound = class_3417.field_14946;
                    float vol = heavyRain ? 0.3f : 0.2f;
                    float f2 = pitch = heavyRain ? 0.9f : 1.0f;
                    if (heavyRain && random.method_43048(8) == 0) {
                        vol = 0.3f;
                        pitch = 0.85f;
                        sound = WeatherClassic.HEAVY_RAIN;
                    }
                    world.method_45446(blockPos2, sound, class_3419.field_15252, vol, pitch, false);
                }
            }
        }
        info.cancel();
    }

    @Invoker(value="getPrecipitationAt")
    protected abstract class_1959.class_1963 invokePrecipitationAt(class_1937 var1, class_2338 var2);
}

