/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2400;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.TornadoWindParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.source.ClientTornadoParticleSource;
import net.weather_classic.storm.source.TornadoParticleSource;

@Environment(value=EnvType.CLIENT)
public class TornadoParticle
extends StormParticle {
    protected final float colorValue;
    private final boolean glow;

    public TornadoParticle(class_638 clientWorld, double x, double y, double z, double vx, double vy, double vz, class_4002 pr) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0);
        this.method_18140(pr);
        this.method_3077(200);
        this.method_3087(1.0f);
        int i = (int)vy;
        this.colorValue = i;
        this.glow = TornadoEntity.TornadoColor.get(this.colorValue) == TornadoEntity.TornadoColor.FIRE;
    }

    @Override
    protected void getParticleRotator() {
        Optional<StormParticleRotator> r;
        TornadoParticleSource source = ClientTornadoParticleSource.getFor(this);
        if (source != null && (r = ClientTornadoParticleSource.getParticleRotator(source)).isPresent()) {
            this.rotator = r.get();
            this.rotator.prepare(this, this instanceof TornadoWindParticle);
            return;
        }
        this.setDead();
    }

    @Override
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    @Override
    protected boolean manualKillCondition() {
        return this.getY() > (double)(this.getCastedRotator().getSource().getCloudY() + 5);
    }

    @Override
    public float getSpecialColorValue() {
        return this.colorValue;
    }

    @Override
    public boolean manuallySetPosFromMotion() {
        return true;
    }

    @Override
    protected boolean emissOption() {
        return this.glow || super.emissOption();
    }

    protected StormParticleRotator getCastedRotator() {
        return (StormParticleRotator)this.rotator;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public DefaultFactory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 defaultParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
            return new TornadoParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

