/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.rotator;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class StormCloudParticleRotator
extends StormParticleRotator {
    public StormCloudParticleRotator(TornadoParticleSource source) {
        super(source);
    }

    @Override
    protected void rotate(StormParticle particle) {
        if (!particle.isDead()) {
            this.spinAsClouds(particle);
        }
    }

    private void spinAsClouds(StormParticle particle) {
        float f1;
        double d1 = this.getSourcePos().method_10216() - particle.getX();
        double d2 = this.getSourcePos().method_10215() - particle.getZ();
        float f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        for (f1 = f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double grab = 2.0 + (double)((float)particle.getAge() / 75.0f);
        if (distXZ > 2.0) {
            grab *= 10.0 / distXZ;
        }
        f1 = (float)((double)f1 + (75.0 + grab - 0.4));
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = 0.055f;
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        particle.motionX += (double)(-moveX);
        particle.motionZ += (double)moveZ;
        particle.motionY = 0.0;
    }

    @Override
    public void prepare(StormParticle particle, boolean b) {
        byte t = this.source.getTornadoType();
        int age = 700;
        if (t == 5 && (double)ClientCustomTornadoConfig.getScaling() <= 0.65) {
            age = 400;
        }
        particle.method_3077(age + particle.getWorld().method_8409().method_43048(75));
        Vector3f colors = ClientGlobal.getDefaultTornadoParticleColor(this.source, particle.getWorld().method_8409(), true);
        particle.method_3084(colors.x, colors.y, colors.z);
    }
}

