/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.particle.rotator;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.global.client.config.ClientCustomTornadoConfig;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.TornadoParticle;
import net.weather_classic.particle.TornadoWindParticle;
import net.weather_classic.particle.rotator.base.StormParticleRotator;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TornadoParticleRotator
extends StormParticleRotator {
    public TornadoParticleRotator(TornadoParticleSource source) {
        super(source);
    }

    @Override
    public void prepare(StormParticle particle, boolean wind) {
        boolean shortStormH;
        class_5819 random = particle.getWorld().method_8409();
        boolean bl = shortStormH = this.getSource().getTornadoType() == 5 && ClientCustomTornadoConfig.getScaling() <= 0.55f;
        if (wind) {
            particle.setScale(0.8f + 0.4f * random.method_43057());
            if (shortStormH) {
                particle.method_3077(10 + random.method_43048(20));
            } else {
                particle.method_3077(40 + random.method_43048(50));
            }
            particle.method_3084(1.0f, 1.0f, 1.0f);
        } else {
            particle.method_3077(shortStormH ? 50 : 100);
            Vector3f colors = ClientGlobal.getDefaultTornadoParticleColor(this.source, random, false);
            TornadoEntity.TornadoColor color = TornadoEntity.TornadoColor.get(particle.getSpecialColorValue());
            if (color != null) {
                if (color == TornadoEntity.TornadoColor.UNIQUE_FLARE) {
                    if (colors.x >= 1.0f && colors.y >= 1.0f && colors.z >= 1.0f) {
                        colors.set(class_3532.method_15363((float)random.method_43057(), (float)0.1f, (float)1.0f), class_3532.method_15363((float)random.method_43057(), (float)0.1f, (float)1.0f), class_3532.method_15363((float)random.method_43057(), (float)0.1f, (float)1.0f));
                    } else {
                        colors.set(class_3532.method_15363((float)(colors.x + 0.2f), (float)0.1f, (float)1.0f), class_3532.method_15363((float)(colors.y + 0.2f), (float)0.1f, (float)1.0f), class_3532.method_15363((float)(colors.z + 0.2f), (float)0.1f, (float)1.0f));
                    }
                } else {
                    Vector3f testColors = TornadoEntity.tornadoColors.get((Object)color);
                    if (color == TornadoEntity.TornadoColor.FIRE && testColors != null) {
                        colors = testColors;
                        float r = random.method_43057() * 0.2f * (float)(random.method_43056() ? -1 : 1);
                        r += colors.x;
                        r = class_3532.method_15363((float)r, (float)0.7f, (float)1.0f);
                        float g = random.method_43057() * 0.5f;
                        colors.set(r, g, colors.z);
                    }
                    colors = testColors != null ? testColors : colors;
                }
            }
            particle.method_3084(colors.x, colors.y, colors.z);
            particle.setScale(0.04f);
        }
        particle.angleY = random.method_43048(360);
        particle.angleX = -30.0f - random.method_43057() - (float)random.method_43048(8);
        particle.angleZ = random.method_43048(50) - random.method_43048(50);
        particle.setGravity(0.01f);
        particle.setnoClip(false);
    }

    @Override
    public void rotate(StormParticle p) {
        TornadoParticle particle = (TornadoParticle)p;
        boolean wind = particle instanceof TornadoWindParticle;
        if (!particle.isDead()) {
            float ticksFade;
            particle.angleY = particle.rotateZ ? (float)((double)particle.angleY - 0.1) : (float)((double)particle.angleY + 0.1);
            float f = ticksFade = this.source.getTornadoType() == 5 && ClientCustomTornadoConfig.getScaling() <= 0.55f ? 2.0f : 20.0f;
            if ((float)particle.getAge() < ticksFade) {
                float maxA = wind ? particle.getSpecialColorValue() / 10.0f : 0.9f;
                particle.method_3083(class_3532.method_15363((float)((float)particle.getAge() / ticksFade), (float)0.0f, (float)maxA));
            } else if (!this.source.isDemon() && (float)particle.getAge() > (float)particle.method_3082() - ticksFade) {
                float count = (float)particle.getAge() - ((float)particle.method_3082() - ticksFade);
                float val = (ticksFade - count) / ticksFade;
                particle.method_3083(val);
            }
            if (!wind) {
                boolean isClassicShape = (this.source.getUuid().getMostSignificantBits() & 1L) == 0L;
                float inc = 0.1f;
                switch (this.source.getTornadoType()) {
                    case 0: {
                        inc += p.getAge() > 30 && p.getAge() < 80 ? 0.1f : 0.0f;
                        break;
                    }
                    case 1: {
                        inc += p.getAge() > 40 && p.getAge() < 50 ? 0.15f : 0.0f;
                        if (p.getAge() > 10 && p.getAge() < 20) {
                            inc += 0.1f;
                        }
                        if (p.getAge() <= 50 || p.getAge() >= 65) break;
                        inc += !isClassicShape ? 0.43f : 0.3f;
                        break;
                    }
                    case 2: {
                        inc += p.getAge() > 30 && p.getAge() < 53 ? 0.25f : 0.0f;
                        if (isClassicShape && p.getAge() < 5) {
                            inc += 0.15f;
                        }
                        if (p.getAge() > 10 && p.getAge() < 30) {
                            inc += 0.1f;
                        }
                        if (p.getAge() > 30 && p.getAge() < 40) {
                            inc += 0.1f;
                        }
                        if (p.getAge() <= 40 || p.getAge() >= 50) break;
                        inc += 0.25f;
                        break;
                    }
                    case 3: {
                        inc += p.getAge() > 30 && p.getAge() < 53 ? 0.2f : 0.0f;
                        if (!isClassicShape && p.getAge() < 10) {
                            inc += 0.3f;
                        }
                        if (p.getAge() > 10 && p.getAge() < 30) {
                            inc += 0.2f;
                        }
                        if (p.getAge() <= 40 || p.getAge() >= 50) break;
                        inc += 0.15f;
                        break;
                    }
                    case 4: {
                        inc += p.getAge() > 30 && p.getAge() < 53 ? 0.3f : 0.0f;
                        if (p.getAge() < 10) {
                            inc += 0.12f;
                        }
                        if (p.getAge() > 10 && p.getAge() < 30) {
                            inc += 0.25f;
                        }
                        if (p.getAge() <= 40 || p.getAge() >= 50) break;
                        inc += isClassicShape ? 0.3f : 0.25f;
                        break;
                    }
                    case 5: {
                        float baseIncrease = ClientCustomTornadoConfig.getBaseParticleSizeIncrease();
                        float bottomIncrease = ClientCustomTornadoConfig.getBottomParticleSizeIncrease();
                        float midIncrease = ClientCustomTornadoConfig.getMidParticleSizeIncrease();
                        float topIncrease = ClientCustomTornadoConfig.getTopParticleSizeIncrease();
                        inc += p.getAge() > 30 && p.getAge() < 53 ? baseIncrease : 0.0f;
                        if (p.getAge() < 10) {
                            inc += bottomIncrease;
                        }
                        if (p.getAge() > 10 && p.getAge() < 30) {
                            inc += midIncrease;
                        }
                        if (p.getAge() <= 40 || p.getAge() >= 50) break;
                        inc += topIncrease;
                    }
                }
                particle.setScale(particle.getScale() + inc);
            }
            if (!this.source.isRemoved()) {
                this.spin(particle);
            }
        }
    }

    private void spin(StormParticle particle) {
        float ang;
        double dx = this.getSourcePos().method_10216() - particle.getX();
        double dz = this.getSourcePos().method_10215() - particle.getZ();
        particle.angleY = ang = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        this.spinAroundSource(particle);
    }

    private void spinAroundSource(StormParticle particle) {
        float r;
        float r2;
        double scaling;
        if (this.getStats() == null) {
            return;
        }
        double maxHeight = 60.0;
        double radius = 10.0;
        byte type = this.getSource().getTornadoType();
        double d = scaling = type > 4 ? (double)ClientCustomTornadoConfig.getScaling() : (double)this.getStats().scaling;
        if (type == 4) {
            scaling = 2.7f;
        }
        if (type == 3) {
            scaling = 2.2f;
        }
        double dx = this.getSourcePos().method_10216() - particle.getX();
        double dz = this.getSourcePos().method_10215() - particle.getZ();
        double distY = particle.getY() - this.getSourcePos().method_10214();
        if (distY < 0.0) {
            distY = 1.0;
        }
        if (distY > maxHeight) {
            distY = maxHeight;
        }
        if ((r2 = (r = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f) % 360.0f) >= 180.0f) {
            r2 -= 360.0f;
        } else if (r2 < -180.0f) {
            r2 += 360.0f;
        }
        double distXZ = Math.sqrt(Math.abs(dx)) + Math.sqrt(Math.abs(dz));
        double intensity = (double)(10.0f / this.getParticleResistance(particle)) * (Math.abs(maxHeight - distY) / maxHeight);
        float liftY = 0.0f;
        liftY += this.getStats().liftSpeed / (this.getParticleResistance(particle) / 2.0f);
        if (distXZ > 5.0) {
            intensity *= radius / distXZ;
        }
        float rs = this.source.getStats().grabSpeed;
        if (type > 4) {
            rs = ClientCustomTornadoConfig.getGrabSpeed();
        }
        if (!this.source.isSpout()) {
            boolean isClassicShape = (this.source.getUuid().getMostSignificantBits() & 1L) == 0L;
            switch (type) {
                case 1: {
                    if (!this.source.isDemon()) {
                        intensity += isClassicShape ? -16.0 : -22.0;
                        if (particle.getAge() >= 30) break;
                        rs = (float)((double)rs / (isClassicShape ? 1.8 : 2.2));
                        break;
                    }
                    intensity += particle.getAge() < 60 ? -3.0 : 0.0;
                    if (particle.getAge() >= 30) break;
                    rs = (float)((double)rs * 1.2);
                    break;
                }
                case 2: {
                    intensity += isClassicShape ? -26.0 : -33.0;
                    if (particle.getAge() >= 30) break;
                    rs = (float)((double)rs / (isClassicShape ? 1.4 : (double)1.8f));
                    break;
                }
                case 3: {
                    intensity += -30.0;
                    if (particle.getAge() < 20) {
                        rs /= isClassicShape ? 2.0f : 1.3f;
                        break;
                    }
                    if (particle.getAge() <= 20) break;
                    intensity += 30.0;
                    break;
                }
                case 4: {
                    intensity += (double)(isClassicShape ? -30 : -45);
                    if (particle.getAge() < 20) {
                        rs /= 2.0f;
                        break;
                    }
                    if (particle.getAge() <= 20) break;
                    intensity += (double)(isClassicShape ? 30 : 45);
                    break;
                }
                case 5: {
                    short funnelWidth = ClientCustomTornadoConfig.getFunnelWidth();
                    byte funnelPointedness = ClientCustomTornadoConfig.getFunnelPointedness();
                    float funnelTightening = (float)funnelWidth * (ClientCustomTornadoConfig.getFunnelTightening() * 1.2f);
                    intensity += (double)(-funnelWidth);
                    if (particle.getAge() < 30) {
                        rs /= (float)funnelPointedness;
                        break;
                    }
                    if (particle.getAge() <= 30) break;
                    intensity += (double)funnelTightening;
                }
            }
        }
        r2 = (float)((double)r2 + (75.0 + intensity - 10.0 * scaling));
        float rx = (float)Math.cos(-r2 * 0.01745329f - (float)Math.PI);
        float rz = (float)Math.sin(-r2 * 0.01745329f - (float)Math.PI);
        float moveX = rx * -rs;
        float moveZ = rz * rs;
        particle.motionX += (double)moveX;
        particle.motionZ += (double)moveZ;
        particle.motionY += (double)(liftY *= this.getSource().getStrength() / 100.0f);
    }

    private float getParticleResistance(StormParticle d) {
        boolean windNotPoof = d instanceof TornadoWindParticle;
        if (windNotPoof) {
            return 1.4f + (float)d.getAge() / 200.0f;
        }
        return 5.0f + (float)d.getAge() / 200.0f;
    }
}

