/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.global.tools.TornadoReviver;
import net.weather_classic.help.BP;
import net.weather_classic.help.Direction2D;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.registry.WCParticles;
import net.weather_classic.storm.TornadoRipper;
import net.weather_classic.storm.TornadoRotator;
import net.weather_classic.storm.TornadoStats;
import net.weather_classic.storm.source.TornadoParticleSource;
import org.joml.Vector3f;

public class TornadoEntity
extends class_1314
implements TornadoParticleSource {
    private final class_1937 world;
    private boolean initialized = false;
    private float realYaw;
    private float prevRealYaw;
    private class_2338 currentTarget;
    private TornadoStats stats;
    private final TornadoRotator rotator;
    private final TornadoRipper ripper;
    private int pullStrengthVariation = 0;
    private boolean worldUnload = false;
    private int timeTraversingBias = 0;
    private boolean biasing = false;
    private final int timeRandomness;
    private class_1923 prevChunkPos;
    private final TornadoStats.Type tornadoType;
    private int colorChangeTicks = 0;
    private TornadoColor currentColor = null;
    public static final Map<TornadoColor, Vector3f> tornadoColors = new HashMap<TornadoColor, Vector3f>();
    private boolean shortenedLife = false;
    private int biasTraversalMax = 500;
    private boolean ascendToGroundLevel = false;
    private boolean demon;
    private final byte speedVary;
    private short dispels = 0;
    private boolean closeToPlayer = false;
    private byte boundToAlt = 0;
    private boolean firenado;
    private boolean modifyGroundLevel = false;
    public static final class_2940<Boolean> DYING = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SPAWNING = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Float> STRENGTH = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Integer> STORM_CLOUD_Y = class_2945.method_12791(TornadoEntity.class, (class_2941)class_2943.field_13327);

    public TornadoEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.tornadoType = TornadoEntity.getTornadoTypeFromEntity(entityType);
        this.field_5960 = true;
        this.method_5875(true);
        this.stats = TornadoStats.get(this.tornadoType);
        this.rotator = new TornadoRotator(this);
        this.ripper = new TornadoRipper(this);
        this.world = world;
        this.timeRandomness = world.method_8409().method_43048(3000);
        this.prevChunkPos = null;
        this.speedVary = this.isSpout() ? (byte)0 : (byte)world.method_8409().method_43048(4);
        this.firenado = entityType != WCEntities.SPOUT && world.method_8409().method_43057() < (float)ModConfig.getPassiveFirenadoChance() / 100.0f;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DYING, (Object)false);
        builder.method_56912(SPAWNING, (Object)false);
        builder.method_56912(STRENGTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(STORM_CLOUD_Y, (Object)128);
        super.method_5693(builder);
    }

    public TornadoEntity asDemon() {
        this.demon = true;
        return this;
    }

    public TornadoEntity getWithShorterLifespan() {
        this.shortenedLife = true;
        return this;
    }

    public boolean isPassiveFirenado() {
        return this.firenado;
    }

    public boolean boundToAlt() {
        return this.boundToAlt > 0;
    }

    public void bindToAlt() {
        if (this.getTornadoType() != 5) {
            return;
        }
        this.boundToAlt = (byte)2;
    }

    public void method_5711(byte status) {
        if (status == 35) {
            this.field_6012 = 0;
            this.shortenedLife = true;
        } else {
            super.method_5711(status);
        }
    }

    private void initTornado() {
        if (!this.worldUnload && this.world.method_27983() == class_1937.field_25179 && !Global.overMaxTornadoes()) {
            Global.addTornado(this);
            this.initialized = true;
            if (!this.getStats().hasDemons && this.demon) {
                this.demon = false;
            }
        }
        if (this.boundToAlt != 2) {
            this.boundToAlt = (byte)(this.tornadoType == TornadoStats.Type.STAGEX && CustomTornadoConfig.USING_ALT ? 1 : 0);
        }
        class_2791 chunk = this.world.method_22350(this.method_24515());
        int p = chunk.method_12005(class_2902.class_2903.field_13197, 8, 8);
        int height = Math.min(p + 64, 256);
        this.method_5725(new class_2338(this.method_31477(), height, this.method_31479()), 0.0f, 0.0f);
        this.setCloudY(height);
        this.setSpawning(true);
        this.updateDisabledReviver();
        if (!this.isSpout()) {
            Utils.playSound((class_1297)this, this.world, this.method_24515().method_10086(20), WeatherClassic.TORNADO_WIND_DIRECTIONAL, this.method_5634(), 4.0f, 1.0f);
        }
    }

    public class_3419 method_5634() {
        return class_3419.field_15252;
    }

    @Override
    public boolean isDestructiveStorm() {
        return this.getStats().ripType != TornadoRipper.RipType.NONE;
    }

    @Override
    public boolean isSpout() {
        return this.tornadoType == TornadoStats.Type.SPOUT;
    }

    @Override
    public byte getTornadoType() {
        return this.tornadoType.getByte();
    }

    public byte getTornadoTypeForRotator() {
        if (this.tornadoType == TornadoStats.Type.STAGEX) {
            return CustomTornadoConfig.getPullType(false);
        }
        return this.getTornadoType();
    }

    private void handleDirectionalWindSound() {
        if (!(this.field_6012 % 10 != 0 && this.field_6012 != 20 || this.world.method_8608())) {
            boolean tear;
            int time;
            float pitch;
            byte type = this.getTornadoType();
            if (type >= 5) {
                type = CustomTornadoConfig.getPassiveSoundType();
            }
            float vol = switch (type) {
                case 0 -> {
                    pitch = 1.0f;
                    time = 140;
                    yield 4.0f;
                }
                case 2 -> {
                    pitch = 0.9f;
                    time = 160;
                    yield 7.0f;
                }
                case 3 -> {
                    pitch = 0.6f;
                    time = 200;
                    yield 8.0f;
                }
                case 4 -> {
                    pitch = 0.4f;
                    time = 210;
                    yield 10.0f;
                }
                default -> {
                    pitch = 0.95f;
                    time = 150;
                    yield 6.0f;
                }
            };
            vol -= 0.5f;
            if (this.field_6012 % time == 0) {
                WCNetworkServer.sendDirectionalWindPayload((class_3218)this.world, this, vol, pitch, false);
            }
            boolean bl = tear = this.isDestructiveStorm() && this.world.method_8409().method_43048(2) == 0;
            if (tear) {
                switch (type) {
                    case 0: {
                        pitch = 0.9f;
                        time = 50;
                        break;
                    }
                    case 2: {
                        pitch = 0.85f;
                        time = 50;
                        break;
                    }
                    case 3: {
                        pitch = 0.83f;
                        time = 50;
                        break;
                    }
                    case 4: {
                        pitch = 0.8f;
                        time = 55;
                        break;
                    }
                    default: {
                        pitch = 0.88f;
                        time = 50;
                    }
                }
                if (this.field_6012 % time == 0) {
                    WCNetworkServer.sendDirectionalWindPayload((class_3218)this.world, this, vol, pitch, true);
                }
            }
        }
    }

    public void method_5773() {
        this.prevChunkPos = this.method_31476();
        super.method_5773();
        if (!this.world.field_9236) {
            if (!this.initialized) {
                this.initTornado();
            } else if (!this.method_31481()) {
                Global.addTornado(this);
            }
            if (this.getTornadoType() == 5) {
                if (!ModConfig.getEnableCustomTornadoes()) {
                    this.killStorm();
                    Global.messageServer("\u00a7cCustom Tornadoes are Currently Disabled", (class_3218)this.world);
                    return;
                }
                if (CustomTornadoConfig.USING_ALT != this.boundToAlt > 0) {
                    if (!WCNetworkServer.awaitingBigUpdate()) {
                        this.killStorm();
                    }
                    return;
                }
            }
            if (this.field_6012 % 300 == 0 && this.field_5974.method_43048(2) == 0) {
                this.pullStrengthVariation = this.field_5974.method_43048(15);
            }
            this.handleTargetting();
            this.ripper.tick();
            this.rotator.grabEntities();
            this.handleStrength();
            this.tickFX();
            if (!this.isDemon()) {
                this.handleDirectionalWindSound();
            }
            if (Global.overMaxTornadoes() && Global.activeTornadoes.get(0) == this) {
                this.killStorm();
                return;
            }
            if (this.killDueToPlayersUnavailable()) {
                this.initialized = false;
            }
            if (this.world.method_8510() % 60L == 0L) {
                if (this.firenado && (this.getTornadoType() == 5 && CustomTornadoConfig.getRipType(true) == 6 || this.isDemon())) {
                    this.firenado = false;
                }
                this.updateDisabledReviver();
                if (this.killDueToInvalidPosition()) {
                    this.killStorm();
                }
            }
            if (!this.initialized) {
                this.killStorm();
                if (!this.worldUnload && !this.getDying()) {
                    Global.weather.addTornadoReviver(new TornadoReviver((class_3218)this.world, this.method_24515(), this.getTornadoType(), this.demon).with(this.currentTarget).binded(this.boundToAlt()));
                }
            }
        }
    }

    private void updateDisabledReviver() {
        Global.weather.addTornadoReviver(new TornadoReviver((class_3218)this.world, this.method_24515(), this.getTornadoType(), this.demon).off(this.method_5628(), this.getDying()).binded(this.boundToAlt()));
    }

    public int getRandomStrengthVariationFallOff() {
        return this.pullStrengthVariation;
    }

    @Override
    public TornadoStats getStats() {
        return this.stats;
    }

    public int getLifetime() {
        int tr = this.stats.time < 1000 ? this.timeRandomness / 3 : this.timeRandomness;
        int end = (int)((double)this.getStats().time * (this.shortenedLife ? (this.isSpout() ? 0.4 : 0.6) : 1.0) + (double)tr);
        return end;
    }

    public class_1923 getPrevChunkPos() {
        return this.prevChunkPos;
    }

    private byte minDistanceFromTarget() {
        return 20;
    }

    public boolean shouldPursuePlayers() {
        return this.demon || this.tornadoType == TornadoStats.Type.STAGEX && CustomTornadoConfig.getChasePlayers();
    }

    public void handleTargetting() {
        if (this.currentTarget != null) {
            if (this.biasing) {
                ++this.timeTraversingBias;
            }
            this.handleMovement();
            if (this.field_6012 % 20 == 0 && (Utils.distanceXZ(this.currentTarget, this.method_24515()) < (double)this.minDistanceFromTarget() || this.biasing && this.timeTraversingBias > this.biasTraversalMax)) {
                this.currentTarget = null;
                this.biasing = false;
                this.timeTraversingBias = 0;
            }
        } else {
            class_1657 player;
            this.method_18800(0.0, 0.0, 0.0);
            if ((this.getSpawning() && ModConfig.getTornadoesBiasTowardsPlayers() || this.shouldPursuePlayers()) && (player = this.world.method_18460((class_1297)this, 256.0)) != null && Utils.distanceXZ(player.method_24515(), this.method_24515()) > (double)(this.minDistanceFromTarget() + 5)) {
                this.bias(BP.of(player.method_23317(), player.method_23318(), player.method_23321()));
                if (this.isDemon()) {
                    WeatherClassic.curseWithStormFury((class_1309)player, false);
                }
                return;
            }
            this.currentTarget = this.getNewTarget();
        }
    }

    private class_2338 getNewTarget() {
        int dist1;
        Direction2D dir = this.getTornadoDirections();
        class_2338 pos = null;
        boolean shortPath = this.shouldPursuePlayers();
        int n = shortPath ? 40 : (this.field_5974.method_43048(4) == 0 ? 80 : (dist1 = this.field_5974.method_43056() ? 120 : 200));
        int dist2 = shortPath ? 40 : (this.field_5974.method_43048(4) == 0 ? 80 : (this.field_5974.method_43056() ? 120 : 200));
        dist1 += this.field_5974.method_43048(40);
        dist2 += this.field_5974.method_43048(40);
        if (dir.getDirection1() != null && dir.getDirection1() != this.method_5755().method_10153()) {
            pos = this.method_24515().method_10079(dir.getDirection1(), dist1);
        }
        if (dir.getDirection2() != null && dir.getDirection2() != this.method_5755().method_10153()) {
            pos = pos == null ? this.method_24515().method_10079(dir.getDirection2(), dist2) : pos.method_10079(dir.getDirection2(), dist2);
        }
        return pos;
    }

    public void bias(class_2338 pos) {
        byte lvl = this.shortenedLife ? (byte)0 : ModConfig.getTornadoBiasIntensityLvl();
        int range = switch (lvl) {
            case 0 -> {
                this.biasTraversalMax = 500 + this.field_5974.method_43048(800);
                yield 50;
            }
            case 2 -> {
                this.biasTraversalMax = 1500 + this.field_5974.method_43048(1000);
                yield 18;
            }
            default -> {
                this.biasTraversalMax = 1000 + this.field_5974.method_43048(1500);
                yield 30;
            }
        };
        if (this.shouldPursuePlayers() && !this.getSpawning()) {
            this.biasTraversalMax = 200 + this.field_5974.method_43048(200);
        }
        this.timeTraversingBias = 0;
        this.currentTarget = this.shouldPursuePlayers() ? pos : pos.method_10079(Utils.randomHorizontal(this.field_5974), 1 + this.field_5974.method_43048(range)).method_10079(Utils.randomHorizontal(this.field_5974), 1 + this.field_5974.method_43048(range / 2));
        this.biasing = true;
    }

    private Direction2D getTornadoDirections() {
        int roll = this.field_5974.method_43048(18);
        switch (roll) {
            case 0: {
                return new Direction2D(class_2350.field_11043, class_2350.field_11034);
            }
            case 1: {
                return new Direction2D(class_2350.field_11035, class_2350.field_11034);
            }
            case 2: {
                return new Direction2D(class_2350.field_11043, class_2350.field_11039);
            }
            case 3: {
                return new Direction2D(class_2350.field_11035, class_2350.field_11039);
            }
            case 4: {
                return new Direction2D(class_2350.field_11034, class_2350.field_11043);
            }
            case 5: {
                return new Direction2D(class_2350.field_11034, class_2350.field_11035);
            }
            case 6: {
                return new Direction2D(class_2350.field_11039, class_2350.field_11043);
            }
            case 7: {
                return new Direction2D(class_2350.field_11039, class_2350.field_11035);
            }
            case 8: 
            case 9: {
                return new Direction2D(class_2350.field_11035, null);
            }
            case 10: 
            case 11: {
                return new Direction2D(class_2350.field_11043, null);
            }
            case 12: 
            case 13: {
                return new Direction2D(class_2350.field_11034, null);
            }
            case 14: 
            case 15: {
                return new Direction2D(class_2350.field_11039, null);
            }
        }
        return new Direction2D(class_2350.field_11043, null);
    }

    private void handleMovement() {
        if (this.field_6012 % (this.demon ? 100 : 200) == 0) {
            this.closeToPlayer = false;
            for (class_1657 player : Utils.getPlayersIn(this.world, this.method_5829().method_1009(128.0, 64.0, 128.0))) {
                if (player.method_7325()) continue;
                if (!this.closeToPlayer && this.method_5858((class_1297)player) < 3600.0) {
                    this.closeToPlayer = true;
                    if (this.demon && (double)this.field_5974.method_43057() < 0.55) {
                        Utils.playSound((class_1297)this, this.world, this.method_24515(), WeatherClassic.GALE_WIGHT_RAGE, this.method_5634(), 5.0f, 0.2f + this.field_5974.method_43057() * 0.1f);
                    }
                }
                if (this.isSpout()) {
                    WeatherClassic.OCEAN_BREEZE.trigger((class_3222)player, this.method_24515(), this.getTornadoType());
                    continue;
                }
                WeatherClassic.TWISTER.trigger((class_3222)player, this.method_24515(), this.getTornadoType());
            }
        }
        this.updateAngles();
        class_243 vec = Utils.convertBlockPosToVec(this.currentTarget);
        Utils.lookAtVec((class_1297)this, vec, this.field_6012 < 20 ? 90.0f : (this.biasing || this.shouldPursuePlayers() ? 2.0f : 0.1f), 0.0f);
        double rads = Math.toRadians(this.realYaw + 90.0f);
        short speed = (short)(!this.demon ? this.getStats().speed + this.speedVary : 15);
        if (this.getStats().speed == 0) {
            speed = 0;
        }
        double vx = Math.cos(rads) * (double)speed * 0.015;
        double vz = Math.sin(rads) * (double)speed * 0.015;
        double vy = this.getAppropriateYVelocity();
        this.method_18800(vx, vy, vz);
    }

    public double getAppropriateYVelocity() {
        int y;
        if (this.isDemon()) {
            if (this.currentTarget != null) {
                if (this.method_23318() > (double)this.currentTarget.method_10264()) {
                    if (this.method_23318() < (double)(this.world.method_31607() + 1)) {
                        return 0.0;
                    }
                    return -0.2;
                }
                if (this.method_23318() < (double)(this.currentTarget.method_10264() - 1) && !this.world.method_8320(this.method_24515().method_10084()).method_26215()) {
                    return 0.2;
                }
            }
            return 0.0;
        }
        int generousness = 3;
        if (this.field_6012 % 100 == 0 && !this.ascendToGroundLevel) {
            y = this.world.method_8598(class_2902.class_2903.field_13203, this.method_24515()).method_10264();
            int thicknessThreshold = 8;
            if (this.method_23318() < (double)(y - generousness)) {
                int thickness = 0;
                for (int i = 0; i < Math.abs(y - this.method_31478()) && i <= 64; ++i) {
                    class_2248 block = this.world.method_8320(this.method_24515().method_10086(i)).method_26204();
                    if (!Utils.canPassThrough(block)) {
                        ++thickness;
                    }
                    if (thickness <= thicknessThreshold) continue;
                    this.ascendToGroundLevel = true;
                    break;
                }
            }
        }
        if (this.ascendToGroundLevel) {
            y = this.world.method_8598(class_2902.class_2903.field_13203, this.method_24515()).method_10264();
            if (this.method_23318() > (double)(y + 1)) {
                this.ascendToGroundLevel = false;
            } else {
                return 0.2;
            }
        }
        if (this.world.method_8320(this.method_24515()).method_26215()) {
            if (this.method_23318() < (double)(this.world.method_31607() + 1)) {
                return 0.0;
            }
            return -0.2;
        }
        if (this.field_6012 % 60 == 0) {
            this.modifyGroundLevel = this.tooDeepInGround();
        }
        if (this.modifyGroundLevel) {
            if (this.world.method_8320(this.method_24515().method_10084()).method_26215()) {
                this.modifyGroundLevel = false;
            }
            return 0.2;
        }
        return 0.0;
    }

    private boolean tooDeepInGround() {
        if (ModConfig.getTornadoDestructionLvl() > 1 || this.getTornadoType() == 5 && CustomTornadoConfig.getDestructionLvlOverride() > 1) {
            class_2338.class_2339 pos = this.method_24515().method_25503();
            for (int i = 1; i < 5; ++i) {
                pos.method_33098(this.method_31478() + i);
                if (!this.world.method_8320((class_2338)pos).method_26215()) continue;
                return false;
            }
            return true;
        }
        return !this.world.method_8320(this.method_24515().method_10084()).method_26215();
    }

    private void updateAngles() {
        this.prevRealYaw = this.realYaw = Utils.wrapAngleAround(this.realYaw, this.method_5791());
        this.prevRealYaw = Utils.wrapAngleAround(this.prevRealYaw, this.realYaw);
        this.realYaw += (this.method_5791() - this.realYaw) * 0.6f;
    }

    public void killStorm() {
        ArrayList<TornadoReviver> blackList = new ArrayList<TornadoReviver>();
        for (TornadoReviver reviver : Global.weather.getRevivers()) {
            if (reviver.isOn() || reviver.getID() != this.method_5628()) continue;
            blackList.add(reviver);
        }
        blackList.forEach(r -> Global.weather.getRevivers().remove(r));
        if (!this.method_31481()) {
            this.method_31472();
        }
        if (this.getTornadoType() == 5) {
            WCNetworkServer.forceBigUpdate();
        }
    }

    private void handleStrength() {
        if (this.getSpawning()) {
            if (this.getStrength() < 40.0f) {
                this.setStrength(40.0f);
            } else if (this.getStrength() >= 100.0f) {
                this.setStrength(100.0f);
            }
            this.setStrength(this.getStrength() + 0.05f);
            if (this.method_55667().method_26215() && this.world.method_8320(this.method_24515().method_10074()).method_26215()) {
                double yPos = this.method_23318();
                if ((yPos -= (double)0.2f - this.field_5974.method_43059() * 2.0) < (double)(this.world.method_31607() + 2)) {
                    yPos = this.method_23318();
                }
                this.method_5808(this.method_23317(), yPos, this.method_23321(), this.method_36454(), 0.0f);
            } else {
                this.setSpawning(false);
            }
        } else if (this.getDying()) {
            if (this.getStrength() < 40.0f) {
                this.setStrength(40.0f);
            } else if (this.getStrength() >= 100.0f) {
                this.setStrength(100.0f);
            }
            this.setStrength(this.getStrength() - 0.01f);
            if (this.method_23318() < (double)this.getCloudY()) {
                double yPos = this.method_23318();
                yPos += (double)0.3f + this.field_5974.method_43059() * 2.0;
                if (!this.world.method_8320(this.method_24515().method_10087(2)).method_26215() && yPos <= this.method_23318() || yPos < (double)(this.world.method_31607() + 2)) {
                    yPos = this.method_23318();
                }
                this.method_5808(this.method_23317(), yPos, this.method_23321(), this.method_36454(), 0.0f);
            } else {
                float persistProb = 0.1f;
                if (Global.weather.isSevereStorm() && !Global.weather.isStormDying()) {
                    persistProb = 0.2f;
                }
                if (this.field_5974.method_43057() < persistProb && !this.shortenedLife && this.dispels <= 0) {
                    this.setDying(false);
                    this.setSpawning(true);
                    this.field_6012 = 0;
                    this.shortenedLife = true;
                    this.currentTarget = null;
                    this.world.method_8421((class_1297)this, (byte)35);
                } else {
                    this.killStorm();
                }
            }
        } else if (this.field_6012 % 20 == 0) {
            this.setStrength((float)this.field_5974.method_43048(30) * 1.0f + 100.0f);
            this.setCloudY(this.method_31478() + 64);
            if (this.field_6012 > this.getLifetime() || this.isSpout() && TornadoEntity.isInvalidForSpout(this.method_55667())) {
                this.startDissipate();
            }
        }
    }

    public void dispel() {
        this.dispels = (short)(this.dispels + 1);
        if (this.dispels > this.getDispellerCountForResistance()) {
            this.startDissipate();
            for (class_1657 player : Utils.getPlayersIn(this.world, this.method_5829().method_1009(86.0, 64.0, 86.0))) {
                WeatherClassic.DISPEL.trigger((class_3222)player, this.getTornadoType());
            }
        }
    }

    public void startDissipate() {
        this.setDying(true);
        this.setSpawning(false);
    }

    private void tickFX() {
        double tryZ;
        double tryX;
        boolean allowColor;
        if (this.field_6012 < 5) {
            return;
        }
        class_3218 sworld = (class_3218)this.world;
        boolean bl = allowColor = this.tornadoType != TornadoStats.Type.STAGEX && !this.demon || this.tornadoType == TornadoStats.Type.STAGEX && CustomTornadoConfig.getTakeSurroundingColor();
        if (!this.isSpout()) {
            if (this.colorChangeTicks <= 0) {
                if (this.currentColor != null) {
                    this.currentColor = null;
                }
                if (this.field_6012 % 50 == 0 && this.field_5974.method_43048(8) == 0 && allowColor) {
                    this.colorChangeTicks = 20 + this.field_5974.method_43048(120);
                }
            } else {
                if (this.currentColor == null) {
                    this.currentColor = this.getTornadoColorFromAround();
                    if (this.currentColor == null) {
                        this.colorChangeTicks = 0;
                        return;
                    }
                }
                --this.colorChangeTicks;
            }
        } else if (this.getCurrentTornadoColor() == null || this.field_6012 % 50 == 0) {
            this.currentColor = this.getTornadoColorFromAround();
        }
        float cval = this.currentColor != null ? this.currentColor.asFloat() : -1.0f;
        boolean beyondRange = this.getRipper().isFarOut();
        int totalTornadoes = Global.activeTornadoes.size();
        boolean cullExtreme = beyondRange || totalTornadoes > 3;
        boolean cullParticles = cullExtreme || totalTornadoes > 1;
        boolean cullParticlesGreatly = cullExtreme || totalTornadoes > 2;
        int count = cullExtreme ? 2 : (int)this.getStats().particleCount;
        float add = this.isDemon() ? 0.5f : 0.0f;
        boolean extra = this.field_6012 % this.getStats().extraParticleInterval == 0 && !this.getDying();
        int multiple = extra ? (int)this.getStats().extraParticleDistance : 2;
        for (int funnelCount = 0; funnelCount < count; ++funnelCount) {
            if (this.field_5974.method_43048(5) == 0 && extra && this.colorChangeTicks <= 0) {
                if (allowColor) {
                    TornadoColor color = this.getTornadoColorFromAround();
                    if (color != null) {
                        cval = color.asFloat();
                        if (this.firenado && this.field_5974.method_43057() < 0.5f) {
                            cval = TornadoColor.FIRE.asFloat();
                        }
                    }
                } else if (CustomTornadoConfig.getColorOverride() && !this.demon) {
                    cval = TornadoColor.UNIQUE_FLARE.asFloat();
                }
            }
            if (this.demon && this.isCloseToPlayer()) {
                cval = TornadoColor.FIRE.asFloat();
            }
            tryX = this.method_23317() + (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple) - (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple);
            tryZ = this.method_23321() + (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple) - (double)(this.field_5974.method_43057() * (this.getStats().particleSpawnRadius + add) * (float)multiple);
            Utils.forceImportantParticles(sworld, WCParticles.TORNADO_PARTICLE, tryX, this.method_23318() + 0.01, tryZ, 0, 0.0, 1.0, 0.0, cval);
        }
        if (this.method_59922().method_43048(3) == 0 && (!this.demon || this.isCloseToPlayer())) {
            for (int windCount = 0; windCount < (this.demon ? 10 : 5); ++windCount) {
                tryX = 10 + this.field_5974.method_43048((int)this.getStats().particleGetRange);
                tryZ = 10 + this.field_5974.method_43048((int)this.getStats().particleGetRange);
                tryX *= this.field_5974.method_43056() ? -1.0 : 1.0;
                tryZ *= this.field_5974.method_43056() ? -1.0 : 1.0;
                tryX += this.method_23317();
                tryZ += this.method_23321();
                double tryY = this.method_23318() + (double)this.field_5974.method_43048(20);
                if (!this.demon) {
                    float randOpacity = 0.9f - this.field_5974.method_43057() * 0.3f;
                    Utils.forceImportantParticles(sworld, WCParticles.TORNADO_WIND_PARTICLE, tryX, tryY, tryZ, 0, 0.0, 1.0, 0.0, randOpacity *= 10.0f);
                    continue;
                }
                Utils.forceImportantParticles(sworld, class_2398.field_11240, tryX, tryY, tryZ, 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.getStats().createClouds) {
            int num;
            int n = num = cullParticles ? 2 : 3;
            if (this.getTornadoType() == 5 && CustomTornadoConfig.getScaling() < 0.75f || cullParticlesGreatly) {
                num = 1;
            }
            for (int cloudCount = 0; cloudCount < num; ++cloudCount) {
                Utils.forceImportantParticles(sworld, WCParticles.STORM_CLOUD_PARTICLE, this.method_23317(), this.getCloudY(), this.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private TornadoColor getTornadoColorFromAround() {
        TornadoColor greenToUse;
        class_2338 pos = this.method_24515();
        class_2338 down = pos.method_10074();
        if (this.isSpout() || Materials.isWater(this.method_55667()) || Materials.isWater(this.world.method_8320(down))) {
            TornadoColor c = Utils.isTropicalOcean((class_5321<class_1959>)((class_5321)this.world.method_23753(pos).method_40230().get())) ? TornadoColor.AQUA_BLUE : TornadoColor.BLUE;
            return ModConfig.getClassicTornadoColors() ? TornadoColor.BLUE : c;
        }
        int dirt = 0;
        int snow = 0;
        int sand = 0;
        int red = 0;
        class_2338.class_2339 test = pos.method_25503();
        int range = 3;
        for (int xx = pos.method_10263() - range; xx < pos.method_10263() + range; xx += 2) {
            for (int zz = pos.method_10260() - range; zz < pos.method_10260() + range; zz += 2) {
                for (int yy = pos.method_10264() - 1; yy < pos.method_10264() + 4; yy += 2) {
                    test.method_10103(xx, yy, zz);
                    class_2680 state = this.world.method_8320((class_2338)test);
                    if (state.method_26215()) continue;
                    if (Materials.isSand(state)) {
                        if (Materials.isRedSand(state)) {
                            ++red;
                            continue;
                        }
                        ++sand;
                        continue;
                    }
                    if (Materials.isDirt(state)) {
                        ++dirt;
                        continue;
                    }
                    if (!Materials.isSnow(state)) continue;
                    ++snow;
                }
            }
        }
        boolean classic = ModConfig.getClassicTornadoColors();
        boolean dirtG = dirt > 5;
        class_6880 biome = this.world.method_23753(pos);
        boolean leavesG = this.field_5974.method_43048(4) == 0 && Utils.isBiomeForest((class_6880<class_1959>)biome);
        boolean snowG = snow > 5;
        boolean sandG = sand > 5 && !classic;
        boolean redG = red > 5 && !classic;
        TornadoColor brownToUse = this.field_5974.method_43056() || classic ? TornadoColor.CLASSIC_BROWN : TornadoColor.BROWN;
        TornadoColor tornadoColor = greenToUse = this.field_5974.method_43056() || classic ? TornadoColor.CLASSIC_GREEN : TornadoColor.GREEN;
        if (leavesG) {
            boolean b = false;
            if (dirtG) {
                b = this.field_5974.method_43048(2) == 0;
            }
            return b ? brownToUse : greenToUse;
        }
        return redG ? TornadoColor.RED : (sandG ? TornadoColor.SANDY : (snowG ? TornadoColor.WHITISH : (dirtG ? (this.field_5974.method_43048(10) == 0 ? greenToUse : brownToUse) : null)));
    }

    public TornadoColor getCurrentTornadoColor() {
        return this.currentColor;
    }

    protected boolean method_5876() {
        return false;
    }

    protected class_3414 method_5737() {
        return null;
    }

    public TornadoRipper getRipper() {
        return this.ripper;
    }

    public TornadoRotator getRotator() {
        return this.rotator;
    }

    public boolean isCloseToPlayer() {
        return this.closeToPlayer;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source == world.method_48963().method_51847()) {
            this.startDissipate();
        } else if (source == world.method_48963().method_48829()) {
            this.killStorm();
        }
        return false;
    }

    public int getMaxRangeForTracking(boolean inChunks) {
        return this.method_5864().method_18387() * (inChunks ? 1 : 16);
    }

    public boolean method_5974(double distanceSquared) {
        int dist = ModConfig.getMaxTornadoLoadDist();
        boolean despawn = distanceSquared > (double)(dist * dist);
        return despawn;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_23734()) {
            this.killStorm();
        } else if (!this.method_5947() && !this.method_17326()) {
            class_1657 entity = this.method_37908().method_18460((class_1297)this, -1.0);
            if (entity != null) {
                int i;
                int j;
                double d = entity.method_5858((class_1297)this);
                if (d > (double)(j = (i = this.method_5864().method_5891().method_27919()) * i) && this.method_5974(d)) {
                    this.killStorm();
                }
                int k = this.method_5864().method_5891().method_27920();
                int l = k * k;
                if (this.field_6278 > 600 && this.field_5974.method_43048(800) == 0 && d > (double)l && this.method_5974(d)) {
                    this.killStorm();
                } else if (d < (double)l) {
                    this.field_6278 = 0;
                }
            }
        } else {
            this.field_6278 = 0;
        }
    }

    public boolean method_17326() {
        return false;
    }

    public boolean method_5947() {
        return this.method_17326();
    }

    @Override
    public float getStrength() {
        return ((Float)this.method_5841().method_12789(STRENGTH)).floatValue();
    }

    public void setStrength(float f) {
        this.method_5841().method_12778(STRENGTH, (Object)Float.valueOf(f));
    }

    public void setSpawning(boolean b) {
        this.method_5841().method_12778(SPAWNING, (Object)b);
    }

    public boolean getSpawning() {
        return (Boolean)this.method_5841().method_12789(SPAWNING);
    }

    public void setDying(boolean b) {
        this.method_5841().method_12778(DYING, (Object)b);
    }

    public boolean getDying() {
        return (Boolean)this.method_5841().method_12789(DYING);
    }

    public void setCloudY(int i) {
        this.method_5841().method_12778(STORM_CLOUD_Y, (Object)i);
    }

    @Override
    public int getCloudY() {
        return (Integer)this.method_5841().method_12789(STORM_CLOUD_Y);
    }

    public void setCurrentTarget(class_2338 pos) {
        this.currentTarget = pos;
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5873(class_1297 entity, boolean force) {
        return false;
    }

    public boolean method_5931() {
        return false;
    }

    public void method_5651(class_2487 nbt) {
        if (!this.world.field_9236 && nbt.method_10545("unload") && nbt.method_10577("unload")) {
            this.worldUnload = true;
            if (nbt.method_10545("targX") && nbt.method_10545("targY") && nbt.method_10545("targZ")) {
                this.currentTarget = BP.of(nbt.method_10550("targX"), nbt.method_10550("targY"), nbt.method_10550("targZ"));
            }
        }
        super.method_5651(nbt);
    }

    public class_2487 method_5647(class_2487 nbt) {
        if (!this.world.field_9236 && this.world.method_18456().isEmpty()) {
            nbt.method_10556("unload", true);
            if (this.currentTarget != null) {
                nbt.method_10569("targX", this.currentTarget.method_10263());
                nbt.method_10569("targY", this.currentTarget.method_10264());
                nbt.method_10569("targZ", this.currentTarget.method_10260());
            }
            Global.removeTornado(this);
        }
        return super.method_5647(nbt);
    }

    public static boolean isInvalidForSpout(class_2680 state) {
        return !Materials.isOcean(state) && !state.method_26215();
    }

    @Override
    public class_243 getEmitter() {
        return this.method_19538();
    }

    public boolean killDueToPlayersUnavailable() {
        if (!this.world.method_18456().isEmpty()) {
            return false;
        }
        boolean fullOther = false;
        for (class_3218 w : this.world.method_8503().method_3738()) {
            if (w.method_27983() == class_1937.field_25179 || w.method_18456().isEmpty()) continue;
            fullOther = true;
            break;
        }
        return !this.world.method_8503().method_3760().method_14571().isEmpty() && fullOther;
    }

    public boolean killDueToInvalidPosition() {
        if (!this.world.method_8621().method_11952(this.method_24515()) || this.method_31478() < this.world.method_31607() - 1 || this.world.method_27983() != class_1937.field_25179) {
            return true;
        }
        class_1657 player = this.world.method_8604(this.method_23317(), this.method_23318(), this.method_23321(), -1.0, p -> p.method_7325());
        if (player != null) {
            int distLimit = ModConfig.getMaxTornadoLoadDist() - 16;
            if (this.method_5707(player.method_33571()) > (double)(distLimit * distLimit)) {
                return true;
            }
        }
        if (this.isDemon() && TornadoEntity.invalidForDemon(this.world)) {
            return true;
        }
        TornadoEntity tornado = Global.getClosestOtherTornado(this);
        if (tornado == null) {
            return false;
        }
        if (Utils.distanceXZ(this.method_19538(), tornado.method_19538()) >= 24.0) {
            return false;
        }
        if (tornado.getTornadoType() > this.getTornadoType()) {
            return true;
        }
        if (tornado.getTornadoType() == this.getTornadoType()) {
            return tornado.method_5628() > this.method_5628();
        }
        return false;
    }

    public static boolean invalidForDemon(class_1937 world) {
        long t = world.method_8532() % 24000L;
        return t <= 12000L || t >= 22000L || !world.method_8546();
    }

    @Override
    public int getPullRadius() {
        return this.rotator.getPullRadius();
    }

    public double method_23320() {
        return this.method_23318() + (double)TornadoEntity.getMidCalculation();
    }

    public static int getMidCalculation() {
        return 20;
    }

    @Override
    public boolean isDemon() {
        return this.demon;
    }

    public short getDispellerCountForResistance() {
        float res = this.getStats().dispellerResistance;
        short r = (short)class_3532.method_15375((float)(res * 10.0f));
        return (short)class_3532.method_15340((int)r, (int)0, (int)10);
    }

    public static TornadoStats.Type getTornadoTypeFrom(byte b) {
        switch (b) {
            case 0: {
                return TornadoStats.Type.SPOUT;
            }
            case 1: {
                return TornadoStats.Type.STAGE2;
            }
            case 2: {
                return TornadoStats.Type.STAGE3;
            }
            case 3: {
                return TornadoStats.Type.STAGE4;
            }
            case 4: {
                return TornadoStats.Type.STAGE5;
            }
            case 5: {
                return TornadoStats.Type.STAGEX;
            }
        }
        return TornadoStats.Type.STAGE2;
    }

    public static class_1299<? extends class_1314> getEntityTypeFrom(byte b) {
        switch (b) {
            case 0: {
                return WeatherClassic.SPOUT;
            }
            case 1: {
                return WeatherClassic.STAGE2;
            }
            case 2: {
                return WeatherClassic.STAGE3;
            }
            case 3: {
                return WeatherClassic.STAGE4;
            }
            case 4: {
                return WeatherClassic.STAGE5;
            }
            case 5: {
                return WeatherClassic.STAGEX;
            }
        }
        return WeatherClassic.STAGE2;
    }

    public static TornadoStats.Type getTornadoTypeFromEntity(class_1299<? extends class_1314> type) {
        return type == WeatherClassic.SPOUT ? TornadoStats.Type.SPOUT : (type == WeatherClassic.STAGE3 ? TornadoStats.Type.STAGE3 : (type == WeatherClassic.STAGE4 ? TornadoStats.Type.STAGE4 : (type == WeatherClassic.STAGE5 ? TornadoStats.Type.STAGE5 : (type == WeatherClassic.STAGEX ? TornadoStats.Type.STAGEX : TornadoStats.Type.STAGE2))));
    }

    static {
        tornadoColors.put(TornadoColor.BROWN, new Vector3f(0.51f, 0.33f, 0.22f));
        tornadoColors.put(TornadoColor.GREEN, new Vector3f(0.0f, 0.42f, 0.0f));
        tornadoColors.put(TornadoColor.SANDY, new Vector3f(0.83f, 0.8f, 0.59f));
        tornadoColors.put(TornadoColor.RED, new Vector3f(0.92f, 0.57f, 0.33f));
        tornadoColors.put(TornadoColor.WHITISH, new Vector3f(0.93f, 1.0f, 1.0f));
        tornadoColors.put(TornadoColor.BLUE, new Vector3f(0.0f, 0.26f, 0.86f));
        tornadoColors.put(TornadoColor.AQUA_BLUE, new Vector3f(0.0f, 0.55f, 0.84f));
        tornadoColors.put(TornadoColor.CLASSIC_BROWN, new Vector3f(0.67f, 0.47f, 0.29f));
        tornadoColors.put(TornadoColor.CLASSIC_GREEN, new Vector3f(0.18f, 0.92f, 0.0f));
        tornadoColors.put(TornadoColor.FIRE, new Vector3f(0.9f, 0.3f, 0.0f));
    }

    public static enum TornadoColor {
        BROWN(0.0f),
        CLASSIC_BROWN(8.0f),
        GREEN(1.0f),
        CLASSIC_GREEN(9.0f),
        SANDY(2.0f),
        RED(3.0f),
        WHITISH(4.0f),
        BLUE(5.0f),
        AQUA_BLUE(6.0f),
        UNIQUE_FLARE(7.0f),
        FIRE(10.0f);

        final float colorFloat;

        private TornadoColor(float f) {
            this.colorFloat = f;
        }

        public float asFloat() {
            return this.colorFloat;
        }

        public static TornadoColor get(float f) {
            int i = (int)f;
            switch (i) {
                case 0: {
                    return BROWN;
                }
                case 1: {
                    return GREEN;
                }
                case 2: {
                    return SANDY;
                }
                case 3: {
                    return RED;
                }
                case 4: {
                    return WHITISH;
                }
                case 5: {
                    return BLUE;
                }
                case 6: {
                    return AQUA_BLUE;
                }
                case 7: {
                    return UNIQUE_FLARE;
                }
                case 8: {
                    return CLASSIC_BROWN;
                }
                case 9: {
                    return CLASSIC_GREEN;
                }
                case 10: {
                    return FIRE;
                }
            }
            return null;
        }
    }
}

