/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_8836;
import net.weather_classic.block.PuddleBlock;
import net.weather_classic.block.TornadoDispellerBlock;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.BP;
import net.weather_classic.help.MutableTriplet;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core.DebrisManipulator;
import net.weather_classic.networking.WCNetworkServer;
import net.weather_classic.registry.WCEntities;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.debris.DebrisEntity;
import net.weather_classic.storm.player.PlayerInputAccount;

public class TornadoRotator {
    private final TornadoEntity storm;
    private List<DebrisEntity> debris = new ArrayList<DebrisEntity>();
    private List<class_1309> mobs = new ArrayList<class_1309>();
    private List<class_8836> vehicles = new ArrayList<class_8836>();
    private List<class_1297> prevList;
    private final MutableTriplet<Integer, Integer, Integer> spoutPullVals;
    private MutableTriplet<Integer, Integer, Integer> tornadoPullVals;
    private List<class_1309> tempList = new ArrayList<class_1309>();
    private List<class_1657> playersForDebrisUpdates = null;

    public TornadoRotator(TornadoEntity tornado) {
        this.storm = tornado;
        this.spoutPullVals = MutableTriplet.of(10, 15, this.getPullRadius());
        this.updatePullVals(tornado);
        this.prevList = List.of();
    }

    public void updatePullVals(TornadoEntity tornado) {
        this.tornadoPullVals = MutableTriplet.of(class_3532.method_15357((double)((double)this.getPullRadius() * 0.37)), class_3532.method_15357((double)((double)this.getPullRadius() * 0.73)), this.getPullRadius());
        byte t = tornado.getTornadoTypeForRotator();
        switch (t) {
            case 2: {
                this.tornadoPullVals.updateA(22);
                break;
            }
            case 3: {
                this.tornadoPullVals.updateA(33);
                break;
            }
            case 4: {
                this.tornadoPullVals.updateA(44);
            }
        }
    }

    public List<DebrisEntity> getDebris() {
        return this.debris;
    }

    public List<class_1309> getRotatingMobs() {
        return this.mobs;
    }

    public boolean maxMobsReached() {
        return this.mobs.size() >= ModConfig.getMaxMobsPerTornado() + this.storm.getTornadoTypeForRotator() * 2;
    }

    public boolean maxDebrisReached() {
        int num = ModConfig.getMaxDebrisPerTornado();
        switch (this.storm.getStats().ripType) {
            case STAGE3: {
                num += 5;
                break;
            }
            case STAGE4: {
                num += 10;
                break;
            }
            case STAGE5: {
                num += 15;
                break;
            }
        }
        return this.debris.size() >= num + (this.storm.isDemon() ? 20 : 0);
    }

    public int getPullRadius() {
        return this.storm.getStats().grabDistance;
    }

    private class_238 getGrabBox(boolean tempBox) {
        int downwardOffset = 10;
        int bobbingRegion = 6;
        class_238 b = new class_238(this.storm.method_24515().method_10086(32)).method_1009((double)this.getPullRadius(), 64.0, (double)this.getPullRadius());
        b = tempBox ? b.method_35575((double)(this.storm.method_31478() + this.storm.getStats().idealLiftHeight)).method_35578((double)(this.storm.method_31478() + 64 + bobbingRegion)) : b.method_35575((double)(this.storm.method_31478() - downwardOffset)).method_35578((double)(this.storm.method_31478() + this.storm.getStats().idealLiftHeight + bobbingRegion));
        return b;
    }

    public void grabEntities() {
        if (this.storm.getRipper() != null && this.storm.getRipper().isBeyondLoadedRange()) {
            if (!this.debris.isEmpty() || !this.mobs.isEmpty()) {
                this.debris.clear();
                this.mobs.clear();
            }
            return;
        }
        if ((this.storm.isDemon() && this.storm.isCloseToPlayer() || this.storm.isPassiveFirenado()) && this.storm.field_6012 % 40 == 0 && !this.maxDebrisReached()) {
            class_2338 spso = this.storm.method_24515().method_10086(20);
            if (this.storm.method_37908().method_8320(spso).method_26215()) {
                Object deb = DebrisEntity.createDebris(WCEntities.DEBRIS, this.storm, spso, class_2246.field_10036.method_9564(), true);
                deb.method_5725(this.storm.method_24515().method_10086(20), 0.0f, 0.0f);
                deb.method_37908().method_8649(deb);
            }
        }
        if (this.storm.field_6012 % 35 == 0) {
            List list = this.storm.method_37908().method_8390(class_1297.class, this.getGrabBox(false), p -> !p.method_5869() && !Utils.inInvalidMode(p) && !Utils.isWindImmuneMob(p));
            for (class_1297 entity : list) {
                class_1657 player;
                DebrisManipulator data;
                class_1297 limit2;
                boolean isDebris;
                if (entity instanceof class_1420) continue;
                if (entity instanceof class_8836) {
                    class_8836 v = (class_8836)entity;
                    double distXZ = Utils.distanceXZ(v.method_24515(), this.storm.method_24515());
                    float limit2 = (float)(this.storm.getTornadoTypeForRotator() <= 0 ? 2.0 : 1.2);
                    if (distXZ < (double)((float)this.getPullRadius() / limit2) && !this.vehicles.contains(v) && this.vehicles.size() < 10) {
                        this.vehicles.add(v);
                    }
                }
                boolean normal = entity.method_5709();
                boolean bl = isDebris = entity.method_5864() == WCEntities.DEBRIS;
                if (this.mobs.contains(entity) || this.debris.contains(entity) || normal && this.maxMobsReached() && !entity.method_31747() || !normal && this.maxDebrisReached()) continue;
                if (normal) {
                    if (this.mobs.contains(entity)) continue;
                    this.mobs.add((class_1309)entity);
                    if (!this.tempList.contains(entity)) continue;
                    this.tempList.remove(entity);
                    continue;
                }
                if (!isDebris || this.debris.contains(entity) || (limit2 = ((DebrisEntity)entity).method_24921()) instanceof class_1657 && (data = (DebrisManipulator)(player = (class_1657)limit2)).getManipulatingDebris() == entity) continue;
                ((DebrisEntity)entity).method_7432((class_1297)this.storm);
                ((DebrisEntity)entity).setTornadoHost(this.storm.method_5667());
                this.debris.add((DebrisEntity)entity);
                entity.method_5660(true);
            }
            this.prevList = list;
        }
        this.pullEntitiesAboveTemporarily();
        if (this.storm.field_6012 % 4 == 0 && !this.vehicles.isEmpty()) {
            float value = this.storm.getTornadoTypeForRotator() == 0 ? 0.4f : (this.storm.getTornadoTypeForRotator() < 3 ? 0.6f : 0.8f);
            float limit = (float)(this.storm.getTornadoTypeForRotator() <= 0 ? 2.0 : 1.2);
            Iterator<class_8836> vehicleIterator = this.vehicles.iterator();
            while (vehicleIterator.hasNext()) {
                double distXZ;
                class_8836 v = vehicleIterator.next();
                if (v.method_5869() || Utils.inInvalidMode((class_1297)v) || !this.prevList.contains(v)) {
                    vehicleIterator.remove();
                    continue;
                }
                if (this.canEntitySeeTornado((class_1297)v)) {
                    v.method_64397((class_3218)this.storm.method_37908(), this.storm.method_37908().method_48963().method_48830(), value);
                }
                if (!((distXZ = Utils.distanceXZ(v.method_24515(), this.storm.method_24515())) > (double)((float)this.getPullRadius() / limit))) continue;
                vehicleIterator.remove();
            }
        }
        Iterator<class_1309> mobsIterator = this.mobs.iterator();
        while (mobsIterator.hasNext()) {
            class_1309 ent = mobsIterator.next();
            if (ent.method_5869() || Utils.inInvalidMode((class_1297)ent) || !this.prevList.contains(ent)) {
                ent.method_5855(ent.method_5748());
                mobsIterator.remove();
                continue;
            }
            if (this.canEntitySeeTornado((class_1297)ent) && ent.method_31478() < this.storm.method_31478() + this.storm.getStats().idealLiftHeight) {
                this.spinEntity((class_1297)ent);
            }
            if (!this.storm.isDemon() || ent.field_6012 % 100 != 0 || !this.storm.isCloseToPlayer()) continue;
            ent.method_5639(6.0f);
        }
        Iterator<DebrisEntity> debrisIterator = this.debris.iterator();
        while (debrisIterator.hasNext()) {
            DebrisEntity ent = debrisIterator.next();
            if (ent.method_5869() || Utils.inInvalidMode((class_1297)ent) || ent.method_24921() != this.storm) {
                debrisIterator.remove();
                continue;
            }
            if (ent.method_31478() < this.storm.method_31478() + this.storm.getStats().idealLiftHeight) {
                this.spinEntity((class_1297)ent);
            }
            if (!ent.isDispeller() || ent.method_5669() <= 350) continue;
            TornadoDispellerBlock.dispel((class_3218)this.storm.method_37908(), ent.method_24515(), true);
            if (ent.method_5669() <= 400) continue;
            ent.forceCollide();
        }
    }

    public boolean canEntitySeeTornado(class_1297 ent) {
        class_2338.class_2339 simple = this.storm.method_24515().method_25503();
        for (int i = 0; i < 12; ++i) {
            if (this.storm.getTornadoTypeForRotator() >= 4 && i % 4 == 0 && ent.method_24828()) {
                for (class_2350 dir : class_2350.values()) {
                    class_2338 pos;
                    if (dir.method_10166() == class_2350.class_2351.field_11052 || !Utils.canSeePosDirect(ent, pos = this.storm.method_24515().method_10086(5 * i).method_10079(dir, 16))) continue;
                    return true;
                }
            }
            simple.method_33098(this.storm.method_31478() + 5 * i);
            if (!Utils.canSeeFair(ent, (class_2338)simple)) continue;
            return true;
        }
        return false;
    }

    public void spinEntity(class_1297 entity) {
        PlayerInputAccount account;
        double distXZSq = Utils.squaredDistanceXZ(this.storm.method_19538(), entity.method_19538());
        if (entity.method_5854() != null) {
            float limit = (float)(this.storm.getTornadoTypeForRotator() <= 0 ? 2.0 : 1.2);
            float vehicleKickout = (float)this.getPullRadius() / limit;
            if (distXZSq < (double)(vehicleKickout * vehicleKickout)) {
                entity.method_5848();
            }
        }
        boolean custom = this.storm.getTornadoType() == 5;
        boolean spout = this.storm.isSpout();
        boolean terrain = entity instanceof DebrisEntity;
        boolean airLimitReached = entity.method_5669() > 600 - (terrain ? 100 : 0);
        boolean airLimitReaching = entity.method_5669() > 500 - (terrain ? 100 : 0);
        boolean inWater = entity.method_5799();
        double scale = this.storm.getStats().scaling - (!this.storm.isSpout() ? 0.2f : 0.0f);
        double d1 = this.storm.method_23317() - entity.method_23317();
        double d2 = this.storm.method_23321() - entity.method_23321();
        float r = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
        float r2 = r % 360.0f;
        if (r2 >= 180.0f) {
            r2 -= 360.0f;
        } else if (r2 < -180.0f) {
            r2 += 360.0f;
        }
        byte pullType = this.getPullingType(spout, distXZSq);
        float lift = this.getLift(spout, this.storm.getStats().liftSpeed, inWater, pullType, terrain);
        if (terrain && this.storm.getStats().ripType.shouldUseWideDestruction() && entity.field_6012 < 10 && Utils.distanceXZ(entity.method_24515(), this.storm.method_24515()) > (double)this.storm.getStats().pathSize) {
            lift *= 2.0f;
        }
        double radius = (float)(!this.storm.isSpout() ? -16 : -1) * (terrain ? (airLimitReaching ? (this.storm.getTornadoTypeForRotator() == 1 ? 3.0f : 2.5f) : 2.0f) : 1.0f);
        r2 = class_3532.method_15393((float)((float)((double)r2 + (75.0 + radius - 10.0 * scale))));
        float xSpin = (float)Math.cos(-r2 * 0.01745329f - (float)Math.PI);
        float zSpin = (float)Math.sin(-r2 * 0.01745329f - (float)Math.PI);
        float speed = this.storm.getStats().grabSpeed * (airLimitReaching ? (entity instanceof class_1657 ? 3.2f : 2.5f) : 1.0f);
        float moveX = xSpin * (speed *= this.storm.getStats().grabMultiplierForMobs);
        float moveZ = zSpin * speed;
        float multiple = this.getGrabSpeed(inWater, spout, entity.method_24828() && entity.method_31747(), terrain, pullType);
        moveX *= multiple;
        moveZ *= multiple;
        float str = airLimitReached ? (entity.method_24828() ? 3 : 70 - this.storm.method_59922().method_43048(20)) : 100 - this.storm.getRandomStrengthVariationFallOff();
        lift *= str / 100.0f;
        class_243 motion = new class_243(0.0, 0.0, 0.0);
        if (entity.method_31747() && (account = Global.wind.getInputAccount(entity.method_5667(), this.storm.method_5667())) != null) {
            if (entity.method_55667().method_26204() instanceof PuddleBlock) {
                moveX *= pullType < 2 ? 2.0f : 3.0f;
                moveZ *= pullType < 2 ? 2.0f : 3.0f;
                lift *= pullType < 2 ? 1.5f : 3.0f;
                if (entity.field_6012 % 10 == 0) {
                    Utils.playSound(null, this.storm.method_37908(), entity.method_24515(), class_3417.field_14756, class_3419.field_15245, 1.0f, 1.5f + entity.method_59922().method_43057() * 0.5f);
                }
            } else {
                float sideways = account.getSidewaysInput();
                float forward = account.getForwardInput();
                class_243 lookingDir = entity.method_5720();
                class_243 rightDir = new class_243(lookingDir.field_1350, 0.0, -lookingDir.field_1352).method_1029();
                motion = lookingDir.method_1021((double)forward).method_1019(rightDir.method_1021((double)sideways));
                if (motion.method_1027() > 0.0) {
                    motion = motion.method_1029();
                }
                float mult = 0.0f;
                if (pullType != 0) {
                    mult = 0.03f;
                    if (!entity.method_24828()) {
                        mult = 0.01f;
                    } else if (entity.method_5624()) {
                        mult = 0.05f;
                    }
                }
                if (custom && CustomTornadoConfig.getPullType(true) == 5 && entity.method_24828() && entity.method_5715()) {
                    mult = 0.15f;
                    lift = 0.0f;
                }
                motion = motion.method_1021((double)mult);
            }
        }
        if (pullType != 0) {
            float maxAnnoyance = this.storm.getStats().maxGrabAnnoyance;
            float maxSpeed = pullType == 2 ? maxAnnoyance : maxAnnoyance + 0.05f;
            moveX = class_3532.method_15363((float)moveX, (float)(-maxSpeed), (float)maxSpeed);
            moveZ = class_3532.method_15363((float)moveZ, (float)(-maxSpeed), (float)maxSpeed);
        }
        double XFinal = entity.method_18798().field_1352 + motion.field_1352;
        double YFinal = entity.method_18798().field_1351;
        double ZFinal = entity.method_18798().field_1350 + motion.field_1350;
        XFinal += (double)(-moveX);
        YFinal += (double)lift;
        ZFinal += (double)moveZ;
        if (entity instanceof class_1309 || terrain) {
            if (airLimitReached) {
                if (entity.method_24828()) {
                    entity.method_5855(entity.method_5748());
                } else if (this.storm.method_59922().method_43048(4) == 0 && this.storm.field_6012 % 50 == 0 && !terrain) {
                    entity.method_5855(entity.method_5748());
                }
            } else if (!entity.method_5799()) {
                entity.method_5855(entity.method_5669() + 1);
            }
            entity.method_18800(XFinal, YFinal, ZFinal);
            if (ModConfig.forceDebrisVelocityUpdates() && terrain) {
                WCNetworkServer.sendDebrisVelocityPacket((DebrisEntity)entity, XFinal, YFinal, ZFinal, this.playersForDebrisUpdates);
            }
            if (entity.method_31747() || entity.method_5817()) {
                entity.field_6037 = true;
            }
            if (custom && entity.method_5709() && CustomTornadoConfig.getPullType(true) == 5) {
                entity.field_6017 = 0.0f;
            }
        }
    }

    private byte getPullingType(boolean spout, double distSq) {
        int a = this.tornadoPullVals.getA();
        int b = this.tornadoPullVals.getB();
        if (spout) {
            a = this.spoutPullVals.getA();
            b = this.spoutPullVals.getB();
            if (distSq <= (double)(a * a)) {
                return 0;
            }
            if (distSq <= (double)(b * b)) {
                return 1;
            }
            return 2;
        }
        if (distSq <= (double)(a * a)) {
            return 0;
        }
        if (distSq <= (double)(b * b)) {
            return 1;
        }
        return 2;
    }

    private float getLift(boolean spout, float input, boolean inWater, byte val, boolean debris) {
        float debrisMult = this.storm.getTornadoTypeForRotator() == 1 ? 1.2f : 1.0f;
        switch (val) {
            case 0: {
                return input * 2.0f * (debris ? debrisMult : 1.0f);
            }
            case 1: {
                return (inWater ? input * 1.0f : input * 1.4f) * (debris ? debrisMult : 1.0f);
            }
        }
        return inWater ? input * 0.6f : input * 0.7f * (debris ? debrisMult : 1.0f);
    }

    private float getGrabSpeed(boolean inWater, boolean spout, boolean playerOnGround, boolean debris, byte val) {
        float base = debris ? 0.4f : 0.0f;
        switch (this.storm.getTornadoTypeForRotator()) {
            case 2: {
                switch (val) {
                    case 0: {
                        return base + (playerOnGround ? 3.5f : 1.0f);
                    }
                    case 1: {
                        return inWater ? 0.65f : (playerOnGround ? 5.0f : 1.2f);
                    }
                }
                return inWater ? 0.4f : (playerOnGround ? 1.7f : 1.0f);
            }
            case 3: {
                switch (val) {
                    case 0: {
                        return base + (playerOnGround ? 3.5f : 1.0f);
                    }
                    case 1: {
                        return inWater ? 0.7f : (playerOnGround ? 5.9f : 1.3f);
                    }
                }
                return inWater ? 0.45f : (playerOnGround ? 1.8f : 1.0f);
            }
            case 4: {
                switch (val) {
                    case 0: {
                        return base + (playerOnGround ? 3.5f : 1.0f);
                    }
                    case 1: {
                        return inWater ? 0.75f : (playerOnGround ? 6.5f : 1.5f);
                    }
                }
                return inWater ? 0.5f : (playerOnGround ? 1.8f : 1.0f);
            }
        }
        switch (val) {
            case 0: {
                return base + (playerOnGround ? 3.5f : 1.0f);
            }
            case 1: {
                return inWater ? 0.6f : (playerOnGround ? 3.0f : 0.9f);
            }
        }
        return inWater ? 0.4f : (playerOnGround ? 1.4f : 0.8f);
    }

    private void pullEntitiesAboveTemporarily() {
        boolean customSmall;
        if (this.storm.field_6012 % 80 == 0) {
            List list;
            if (ModConfig.forceDebrisVelocityUpdates()) {
                this.playersForDebrisUpdates = Utils.getPlayersIn(this.storm.method_37908(), new class_238(BP.of(this.storm.method_33571())).method_1014(128.0));
            } else if (this.playersForDebrisUpdates != null) {
                this.playersForDebrisUpdates = null;
            }
            class_238 b = this.getGrabBox(true);
            this.tempList = list = this.storm.method_37908().method_8390(class_1309.class, b, p -> !this.mobs.contains(p) && !p.method_5869() && !Utils.inInvalidMode((class_1297)p) && !Utils.isWindImmuneMob((class_1297)p));
        }
        boolean bl = customSmall = this.storm.getTornadoType() == 5 && CustomTornadoConfig.getScaling() <= 0.55f;
        if (customSmall) {
            return;
        }
        int num = 0;
        for (class_1309 entity : this.tempList) {
            if (entity.method_5869() || Utils.inInvalidMode((class_1297)entity) || !entity.method_31747() && num > 10) continue;
            if (this.canEntitySeeTornado((class_1297)entity) && entity.method_31478() < this.storm.method_31478() + 64) {
                this.spinEntity((class_1297)entity);
            }
            num = (byte)(num + 1);
        }
    }
}

