/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm;

import net.minecraft.class_3218;
import net.weather_classic.WeatherClassic;
import net.weather_classic.config.CustomTornadoConfig;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.storm.TornadoEntity;
import net.weather_classic.storm.TornadoRipper;

public class TornadoStats {
    public short speed;
    public float grabSpeed;
    public float liftSpeed;
    public float particleSpawnRadius;
    public short pathSize;
    public float scaling;
    public int time;
    public float maxGrabAnnoyance;
    public short particleCount;
    public short extraParticleInterval;
    public boolean hasDemons;
    public float grabMultiplierForMobs;
    public short grabDistance;
    public short idealLiftHeight;
    public TornadoRipper.RipType ripType;
    public short extraParticleDistance;
    public short particleGetRange;
    public boolean createClouds;
    public int soundDist;
    public float dispellerResistance;
    private final Type type;

    private TornadoStats(Type t) {
        this.type = t;
    }

    public static TornadoStats create(Type type) {
        TornadoStats config = new TornadoStats(type);
        switch (type.ordinal()) {
            case 0: {
                config.createSpoutStats();
                break;
            }
            case 1: {
                config.createStage2Stats();
                break;
            }
            case 2: {
                config.createStage3Stats();
                break;
            }
            case 3: {
                config.createStage4Stats();
                break;
            }
            case 4: {
                config.createStage5Stats();
                break;
            }
            case 5: {
                config.createStageXStats();
                break;
            }
        }
        return config;
    }

    public static TornadoStats get(Type type) {
        switch (type.ordinal()) {
            case 0: {
                return WeatherClassic.SPOUT_CONFIG;
            }
            case 1: {
                return WeatherClassic.STAGE2_CONFIG;
            }
            case 2: {
                return WeatherClassic.STAGE3_CONFIG;
            }
            case 3: {
                return WeatherClassic.STAGE4_CONFIG;
            }
            case 4: {
                return WeatherClassic.STAGE5_CONFIG;
            }
            case 5: {
                return WeatherClassic.STAGEX_CONFIG;
            }
        }
        return null;
    }

    private void createSpoutStats() {
        this.speed = (short)5;
        this.grabSpeed = 0.03f;
        this.liftSpeed = 0.05f;
        this.particleSpawnRadius = 1.5f;
        this.pathSize = (short)8;
        this.scaling = 0.8f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 1800 : 1200;
        this.maxGrabAnnoyance = 0.12f;
        this.particleCount = (short)5;
        this.extraParticleInterval = (short)10;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.0f;
        this.grabDistance = (short)24;
        this.idealLiftHeight = (short)35;
        this.ripType = TornadoRipper.RipType.NONE;
        this.extraParticleDistance = (short)8;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = false;
        this.soundDist = 36;
        this.dispellerResistance = 0.0f;
    }

    private void createStage2Stats() {
        this.speed = (short)6;
        this.grabSpeed = 0.08f;
        this.liftSpeed = 0.05f;
        this.particleSpawnRadius = 2.0f;
        this.pathSize = (short)2;
        this.scaling = 1.2f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 5200 : 3200;
        this.maxGrabAnnoyance = 0.15f;
        this.particleCount = (short)8;
        this.extraParticleInterval = (short)25;
        this.hasDemons = true;
        this.grabMultiplierForMobs = 1.1f;
        this.grabDistance = (short)46;
        this.idealLiftHeight = (short)40;
        this.ripType = TornadoRipper.RipType.STAGE2;
        this.extraParticleDistance = (short)8;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 52;
        this.dispellerResistance = 0.0f;
    }

    private void createStage3Stats() {
        this.speed = (short)7;
        this.grabSpeed = 0.0935f;
        this.liftSpeed = 0.051f;
        this.particleSpawnRadius = 4.0f;
        this.pathSize = (short)4;
        this.scaling = 1.3f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 5200 : 3200;
        this.maxGrabAnnoyance = 0.2f;
        this.particleCount = (short)8;
        this.extraParticleInterval = (short)15;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.15f;
        this.grabDistance = (short)56;
        this.idealLiftHeight = (short)37;
        this.ripType = TornadoRipper.RipType.STAGE3;
        this.extraParticleDistance = (short)4;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 64;
        this.dispellerResistance = 0.2f;
    }

    private void createStage4Stats() {
        this.speed = (short)5;
        this.grabSpeed = 0.1f;
        this.liftSpeed = 0.052f;
        this.particleSpawnRadius = 15.0f;
        this.pathSize = (short)11;
        this.scaling = 1.6f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 5200 : 3200;
        this.maxGrabAnnoyance = 0.25f;
        this.particleCount = (short)9;
        this.extraParticleInterval = (short)20;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.25f;
        this.grabDistance = (short)66;
        this.idealLiftHeight = (short)45;
        this.ripType = TornadoRipper.RipType.STAGE4;
        this.extraParticleDistance = (short)4;
        this.particleGetRange = (short)(this.particleSpawnRadius + 16.0f);
        this.createClouds = true;
        this.soundDist = 72;
        this.dispellerResistance = 0.4f;
    }

    private void createStage5Stats() {
        this.speed = (short)4;
        this.grabSpeed = 0.15f;
        this.liftSpeed = 0.053f;
        this.particleSpawnRadius = 30.0f;
        this.pathSize = (short)18;
        this.scaling = 1.8f;
        this.time = ModConfig.getTornadoesExtraLongDuration() ? 5200 : 3200;
        this.maxGrabAnnoyance = 0.3f;
        this.particleCount = (short)9;
        this.extraParticleInterval = (short)10;
        this.hasDemons = false;
        this.grabMultiplierForMobs = 1.3f;
        this.grabDistance = (short)86;
        this.idealLiftHeight = (short)50;
        this.ripType = TornadoRipper.RipType.STAGE5;
        this.extraParticleDistance = (short)4;
        this.particleGetRange = (short)(this.particleSpawnRadius * 2.0f);
        this.createClouds = true;
        this.soundDist = 90;
        this.dispellerResistance = 0.6f;
    }

    private void createStageXStats() {
        this.speed = CustomTornadoConfig.getSpeed();
        this.liftSpeed = 0.05f;
        this.hasDemons = false;
        switch (CustomTornadoConfig.getPullType(true)) {
            case 0: {
                this.maxGrabAnnoyance = WeatherClassic.SPOUT_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.SPOUT_CONFIG.grabMultiplierForMobs + 0.05f;
                this.grabDistance = (short)(WeatherClassic.SPOUT_CONFIG.grabDistance + 6);
                this.idealLiftHeight = WeatherClassic.SPOUT_CONFIG.idealLiftHeight;
                break;
            }
            case 2: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE3_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE3_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE3_CONFIG.grabDistance;
                this.idealLiftHeight = WeatherClassic.STAGE3_CONFIG.idealLiftHeight;
                break;
            }
            case 3: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE4_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE4_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE4_CONFIG.grabDistance;
                this.idealLiftHeight = WeatherClassic.STAGE4_CONFIG.idealLiftHeight;
                break;
            }
            case 4: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE5_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE5_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE5_CONFIG.grabDistance;
                this.idealLiftHeight = WeatherClassic.STAGE5_CONFIG.idealLiftHeight;
                break;
            }
            case 5: {
                this.maxGrabAnnoyance = WeatherClassic.SPOUT_CONFIG.maxGrabAnnoyance - 0.02f;
                this.grabMultiplierForMobs = WeatherClassic.SPOUT_CONFIG.grabMultiplierForMobs;
                this.grabDistance = (short)(WeatherClassic.SPOUT_CONFIG.grabDistance - 4);
                this.idealLiftHeight = (short)(WeatherClassic.SPOUT_CONFIG.idealLiftHeight - 10);
                break;
            }
            default: {
                this.maxGrabAnnoyance = WeatherClassic.STAGE2_CONFIG.maxGrabAnnoyance;
                this.grabMultiplierForMobs = WeatherClassic.STAGE2_CONFIG.grabMultiplierForMobs;
                this.grabDistance = WeatherClassic.STAGE2_CONFIG.grabDistance;
                this.idealLiftHeight = WeatherClassic.STAGE2_CONFIG.idealLiftHeight;
            }
        }
        this.scaling = CustomTornadoConfig.getScaling();
        if (this.scaling < 0.55f) {
            this.idealLiftHeight = (short)17;
        }
        this.grabSpeed = CustomTornadoConfig.getGrabSpeed();
        this.ripType = TornadoRipper.RipType.fromByte(CustomTornadoConfig.getRipType(false));
        this.particleSpawnRadius = CustomTornadoConfig.getTornadoParticleRadiusFromLvl();
        this.particleGetRange = CustomTornadoConfig.getTornadoParticleFindRangeFromLvl();
        this.time = CustomTornadoConfig.getTime() + (ModConfig.getTornadoesExtraLongDuration() ? 1200 : 0);
        switch (CustomTornadoConfig.getRipType(true)) {
            case 0: {
                this.pathSize = 0;
                break;
            }
            case 2: {
                this.pathSize = WeatherClassic.STAGE3_CONFIG.pathSize;
                break;
            }
            case 3: {
                this.pathSize = WeatherClassic.STAGE4_CONFIG.pathSize;
                break;
            }
            case 4: {
                this.pathSize = WeatherClassic.STAGE5_CONFIG.pathSize;
                break;
            }
            case 5: {
                this.pathSize = (short)(WeatherClassic.STAGE5_CONFIG.pathSize + 8);
                break;
            }
            case 6: {
                this.pathSize = (short)(WeatherClassic.STAGE5_CONFIG.pathSize + 10);
                break;
            }
            case 7: {
                this.pathSize = (short)(WeatherClassic.STAGE2_CONFIG.pathSize - 1);
                break;
            }
            default: {
                this.pathSize = WeatherClassic.STAGE2_CONFIG.pathSize;
            }
        }
        this.extraParticleInterval = CustomTornadoConfig.getExtraParticleInterval();
        this.extraParticleDistance = CustomTornadoConfig.getExtraParticleDistance();
        this.createClouds = CustomTornadoConfig.getCreateClouds();
        this.particleCount = CustomTornadoConfig.getParticleCount();
        this.soundDist = CustomTornadoConfig.getSoundDist();
        this.dispellerResistance = CustomTornadoConfig.getDispellerResistance();
        Global.getAllActiveCustomTornadoes().forEach(p -> p.getRotator().updatePullVals((TornadoEntity)p));
    }

    public void reinit(boolean switched) {
        switch (this.type.ordinal()) {
            case 0: {
                this.createSpoutStats();
                break;
            }
            case 1: {
                this.createStage2Stats();
                break;
            }
            case 2: {
                this.createStage3Stats();
                break;
            }
            case 3: {
                this.createStage4Stats();
                break;
            }
            case 4: {
                this.createStage5Stats();
                break;
            }
            case 5: {
                if (Global.weather != null && Global.weather.getWorld() != null) {
                    CustomTornadoConfig.updateCustomTornadoInfo((class_3218)Global.weather.getWorld(), !switched, CustomTornadoConfig.USING_ALT);
                }
                this.createStageXStats();
            }
        }
    }

    public static TornadoStats getFrom(byte b) {
        switch (b) {
            case 0: {
                return WeatherClassic.SPOUT_CONFIG;
            }
            case 2: {
                return WeatherClassic.STAGE3_CONFIG;
            }
            case 3: {
                return WeatherClassic.STAGE4_CONFIG;
            }
            case 4: {
                return WeatherClassic.STAGE5_CONFIG;
            }
            case 5: {
                return WeatherClassic.STAGEX_CONFIG;
            }
        }
        return WeatherClassic.STAGE2_CONFIG;
    }

    public static enum Type {
        SPOUT,
        STAGE2,
        STAGE3,
        STAGE4,
        STAGE5,
        STAGEX;


        public byte getByte() {
            switch (this.ordinal()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return 1;
        }

        public static byte fromSevereStormStage(byte stage) {
            switch (stage) {
                case 0: {
                    return STAGE2.getByte();
                }
                case 1: {
                    return STAGE3.getByte();
                }
                case 2: {
                    return STAGE4.getByte();
                }
                case 3: {
                    return STAGE5.getByte();
                }
            }
            return STAGE2.getByte();
        }
    }
}

