/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.storm.debris;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3966;
import net.weather_classic.block.TornadoDispellerBlock;
import net.weather_classic.config.ModConfig;
import net.weather_classic.global.Global;
import net.weather_classic.help.Materials;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core.DebrisManipulator;
import net.weather_classic.registry.WCBlocks;
import net.weather_classic.storm.TornadoEntity;

public class DebrisEntity
extends class_1676 {
    public final class_1937 world;
    private class_2680 state = class_2246.field_10566.method_9564();
    private UUID tornadoHost = null;
    private boolean isDispeller;
    public final short rotationSpeedAdds;
    private boolean forceCollide = false;
    private double damageMultiplier = 1.0;
    private boolean doDebrisImpact = false;
    public static final class_2940<Integer> BLOCK = class_2945.method_12791(DebrisEntity.class, (class_2941)class_2943.field_13327);

    public DebrisEntity(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
        this.world = world;
        this.method_5803(true);
        this.rotationSpeedAdds = (short)world.method_8409().method_43048(10);
    }

    public static DebrisEntity createDebris(class_1299<? extends class_1676> entityType, class_1309 owner, class_2680 block, boolean spinning, class_1937 world) {
        DebrisEntity debris = new DebrisEntity(entityType, world);
        debris.setBlockState(block);
        debris.state = block;
        debris.method_5660(spinning);
        debris.method_7432((class_1297)owner);
        debris.isDispeller = block.method_27852(WCBlocks.TORNADO_DISPELLER);
        return debris;
    }

    public static DebrisEntity createDebris(class_1299<? extends class_1676> entityType, TornadoEntity tornado, class_2338 pos, class_2680 block, boolean spinning) {
        DebrisEntity debris = new DebrisEntity(entityType, tornado.method_37908());
        debris.setBlockState(block);
        debris.state = block;
        debris.method_5660(spinning);
        if (tornado != null) {
            debris.setTornadoHost(tornado.method_5667());
            debris.method_7432((class_1297)tornado);
        }
        debris.isDispeller = block.method_27852(WCBlocks.TORNADO_DISPELLER);
        return debris;
    }

    public void method_5773() {
        super.method_5773();
        this.travel(this.method_18798());
        boolean water = this.method_5869();
        if (water) {
            if (this.damageMultiplier > 1.0) {
                this.setDamageMultiplier(1.0);
            }
            Utils.setVelocityY((class_1297)this, -0.3f);
            if (this.isDispeller() && !this.world.field_9236) {
                TornadoDispellerBlock.dispel((class_3218)this.world, this.method_24515(), false);
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
        }
        if (this.method_5715() && this.field_6012 % 20 == 0) {
            boolean bl = this.doDebrisImpact = this.world.method_18460((class_1297)this, 24.0) != null;
        }
        if (!this.method_5715() || this.doDebrisImpact) {
            this.checkCollideWithEntities(this.damageMultiplier > 1.0);
        }
        this.handleCollision();
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            DebrisManipulator data;
            class_1657 player = (class_1657)class_12972;
            if (!this.world.field_9236 && (data = (DebrisManipulator)player).getManipulatingDebris() != this && this.method_5740()) {
                this.method_5875(false);
            }
        }
    }

    public void setDamageMultiplier(double d) {
        this.damageMultiplier = d;
    }

    public void checkCollideWithEntities(boolean force) {
        List entities;
        boolean movingFast;
        boolean bl = force || (this.getTornadoHost() != null ? !Utils.isVelocityZero((class_1297)this) : this.method_60478().method_1033() > 1.0) ? true : (movingFast = false);
        if (movingFast && !(entities = this.world.method_8333((class_1297)this, this.method_5829().method_1009(0.2, 0.2, 0.2), p -> p.method_5709())).isEmpty()) {
            for (class_1297 ent : entities) {
                if (force && ent == this.method_24921() || this.world.field_9236) continue;
                ent.method_64397((class_3218)this.world, this.world.method_48963().method_48798((class_1297)(this.method_24921() != null ? this.method_24921() : this)), 8.0f * (float)this.damageMultiplier);
            }
        }
    }

    private void handleCollision() {
        if (!this.world.field_9236 && this.field_6012 > (this.shouldSpin() ? 40 : 10) && (this.field_5976 || this.field_5992 || this.forceCollide)) {
            class_2350 validDir = null;
            for (class_2350 dir : class_2350.values()) {
                if (Utils.canPassThrough((class_1936)this.world, this.method_24515().method_10093(dir))) continue;
                validDir = dir;
                break;
            }
            if (validDir != null || this.forceCollide) {
                if (this.state != null) {
                    if (this.state.method_27852(class_2246.field_10375)) {
                        this.createTntExplosion();
                    } else if (!this.isDispeller) {
                        class_2338 placePos = this.method_24515();
                        if (!Utils.canPassThrough((class_1936)this.world, placePos)) {
                            if (this.method_59922().method_43057() < 0.25f) {
                                this.world.method_22352(placePos, this.shouldBreakBlockOnImpact(placePos));
                            } else if (!Utils.canPassThrough((class_1936)this.world, placePos.method_10084())) {
                                this.world.method_22352(placePos.method_10084(), this.shouldBreakBlockOnImpact(placePos));
                            } else {
                                placePos = placePos.method_10084();
                            }
                        }
                        if (placePos != null) {
                            if (!this.world.method_8320(placePos).method_26215() && Utils.canPassThrough((class_1936)this.world, placePos)) {
                                this.world.method_22352(placePos, this.shouldBreakBlockOnImpact(placePos));
                            }
                            this.world.method_8501(placePos, this.state);
                            Utils.playSound(null, this.world, placePos, this.state.method_26231().method_10598(), this.method_5634(), 1.0f, 1.0f);
                        }
                    } else {
                        if (this.tornadoHost != null && this.isDispeller()) {
                            Global.activeTornadoes.forEach(p -> {
                                if (p.method_5667().equals(this.tornadoHost)) {
                                    p.dispel();
                                    return;
                                }
                            });
                        }
                        for (int i = 0; i < 5; ++i) {
                            ((class_3218)this.world).method_65096((class_2394)class_2398.field_11221, (double)((float)this.method_31477() + this.field_5974.method_43057()), this.method_23318() + 0.5, (double)((float)this.method_31479() + this.field_5974.method_43057()), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    this.method_31472();
                }
            } else if (Utils.isVelocityZero((class_1297)this) && this.method_24828()) {
                this.method_5814((double)this.method_31477() + 0.5, this.method_23318(), (double)this.method_31479() + 0.5);
            }
        }
    }

    private boolean shouldBreakBlockOnImpact(class_2338 pos) {
        return !Materials.isAggregate(this.world.method_8320(pos)) && !Materials.isStone(this.world.method_8320(pos));
    }

    public boolean shouldSpin() {
        return this.method_5715() && !this.method_5799() && !Utils.isVelocityZero((class_1297)this);
    }

    private void createTntExplosion() {
        this.method_37908().method_55117((class_1297)this, class_1927.method_55108((class_1937)this.method_37908(), (class_1297)this), null, this.method_23317(), this.method_23323(0.0625), this.method_23321(), 4.0f, false, class_1937.class_7867.field_40891);
    }

    protected void method_7454(class_3966 entityHitResult) {
    }

    public boolean method_26958(class_1297 entity) {
        return super.method_5863() && !entity.field_5960;
    }

    public void method_5697(class_1297 entity) {
    }

    public boolean method_30949(class_1297 other) {
        if (other instanceof TornadoEntity || other instanceof DebrisEntity) {
            return false;
        }
        return other.method_30948() && !this.method_5794(other);
    }

    public void method_5982() {
        class_1657 entity = this.method_37908().method_8604(this.method_23317(), this.method_23318(), this.method_23321(), 224.0, null);
        if (entity != null) {
            return;
        }
        this.method_31472();
    }

    public void setBlockState(class_2680 state) {
        this.method_5841().method_12778(BLOCK, (Object)class_2248.method_9507((class_2680)state));
    }

    public class_2680 getBlockState() {
        return class_2248.method_9531((int)((Integer)this.method_5841().method_12789(BLOCK)));
    }

    public void setTornadoHost(UUID tornado) {
        this.tornadoHost = tornado;
    }

    public UUID getTornadoHost() {
        return this.tornadoHost;
    }

    public boolean method_5640(double distance) {
        int dist = ModConfig.getCullDebrisRendering() ? 60 : 128;
        return distance < (double)(dist * dist);
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return source == world.method_48963().method_48829() || source == world.method_48963().method_51847() ? super.method_64397(world, source, amount) : false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(BLOCK, (Object)class_2248.method_9507((class_2680)class_2246.field_10566.method_9564()));
    }

    public class_3419 method_5634() {
        return class_3419.field_15245;
    }

    public void method_5651(class_2487 nbt) {
        super.method_5651(nbt);
        if (!this.world.field_9236) {
            if (nbt.method_10545("blockID")) {
                this.setBlockState(class_2248.method_9531((int)nbt.method_10550("blockID")));
            }
            if (nbt.method_10545("tornadoBound")) {
                this.method_31472();
                return;
            }
        }
    }

    public class_2487 method_5647(class_2487 nbt) {
        if (!this.world.field_9236) {
            nbt.method_10569("blockID", ((Integer)this.field_6011.method_12789(BLOCK)).intValue());
            if (this.tornadoHost != null && Global.activeTornadoes.stream().anyMatch(p -> p.method_5667().equals(this.tornadoHost))) {
                nbt.method_10556("tornadoBound", true);
            }
        }
        return super.method_5647(nbt);
    }

    public void method_18800(double x, double y, double z) {
        this.method_18799(new class_243(x, y, z));
    }

    public void travel(class_243 vel) {
        class_2338 blockPos = this.method_23314();
        float p = this.method_37908().method_8320(blockPos).method_26204().method_9499();
        float f = this.method_24828() ? p * 0.91f : 0.91f;
        double vv = vel.field_1351;
        if (!this.method_5740()) {
            vel = new class_243(vel.field_1352, (vv -= 0.08) * 0.96, vel.field_1350);
        }
        this.method_18800(vel.field_1352 * (double)f, vel.field_1351, vel.field_1350 * (double)f);
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public boolean isDispeller() {
        return this.isDispeller;
    }

    public void forceCollide() {
        this.forceCollide = true;
        this.field_6012 = 50;
    }
}

