/*
 * Decompiled with CFR 0.152.
 */
package net.weather_classic.wind_core;

import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.weather_classic.global.client.ClientGlobal;
import net.weather_classic.help.Utils;
import net.weather_classic.item.core.SimpleParticleSource;
import net.weather_classic.particle.StormParticle;
import net.weather_classic.particle.TornadoWindParticle;
import net.weather_classic.particle.rotator.WindCoreTornadoParticleRotator;

@Environment(value=EnvType.CLIENT)
public class ClientWindCoreParticleSource
implements SimpleParticleSource {
    private final UUID id;
    private class_243 pos;
    private final byte b;
    private final WindCoreTornadoParticleRotator particleRotator;

    public ClientWindCoreParticleSource(UUID player, class_243 emitter, byte info) {
        this.id = player;
        this.pos = emitter;
        this.b = info;
        this.particleRotator = new WindCoreTornadoParticleRotator(this);
    }

    @Override
    public UUID getUuid() {
        return this.id;
    }

    @Override
    public class_243 getEmitter() {
        return this.pos;
    }

    @Override
    public byte getInfo() {
        return this.b;
    }

    public static WindCoreTornadoParticleRotator getParticleRotator(SimpleParticleSource source) {
        if (!(source instanceof ClientWindCoreParticleSource)) {
            return null;
        }
        return ((ClientWindCoreParticleSource)source).particleRotator;
    }

    public static SimpleParticleSource getFor(StormParticle particle) {
        for (UUID id : ClientGlobal.activePlayerTornadoSources.keySet()) {
            int dist;
            SimpleParticleSource source = ClientGlobal.activePlayerTornadoSources.get(id);
            int range = 10;
            int n = dist = particle instanceof TornadoWindParticle ? range + 25 : range;
            if (!(Utils.distanceXZ(particle.getX(), particle.getY(), particle.getZ(), source.getEmitter()) < (double)dist)) continue;
            return source;
        }
        return null;
    }

    public void updateSource() {
        SimpleParticleSource source = ClientGlobal.activePlayerTornadoSources.get(this.id);
        if (source != null) {
            this.pos = source.getEmitter();
        }
    }
}

